/*
 * Decompiled with CFR 0.152.
 */
package com.makeLogic.utils;

import com.makeLogic.utils.FileMenu;
import com.makeLogic.utils.MLInternalFrame;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyVetoException;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class InternalFrameClosingHandler
extends InternalFrameAdapter {
    Container container;
    Hashtable internalFramesOpenFileNames;
    MLInternalFrame internalFrame;

    public InternalFrameClosingHandler(Container container, Hashtable internalFramesOpenFileNames, MLInternalFrame internalFrame) {
        this.container = container;
        this.internalFramesOpenFileNames = internalFramesOpenFileNames;
        this.internalFrame = internalFrame;
    }

    public void internalFrameClosing(InternalFrameEvent e) {
        FileMenu.updateConfFile();
        FileMenu.updateRecentFilesMenu(FileMenu.recentFilesMenuItem);
        Hashtable tempOpenMenuHash = FileMenu.getInternalFramesOpenFileNamesHashTable();
        Hashtable tempNewMenuHash = FileMenu.getInternalFramesNewFileNamesHashTable();
        Vector recentFileEntries = FileMenu.getRecentFileEntriesVector();
        if (!this.internalFrame.getChanged()) {
            try {
                this.internalFrame.removeInternalFrameListener(this);
                this.internalFrame.setClosed(true);
            }
            catch (PropertyVetoException pve) {
                JOptionPane.showMessageDialog(null, pve.getMessage(), "MakeLogic:FileMenu", 0);
            }
            if (tempNewMenuHash.containsKey(this.internalFrame)) {
                tempNewMenuHash.remove(this.internalFrame);
            }
            return;
        }
        if (tempOpenMenuHash.containsKey(this.internalFrame)) {
            String fileTitle = this.internalFrame.getTitle().substring(0, this.internalFrame.getTitle().length() - 1);
            int result = JOptionPane.showConfirmDialog(this.internalFrame, "Do You want to Save ?" + fileTitle, "Confirm Dialog", 1);
            if (result == 0) {
                String FileName = (String)tempOpenMenuHash.get(this.internalFrame);
                try {
                    DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(FileName));
                    Component[] jsp = this.internalFrame.getContentPane().getComponents();
                    JScrollPane jspn = (JScrollPane)this.internalFrame.getContentPane().getComponent(0);
                    JViewport jvp = jspn.getViewport();
                    JEditorPane jep = (JEditorPane)jvp.getView();
                    try {
                        outputStream.writeBytes(jep.getText());
                    }
                    catch (IOException ioexcep) {
                        JOptionPane.showMessageDialog(null, ioexcep.getMessage(), "MakeLogic:FileMenu", 0);
                    }
                }
                catch (FileNotFoundException fnfe) {
                    JOptionPane.showMessageDialog(null, fnfe.getMessage(), "MakeLogic:FileMenu", 0);
                }
                try {
                    this.internalFrame.removeInternalFrameListener(this);
                    this.internalFrame.setClosed(true);
                }
                catch (PropertyVetoException pve) {
                    JOptionPane.showMessageDialog(null, pve.getMessage(), "MakeLogic:FileMenu", 0);
                }
            } else {
                if (result == 2) {
                    return;
                }
                if (result == 1) {
                    try {
                        this.internalFrame.removeInternalFrameListener(this);
                        this.internalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException pve) {
                        JOptionPane.showMessageDialog(null, pve.getMessage(), "MakeLogic:FileMenu", 0);
                    }
                }
            }
        } else {
            String fileTitle = this.internalFrame.getTitle().substring(0, this.internalFrame.getTitle().length() - 1);
            int result = JOptionPane.showConfirmDialog(this.internalFrame, "Do You want to Save ?" + fileTitle, "Confirm Dialog", 1);
            Component[] jsp = this.internalFrame.getContentPane().getComponents();
            JScrollPane jspn = (JScrollPane)this.internalFrame.getContentPane().getComponent(0);
            JViewport jvp = jspn.getViewport();
            JEditorPane jep = (JEditorPane)jvp.getView();
            if (result == 0) {
                String newFileName = (String)tempNewMenuHash.get(this.internalFrame);
                File currentFile = new File(newFileName + ".txt");
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setSelectedFile(currentFile);
                int response = fileChooser.showSaveDialog(this.container);
                if (response == 0) {
                    try {
                        DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(fileChooser.getSelectedFile().getAbsolutePath()));
                        outputStream.writeBytes(jep.getText());
                    }
                    catch (FileNotFoundException fnfe) {
                        JOptionPane.showMessageDialog(null, fnfe.getMessage(), "MakeLogic:FileMenu", 0);
                    }
                    catch (IOException ioexcep) {
                        JOptionPane.showMessageDialog(null, ioexcep.getMessage(), "MakeLogic:FileMenu", 0);
                    }
                    try {
                        this.internalFrame.removeInternalFrameListener(this);
                        this.internalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException pve) {
                        JOptionPane.showMessageDialog(null, pve.getMessage(), "MakeLogic:FileMenu", 0);
                    }
                    tempNewMenuHash.remove(this.internalFrame);
                    tempOpenMenuHash.put(this.internalFrame, fileChooser.getSelectedFile().getAbsolutePath());
                    recentFileEntries.add(fileChooser.getSelectedFile().getAbsolutePath());
                }
            } else {
                if (result == 2) {
                    return;
                }
                if (result == 1) {
                    try {
                        this.internalFrame.removeInternalFrameListener(this);
                        this.internalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException pve) {
                        JOptionPane.showMessageDialog(null, pve.getMessage(), "MakeLogic:FileMenu", 0);
                    }
                    tempNewMenuHash.remove(this.internalFrame);
                }
            }
        }
    }
}

