/*
 * Decompiled with CFR 0.152.
 */
package com.makeLogic.utils;

import com.makeLogic.utils.ExitMenuItem;
import com.makeLogic.utils.MLInternalFrame;
import com.makeLogic.utils.NewMenuItem;
import com.makeLogic.utils.OpenMenuItem;
import com.makeLogic.utils.RecentFilesMenuItem;
import com.makeLogic.utils.SaveAsMenuItem;
import com.makeLogic.utils.SaveMenuItem;
import com.makeLogic.utils.VersionManager;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class FileMenu
extends JMenu {
    Container container;
    NewMenuItem newMenuItem;
    OpenMenuItem openMenuItem;
    private static SaveMenuItem saveMenuItem;
    SaveAsMenuItem saveAsMenuItem;
    public static RecentFilesMenuItem recentFilesMenuItem;
    ExitMenuItem exitMenuItem;
    JSeparator separatorOne;
    JSeparator separatorTwo;
    JSeparator separatorThree;
    KeyStroke newMenuItemKeyStroke;
    KeyStroke openMenuItemKeyStroke;
    KeyStroke saveMenuItemKeyStroke;
    KeyStroke saveAsMenuItemKeyStroke;
    char recentFilesMenuItemKeyStroke;
    KeyStroke exitMenuItemKeyStroke;
    static Hashtable internalFrameOpenFileNames;
    static Hashtable internalFrameNewFileNames;
    static Vector recentFileEntries;
    static int maxEntriesInConfFile;
    static int maxEntriesInRecentFilesMenu;

    public FileMenu(Container container) {
        super("File");
        this.setMnemonic('F');
        this.container = container;
        VersionManager versionManager = new VersionManager("FM_1.1", false);
        internalFrameOpenFileNames = new Hashtable();
        internalFrameNewFileNames = new Hashtable();
        recentFileEntries = new Vector();
        this.newMenuItem = new NewMenuItem(container);
        this.add(this.newMenuItem);
        this.openMenuItem = new OpenMenuItem(container);
        this.add(this.openMenuItem);
        this.separatorOne = new JSeparator();
        this.add(this.separatorOne);
        saveMenuItem = new SaveMenuItem(container);
        this.add(saveMenuItem);
        this.saveAsMenuItem = new SaveAsMenuItem(container);
        this.add(this.saveAsMenuItem);
        this.separatorTwo = new JSeparator();
        this.add(this.separatorTwo);
        recentFilesMenuItem = new RecentFilesMenuItem(container);
        this.add(recentFilesMenuItem);
        this.separatorThree = new JSeparator();
        this.add(this.separatorThree);
        this.exitMenuItem = new ExitMenuItem(container);
        this.add(this.exitMenuItem);
        FileMenu.updateRecentFilesMenu(recentFilesMenuItem);
    }

    public FileMenu(Container container, KeyStroke newMenuItemKeyStroke, KeyStroke openMenuItemKeyStroke, KeyStroke saveMenuItemKeyStroke, KeyStroke saveAsMenuItemKeyStroke, char recentFilesMenuItemKeyStroke, KeyStroke exitMenuItemKeyStroke) {
        this(container);
        VersionManager versionManager = new VersionManager("FM_1.1", false);
        this.newMenuItemKeyStroke = newMenuItemKeyStroke;
        this.setKeyStrokeForNewMenuItem(newMenuItemKeyStroke);
        this.openMenuItemKeyStroke = openMenuItemKeyStroke;
        this.setKeyStrokeForOpenMenuItem(openMenuItemKeyStroke);
        this.saveMenuItemKeyStroke = saveMenuItemKeyStroke;
        this.setKeyStrokeForSaveMenuItem(saveMenuItemKeyStroke);
        this.saveAsMenuItemKeyStroke = saveAsMenuItemKeyStroke;
        this.setKeyStrokeForSaveAsMenuItem(saveAsMenuItemKeyStroke);
        this.recentFilesMenuItemKeyStroke = recentFilesMenuItemKeyStroke;
        this.setKeyStrokeForRecentFilesMenuItem(recentFilesMenuItemKeyStroke);
        this.exitMenuItemKeyStroke = exitMenuItemKeyStroke;
        this.setKeyStrokeForExitMenuItem(exitMenuItemKeyStroke);
        FileMenu.updateRecentFilesMenu(recentFilesMenuItem);
    }

    public void setKeyStrokeForNewMenuItem(KeyStroke newMenuItemKeyStroke) {
        this.newMenuItem.setKeyStrokeForNewMenuItem(newMenuItemKeyStroke);
    }

    public void setKeyStrokeForOpenMenuItem(KeyStroke openMenuItemKeyStroke) {
        this.openMenuItem.setAccelerator(openMenuItemKeyStroke);
    }

    public void setKeyStrokeForSaveMenuItem(KeyStroke saveMenuItemKeyStroke) {
        saveMenuItem.setAccelerator(saveMenuItemKeyStroke);
    }

    public void setKeyStrokeForSaveAsMenuItem(KeyStroke saveAsMenuItemKeyStroke) {
        this.saveAsMenuItem.setAccelerator(saveAsMenuItemKeyStroke);
    }

    public void setKeyStrokeForRecentFilesMenuItem(char recentFilesMenuItemKeyStroke) {
        recentFilesMenuItem.setMnemonic(recentFilesMenuItemKeyStroke);
    }

    public void setKeyStrokeForExitMenuItem(KeyStroke exitMenuItemKeyStroke) {
        this.exitMenuItem.setAccelerator(exitMenuItemKeyStroke);
    }

    public void addNewMenuItemActionListener(ActionListener newMenuItemActionListener) {
        this.newMenuItem.addActionListener(newMenuItemActionListener);
    }

    public void addOpenMenuItemActionListener(ActionListener openMenuItemActionListener) {
        this.openMenuItem.addActionListener(openMenuItemActionListener);
    }

    public void addSaveMenuItemActionListener(ActionListener saveMenuItemActionListener) {
        saveMenuItem.addActionListener(saveMenuItemActionListener);
    }

    public void addSaveAsMenuItemActionListener(ActionListener saveAsMenuItemActionListener) {
        this.saveAsMenuItem.addActionListener(saveAsMenuItemActionListener);
    }

    public void addRecentFilesMenuItemActionListener(ActionListener recentFilesMenuItemActionListener) {
        recentFilesMenuItem.addActionListener(recentFilesMenuItemActionListener);
    }

    public void addExitMenuItemActionListener(ActionListener exitMenuItemActionListener) {
        this.exitMenuItem.addActionListener(exitMenuItemActionListener);
    }

    public void disableDefaultNewMenuItemListener() {
        this.newMenuItem.removeActionListener(this.newMenuItem);
    }

    public void disableDefaultOpenMenuItemListener() {
        this.openMenuItem.removeActionListener(this.openMenuItem);
    }

    public void disableDefaultSaveMenuItemListener() {
        saveMenuItem.removeActionListener(saveMenuItem);
    }

    public void disableDefaultSaveAsMenuItemListener() {
        this.saveAsMenuItem.removeActionListener(this.saveAsMenuItem);
    }

    public void disableDefaultRecentFilesMenuItemListener() {
        this.remove(recentFilesMenuItem);
        this.remove(this.separatorThree);
    }

    public void disableDefaultExitMenuItemListener() {
        this.exitMenuItem.removeActionListener(this.exitMenuItem);
    }

    static synchronized Hashtable getInternalFramesOpenFileNamesHashTable() {
        return internalFrameOpenFileNames;
    }

    static synchronized Vector getRecentFileEntriesVector() {
        return recentFileEntries;
    }

    static synchronized Hashtable getInternalFramesNewFileNamesHashTable() {
        return internalFrameNewFileNames;
    }

    static void removeOpenFileEntry(MLInternalFrame internalFrame) {
        internalFrameOpenFileNames.remove(internalFrame);
    }

    static synchronized void updateConfFile() {
        Vector<String> fileVector = new Vector<String>();
        Vector recentFileVector = FileMenu.getRecentFileEntriesVector();
        try {
            BufferedReader bufferReader = new BufferedReader(new FileReader("conf.txt"));
            String line = bufferReader.readLine();
            while (line != null) {
                fileVector.add(line);
                line = bufferReader.readLine();
            }
            bufferReader.close();
            Object tempFrame = null;
            Object fileEntryInOpenHashTable = null;
            String fileEntryInVector = null;
            int k = 0;
            while (k < recentFileVector.size()) {
                fileEntryInVector = (String)recentFileVector.get(k);
                try {
                    if (fileVector.contains(fileEntryInVector)) {
                        int index = fileVector.lastIndexOf(fileEntryInVector);
                        fileVector.remove(index);
                        fileVector.add(fileEntryInVector);
                    } else {
                        fileVector.add(fileEntryInVector);
                    }
                }
                catch (NoSuchElementException nsee) {
                    JOptionPane.showMessageDialog(null, nsee.getMessage(), "MakeLogic:FileMenu", 0);
                }
                ++k;
            }
            try {
                PrintWriter fileWriter = new PrintWriter(new BufferedWriter(new FileWriter("conf.txt")));
                int i = 0;
                if (fileVector.size() > maxEntriesInConfFile) {
                    i = fileVector.size() - maxEntriesInConfFile;
                }
                while (i < fileVector.size()) {
                    fileWriter.println(fileVector.get(i));
                    fileWriter.flush();
                    ++i;
                }
            }
            catch (FileNotFoundException fnfe) {
                JOptionPane.showMessageDialog(null, fnfe.getMessage(), "MakeLogic:FileMenu", 0);
            }
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(null, "Recent Files Information is Lost.Program will try to Recover", "MakeLogic:FileMenu", 1);
            try {
                PrintWriter fileWriter = new PrintWriter(new BufferedWriter(new FileWriter("conf.txt")));
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, ioe.getMessage(), "MakeLogic:FileMenu", 0);
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, ioe.getMessage(), "MakeLogic:FileMenu", 0);
        }
    }

    static synchronized void updateRecentFilesMenu(RecentFilesMenuItem recentFilesMenu) {
        recentFilesMenu.removeAll();
        Vector<String> fileVector = new Vector<String>();
        try {
            BufferedReader bufferReader = new BufferedReader(new FileReader("conf.txt"));
            String line = bufferReader.readLine();
            while (line != null) {
                fileVector.add(line);
                line = bufferReader.readLine();
            }
            bufferReader.close();
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(null, "Recent File Information is Lost.Program will try to Recover", "MakeLogic:FileMenu", 1);
            try {
                PrintWriter fileWriter = new PrintWriter(new BufferedWriter(new FileWriter("conf.txt")));
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, ioe.getMessage(), "MakeLogic:FileMenu", 0);
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, ioe.getMessage(), "MakeLogic:FileMenu", 0);
        }
        JMenuItem tempItem = null;
        try {
            int i = fileVector.size() - 1;
            while (i >= fileVector.size() - maxEntriesInRecentFilesMenu) {
                tempItem = new JMenuItem((String)fileVector.get(i));
                tempItem.addActionListener(recentFilesMenu);
                recentFilesMenu.add(tempItem);
                --i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getMaxEntriesInConfFile() {
        return maxEntriesInConfFile;
    }

    public int getMaxEntriesInRecentFilesMenu() {
        return maxEntriesInRecentFilesMenu;
    }

    public void setMaxEntriesInConfFile(int maxEntriesInConfFile) {
        if (maxEntriesInConfFile < 0) {
            FileMenu.maxEntriesInConfFile = 20;
        }
        FileMenu.maxEntriesInConfFile = maxEntriesInConfFile;
    }

    public void setMaxEntriesInRecentFilesMenu(int maxEntriesInRecentFilesMenu) {
        int maxEntriesInConfFile;
        if (maxEntriesInRecentFilesMenu < 0) {
            FileMenu.maxEntriesInRecentFilesMenu = 4;
        }
        FileMenu.maxEntriesInRecentFilesMenu = maxEntriesInRecentFilesMenu < (maxEntriesInConfFile = this.getMaxEntriesInConfFile()) ? maxEntriesInRecentFilesMenu : maxEntriesInConfFile;
    }

    public WindowListener getDefaultClosingListener() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FileMenu.this.exitMenuItem.actionPerformed(null);
            }
        };
        return windowAdapter;
    }

    public JMenuItem getNewMenuItem() {
        return this.newMenuItem;
    }

    public JMenuItem getOpenMenuItem() {
        return this.openMenuItem;
    }

    public static JMenuItem getSaveMenuItem() {
        return saveMenuItem;
    }

    public JMenuItem getSaveAsMenuItem() {
        return this.saveAsMenuItem;
    }

    public static JMenu getRecentFilesMenuItem() {
        return recentFilesMenuItem;
    }

    public JMenuItem getExitMenuItem() {
        return this.exitMenuItem;
    }

    static {
        maxEntriesInConfFile = 20;
        maxEntriesInRecentFilesMenu = 8;
    }
}

