/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PieChart
extends Chart {
    public static final int SELECTION_STYLE_TRIANGLE = 0;
    public static final int SELECTION_STYLE_CIRCLE = 1;
    public static final int SELECTION_STYLE_DETACHED = 2;
    private int bM;
    private double bO;
    private boolean aJ;
    private boolean s;
    private boolean bJ;
    private boolean bD;
    private int bP;
    private int bz;
    private boolean by;
    private Color bL;
    private double bw;
    private Hashtable bB;
    private int bC;
    private int bA;
    private int ai;
    private int a1;
    private Color bH;
    private Color[] bI;
    private double[][] bN;
    private Rectangle[] bK;
    private Point[] bx;
    private int[] bG;
    private static final int bF = 0;
    private static final int bQ = 1;
    private static final int bE = 2;

    public PieChart() {
        this(1);
    }

    public PieChart(int n) {
        this(1, n);
    }

    public PieChart(int n, int n2) {
        super(n, n2);
        this.S = "pie";
        this.bI = new Color[n2];
        this.bN = new double[n][n2];
        this.bB = new Hashtable();
        this.bK = new Rectangle[n == 1 ? 1 : n2];
        this.bx = new Point[this.bK.length];
        this.bG = new int[this.bK.length];
        int n3 = 0;
        while (n3 < this.bK.length) {
            this.bK[n3] = new Rectangle();
            this.bx[n3] = new Point();
            ++n3;
        }
        this.bM = 20;
        this.bO = 0.4f;
        this.s = false;
        this.bJ = false;
        this.bD = false;
        this.bP = 0;
        this.bz = 0;
        this.by = true;
        this.bL = null;
        this.bw = 0.1;
        this.bC = 3;
        this.bA = 3;
        this.a1 = 3;
        this.ai = 3;
    }

    public void reset() {
        super.reset();
        this.bM = 20;
        this.bO = 0.4f;
        this.s = false;
        this.bJ = false;
        this.bD = false;
        this.bP = 0;
        this.bz = 0;
        this.by = true;
        this.bL = null;
        this.bw = 0.1;
        if (this.bB != null) {
            this.bB.clear();
        }
        this.bC = 3;
        this.bA = 3;
        this.a1 = 3;
        this.ai = 3;
    }

    public double getPercentValue(int n, int n2) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
        if (n2 < 0 || n2 >= this.getSampleCount()) {
            throw new IllegalArgumentException("Invalid sample index: " + n2);
        }
        int n3 = this.getSeriesCount();
        if (n3 == 1) {
            double d;
            int n4 = this.getSampleCount();
            double d2 = 0.0;
            int n5 = 0;
            while (n5 < n4) {
                d = this.getSampleValue(0, n5);
                if (d > 0.0) {
                    d2 += d;
                }
                ++n5;
            }
            d = this.getSampleValue(0, n2);
            if (d >= 0.0) {
                return d / d2 * 100.0;
            }
        } else {
            double d;
            double d3 = 0.0;
            int n6 = 0;
            while (n6 < n3) {
                d = this.getSampleValue(n6, n2);
                if (d > 0.0) {
                    d3 += d;
                }
                ++n6;
            }
            d = this.getSampleValue(n, n2);
            if (d > 0.0) {
                return d / d3 * 100.0;
            }
        }
        return 0.0;
    }

    public void setAngle(int n) {
        if (this.bM != n) {
            this.bM = n;
            this.goto = true;
            this.al = true;
            this.autoRepaint();
        }
    }

    public int getAngle() {
        return this.bM;
    }

    public void setDepth(double d) {
        if (this.bO != d) {
            this.bO = d;
            this.goto = true;
            this.al = true;
            this.autoRepaint();
        }
    }

    public float getDepth() {
        return (float)this.bO;
    }

    public void setPercentDecimalCount(int n) {
        if (this.bP != n) {
            this.bP = n;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public int getPercentDecimalCount() {
        return this.bP;
    }

    public void setPercentLabelsOn(boolean bl) {
        if (this.bJ != bl) {
            this.bJ = bl;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public boolean isPercentLabelsOn() {
        return this.bJ;
    }

    public void setPercentLabelStyle(int n) {
        if (this.bC != n) {
            this.bC = 3;
            if (n == 0 || n == 1) {
                this.bC = n;
            }
            this.goto = true;
            this.autoRepaint();
        }
    }

    public int getPercentLabelStyle() {
        return this.bC;
    }

    public void setValueLabelStyle(int n) {
        if (this.bA != n) {
            this.bA = 3;
            if (n == 0 || n == 1) {
                this.bA = n;
            }
            this.goto = true;
            this.autoRepaint();
        }
    }

    public int getValueLabelStyle() {
        return this.bA;
    }

    public void setSampleLabelsOn(boolean bl) {
        if (this.s != bl) {
            this.s = bl;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public boolean isSampleLabelsOn() {
        return this.s;
    }

    public void setSampleLabelStyle(int n) {
        if (this.a1 != n) {
            this.a1 = 3;
            if (n == 0 || n == 1) {
                this.a1 = n;
            }
            this.goto = true;
            this.autoRepaint();
        }
    }

    public int getSampleLabelStyle() {
        return this.a1;
    }

    public void setSeriesLabelsOn(boolean bl) {
        if (this.aJ != bl) {
            this.aJ = bl;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public boolean isSeriesLabelsOn() {
        return this.aJ;
    }

    public void setSeriesLabelStyle(int n) {
        if (this.ai != n) {
            this.ai = 3;
            if (n == 0 || n == 1) {
                this.ai = n;
            }
            this.goto = true;
            this.autoRepaint();
        }
    }

    public int getSeriesLabelStyle() {
        return this.ai;
    }

    public void setPieLabelsOn(boolean bl) {
        if (this.bD != bl) {
            this.bD = bl;
            this.goto = true;
            this.al = true;
            this.autoRepaint();
        }
    }

    public boolean isPieLabelsOn() {
        return this.bD;
    }

    public void setInsideLabelColor(int n, Color color) {
        if (n >= 0) {
            if (n >= this.bI.length) {
                Color[] colorArray = new Color[n + 1];
                System.arraycopy(this.bI, 0, colorArray, 0, this.bI.length);
                this.bI = colorArray;
            }
            this.bI[n] = color;
            this.autoRepaint();
        } else {
            this.bH = color;
        }
    }

    public Color getInsideLabelColor(int n) {
        if (n == -1) {
            return this.bH;
        }
        try {
            return this.bI[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid pie index: " + n);
        }
    }

    public void setFont(String string, Font font) {
        super.setFont(string, font);
    }

    public void setSelectionStyle(int n) {
        if (this.bz != n) {
            this.bz = n;
            this.goto = true;
            this.al = true;
            this.autoRepaint();
        }
    }

    public int getSelectionStyle() {
        return this.bz;
    }

    public void setDetachedDistance(double d) {
        if (this.bw != d) {
            this.bw = d;
            this.goto = true;
            this.al = true;
            this.autoRepaint();
        }
    }

    public double getDetachedDistance() {
        return this.bw;
    }

    public void setDetachedSlice(int n, int n2, double d) {
        Double d2 = new Double(n * 1000000 + n2);
        if (d != 0.0) {
            this.bB.put(d2, new Double(d));
        } else {
            this.bB.remove(d2);
        }
        this.goto = true;
        this.al = true;
        this.autoRepaint();
    }

    public double getDetachedSlice(int n, int n2) {
        Double d = new Double(n * 1000000 + n2);
        Double d2 = (Double)this.bB.get(d);
        if (d2 != null) {
            return d2;
        }
        return 0.0;
    }

    public void setSliceSeperatorOn(boolean bl) {
        if (this.by != bl) {
            this.by = bl;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public boolean isSliceSeperatorOn() {
        return this.by;
    }

    public void setSliceSeperatorColor(Color color) {
        if (this.bL != color) {
            this.bL = color;
            this.goto = true;
            this.autoRepaint();
        }
    }

    public Color getSliceSeperatorColor() {
        return this.bL;
    }

    protected void checkDataIntegrity() {
        super.checkDataIntegrity();
        int n = this.getSeriesCount();
        int n2 = this.getSampleCount();
        this.bN = new double[n][n2];
        this.bK = new Rectangle[n == 1 ? 1 : n2];
        this.bx = new Point[this.bK.length];
        this.bG = new int[this.bK.length];
        int n3 = 0;
        while (n3 < this.bK.length) {
            this.bK[n3] = new Rectangle();
            this.bx[n3] = new Point();
            ++n3;
        }
        if (this.bI != null && n2 != this.bI.length) {
            Color[] colorArray = new Color[n2];
            int n4 = Math.min(n2, this.bI.length);
            System.arraycopy(this.bI, 0, colorArray, 0, n4);
            this.bI = colorArray;
        }
    }

    public ChartSample checkSelection(Point point) {
        if (point == null) {
            return null;
        }
        this.bm = -1;
        this.R = -1;
        ChartSample chartSample = super.checkSelection(point);
        if (chartSample == null) {
            int n = -1;
            Rectangle rectangle = null;
            int n2 = 0;
            while (n2 < this.bK.length) {
                rectangle = this.bK[n2];
                if (rectangle != null && rectangle.contains(point)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n >= 0) {
                double d;
                int n3;
                double d2;
                double d3;
                point.x -= this.bx[n].x;
                point.y -= this.bx[n].y;
                if (this.is3DModeOn()) {
                    int n4 = this.bG[n];
                    int n5 = (int)Math.round((double)n4 * ((double)this.bM / 90.0));
                    d3 = (double)n4 / (double)(n4 - n5);
                    point.y = (int)Math.round((double)point.y * d3);
                }
                if ((d3 = -((d2 = Math.atan2(point.y, point.x)) * 57.29577951308232)) > 90.0 && d3 <= 180.0) {
                    d3 = -360.0 + d3;
                }
                int n6 = this.getSeriesCount();
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                if (n6 == 1) {
                    n3 = this.getSampleCount();
                    int n7 = 0;
                    while (n7 < n3) {
                        if (n7 < n3 - 1) {
                            d5 = Math.min(this.bN[0][n7], this.bN[0][n7 + 1]);
                            d6 = Math.max(this.bN[0][n7], this.bN[0][n7 + 1]);
                        } else {
                            d5 = Math.min(this.bN[0][n7], -270.0);
                            d6 = Math.max(this.bN[0][n7], -270.0);
                        }
                        if (d3 >= d5 && d3 < d6) {
                            chartSample = this.getSample(0, n7);
                            d4 = (d5 + d6) / 2.0;
                            break;
                        }
                        ++n7;
                    }
                } else {
                    n3 = 0;
                    while (n3 < n6) {
                        if (n3 < n6 - 1) {
                            d5 = Math.min(this.bN[n3][n], this.bN[n3 + 1][n]);
                            d6 = Math.max(this.bN[n3][n], this.bN[n3 + 1][n]);
                        } else {
                            d5 = Math.min(this.bN[n3][n], -270.0);
                            d6 = Math.max(this.bN[n3][n], -270.0);
                        }
                        if (d3 >= d5 && d3 < d6) {
                            chartSample = this.getSample(n3, n);
                            d4 = (d5 + d6) / 2.0;
                            break;
                        }
                        ++n3;
                    }
                }
                if (chartSample != null && chartSample.isSelected() && this.bz == 2) {
                    double d7 = d4 * (Math.PI / 180);
                    point.x = (int)((double)point.x - Math.cos(d7) * (double)this.bG[n] * 0.5 * this.bw);
                    point.y = (int)((double)point.y + Math.sin(d7) * (double)this.bG[n] * 0.5 * this.bw);
                    d2 = Math.atan2(point.y, point.x);
                    d3 = -(d2 * 57.29577951308232);
                    if (d3 > 90.0 && d3 <= 180.0) {
                        d3 = -360.0 + d3;
                    }
                    if (d3 < d5 || d3 >= d6) {
                        return null;
                    }
                }
                if ((d = Math.sqrt(point.x * point.x + point.y * point.y)) > (double)(this.bG[n] / 2)) {
                    return null;
                }
            }
        }
        if (chartSample != null) {
            this.R = chartSample.getIndex();
            this.bm = chartSample.getSeries();
            this.ay = point;
        } else {
            this.R = -1;
            this.bm = -1;
        }
        return chartSample;
    }

    public Rectangle getGraphBounds() {
        if (!this.Z && this.aW != null) {
            return this.aW;
        }
        Rectangle rectangle = super.a(this.getLegendLabels());
        Insets insets = this.getGraphInsets();
        if (insets != null) {
            int n;
            Dimension dimension = this.getSize();
            if (insets.top != -1) {
                n = rectangle.y + rectangle.height;
                rectangle.y = insets.top;
                rectangle.height = n - rectangle.y;
            }
            if (insets.left != -1) {
                n = rectangle.x + rectangle.width;
                rectangle.x = insets.left;
                rectangle.width = n - rectangle.x;
            }
            if (insets.bottom != -1) {
                rectangle.height = dimension.height - insets.bottom - rectangle.y;
            }
            if (insets.right != -1) {
                rectangle.width = dimension.width - insets.right - rectangle.x;
            }
        }
        this.Z = false;
        this.aW = rectangle;
        return rectangle;
    }

    public void render(Graphics graphics) {
        this.a(graphics, !this.isServletModeOn());
    }

    void a(Graphics graphics, boolean bl) {
        Serializable serializable;
        Rectangle rectangle = this.getGraphBounds();
        int n = 0;
        while (n < this.overlayCharts.size()) {
            serializable = (Chart)this.overlayCharts.elementAt(n);
            if (serializable != null) {
                ((Chart)serializable).calculateChartData(rectangle, rectangle);
            }
            ++n;
        }
        serializable = this.getSize();
        if (bl && this.else == null) {
            try {
                this.else = this.createImage(Math.max(1, ((Dimension)serializable).width), Math.max(1, ((Dimension)serializable).height));
            }
            catch (Throwable throwable) {
                System.out.println("BarChart.offscreen security exception");
                Chart.do();
            }
            this.goto = true;
        }
        if (!bl || this.goto || this.else == null) {
            Graphics graphics2 = graphics;
            if (this.else != null && bl && !this.aZ) {
                graphics2 = this.else.getGraphics();
                graphics2.setColor(this.getBackground());
                graphics2.fillRect(0, 0, ((Dimension)serializable).width, ((Dimension)serializable).height);
            } else if (this.aZ && this.aU != null && this.else != null) {
                graphics2 = this.aU;
                graphics2.setColor(this.getBackground());
                graphics2.fillRect(0, 0, ((Dimension)serializable).width, ((Dimension)serializable).height);
            }
            this.a(graphics2, (Dimension)serializable);
            this.renderData(graphics2, rectangle, rectangle);
            int n2 = 0;
            while (n2 < this.overlayCharts.size()) {
                Chart chart = (Chart)this.overlayCharts.elementAt(n2);
                if (chart != null) {
                    chart.renderData(graphics2, rectangle, rectangle);
                }
                ++n2;
            }
            if (this.isLegendOn()) {
                this.a(graphics2, rectangle, this.getLegendLabels());
            }
            if (!this.aZ && graphics2 != graphics) {
                graphics2.dispose();
            }
            this.goto = true;
        }
        if ((bl || this.aZ) && this.else != null) {
            graphics.drawImage(this.else, 0, 0, this);
        }
        this.a(graphics, rectangle);
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.try(graphics, rectangle);
        this.a(graphics);
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
    }

    private void try(Graphics graphics, Rectangle rectangle) {
        int n = this.getSeriesCount();
        if (n == 1) {
            this.bK[0] = rectangle;
            double[] dArray = this.getSampleValues(0);
            this.a(graphics, rectangle, dArray, 0);
        } else {
            int n2 = this.getSampleCount();
            this.a(rectangle, n2);
            int n3 = 0;
            while (n3 < n2) {
                double[] dArray = new double[n];
                int n4 = 0;
                while (n4 < n) {
                    dArray[n4] = this.getSampleValue(n4, n3);
                    ++n4;
                }
                this.a(graphics, this.bK[n3], dArray, n3);
                ++n3;
            }
        }
    }

    private void a(Rectangle rectangle, int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = n;
        int n6 = 1;
        int n7 = 1;
        while (n7 <= n) {
            n3 = 1;
            while (n3 <= n) {
                if (n7 * n3 >= n && (n2 = Math.min(rectangle.width / n7, rectangle.height / n3)) > n4) {
                    n4 = n2;
                    n5 = n7;
                    n6 = n3;
                }
                ++n3;
            }
            ++n7;
        }
        n3 = 0;
        n2 = 0;
        while (n2 < n6) {
            int n8 = 0;
            while (n8 < n5) {
                if (n3 < n) {
                    Rectangle rectangle2 = this.bK[n3];
                    rectangle2.width = rectangle.width / n5;
                    rectangle2.height = rectangle.height / n6;
                    rectangle2.x = rectangle.x + rectangle2.width * n8;
                    rectangle2.y = rectangle.y + rectangle2.height * n2;
                    rectangle2.width -= 10;
                    rectangle2.height -= 10;
                    rectangle2.x += 5;
                    rectangle2.y += 5;
                    ++n3;
                }
                ++n8;
            }
            ++n2;
        }
    }

    private void a(Graphics graphics, Rectangle rectangle, double[] dArray, int n) {
        double color;
        double d2;
        int n2;
        double d3;
        int n3;
        int n4;
        int n5;
        int n6;
        if (rectangle == null || rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        int n7 = n6 = (n5 = Math.min(rectangle.width, rectangle.height));
        int n8 = rectangle.x + rectangle.width / 2;
        int n9 = rectangle.y + rectangle.height / 2;
        Font font = this.getFont("pieLabelFont");
        if (font != null) {
            graphics.setFont(font);
        } else {
            graphics.setFont(this.getFont());
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        boolean bl2 = this.is3DModeOn();
        if (bl2) {
            int n10 = (int)Math.round((double)n5 * ((double)this.bM / 90.0));
            int n11 = (int)Math.round((double)n5 * this.bO * ((double)this.bM / 90.0));
            n7 = (n6 -= n10) + n11;
            n9 -= n11 / 2;
            double d4 = (double)rectangle.width / (double)n5;
            n4 = (int)Math.round((double)n5 * d4);
            n3 = (int)Math.round((double)n6 * d4);
            n11 = (int)Math.round((double)n4 * this.bO * ((double)this.bM / 90.0));
            n7 = n3 + n11;
            n9 = rectangle.y + rectangle.height / 2 - n11 / 2;
            if (n9 - n3 / 2 < rectangle.y) {
                double d5 = (double)n3 / (double)n7;
                n7 = rectangle.height;
                n3 = (int)Math.round((double)n7 * d5);
                n11 = rectangle.height - n3;
                d4 = (double)n5 / (double)n6;
                n4 = (int)Math.round((double)n3 * d4);
                n9 = rectangle.y + rectangle.height / 2 - n11 / 2;
            }
            n5 = n4;
            n6 = n3;
        }
        if (this.bD) {
            Font font2 = this.getFont("pieLabelFont");
            String string = this.getSampleLabel(n);
            Dimension dimension = this.a(string, this.getFontMetrics(font2));
            if (bl2) {
                int n12 = (int)Math.round((double)n5 * this.bO * ((double)this.bM / 90.0));
                n4 = n9 + n6 / 2 + dimension.height - fontMetrics.getDescent() + 2;
                if ((n4 += n12) > rectangle.y + rectangle.height) {
                    n3 = n4 - (rectangle.y + rectangle.height);
                    n6 -= n3;
                    n9 -= n3 / 2;
                }
            } else {
                n5 = n6 -= dimension.height;
                n9 -= dimension.height / 2;
            }
        }
        this.bx[n].x = n8;
        this.bx[n].y = n9;
        this.bG[n] = n5;
        double d6 = 0.0;
        int n13 = 0;
        while (n13 < dArray.length) {
            if (dArray[n13] > 0.0) {
                d6 += dArray[n13];
            }
            ++n13;
        }
        double d7 = 90.0;
        n3 = this.getSeriesCount();
        int n14 = 0;
        while (n14 < dArray.length) {
            d3 = dArray[n14] / d6 * 360.0;
            if (n3 == 1) {
                this.bN[0][n14] = d7;
            } else {
                this.bN[n14][n] = d7;
            }
            if (!Double.isNaN(d3)) {
                d7 -= d3;
            }
            ++n14;
        }
        if (bl2) {
            d3 = -270.0;
            n2 = dArray.length - 1;
            while (d3 < -90.0 && n2 >= 0) {
                d2 = d3;
                d2 = n3 == 1 ? this.bN[0][n2] : this.bN[n2][n];
                boolean bl = false;
                bl = n3 == 1 ? this.isSelected(0, n2) : this.isSelected(n2, n);
                color = 0.0;
                color = bl && this.bz == 2 ? this.bw : (n3 == 1 ? this.getDetachedSlice(0, n2) : this.getDetachedSlice(n2, n));
                if (!new Double(d2).isNaN() && !new Double(d2 - d3).isNaN()) {
                    this.a(graphics, this.getSampleColor(n2), d2, d2 - d3, n5, n6, n8, n9, bl, color, 1);
                }
                --n2;
                d3 = d2;
            }
            n2 = 0;
            while (n2 < dArray.length) {
                d2 = d3 = -270.0;
                if (n3 == 1) {
                    if (n2 < this.bN[0].length - 1) {
                        d3 = this.bN[0][n2 + 1];
                    }
                    d2 = this.bN[0][n2];
                } else {
                    if (n2 < this.bN.length - 1) {
                        d3 = this.bN[n2 + 1][n];
                    }
                    d2 = this.bN[n2][n];
                }
                if (d2 >= -90.0) {
                    boolean bl = false;
                    bl = n3 == 1 ? this.isSelected(0, n2) : this.isSelected(n2, n);
                    color = 0.0;
                    color = bl && this.bz == 2 ? this.bw : (n3 == 1 ? this.getDetachedSlice(0, n2) : this.getDetachedSlice(n2, n));
                    if (!new Double(d2).isNaN() && !new Double(d2 - d3).isNaN()) {
                        this.a(graphics, this.getSampleColor(n2), d2, d2 - d3, n5, n6, n8, n9, bl, color, 1);
                    }
                }
                ++n2;
            }
        }
        int n15 = 0;
        while (n15 < dArray.length) {
            double d;
            d2 = d = -270.0;
            if (n3 == 1) {
                if (n15 < this.bN[0].length - 1) {
                    d = this.bN[0][n15 + 1];
                }
                d2 = this.bN[0][n15];
            } else {
                if (n15 < this.bN.length - 1) {
                    d = this.bN[n15 + 1][n];
                }
                d2 = this.bN[n15][n];
            }
            if (d2 != d) {
                boolean bl = false;
                bl = n3 == 1 ? this.isSelected(0, n15) : this.isSelected(n15, n);
                color = 0.0;
                color = bl && this.bz == 2 ? this.bw : (n3 == 1 ? this.getDetachedSlice(0, n15) : this.getDetachedSlice(n15, n));
                if (!new Double(d2).isNaN() && !new Double(d2 - d).isNaN()) {
                    this.a(graphics, this.getSampleColor(n15), d2, d2 - d, n5, n6, n8, n9, bl, color, 2);
                }
            }
            ++n15;
        }
        if (this.by) {
            double d;
            double d4;
            int n10 = 0;
            while (n10 < dArray.length) {
                double d11 = 0.0;
                d4 = -90.0;
                ChartSample chartSample = null;
                boolean bl = false;
                if (n3 == 1) {
                    if (n10 < this.bN[0].length - 1) {
                        d4 = this.bN[0][n10 + 1];
                    }
                    d11 = this.bN[0][n10];
                    chartSample = this.getSample(0, n10);
                    bl = this.isSelected(0, n10);
                } else {
                    if (n10 < this.bN.length - 1) {
                        d4 = this.bN[n10 + 1][n];
                    }
                    d11 = this.bN[n10][n];
                    chartSample = this.getSample(n10, n);
                    bl = this.isSelected(n10, n);
                }
                double d5 = 0.0;
                d5 = bl && this.bz == 2 ? this.bw : (n3 == 1 ? this.getDetachedSlice(0, n10) : this.getDetachedSlice(n10, n));
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN() && d5 == 0.0) {
                    d = (double)(-Math.round(d11)) * (Math.PI / 180);
                    int n11 = n8 + (int)Math.round(Math.cos(d) * ((double)n5 * 0.5));
                    int n12 = n9 + (int)Math.round(Math.sin(d) * ((double)n6 * 0.5));
                    double d8 = (double)(-Math.round(d4)) * (Math.PI / 180);
                    int n16 = n8 + (int)Math.round(Math.cos(d8) * ((double)n5 * 0.5));
                    int n17 = n9 + (int)Math.round(Math.sin(d8) * ((double)n6 * 0.5));
                    if (d11 > -90.0 && d11 < 90.0) {
                        graphics.setColor(this.getSampleColor(n10));
                        graphics.drawLine(n8, n9 + 1, n11, n12 + 1);
                    } else if (-d11 > 90.0 && -d11 < 270.0) {
                        graphics.setColor(this.getSampleColor(n10));
                        graphics.drawLine(n8, n9 - 1, n11, n12 - 1);
                    }
                    if (-d4 > 90.0 && -d4 < 270.0) {
                        graphics.setColor(this.getSampleColor(n10));
                        graphics.drawLine(n8, n9 + 1, n16, n17 + 1);
                    } else if (d4 > -90.0 && d4 < 90.0) {
                        graphics.setColor(this.getSampleColor(n10));
                        graphics.drawLine(n8, n9 - 1, n16, n17 - 1);
                        if (n17 < n9) {
                            graphics.drawLine(n8, n9 - 1, n16 - 1, n17 - 1);
                        }
                    }
                }
                ++n10;
            }
            n2 = 0;
            int n21 = 0;
            while (n21 < dArray.length) {
                d4 = 0.0;
                double d9 = 90.0;
                ChartSample chartSample = null;
                int n18 = 0;
                if (n3 == 1) {
                    if (n21 < this.bN[0].length - 1) {
                        d9 = this.bN[0][n21 + 1];
                    }
                    d4 = this.bN[0][n21];
                    n18 = this.isSelected(0, n21);
                    chartSample = this.getSample(0, n21);
                } else {
                    if (n21 < this.bN.length - 1) {
                        d9 = this.bN[n21 + 1][n];
                    }
                    d4 = this.bN[n21][n];
                    n18 = this.isSelected(n21, n);
                    chartSample = this.getSample(n21, n);
                }
                d = 0.0;
                d = n18 != 0 && this.bz == 2 ? this.bw : (n3 == 1 ? this.getDetachedSlice(0, n21) : this.getDetachedSlice(n21, n));
                if (d == 0.0) {
                    if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                        if (this.bL != null) {
                            graphics.setColor(this.bL);
                        } else {
                            graphics.setColor(this.getSampleColor(n21).darker());
                        }
                        double d10 = (double)(-Math.round(d4)) * (Math.PI / 180);
                        int n19 = n8 + (int)Math.round(Math.cos(d10) * ((double)n5 * 0.5));
                        int n20 = n9 + (int)Math.round(Math.sin(d10) * ((double)n6 * 0.5));
                        double d11 = (double)(-Math.round(d9)) * (Math.PI / 180);
                        int n22 = n8 + (int)Math.round(Math.cos(d11) * ((double)n5 * 0.5));
                        int n23 = n9 + (int)Math.round(Math.sin(d11) * ((double)n6 * 0.5));
                        if (n2 != 0) {
                            graphics.drawLine(n8, n9, n19, n20);
                        }
                        graphics.drawLine(n8, n9, n22, n23);
                    }
                    n2 = n18;
                }
                ++n21;
            }
        }
        if (this.bD) {
            String string = n3 == 1 ? this.getSeriesLabel(n) : this.getSampleLabel(n);
            Font font3 = this.getFont("pieLabelFont");
            if (string != null && string.trim().length() > 0) {
                Color color2;
                int n24;
                Dimension dimension = this.a(string, this.getFontMetrics(font3));
                int n25 = n8 - dimension.width / 2;
                int n26 = n9 + n6 / 2 + fontMetrics.getHeight() - fontMetrics.getDescent() + 2;
                if (bl2) {
                    n24 = n26 + (int)Math.round((double)n5 * this.bO * ((double)this.bM / 90.0));
                }
                graphics.setColor((color2 = this.getSampleLabelColor(n)) != null ? color2 : this.getForeground());
                this.a(graphics, string, n25, n24, dimension, 0, 0);
            }
        }
    }

    private void a(Graphics graphics, Color color, double d, double d2, int n, int n2, int n3, int n4, boolean bl, double d3, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        double d4;
        double d5;
        if (d3 > 0.0 && d2 < 360.0) {
            d5 = -d + d2 / 2.0;
            d4 = d5 * (Math.PI / 180);
            n3 += (int)Math.round(Math.cos(d4) * ((double)n * (d3 / 2.0)));
            n4 += (int)Math.round(Math.sin(d4) * ((double)n2 * (d3 / 2.0)));
        }
        d5 = (double)(-Math.round(d)) * (Math.PI / 180);
        d4 = (double)(-Math.round(d - d2)) * (Math.PI / 180);
        double d6 = Math.abs(d5 - d4) / (Math.PI * 2);
        double d7 = Math.PI * (double)Math.max(n, n2);
        double d8 = d6 * d7;
        double d9 = Math.abs(d5 - d4) / d8;
        if (n5 == 1) {
            int n10;
            int n11;
            n9 = (int)Math.round((double)n * this.bO * ((double)this.bM / 90.0));
            n8 = n / 2 + 1;
            n7 = n2 / 2 + 1;
            if (d9 > 0.0) {
                double d10 = d5;
                graphics.setColor(color.darker().darker());
                while (d10 < d4) {
                    n11 = n3 + (int)Math.round(Math.cos(d10) * (double)n8);
                    n10 = n4 + (int)Math.round(Math.sin(d10) * (double)n7);
                    if (n10 >= n4) {
                        graphics.drawLine(n11, n10, n11, n10 + n9 - 1);
                    }
                    d10 += d9;
                }
            }
            n6 = n3 + (int)Math.round(Math.cos(d5) * (double)n8);
            int n12 = n4 + (int)Math.round(Math.sin(d5) * (double)n7);
            n11 = n3 + (int)Math.round(Math.cos(d4) * (double)n8);
            n10 = n4 + (int)Math.round(Math.sin(d4) * (double)n7);
            if (n6 < n3) {
                if (n12 > n4) {
                    graphics.fillPolygon(new int[]{n3, n3, n6, n6}, new int[]{n4 + n9, n4 - 2, n12 - 2, n12 + n9}, 4);
                }
                graphics.fillPolygon(new int[]{n3, n3, n6, n6}, new int[]{n4 + n9, n4 - 1, n12 - 1, n12 + n9}, 4);
            }
            if (n11 > n3) {
                graphics.fillPolygon(new int[]{n3, n3, n11 + 1, n11 + 1}, new int[]{n4 + n9, n4 - 1, n10 - 1, n10 + n9}, 4);
                graphics.fillPolygon(new int[]{n3, n3, n11, n11}, new int[]{n4 + n9, n4 - 1, n10 - 1, n10 + n9}, 4);
                graphics.fillPolygon(new int[]{n3, n3, n11 - 1, n11 - 1}, new int[]{n4 + n9, n4 - 1, n10 - 1, n10 + n9}, 4);
            }
            int n13 = n3 - n / 2;
            int n14 = n4 - n2 / 2;
            int n15 = (int)Math.round(d);
            int n16 = (int)Math.round(d - d2) - (int)Math.round(d);
            graphics.fillArc(n13 - 1, n14 - 1 + n9, n + 2, n2 + 3, n15, n16);
        }
        if (n5 == 2) {
            n9 = n3 - n / 2;
            n8 = n4 - n2 / 2;
            n7 = (int)Math.round(d);
            n6 = (int)Math.round(d - d2) - (int)Math.round(d);
            if (!this.is3DModeOn()) {
                graphics.setColor(color);
                graphics.fillArc(n9 - 1, n8 - 1, n + 3, n2 + 3, n7, n6);
                graphics.setColor(color.darker());
                graphics.drawArc(n9 - 1, n8 - 1, n + 2, n2 + 2, n7, n6);
            } else {
                graphics.setColor(color);
                graphics.fillArc(n9 - 1, n8 - 1, n + 2, n2 + 2, n7, n6);
                graphics.drawArc(n9, n8 - 1, n, n2 + 2, n7, n6);
                graphics.setColor(color.darker().darker());
                graphics.drawArc(n9 - 1, n8 - 1, n + 2, n2 + 3, n7, n6);
                graphics.setColor(color);
                graphics.drawArc(n9 - 1, n8, n + 2, n2, n7, n6);
                graphics.setColor(color.darker());
                graphics.drawArc(n9 - 1, n8 - 1, n + 2, n2 + 2, n7, n6);
            }
        }
        if (bl) {
            this.a(graphics, color, (int)Math.round(-d), (int)Math.round(-d2), n, n2, n3, n4, this.bz);
        }
    }

    private void a(Graphics graphics, Color color, double d, double d2, int n, int n2, int n3, int n4, int n5) {
        if (n5 == 1) {
            double d3 = d - d2 / 2.0;
            double d4 = d3 * (Math.PI / 180);
            int n6 = n3 + (int)Math.round(Math.cos(d4) * ((double)n * 0.4));
            int n7 = n4 + (int)Math.round(Math.sin(d4) * ((double)n2 * 0.4));
            int n8 = Math.max(n / 16, 3);
            int n9 = Math.max(n2 / 16, 3);
            int n10 = n8 / 2;
            int n11 = n9 / 2;
            graphics.setColor(color.darker());
            graphics.fillOval(n6 - n10, n7 - n11, n8, n9);
            graphics.setColor(color.darker());
            graphics.drawArc(n6 - n10, n7 - n11, n8, n9, 45, 180);
            graphics.setColor(color.darker().darker());
            graphics.drawArc(n6 - n10 + 1, n7 - n11 + 1, n8 - 2, n9 - 2, 45, 180);
            graphics.setColor(color);
            graphics.drawArc(n6 - n10 + 1, n7 - n11 + 1, n8 - 2, n9 - 2, 45, -180);
            graphics.setColor(color.brighter());
            graphics.drawArc(n6 - n10, n7 - n11, n8, n9, 45, -180);
        } else if (n5 == 0) {
            double d5 = d - d2 / 2.0;
            double d6 = d5 * (Math.PI / 180);
            int n12 = (int)Math.round((double)n * 0.7);
            int n13 = (int)Math.round((double)n2 * 0.7);
            int n14 = n3 + (int)Math.round(Math.cos(d6) * ((double)n * 0.1));
            int n15 = n4 + (int)Math.round(Math.sin(d6) * ((double)n2 * 0.1));
            graphics.setColor(color.darker());
            graphics.fillArc(n14 -= (int)Math.round((double)n12 / 2.0), n15 -= (int)Math.round((double)n13 / 2.0), n12 + 1, n13 + 1, (int)(-Math.round(d)), (int)Math.round(d2));
        }
    }

    boolean a(Graphics graphics, Rectangle rectangle) {
        boolean bl;
        boolean bl2 = super.a(graphics, rectangle);
        if (bl2) {
            return true;
        }
        if (!(this.s && this.a1 == 3 || this.aJ && this.ai == 3 || this.isValueLabelsOn() && this.bA == 3 || this.bJ && this.bC == 3)) {
            return false;
        }
        int n = this.getSeriesCount();
        int n2 = this.getSampleCount();
        if (graphics == null || this.bm < 0 || this.bm >= n || this.R < -1 || this.R >= n2) {
            return false;
        }
        Font font = this.getFont("floatingLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        boolean bl3 = this.isValueLabelsOn() && this.bA == 3;
        boolean bl4 = this.bJ && this.bC == 3;
        boolean bl5 = this.s && this.a1 == 3;
        boolean bl6 = bl = this.aJ && n > 1 && this.ai == 3;
        if (this.R >= 0) {
            String string = this.a(this.bm, this.R, bl, bl5, bl3, bl4);
            this.if(graphics, string, this.bm, this.R, font, fontMetrics);
        } else if (this.isFloatingOnLegendOn()) {
            int n3 = 0;
            while (n3 < n2) {
                String string = this.a(this.bm, n3, bl, bl5, bl3, bl4);
                this.if(graphics, string, this.bm, n3, font, fontMetrics);
                ++n3;
            }
        }
        return true;
    }

    private void if(Graphics graphics, String string, int n, int n2, Font font, FontMetrics fontMetrics) {
        int n3 = this.getSeriesCount();
        Point point = this.bx[n3 > 1 ? n2 : 0];
        if (point == null) {
            return;
        }
        double d = 0.0;
        d = n3 == 1 ? (n2 < this.bN[0].length - 1 ? -((this.bN[0][n2] + this.bN[0][n2 + 1]) / 2.0) : -((this.bN[0][n2] - 270.0) / 2.0)) : (n < this.bN.length - 1 ? -((this.bN[n][n2] + this.bN[n + 1][n2]) / 2.0) : -((this.bN[n][n2] - 270.0) / 2.0));
        double d2 = 1.0;
        int n4 = this.bG[n3 == 1 ? 0 : n2];
        if (this.is3DModeOn()) {
            int n5 = (int)Math.round((double)n4 * ((double)this.bM / 90.0));
            d2 = (double)(n4 - n5) / (double)n4;
        }
        double d3 = d * (Math.PI / 180);
        int n6 = point.x + (int)Math.round(Math.cos(d3) * (double)n4 * 0.3);
        int n7 = point.y + (int)Math.round(Math.sin(d3) * (double)n4 * 0.3 * d2);
        Dimension dimension = this.a(string, fontMetrics);
        n6 -= dimension.width / 2;
        n7 -= dimension.height / 2 - fontMetrics.getAscent();
        Dimension dimension2 = this.getSize();
        n6 = Math.max(n6, 3);
        n6 = Math.min(n6, dimension2.width - dimension.width - 3);
        n7 = Math.max(n7, fontMetrics.getAscent());
        n7 = Math.min(n7, dimension2.height - dimension.height + fontMetrics.getAscent() - 1);
        int n8 = fontMetrics.getHeight();
        int n9 = fontMetrics.getDescent();
        graphics.setColor(new Color(255, 255, 231));
        graphics.fillRect(n6 - 2, n7 - n8 + n9 * 2 - 3, dimension.width + 5, dimension.height + 2);
        graphics.setColor(this.getSampleColor(this.getSeriesCount() == 1 ? n2 : n).darker());
        graphics.drawRect(n6 - 3, n7 - n8 + n9 * 2 - 4, dimension.width + 5, dimension.height + 3);
        graphics.setColor(Color.black);
        this.a(graphics, string, n6, n7, dimension, 0, 0);
    }

    private void a(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = this.getSeriesCount();
        boolean bl = this.bJ && this.bC != 3;
        bl |= this.isValueLabelsOn() && this.bA != 3;
        bl |= this.s && this.a1 != 3;
        if (!(bl |= this.aJ && n > 1 && this.ai != 3)) {
            return;
        }
        Font font = this.getFont("insideLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = this.getSampleCount();
        boolean bl2 = this.bJ && this.bC != 3;
        boolean bl3 = this.isValueLabelsOn() && this.bA != 3;
        boolean bl4 = this.aJ && n > 1 && this.ai != 3;
        boolean bl5 = this.s && this.a1 != 3;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                ChartSample chartSample = null;
                chartSample = n == 1 ? this.getSample(0, n4) : this.getSample(n3, n4);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                    String string = this.a(n3, n4, bl4, bl5, bl3, bl2);
                    this.a(graphics, string, n3, n4, font, fontMetrics);
                }
                ++n4;
            }
            ++n3;
        }
    }

    private void a(Graphics graphics, String string, int n, int n2, Font font, FontMetrics fontMetrics) {
        Color color;
        double d;
        int n3 = this.getSeriesCount();
        Point point = this.bx[n3 > 1 ? n2 : 0];
        if (point == null) {
            return;
        }
        double d2 = 0.0;
        double d3 = d = -270.0;
        if (n3 == 1) {
            if (n2 < this.bN[0].length - 1) {
                d = this.bN[0][n2 + 1];
            }
            d3 = this.bN[0][n2];
        } else {
            if (n < this.bN.length - 1) {
                d = this.bN[n + 1][n2];
            }
            d3 = this.bN[n][n2];
        }
        d2 = -((d3 + d) / 2.0);
        double d4 = 1.0;
        int n4 = this.bG[n3 == 1 ? 0 : n2];
        double d5 = 0.0;
        if (this.isSelected(n, n2) && d3 - d < 360.0 && this.bz == 2) {
            d5 = (double)n4 * this.bw / 2.0;
        }
        if (this.is3DModeOn()) {
            int n5 = (int)Math.round((double)n4 * ((double)this.bM / 90.0));
            d4 = (double)(n4 - n5) / (double)n4;
        }
        double d6 = d2 * (Math.PI / 180);
        int n6 = point.x + (int)Math.round(Math.cos(d6) * (double)n4 * 0.35 + Math.cos(d6) * d5);
        int n7 = point.y + (int)Math.round((Math.sin(d6) * (double)n4 * 0.35 + Math.sin(d6) * d5) * d4);
        Dimension dimension = this.a(string, fontMetrics);
        n6 -= dimension.width / 2;
        n7 -= dimension.height / 2 - fontMetrics.getAscent();
        int n8 = 0;
        if (n3 > 1) {
            n8 = n2;
        }
        if ((color = this.getInsideLabelColor(n8)) == null) {
            color = this.getInsideLabelColor(-1);
        }
        if (color == null) {
            Color color2 = this.getSampleColor(n3 == 1 ? n2 : n);
            color = (color2.getRed() + color2.getGreen() + color2.getBlue()) / 3 > 110 ? Color.black : Color.white;
        }
        graphics.setColor(color);
        this.a(graphics, string, n6, n7, dimension, 0, 0);
    }

    private String a(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string;
        int n3 = this.getSeriesCount();
        int n4 = this.getSampleCount();
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n4) {
            return "";
        }
        String string2 = this.getLabel("valueLabelPrefix_" + n);
        if (string2 == null) {
            string2 = this.getLabel("valueLabelPrefix");
        }
        if ((string = this.getLabel("valueLabelPostfix_" + n)) == null) {
            string = this.getLabel("valueLabelPostfix");
        }
        String string3 = bl ? this.getSeriesLabel(n) : null;
        String string4 = bl2 ? this.getSampleLabel(n2) : null;
        String string5 = bl3 ? this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n)) : null;
        string5 = string2 != null && string5 != null ? string2 + string5 : string5;
        string5 = string != null && string5 != null ? string5 + string : string5;
        String string6 = bl4 ? this.formatNumber(this.getPercentValue(n, n2), this.getPercentDecimalCount()) + "%" : null;
        StringBuffer stringBuffer = new StringBuffer();
        if (string3 != null) {
            stringBuffer.append(string3);
            if (!(string3.endsWith("\n") || string4 == null && string5 == null && string6 == null)) {
                stringBuffer.append(" : ");
            }
        }
        if (string4 != null) {
            stringBuffer.append(string4);
            if (!(string4.endsWith("\n") || string5 == null && string6 == null)) {
                stringBuffer.append(" : ");
            }
        }
        if (string5 != null) {
            stringBuffer.append(string5);
            if (!string5.endsWith("\n") && string6 != null) {
                stringBuffer.append(" : ");
            }
        }
        if (string6 != null) {
            stringBuffer.append(string6);
        }
        return stringBuffer.toString();
    }

    boolean a() {
        return this.isValueLabelsOn() && this.bA == 3 || this.s && this.a1 == 3 || this.bJ && this.bC == 3 || this.aJ && this.ai == 3;
    }
}

