/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.gui;

import com.objectplanet.gui.TableData;
import com.objectplanet.gui.TableEvent;
import com.objectplanet.gui.TableListener;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class Table
extends Applet
implements Runnable {
    public static final int SORT_ASCENDING = 0;
    public static final int SORT_DESCENDING = 1;
    public static final int SORT_UNSORTED = 2;
    public static final int COLUMN_TEXT = 0;
    public static final int COLUMN_NUMBER = 1;
    public static final int COLUMN_CURRENCY = 2;
    public static final int COLUMN_DATE = 3;
    public static final int COLUMN_IP = 4;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int SELECT_NONE = 0;
    public static final int SELECT_SINGLE = 1;
    public static final int SELECT_MULTIPLE = 2;
    public static final int BOTTOM = 0;
    public static final int TOP = 1;
    private static final int URL_LINE = 0;
    private static final int URL_NOLINE = 1;
    protected TableData tableData;
    protected double[][] numericalData;
    private int[] sortedList;
    protected int[] displayList;
    private String[] filterDisplayed;
    private String[] filterValues;
    private double[] filterNumbers;
    private int[] filterCheck;
    private static final int FILTER_EQUALS = 0;
    private static final int FILTER_INCLUDES = 1;
    private static final int FILTER_STARTS_WITH = 2;
    private static final int FILTER_ENDS_WITH = 3;
    private static final int FILTER_NOT_EQUAL = 4;
    private static final int FILTER_LARGER = 5;
    private static final int FILTER_LARGER_EQUAL = 6;
    private static final int FILTER_LESS = 7;
    private static final int FILTER_LESS_EQUAL = 8;
    private boolean[] filterOn;
    private String[] headerLabels;
    private Vector listeners;
    private static String[] parameters_all = new String[]{"fieldseparator", "columncount", "header", "headeroff", "headerbackground", "filter", "filteron", "filterbaron", "filterbarposition", "progressivefilteron", "selectionmode", "columnwidth", "columnstretchOn", "columnalignment", "columntype", "rowforeground", "rowbackground", "foreground", "background", "totalrowon", "sortingoff", "filterwildcard", "gridon", "gridcolor", "urlcolor", "urltarget", "urlstyle", "locale", "dateformatinputlocale", "font", "headerfont", "headerfontcolor", "rowfont", "totalrowfont", "totalrowfontcolor", "filterbarfont", "filterbarfontcolor", "alternaterowbackground", "tooltipfilter", "tooltipfelay", "tooltipfelayheader", "tooltipdelayfilter", "tooltipbackground", "defaultsortorder", "sortedcolumn", "labelcacheon"};
    private static String[] parameters_col = new String[]{"prefix_", "postfix_", "decimalcount_", "dateformat_", "dateformatinput_", "image_", "tooltipheader_", "tooltipfilter_"};
    private static String[] parameters_row = new String[]{"rowforeground_", "rowbackground_", "url_", "urltarget_"};
    private static String[] parameters_row_col = new String[]{"url_", "urltarget_", "cellimage_"};
    private double[] columnWidth;
    private int[] columnAlignment;
    private int[] columnType;
    private boolean[] columnOn;
    private boolean[] selectedRows;
    private Color[] headerBackground;
    private Color[] rowForeground;
    private Color[] rowBackground;
    private Color defaultRowForeground;
    private Color defaultRowBackground;
    private boolean automaticRepaintOn;
    private boolean headerOn;
    private boolean filterBarOn;
    private int filterBarPosition;
    private boolean progressiveFilterOn;
    private int selectionMode;
    private String[] columnPrefix;
    private String[] columnPostfix;
    private boolean[] totalRowOn;
    private int[] decimalCount;
    private boolean[] sortingOn;
    private int[] defaultSortOrder;
    private int[] sortOrder;
    private String filterWildCard;
    private Hashtable urlList;
    private Hashtable urlTargetList;
    private Color urlColor;
    private int urlStyle;
    private boolean gridOn;
    private Color gridColor;
    private String fieldSeparator;
    private boolean columnStretchOn;
    private Dimension preferredSize;
    private String loadingDataMessage;
    private boolean loadingMessageOn;
    private boolean loadAndSetURLData;
    private String dataURL;
    private Hashtable fonts;
    private Hashtable fontColors;
    private Vector dateFormatter;
    private Vector dateParserPattern;
    private SimpleDateFormat dateParser;
    private String defaultDatePattern;
    private Locale dateFormatInputLocale;
    private Color alternateRowBackgroundColor;
    private int alternateRowBackgroundCount;
    private int alternateRowBackgroundStart;
    private Hashtable cellImages;
    private Applet parentApplet;
    private String parameterPrefix;
    private Hashtable tooltipLabels;
    private Hashtable tooltipDelays;
    private Color tooltipBackground;
    private int initiallySortedColumn;
    private boolean labelCacheOn;
    private static Hashtable labelCache;
    private int[] rowHeight;
    private int totalRowHeight;
    private boolean rowHeightCalculation;
    private int displayListCount;
    private int[] columnXpos;
    private boolean[] headerPushed;
    private int visibleColumnCount;
    private int selectedHeader;
    private boolean adjusting;
    private double lastClickedPos;
    private int currentSeperator;
    private int currentFilterEditField;
    private int[] filterEditPos;
    private boolean cursorOn;
    private int threadType;
    private Image offscreen;
    private int firstRow;
    private int offset;
    private int lastSelectedRow;
    private int lastSelectedCell;
    private int clickedRow;
    private int clickedCell;
    private long lastSelectedTime;
    private int lastSortedColumn;
    private boolean isSorted;
    private long lastPaintTime;
    private double[] columnTotal;
    private int rowBottom;
    private AppletContext appletContext;
    private boolean loadingData;
    private int loadingDataDots;
    private NumberFormat numberFormatter;
    private NumberFormat currencyFormatter;
    private int[] row_col_index;
    private boolean systemColorPresent;
    private Point lastMousePosition;
    private Object threadLock;
    private int firstSelectedRow;
    private String currentTooltip;
    private boolean tooltipOn;
    private int tooltipCountDown;
    private Thread tooltipThread;
    private boolean vScrollbarOn;
    private boolean upButtonPushed;
    private boolean downButtonPushed;
    private boolean aboveSliderPushed;
    private boolean belowSliderPushed;
    private int vScrollerTop;
    private int vSliderSpace;
    private int vSliderPos;
    private int vSliderSize;
    private int upButtonHeight;
    private int downButtonHeight;
    private boolean vSliderAdjusting;
    private int vSliderAdjustPos;
    private boolean hScrollbarOn;
    private boolean leftButtonPushed;
    private boolean rightButtonPushed;
    private boolean leftToSliderPushed;
    private boolean rightToSliderPushed;
    private int hSliderSpace;
    private int hSliderSize;
    private int hSliderPos;
    private boolean hSliderAdjusting;
    private int hSliderAdjustPos;
    private int maxDisplayRowCount;
    private int scrollByPageToY;
    private int scrollByPageToX;
    private Thread scrollerThread;
    private static final int DOUBLE_CLICK_DELAY = 500;
    private static final int BORDER = 2;
    private static final int COLUMN_WIDTH = 100;
    private static final int LESS = -1;
    private static final int EQUAL = 0;
    private static final int LARGER = 1;
    private static final int SCROLLER = 15;
    private static final Cursor DEFAULT_CURSOR;
    private static final Cursor HAND_CURSOR;
    private static final Cursor RESIZE_CURSOR;
    private static final Cursor TEXT_CURSOR;
    private static final int THREAD_SCROLL_LEFT_BUTTON = 1;
    private static final int THREAD_SCROLL_RIGHT_BUTTON = 2;
    private static final int THREAD_SCROLL_UP_BUTTON = 3;
    private static final int THREAD_SCROLL_DOWN_BUTTON = 4;
    private static final int THREAD_JUMP_LEFT_BUTTON = 5;
    private static final int THREAD_JUMP_RIGHT_BUTTON = 6;
    private static final int THREAD_JUMP_UP_BUTTON = 7;
    private static final int THREAD_JUMP_DOWN_BUTTON = 8;
    private static final int THREAD_LOADING_DATA = 9;
    private static final int THREAD_UPDATE_DATA = 0;
    private static final int THREAD_TOOLTIP_COUNTDOWN = 10;
    private static final int CONTINOUS_SCROLL_DELAY = 35;
    private static final Font DEFAULT_FONT;

    public Insets getInsets() {
        return new Insets(3, 3, 2, 2);
    }

    public boolean isTotalRowOn(int n) {
        boolean bl = false;
        if (n >= 0 && n < this.totalRowOn.length) {
            return this.totalRowOn[n];
        }
        if (n == -1) {
            int n2 = 0;
            while (n2 < this.totalRowOn.length) {
                if (this.totalRowOn[n2]) {
                    bl = true;
                }
                ++n2;
            }
        }
        return bl;
    }

    private Date parseDate(int n, String string) {
        if (n < 0 || n >= this.dateParserPattern.size() || string == null) {
            return null;
        }
        String string2 = (String)this.dateParserPattern.elementAt(n);
        if (string2 != null && string2.trim().length() > 0) {
            this.dateParser.applyPattern(string2);
        } else {
            this.dateParser.applyPattern(this.defaultDatePattern);
        }
        try {
            return this.dateParser.parse(string);
        }
        catch (ParseException parseException) {
            System.out.println("Invalid date and time pattern match: " + string + " " + this.dateParser.toPattern());
            return null;
        }
    }

    private static String convertLineBreaks(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (n2 < cArray.length - 1 && cArray[n2] == '\\' && cArray[n2 + 1] == 'n') {
                cArray2[n++] = 10;
                ++n2;
            } else {
                cArray2[n++] = cArray[n2];
            }
            ++n2;
        }
        return new String(cArray2, 0, n);
    }

    public void setLabelCacheOn(boolean bl) {
        this.labelCacheOn = bl;
    }

    private void calculateRowHeight(int n) {
        Font font;
        if (n >= this.rowHeight.length) {
            this.rowHeight = Table.createArrayCopy(this.rowHeight, n + 100, 0);
        }
        if ((font = this.getFont("rowFont")) == null) {
            font = this.getFont();
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        this.getColumnCount();
        int n3 = this.getColumnCount();
        int n4 = n2 + 2;
        if (n >= 0) {
            int n5 = n4;
            int n6 = 0;
            while (n6 < n3) {
                Image image = this.getImage(n6, n);
                if (image != null) {
                    n5 = Math.max(n5, image.getHeight(this) + 2);
                }
                ++n6;
            }
            this.rowHeight[n] = n5;
        } else {
            int n7 = 0;
            if (this.rowHeight != null) {
                n7 = Math.min(this.rowHeight.length, this.tableData.getLastIndex() + 1);
            }
            int n8 = 0;
            while (n8 < n7) {
                int n9 = n4;
                if (this.tableData.containsRow(n8)) {
                    int n10 = 0;
                    while (n10 < n3) {
                        Image image = this.getImage(n10, n8);
                        if (image != null) {
                            n9 = Math.max(n9, image.getHeight(this) + 2);
                        }
                        ++n10;
                    }
                    this.rowHeight[n8] = n9;
                } else {
                    this.rowHeight[n8] = 0;
                }
                ++n8;
            }
            this.totalRowHeight = 0;
            n8 = 0;
            while (n8 < this.displayListCount) {
                if (this.displayList[n8] < this.rowHeight.length) {
                    this.totalRowHeight += this.rowHeight[this.displayList[n8]];
                }
                ++n8;
            }
        }
    }

    public static String getVersion() {
        return "2.0pre3";
    }

    private void paint3DBox(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(n, n2, n3, n4);
        if (bl) {
            graphics.setColor(this.getBackground().darker());
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        } else {
            graphics.setColor(Color.white);
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
            graphics.setColor(Color.black);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - 2);
            graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
        }
    }

    protected void autoRepaint() {
        if (this.automaticRepaintOn) {
            this.repaint();
        }
    }

    public boolean isRowSelected(int n) {
        if (n >= 0 && n < this.selectedRows.length) {
            return this.selectedRows[n];
        }
        return false;
    }

    private static Color createColor(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if ((string = string.trim().toLowerCase()).indexOf(",") >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            try {
                return new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (Exception exception) {
                System.out.println("Invalid RGB color: " + string);
            }
        } else if (string.startsWith("#")) {
            try {
                return new Color(Integer.parseInt(string.substring(1, 3), 16), Integer.parseInt(string.substring(3, 5), 16), Integer.parseInt(string.substring(5, 7), 16));
            }
            catch (Exception exception) {
                System.out.println("Invalid hex color: " + string);
            }
        } else {
            if (string.equals("black")) {
                return Color.black;
            }
            if (string.equals("blue")) {
                return Color.blue;
            }
            if (string.equals("cyan")) {
                return Color.cyan;
            }
            if (string.equals("darkgray")) {
                return Color.darkGray;
            }
            if (string.equals("gray")) {
                return Color.gray;
            }
            if (string.equals("green")) {
                return Color.green;
            }
            if (string.equals("lightgray")) {
                return Color.lightGray;
            }
            if (string.equals("magenta")) {
                return Color.magenta;
            }
            if (string.equals("orange")) {
                return Color.orange;
            }
            if (string.equals("pink")) {
                return Color.pink;
            }
            if (string.equals("red")) {
                return Color.red;
            }
            if (string.equals("white")) {
                return Color.white;
            }
            if (string.equals("yellow")) {
                return Color.yellow;
            }
            System.out.println("Invalid color name: " + string);
        }
        return null;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
        this.autoRepaint();
    }

    public Color getGridColor() {
        if (this.gridColor != null) {
            return this.gridColor;
        }
        return this.getBackground();
    }

    public boolean gotoRow(int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.displayListCount) {
            if (this.displayList[n3] == n) {
                n2 = n3;
                break;
            }
            n2 = this.displayListCount - 1;
            ++n3;
        }
        return this.gotoRowPosition(n2);
    }

    public boolean isLabelCacheOn() {
        return this.labelCacheOn;
    }

    public synchronized void sortColumn(int n, int n2) {
        if (n < -1 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column: " + n);
        }
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Invalid sort order");
        }
        if (n2 == 2) {
            return;
        }
        int n3 = this.getRowCount();
        this.qsort(this.sortedList, 0, n3 - 1, n);
        this.lastSortedColumn = n;
        int n4 = 0;
        while (n4 < this.sortOrder.length) {
            this.sortOrder[n4] = n4 == n ? n2 : 2;
            ++n4;
        }
        if (n2 == 1) {
            n4 = 0;
            while (n4 < n3 / 2 && n4 < this.sortedList.length) {
                int n5 = this.sortedList[n4];
                this.sortedList[n4] = this.sortedList[n3 - 1 - n4];
                this.sortedList[n3 - 1 - n4] = n5;
                ++n4;
            }
        }
        this.isSorted = true;
        this.refilterTable();
        this.autoRepaint();
    }

    public boolean isProgressiveFilterOn() {
        return this.progressiveFilterOn;
    }

    public boolean isGridOn() {
        return this.gridOn;
    }

    public void setFilterFields(Object[] objectArray) {
        int n = 0;
        while (n < this.filterDisplayed.length) {
            if (objectArray != null && n < objectArray.length && objectArray[n] != null) {
                if (objectArray[n] instanceof String) {
                    this.filterDisplayed[n] = ((String)objectArray[n]).trim();
                } else if (objectArray[n] instanceof Date) {
                    this.filterDisplayed[n] = this.getDateString((Date)objectArray[n], n);
                }
            } else {
                this.filterDisplayed[n] = null;
            }
            if (n < this.filterEditPos.length && this.filterDisplayed[n] != null && this.filterDisplayed[n].length() > 0) {
                this.filterEditPos[n] = this.filterDisplayed[n].length();
            } else if (n < this.filterEditPos.length) {
                this.filterEditPos[n] = 0;
            }
            this.setFilterValueAndCheck(n, this.filterDisplayed[n]);
            ++n;
        }
        this.autoRepaint();
    }

    private URL createURL(String string) {
        if (string == null) {
            return null;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            int n;
            URL uRL2 = null;
            try {
                uRL2 = this.getDocumentBase();
            }
            catch (Exception exception) {}
            String string2 = "";
            if (uRL2 != null) {
                string2 = uRL2.toExternalForm();
            }
            if ((n = string2.lastIndexOf("?")) > -1) {
                string2 = string2.substring(0, n);
            }
            if (string.startsWith("/")) {
                int n2;
                String string3 = uRL2.getFile();
                if (string3 != null && string3.trim().length() > 0 && (n2 = string2.lastIndexOf(string3)) >= 0) {
                    string2 = string2.substring(0, n2);
                }
            } else if (!string2.endsWith("/")) {
                string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
            }
            if (string2.startsWith("file:/\\")) {
                string2 = "file://" + string2.substring(8);
            }
            try {
                uRL = new URL(string2 + string);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("Invalid URL: " + string2);
            }
        }
        return uRL;
    }

    private void paintTotalRow(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.getTotalRowHeight();
        int n2 = dimension.width - 4;
        if (this.vScrollbarOn) {
            n2 -= 15;
        }
        int n3 = dimension.height - 2 - n;
        if (this.filterBarOn && this.filterBarPosition == 0) {
            n3 -= this.getFilterHeight();
        }
        if (this.hScrollbarOn) {
            n3 -= 15;
        }
        graphics.setClip(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.defaultRowBackground);
        graphics.fillRect(2, n3, n2, n);
        graphics.setColor(this.getBackground());
        graphics.drawLine(2, n3 + 1, this.columnXpos[this.columnXpos.length - 1] - 1, n3 + 1);
        int n4 = 0;
        while (n4 < this.columnXpos.length) {
            int n5 = this.columnXpos[n4] - 1 - this.offset;
            graphics.drawLine(n5, n3 + 1, n5, n3 + n + 1);
            ++n4;
        }
        Font font = this.getFont("totalRowFont");
        if (font == null) {
            font = this.getFont();
        }
        graphics.setFont(font);
        Color color = this.getFontColor("totalRowFontColor");
        int n6 = 0;
        while (n6 < this.columnXpos.length) {
            if (this.totalRowOn[n6]) {
                NumberFormat numberFormat = NumberFormat.getInstance(this.getLocale());
                if (this.columnType[n6] == 2) {
                    numberFormat = NumberFormat.getCurrencyInstance(this.getLocale());
                }
                numberFormat.setMaximumFractionDigits(this.decimalCount[n6]);
                numberFormat.setMinimumFractionDigits(this.decimalCount[n6]);
                String string = null;
                string = this.columnType[n6] == 1 || this.columnType[n6] == 2 ? numberFormat.format(this.columnTotal[n6]) : Math.round(this.columnTotal[n6]) + "";
                if (this.columnPrefix != null && n6 < this.columnPrefix.length && this.columnPrefix[n6] != null) {
                    string = this.columnPrefix[n6] + string;
                }
                if (this.columnPostfix != null && n6 < this.columnPostfix.length && this.columnPostfix[n6] != null) {
                    string = string + this.columnPostfix[n6];
                }
                if (color != null) {
                    graphics.setColor(color);
                } else {
                    graphics.setColor(this.defaultRowForeground);
                }
                this.paintFieldLabel(graphics, string, n3 + 1, n6, false);
            }
            ++n6;
        }
    }

    public String createArrayString(int[] nArray, String string) {
        if (nArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(nArray[n]);
            if (n < nArray.length - 1) {
                stringBuffer.append(string);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public AppletContext getAppletContext() {
        if (this.parentApplet != null) {
            return this.parentApplet.getAppletContext();
        }
        return super.getAppletContext();
    }

    private void update_data() {
        if (this.dataURL != null && !this.loadingData) {
            if (this.loadAndSetURLData) {
                this.loadURLParameters(this.dataURL);
            } else {
                Hashtable hashtable = new Hashtable();
                this.loadURLParameters(this.dataURL, hashtable);
                this.setParameters(hashtable);
                this.repaint();
            }
            this.notifyListeners(4, -1);
        }
    }

    private void checkLabelCache(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (n < this.columnType.length && objectArray[n] != null) {
                switch (this.columnType[n]) {
                    case 0: 
                    case 3: 
                    case 4: {
                        Object object = objectArray[n];
                        if (labelCache.containsKey(object)) {
                            objectArray[n] = labelCache.get(object);
                            break;
                        }
                        labelCache.put(object, object);
                        break;
                    }
                }
            }
            ++n;
        }
    }

    public void setTooltipDelay(String string, int n) {
        if (string != null) {
            if (n >= 0) {
                this.tooltipDelays.put(string.toLowerCase(), new Integer(n));
            } else {
                this.tooltipDelays.remove(string.toLowerCase());
            }
        }
    }

    public int getTooltipDelay(String string) {
        Integer n;
        int n2 = 1500;
        if (string != null && (n = (Integer)this.tooltipDelays.get(string.toLowerCase())) != null) {
            n2 = n;
        }
        return n2;
    }

    public int[] getSelectedRows() {
        int n = 0;
        int[] nArray = new int[this.selectedRows.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            if (this.selectedRows[n2]) {
                nArray[n++] = n2;
            }
            ++n2;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    private void paintRows(Graphics graphics) {
        int n;
        int n2;
        Font font;
        if (graphics == null || this.displayListCount < 1) {
            return;
        }
        if (this.rowHeightCalculation) {
            this.calculateRowHeight(-1);
            this.rowHeightCalculation = false;
        }
        Dimension dimension = this.getSize();
        int n3 = this.getHeaderHeight();
        int n4 = dimension.height - 2;
        if (this.hScrollbarOn) {
            n4 -= 15;
        }
        if (this.isFilterBarOn() && this.getFilterBarPosition() == 0) {
            n4 -= this.getFilterHeight();
        }
        if (this.isTotalRowOn(-1)) {
            n4 -= this.getTotalRowHeight();
        }
        if ((font = this.getFont("rowFont")) != null) {
            graphics.setFont(font);
        } else {
            graphics.setFont(this.getFont());
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.getAscent();
        int n6 = fontMetrics.getDescent();
        graphics.setClip(0, 0, dimension.width, dimension.height);
        int n7 = n3 + 2 + 1;
        if (this.isFilterBarOn() && this.getFilterBarPosition() == 1) {
            n7 += this.getFilterHeight();
        }
        int n8 = this.firstRow;
        while (n7 < n4 && n8 < this.displayListCount) {
            n2 = this.rowHeight[this.displayList[n8]];
            if (this.alternateRowBackgroundColor != null && n8 >= this.alternateRowBackgroundStart && (n8 - this.alternateRowBackgroundStart) % (this.alternateRowBackgroundCount * 2) < this.alternateRowBackgroundCount) {
                graphics.setColor(this.alternateRowBackgroundColor);
                graphics.fillRect(2, n7, dimension.width - 4, n2);
            }
            if (n8 < this.displayList.length && this.displayList[n8] < this.rowBackground.length && this.rowBackground[this.displayList[n8]] != null) {
                graphics.setColor(this.rowBackground[this.displayList[n8]]);
                graphics.fillRect(2, n7, dimension.width - 4, n2);
            }
            if (n8 < this.displayList.length && this.displayList[n8] < this.selectedRows.length && this.selectedRows[this.displayList[n8]]) {
                if (this.systemColorPresent) {
                    graphics.setColor(SystemColor.textHighlight);
                } else {
                    graphics.setColor(new Color(664682));
                }
                graphics.fillRect(2, n7, dimension.width - 4, n2);
            }
            if (this.getURL(this.displayList[n8], -1) != null && this.urlStyle == 0) {
                if (this.urlColor != null) {
                    graphics.setColor(this.urlColor);
                } else {
                    graphics.setColor(Color.blue);
                }
                n = n7 + n2 / 2 + n5 / 2;
                graphics.drawLine(5, n + 1, this.columnXpos[this.columnXpos.length - 1] - 1, n + 1);
            }
            ++n8;
            n7 += n2;
        }
        n2 = this.getColumnCount();
        n = 0;
        while (n < n2) {
            if (this.columnOn[n]) {
                int n9 = 3;
                if (n > 0 && n <= this.columnXpos.length) {
                    n9 = this.columnXpos[n - 1];
                }
                int n10 = this.columnXpos[0] - 2 - 1;
                if (n > 0 && n < this.columnXpos.length) {
                    n10 = this.columnXpos[n] - this.columnXpos[n - 1];
                }
                if (this.visibleColumnCount > 1) {
                    graphics.setClip(n9 - this.offset, 0, n10 - 1, dimension.height);
                }
                n7 = n3 + 2 + 1;
                if (this.isFilterBarOn() && this.getFilterBarPosition() == 1) {
                    n7 += this.getFilterHeight();
                }
                n8 = this.firstRow;
                while (n7 < n4 && n8 < this.displayListCount) {
                    URL uRL;
                    int n11;
                    int n12 = this.rowHeight[this.displayList[n8]];
                    int n13 = this.displayList[n8];
                    Object[] objectArray = this.getRow(n13, false, false);
                    String string = null;
                    if (objectArray != null && n < objectArray.length) {
                        string = objectArray[n] instanceof String ? (String)objectArray[n] : "";
                    }
                    if (n < this.columnType.length && string != null) {
                        if (this.columnType[n] == 1) {
                            try {
                                double d = this.numericalData[n13][n];
                                this.numberFormatter.setMaximumFractionDigits(this.decimalCount[n]);
                                this.numberFormatter.setMinimumFractionDigits(this.decimalCount[n]);
                                string = this.numberFormatter.format(d);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if (this.columnType[n] == 2) {
                            try {
                                double d = this.numericalData[n13][n];
                                this.currencyFormatter.setMaximumFractionDigits(this.decimalCount[n]);
                                this.currencyFormatter.setMinimumFractionDigits(this.decimalCount[n]);
                                string = this.currencyFormatter.format(d);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if (this.columnType[n] == 3 && objectArray != null && n < objectArray.length && objectArray[n] instanceof Date) {
                            string = this.getDateString((Date)objectArray[n], n);
                        } else if (this.columnType[n] == 4 && objectArray[n] instanceof byte[]) {
                            string = Table.getIPString((byte[])objectArray[n]);
                        }
                    }
                    if (string != null && n < this.columnPrefix.length) {
                        if (this.columnPrefix[n] != null) {
                            string = this.columnPrefix[n] + string;
                        }
                        if (this.columnPostfix[n] != null) {
                            string = string + this.columnPostfix[n];
                        }
                    }
                    int n14 = 0;
                    if (string != null) {
                        n14 = fontMetrics.stringWidth(string);
                    }
                    Image image = this.getImage(n, this.displayList[n8]);
                    int n15 = 0;
                    if (image != null) {
                        n15 = image.getWidth(this);
                    }
                    int n16 = 0;
                    if (image != null) {
                        n16 = image.getHeight(this);
                    }
                    int n17 = n9 - this.offset + 1;
                    int n18 = n9 - this.offset + 3;
                    int n19 = n7 + n12 / 2 + n5 / 2;
                    if (n < this.columnAlignment.length) {
                        switch (this.columnAlignment[n]) {
                            case 0: {
                                if (image == null) break;
                                n18 += n15 + 3;
                                break;
                            }
                            case 2: {
                                if (n >= this.columnXpos.length) break;
                                n18 = this.visibleColumnCount == 1 ? (image != null ? Math.max(n18, this.columnXpos[n] - n14 - 3 - n15 + 3) : Math.max(n18, this.columnXpos[n] - n14 - 3)) : (image != null ? Math.max(n18, this.columnXpos[n] - n14 - 2 - this.offset - n15 + 3) : Math.max(n18, this.columnXpos[n] - n14 - 2 - this.offset));
                                n17 = n18 + n14 + 3;
                                break;
                            }
                            case 1: {
                                n11 = n15 + n14;
                                if (image != null) {
                                    n11 += 3;
                                }
                                int n20 = n9 + n10 / 2 - this.offset;
                                n17 = Math.max(n20 - n11 / 2, n9 + 3 - this.offset);
                                n18 = n17 + n15;
                                if (image == null) break;
                                n18 += 3;
                                break;
                            }
                        }
                    }
                    n11 = 0;
                    if (n8 < this.displayList.length && this.displayList[n8] < this.selectedRows.length) {
                        n11 = this.selectedRows[this.displayList[n8]];
                    }
                    if (this.selectionMode != 0 && n11 != 0 && this.lastSelectedCell == n) {
                        if (this.systemColorPresent) {
                            graphics.setColor(SystemColor.textHighlight.brighter());
                        } else {
                            graphics.setColor(new Color(664682).brighter());
                        }
                        graphics.fillRect(n18 - 2, n19 - n5, n14 + 2, n5 + n6);
                    }
                    if ((uRL = this.getURL(this.displayList[n8], n)) != null && n11 == 0) {
                        if (this.urlColor != null) {
                            graphics.setColor(this.urlColor);
                        } else {
                            graphics.setColor(Color.blue);
                        }
                    } else if (n11 != 0) {
                        if (this.systemColorPresent) {
                            graphics.setColor(SystemColor.textHighlightText);
                        } else {
                            graphics.setColor(Color.white);
                        }
                    } else if (this.isEnabled()) {
                        if (n8 < this.displayList.length && this.displayList[n8] < this.rowForeground.length && this.rowForeground[this.displayList[n8]] != null) {
                            graphics.setColor(this.rowForeground[this.displayList[n8]]);
                        } else {
                            graphics.setColor(this.defaultRowForeground);
                        }
                    } else {
                        graphics.setColor(Color.gray);
                    }
                    if (image != null) {
                        int n21 = n7 + n12 / 2 - n16 / 2;
                        graphics.drawImage(image, n17, n21, this);
                    }
                    if (string != null) {
                        graphics.drawString(string, n18, n19);
                    }
                    if (uRL != null && this.urlStyle == 0 && n14 != 0) {
                        graphics.drawLine(n18 - 1, n19 + 1, n18 + n14, n19 + 1);
                    }
                    ++n8;
                    n7 += n12;
                }
            }
            ++n;
        }
        this.rowBottom = n7;
    }

    public void destroy() {
        TableEvent.closeEvaluation();
        super.destroy();
    }

    public synchronized void setColumnType(int n, int n2) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column: " + n);
        }
        int n3 = this.columnType[n];
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.columnType[n] = n2;
                if (n3 == n2) break;
                if (n2 == 4) {
                    int n4 = this.tableData.getLastIndex();
                    int n5 = 0;
                    while (n5 <= n4) {
                        String string = this.getCellLabel(n5, n);
                        if (string != null && this.numericalData != null && n5 < this.numericalData.length && this.numericalData[n5] != null && n < this.numericalData[n5].length) {
                            this.numericalData[n5][n] = Table.getIPNumber(string);
                        }
                        ++n5;
                    }
                }
                this.calculateTotals();
                this.autoRepaint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column type");
            }
        }
    }

    public int getColumnType(int n) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column: " + n);
        }
        return this.columnType[n];
    }

    public void setFilter(int n, String string) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column: " + n);
        }
        this.filterDisplayed[n] = string;
        if (n < this.filterEditPos.length && this.filterDisplayed[n] != null && this.filterDisplayed[n].length() > 0) {
            this.filterEditPos[n] = this.filterDisplayed[n].length();
        } else if (n < this.filterEditPos.length) {
            this.filterEditPos[n] = 0;
        }
        this.setFilterValueAndCheck(n, string);
        this.refilterTable();
        this.checkScrollBars();
        this.adjustXpos();
        this.autoRepaint();
    }

    public String getFilter(int n) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column: " + n);
        }
        return this.filterDisplayed[n];
    }

    public void setColumnStretchOn(boolean bl) {
        this.columnStretchOn = bl;
        this.adjustXpos();
        this.autoRepaint();
    }

    private void processMousePressed(MouseEvent mouseEvent) {
        Dimension dimension = this.getSize();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.getRowColumnIndex(n, n2, this.row_col_index);
        this.clickedRow = this.row_col_index[0];
        this.lastClickedPos = n;
        int n3 = this.getHeaderHeight();
        int n4 = this.getFilterHeight();
        this.clickedCell = this.get_field(n);
        int n5 = this.get_field_separator(n);
        int n6 = 0;
        if (this.getFilterBarPosition() == 1) {
            n6 = this.getHeaderHeight() + 2 + 1;
        } else {
            n6 = dimension.height - 2 - n4;
            if (this.hScrollbarOn) {
                n6 -= n4;
            }
        }
        this.requestFocus();
        this.selectedHeader = this.clickedCell = this.get_field(n);
        if (n5 >= 0 && n2 > 2 && n2 < n3 + 2) {
            if (this.headerOn) {
                this.adjusting = true;
            }
        } else if (this.selectedHeader >= 0 && n2 > 2 && n2 < n3 + 2) {
            if (this.headerOn && this.sortingOn[this.selectedHeader]) {
                this.headerPushed[this.selectedHeader] = true;
            }
        } else if (this.vScrollbarOn && n > dimension.width - 2 - 15) {
            this.handleVerticalScrollbar(mouseEvent);
        } else if (this.hScrollbarOn && n2 > dimension.height - 2 - 15) {
            this.handleHorizontalScrollbar(mouseEvent);
        } else if (this.selectedHeader >= 0 && n2 > n6 && n2 < n6 + n4) {
            if ((mouseEvent.getModifiers() & 4) == 4) {
                this.setFilter(this.clickedCell, this.filterDisplayed[this.clickedCell]);
                this.setFilterOn(this.clickedCell, !this.filterOn[this.clickedCell]);
                this.notifyListeners(6, this.clickedCell);
            } else {
                this.setFilterFocus(this.clickedCell, true);
            }
        } else if (this.clickedCell >= 0 && n2 > n3 + 2 && n2 < this.rowBottom) {
            this.handleRowSelection(mouseEvent, this.clickedRow, this.clickedCell, this.row_col_index[2]);
        } else {
            this.setFilterFocus(this.clickedCell, false);
            this.handleRowSelection(mouseEvent, this.lastSelectedRow, this.clickedCell, this.row_col_index[2]);
        }
        this.tooltipCountDown = Integer.MAX_VALUE;
        this.currentTooltip = null;
        this.tooltipOn = false;
        this.repaint();
    }

    private void processMouseDragged(MouseEvent mouseEvent) {
        int n = this.getColumnCount();
        if (this.adjusting && n > 1) {
            if (this.columnStretchOn && this.currentSeperator < n - 1) {
                double d;
                double d2 = mouseEvent.getX();
                double d3 = d2 - this.lastClickedPos;
                if (d3 < 0.0) {
                    d = 2.0;
                    if (this.currentSeperator > 0 && this.currentSeperator <= this.columnXpos.length) {
                        d = this.columnXpos[this.currentSeperator - 1];
                    }
                    d3 = -Math.min(Math.abs(d3), (double)this.columnXpos[this.currentSeperator] - d);
                }
                int n2 = this.currentSeperator;
                this.columnWidth[n2] = this.columnWidth[n2] + d3;
                d = this.columnXpos[this.columnXpos.length - 1] - this.columnXpos[this.currentSeperator];
                double d4 = (d - d3) / d;
                int n3 = this.currentSeperator + 1;
                while (n3 < this.columnWidth.length) {
                    int n4 = n3;
                    this.columnWidth[n4] = this.columnWidth[n4] * d4;
                    this.columnWidth[n3] = Math.max(this.columnWidth[n3], 5.0);
                    ++n3;
                }
                this.lastClickedPos = d2;
            } else if (!this.columnStretchOn) {
                int n5 = mouseEvent.getX() + this.offset;
                int n6 = n5 - this.columnXpos[this.currentSeperator];
                int n7 = 0;
                if (this.currentSeperator > 0 && this.currentSeperator <= this.columnXpos.length) {
                    n7 = this.columnXpos[this.currentSeperator - 1];
                }
                if (n5 > n7) {
                    int n8 = this.currentSeperator;
                    this.columnWidth[n8] = this.columnWidth[n8] + (double)n6;
                }
            }
            this.adjustXpos();
            this.checkScrollBars();
            this.repaint();
        } else if (this.vSliderAdjusting) {
            this.adjustVerticalScrollbar(mouseEvent);
        } else if (this.hSliderAdjusting) {
            this.adjustHorizontalScrollbar(mouseEvent);
        }
    }

    private void calculateTotals() {
        int n = this.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            double d = 0.0;
            if (this.columnType[n2] == 1 || this.columnType[n2] == 2) {
                int n3 = 0;
                while (n3 < this.displayListCount) {
                    if (this.displayList[n3] < this.numericalData.length) {
                        d += this.numericalData[this.displayList[n3]][n2];
                    }
                    ++n3;
                }
                this.columnTotal[n2] = d;
            } else {
                this.columnTotal[n2] = this.displayListCount;
            }
            ++n2;
        }
    }

    public void setParameterPrefix(String string) {
        this.parameterPrefix = string;
    }

    public String getParameterPrefix() {
        return this.parameterPrefix;
    }

    public void setPostfix(int n, String string) {
        if (n >= 0 && n < this.columnPostfix.length) {
            this.columnPostfix[n] = string;
            this.autoRepaint();
        }
    }

    public String getPostfix(int n) {
        if (n >= 0 && n < this.columnPostfix.length) {
            return this.columnPostfix[n];
        }
        return null;
    }

    public void setDefaultSortOrder(int n, int n2) {
        if (n >= 0 && n < this.defaultSortOrder.length && (n2 == 0 || n2 == 1)) {
            this.defaultSortOrder[n] = n2;
        }
    }

    public int getDefaultSortOrder(int n) {
        if (n >= 0 && n < this.defaultSortOrder.length) {
            return this.defaultSortOrder[n];
        }
        return 0;
    }

    public int getSortOrder(int n) {
        if (n >= 0 && n < this.sortOrder.length) {
            return this.sortOrder[n];
        }
        return 2;
    }

    public void addTableListener(TableListener tableListener) {
        this.listeners.addElement(tableListener);
    }

    public boolean isColumnOn(int n) {
        try {
            return this.columnOn[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public void setAutomaticRepaintOn(boolean bl) {
        this.automaticRepaintOn = bl;
    }

    private void paintFilter(Graphics graphics) {
        Font font = this.getFont("filterBarFont");
        if (font == null) {
            font = this.getFont();
        }
        graphics.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Dimension dimension = this.getSize();
        int n = this.getFilterHeight();
        graphics.setClip(0, 0, dimension.width, dimension.height);
        int n2 = 0;
        if (this.filterBarPosition == 1) {
            n2 = 2;
            if (this.isHeaderOn()) {
                n2 += this.getHeaderHeight();
            }
        } else {
            n2 = dimension.height - 2 - n;
            if (this.hScrollbarOn) {
                n2 -= 15;
            }
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(3, n2, dimension.width - 4 - 1, n);
        if (this.filterBarPosition == 1) {
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(3, n2 + n, dimension.width, n2 + n);
        }
        int n3 = this.getColumnCount();
        Color color = this.getFontColor("filterBarFontColor");
        int n4 = 0;
        while (n4 < n3) {
            if (this.columnOn[n4] && this.columnWidth[n4] != 0.0) {
                int n5 = 2 - this.offset + 1;
                if (n4 > 0 && n4 <= this.columnXpos.length) {
                    n5 = this.columnXpos[n4 - 1] - this.offset;
                }
                int n6 = 0;
                if (n4 > 0 && n4 < this.columnXpos.length) {
                    n6 = this.columnXpos[n4] - this.columnXpos[n4 - 1];
                } else if (n4 >= 0 && n4 < this.columnXpos.length) {
                    n6 = this.columnXpos[n4] - 2 - 1;
                }
                graphics.setClip(0, 0, dimension.width, dimension.height);
                if (this.filterOn[n4]) {
                    graphics.setColor(this.getBackground());
                } else if (this.defaultRowBackground != null) {
                    graphics.setColor(this.defaultRowBackground);
                } else {
                    graphics.setColor(Color.white);
                }
                graphics.fillRect(n5, n2 + 1, n6 - 2, n - 3);
                graphics.setColor(this.getBackground());
                graphics.draw3DRect(n5, n2 + 1, n6 - 2, n - 3, false);
                String string = this.filterDisplayed[n4];
                if (color != null) {
                    graphics.setColor(color);
                } else {
                    graphics.setColor(this.getForeground());
                }
                int n7 = this.paintFieldLabel(graphics, string, n2, n4, false);
                if (this.currentFilterEditField == n4 && this.cursorOn) {
                    int n8 = n7;
                    if (string != null && n4 < this.filterEditPos.length) {
                        if (this.filterEditPos[n4] < string.length()) {
                            String string2 = string.substring(0, this.filterEditPos[n4]);
                            if (string2 != null) {
                                n8 += fontMetrics.stringWidth(string2);
                            }
                        } else {
                            n8 += fontMetrics.stringWidth(string);
                        }
                    }
                    graphics.setColor(this.getForeground());
                    graphics.drawLine(n8, n2 + 3, n8, n2 + n - 3);
                    graphics.drawLine(n8 + 1, n2 + 3, n8 + 1, n2 + n - 3);
                }
            }
            ++n4;
        }
        if (this.visibleColumnCount > 1) {
            n4 = this.columnXpos[this.columnXpos.length - 1] - this.offset;
            graphics.setClip(0, 0, dimension.width, dimension.height);
            if (this.defaultRowBackground != null) {
                graphics.setColor(this.defaultRowBackground);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.fillRect(n4, n2 + 1, dimension.width, n - 2);
            graphics.setColor(this.getBackground());
            graphics.draw3DRect(n4, n2 + 1, dimension.width, n - 3, false);
        }
    }

    private void paintBorder(Graphics graphics) {
        int n = 2;
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.getBackground());
        graphics.setClip(0, 0, dimension.width, dimension.height);
        int n2 = 0;
        while (n2 < n) {
            graphics.drawRect(rectangle.x + n2, rectangle.y + n2, rectangle.width - n2 * 2, rectangle.height - n2 * 2);
            ++n2;
        }
        graphics.draw3DRect(rectangle.x + n, rectangle.y + n, rectangle.width - n * 2, rectangle.height - n * 2, false);
        graphics.setColor(Color.black);
        graphics.drawLine(rectangle.x + n, rectangle.y + n, rectangle.x + n, rectangle.height - n);
        graphics.drawLine(rectangle.x + n, rectangle.y + n, rectangle.width - n, rectangle.y + n);
    }

    private int getHeaderHeight() {
        int n = 0;
        if (this.headerOn) {
            Font font = this.getFont("headerFont");
            FontMetrics fontMetrics = null;
            fontMetrics = font != null ? this.getFontMetrics(font) : this.getFontMetrics(this.getFont());
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.headerLabels.length) {
                if (this.headerLabels[n2] != null && this.headerLabels[n2].indexOf(10) != -1) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) {
                n2 = 0;
                int n3 = 0;
                while (n3 < this.headerLabels.length) {
                    if (this.headerLabels[n3] != null && this.headerLabels[n3].indexOf(10) != -1) {
                        StringTokenizer stringTokenizer = new StringTokenizer(this.headerLabels[n3], "\n");
                        n2 = Math.max(n2, stringTokenizer.countTokens());
                    }
                    ++n3;
                }
                n = n2 * (fontMetrics.getMaxAscent() + 1) + 7;
            } else {
                n = fontMetrics.getHeight() + 6;
            }
        }
        return n;
    }

    public void run() {
        switch (this.threadType) {
            case 9: {
                this.initLoadData();
                break;
            }
            case 0: {
                this.update_data();
                break;
            }
            case 4: {
                try {
                    Thread.sleep(250L);
                    while (true) {
                        Thread.sleep(35L);
                        if (this.displayListCount - this.firstRow <= this.maxDisplayRowCount) continue;
                        ++this.firstRow;
                        this.vSliderPos = this.vScrollerTop + 1 + 15 + (int)Math.round((double)this.firstRow / (double)(this.displayListCount - this.maxDisplayRowCount) * (double)(this.vSliderSpace - this.vSliderSize - 2));
                        this.repaint();
                        this.notifyListeners(null, 7, -1, this.firstRow, this.getRowIndex(this.firstRow), null);
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            case 3: {
                try {
                    Thread.sleep(250L);
                    while (true) {
                        Thread.sleep(35L);
                        if (this.firstRow <= 0) continue;
                        this.firstRow += -1;
                        this.vSliderPos = this.vScrollerTop + 1 + 15 + (int)Math.round((double)this.firstRow / (double)(this.displayListCount - this.maxDisplayRowCount) * (double)(this.vSliderSpace - this.vSliderSize - 2));
                        this.repaint();
                        this.notifyListeners(null, 7, -1, this.firstRow, this.getRowIndex(this.firstRow), null);
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            case 8: {
                try {
                    Thread.sleep(250L);
                    while (true) {
                        Thread.sleep(35L);
                        if (this.scrollByPageToY <= this.vSliderPos + this.vSliderSize) continue;
                        this.firstRow += this.maxDisplayRowCount;
                        this.firstRow = Math.min(this.firstRow, this.displayListCount - this.maxDisplayRowCount);
                        this.vSliderPos = this.vScrollerTop + 1 + 15 + (int)Math.round((double)this.firstRow / (double)(this.displayListCount - this.maxDisplayRowCount) * (double)(this.vSliderSpace - this.vSliderSize - 2));
                        this.repaint();
                        this.notifyListeners(null, 7, -1, this.firstRow, this.getRowIndex(this.firstRow), null);
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            case 7: {
                try {
                    Thread.sleep(250L);
                    while (true) {
                        Thread.sleep(35L);
                        if (this.scrollByPageToY >= this.vSliderPos) continue;
                        this.firstRow -= this.maxDisplayRowCount;
                        this.firstRow = Math.max(this.firstRow, 0);
                        this.vSliderPos = this.vScrollerTop + 1 + 15 + (int)Math.round((double)this.firstRow / (double)(this.displayListCount - this.maxDisplayRowCount) * (double)(this.vSliderSpace - this.vSliderSize - 2));
                        this.repaint();
                        this.notifyListeners(null, 7, -1, this.firstRow, this.getRowIndex(this.firstRow), null);
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            case 2: {
                try {
                    Thread.sleep(250L);
                    int n = 17 + this.hSliderSpace;
                    int n2 = this.columnXpos[this.columnXpos.length - 1];
                    while (true) {
                        Thread.sleep(35L);
                        if (n2 - this.offset <= n + 15) continue;
                        int n3 = n2 - this.offset - n - 15 - 1;
                        this.offset += Math.min(10, n3);
                        int n4 = this.hSliderSpace + 30;
                        this.hSliderPos = 18 + (int)Math.round((double)(this.offset + 3) / (double)(n2 - n4) * (double)(this.hSliderSpace - this.hSliderSize));
                        this.repaint();
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            case 1: {
                try {
                    Thread.sleep(250L);
                    while (true) {
                        Thread.sleep(35L);
                        int n = this.columnXpos[this.columnXpos.length - 1];
                        int n5 = this.hSliderSpace + 30;
                        if (this.offset <= 0) continue;
                        this.offset -= 10;
                        this.offset = Math.max(0, this.offset);
                        this.hSliderPos = 18 + (int)Math.round((double)this.offset / (double)(n - n5) * (double)(this.hSliderSpace - this.hSliderSize));
                        this.repaint();
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            case 6: {
                try {
                    Thread.sleep(250L);
                    int n = this.columnXpos[this.columnXpos.length - 1];
                    while (true) {
                        Thread.sleep(35L);
                        if (this.scrollByPageToX < this.hSliderPos + this.hSliderSize) continue;
                        int n6 = n - this.offset - 2 - this.hSliderSpace - 30 - 1;
                        this.offset += Math.min(15 + this.hSliderSpace, n6);
                        int n7 = this.hSliderSpace + 30;
                        this.hSliderPos = 18 + (int)Math.round((double)(this.offset + 3) / (double)(n - n7) * (double)(this.hSliderSpace - this.hSliderSize));
                        this.repaint();
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            case 5: {
                try {
                    Thread.sleep(250L);
                    int n = this.columnXpos[this.columnXpos.length - 1];
                    while (true) {
                        Thread.sleep(35L);
                        if (this.scrollByPageToX >= this.hSliderPos) continue;
                        this.offset -= 15 + this.hSliderSpace;
                        this.offset = Math.max(this.offset, 0);
                        int n8 = this.hSliderSpace + 30;
                        this.hSliderPos = 18 + (int)Math.round((double)this.offset / (double)(n - n8) * (double)(this.hSliderSpace - this.hSliderSize));
                        this.repaint();
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            case 10: {
                while (true) {
                    this.tooltipCountDown = Integer.MAX_VALUE;
                    while (this.tooltipCountDown > 0) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.tooltipCountDown -= 100;
                    }
                    this.tooltipOn = true;
                    this.repaint();
                }
            }
        }
    }

    public void init() {
        if (this.getParameter("loadingMessageOn") != null) {
            this.loadingMessageOn = this.getParameter("loadingMessageOn").trim().equalsIgnoreCase("true");
        }
        this.loadingDataMessage = this.getParameter("loadingDataMessage");
        this.dataURL = this.getParameter("data");
        this.automaticRepaintOn = false;
        if (this.loadingMessageOn || this.loadAndSetURLData) {
            this.loadingData = true;
            this.threadType = 9;
            Thread thread = new Thread((Runnable)this, "THREAD_LOADING_DATA");
            thread.start();
        } else {
            this.initLoadData();
        }
    }

    public void setDecimalCount(int n, int n2) {
        try {
            this.decimalCount[n] = Math.max(0, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid column: " + n);
        }
        this.autoRepaint();
    }

    public int getDecimalCount(int n) {
        try {
            return this.decimalCount[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid column: " + n);
        }
    }

    private void adjustVerticalScrollbar(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        int n2 = n - this.vSliderAdjustPos;
        if (n < this.vSliderPos && n2 > 0 || n > this.vSliderPos + this.vSliderSize && n2 < 0) {
            this.vSliderAdjustPos = n;
            return;
        }
        this.vSliderPos += n2;
        this.vSliderPos = Math.max(this.vSliderPos, this.vScrollerTop + 15 + 1);
        this.vSliderPos = Math.min(this.vSliderPos, this.vScrollerTop + 15 + this.vSliderSpace - this.vSliderSize - 1);
        int n3 = this.vSliderPos - this.vScrollerTop - 15 - 1;
        this.firstRow = (int)Math.round((double)(n3 * (this.displayListCount - this.maxDisplayRowCount)) / (double)(this.vSliderSpace - this.vSliderSize - 2));
        this.vSliderAdjustPos = n;
        this.repaint();
        this.notifyListeners(null, 7, -1, this.firstRow, this.getRowIndex(this.firstRow), null);
    }

    private void adjustXpos() {
        int n;
        Dimension dimension = this.getSize();
        int n2 = dimension.width - 2;
        if (this.vScrollbarOn) {
            n2 -= 15;
        }
        if (this.columnStretchOn) {
            double d = 0.0;
            n = 0;
            while (n < this.columnWidth.length) {
                if (this.columnOn[n]) {
                    d += this.columnWidth[n];
                }
                ++n;
            }
            n = n2 - 2;
            int n3 = 0;
            while (n3 < this.columnWidth.length) {
                double d2 = 0.0;
                if (this.columnOn[n3]) {
                    d2 = this.columnWidth[n3];
                }
                this.columnWidth[n3] = (double)n * (d2 / d);
                ++n3;
            }
        }
        int n4 = 3;
        int n5 = this.getColumnCount();
        n = 0;
        while (n < n5) {
            if (this.columnOn[n]) {
                n4 = (int)((double)n4 + this.columnWidth[n]);
            }
            this.columnXpos[n] = n4;
            ++n;
        }
        if (this.columnStretchOn || n5 == 1) {
            this.columnXpos[this.columnXpos.length - 1] = n2;
        }
    }

    public int getRowPosition(int n) {
        if (n >= 0) {
            int n2 = 0;
            while (n2 < this.displayListCount) {
                if (this.displayList[n2] == n) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    private void handleRowSelection(MouseEvent mouseEvent, int n, int n2, int n3) {
        if (n < 0 && this.getURL(n, n2) != null) {
            return;
        }
        this.lastSelectedCell = n2;
        Object[] objectArray = null;
        if (n >= 0) {
            objectArray = this.getRow(n, true, true);
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        switch (this.selectionMode) {
            case 0: {
                int n4 = 0;
                if (mouseEvent.isMetaDown()) {
                    n4 = 3;
                }
                this.lastSelectedRow = n;
                this.notifyListeners(objectArray, n4, n2, n3, n, point);
                break;
            }
            case 1: {
                long l;
                int n5;
                if (n != -1 && n != this.lastSelectedRow && this.lastSelectedRow >= 0 && this.lastSelectedRow <= this.tableData.getLastIndex()) {
                    n5 = this.lastSelectedRow;
                    if (this.lastSelectedRow >= 0 && this.tableData.containsRow(n5)) {
                        this.selectRow(this.lastSelectedRow, false);
                        this.notifyListeners(this.getRow(n5, true, true), 1, -1, -1, n5, point);
                    }
                }
                n5 = this.lastSelectedRow;
                if (n >= 0) {
                    this.selectRow(n, true);
                }
                if (this.filterBarOn) {
                    this.setFilterFields(objectArray);
                }
                int n6 = 0;
                if (mouseEvent.isMetaDown()) {
                    n6 = 3;
                }
                if ((l = System.currentTimeMillis()) - this.lastSelectedTime < 500L && n == n5) {
                    this.notifyListeners(objectArray, 2, n2, n3, n, point);
                } else {
                    this.notifyListeners(objectArray, n6, n2, n3, n, point);
                }
                this.lastSelectedTime = l;
                break;
            }
            case 2: {
                if (n3 != -1 && n != -1 && n2 != -1) {
                    if (mouseEvent.isShiftDown()) {
                        this.lastSelectedRow = Math.max(this.lastSelectedRow, 0);
                        int n7 = Math.min(this.getRowPosition(this.lastSelectedRow), n3);
                        int n8 = Math.max(this.getRowPosition(this.lastSelectedRow), n3);
                        int n9 = n7;
                        while (n9 <= n8) {
                            this.selectRow(this.displayList[n9], this.isRowSelected(this.lastSelectedRow));
                            if (this.selectedRows[this.displayList[n9]]) {
                                this.notifyListeners(this.getRow(this.displayList[n9]), 0, n2, n9, this.displayList[n9], point);
                            } else {
                                this.notifyListeners(this.getRow(this.displayList[n9]), 1, n2, n9, this.displayList[n9], point);
                            }
                            ++n9;
                        }
                        this.selectRow(this.displayList[n3], this.isRowSelected(this.lastSelectedRow));
                        if (this.selectedRows[n]) {
                            this.setFilterFields(objectArray);
                        } else {
                            this.setFilterFields(null);
                        }
                    } else {
                        this.selectRow(n, !this.isRowSelected(n));
                        if (this.selectedRows[n]) {
                            this.setFilterFields(objectArray);
                            this.notifyListeners(objectArray, 0, n2, n3, n, point);
                        } else {
                            this.setFilterFields(null);
                            this.notifyListeners(objectArray, 1, n2, n3, n, point);
                        }
                    }
                }
                this.firstSelectedRow = -1;
                break;
            }
        }
        this.setFilterFocus(-1, false);
    }

    public void stop() {
        TableEvent.closeEvaluation();
        super.stop();
    }

    private void addURL(int n, int n2, URL uRL) {
        if (n < 0 || n2 < -1) {
            return;
        }
        Integer n3 = null;
        n3 = n2 == -1 ? new Integer(n) : new Integer(1000000 + n * 1000 + n2);
        if (uRL != null) {
            this.urlList.put(n3, uRL);
        } else {
            this.urlList.remove(n3);
        }
    }

    private void paintTooltip(Graphics graphics, String string, Point point) {
        if (graphics == null || string == null || point == null) {
            return;
        }
        String string2 = (String)this.tooltipLabels.get(string.toLowerCase());
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = stringArray.length * fontMetrics.getMaxAscent() + 1;
            int n3 = 0;
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (stringArray[n4] != null && stringArray[n4].length() > 0) {
                    n3 = Math.max(n3, fontMetrics.stringWidth(stringArray[n4]));
                }
                ++n4;
            }
            n4 = this.lastMousePosition.x + 5;
            int n5 = this.lastMousePosition.y + 25;
            n4 = Math.min(n4, this.getSize().width - 4 - n3 - 1);
            int n6 = 0;
            if (this.isFilterBarOn()) {
                n6 = this.getFilterHeight();
            }
            n5 = Math.min(n5, this.getSize().height - n2 - 8 - n6);
            Color color = this.tooltipBackground;
            if (color == null) {
                color = new Color(0xFFFFE7);
            }
            graphics.setColor(color);
            graphics.fillRect(n4, n5, n3 + 4, n2 + 4);
            graphics.setColor(Color.black);
            graphics.drawRect(n4, n5, n3 + 4, n2 + 4);
            n4 += 2;
            n5 += fontMetrics.getDescent() - 2;
            graphics.setColor(Color.black);
            int n7 = 0;
            while (n7 < stringArray.length) {
                if (stringArray[n7] != null && stringArray[n7].length() > 0) {
                    graphics.drawString(stringArray[n7], n4, n5 + fontMetrics.getMaxAscent() + 1);
                }
                n5 += fontMetrics.getMaxAscent() + 1;
                ++n7;
            }
        }
    }

    private void handleFilterEdit(KeyEvent keyEvent) {
        int n;
        int n2;
        CharSequence charSequence;
        boolean bl;
        char c = keyEvent.getKeyChar();
        int n3 = keyEvent.getKeyCode();
        int n4 = keyEvent.getID();
        this.tooltipCountDown = Integer.MAX_VALUE;
        this.currentTooltip = null;
        this.tooltipOn = false;
        boolean bl2 = false;
        boolean bl3 = bl = this.progressiveFilterOn && this.filterOn != null && this.currentFilterEditField >= 0 && this.currentFilterEditField < this.filterOn.length && this.filterOn[this.currentFilterEditField];
        if (n4 == 400) {
            if (c >= ' ') {
                if (this.filterDisplayed[this.currentFilterEditField] == null) {
                    this.filterDisplayed[this.currentFilterEditField] = "";
                }
                charSequence = new StringBuffer(this.filterDisplayed[this.currentFilterEditField]);
                if (this.currentFilterEditField < this.filterEditPos.length && this.filterEditPos[this.currentFilterEditField] < ((StringBuffer)charSequence).length()) {
                    ((StringBuffer)charSequence).insert(this.filterEditPos[this.currentFilterEditField], c);
                } else {
                    ((StringBuffer)charSequence).append(c);
                }
                this.filterDisplayed[this.currentFilterEditField] = ((StringBuffer)charSequence).toString();
                if (this.currentFilterEditField < this.filterEditPos.length) {
                    int n5 = this.currentFilterEditField;
                    this.filterEditPos[n5] = this.filterEditPos[n5] + 1;
                }
                if (this.currentFilterEditField >= 0 && this.currentFilterEditField < this.filterDisplayed.length) {
                    this.setFilterValueAndCheck(this.currentFilterEditField, this.filterDisplayed[this.currentFilterEditField]);
                }
                bl2 = true;
            }
        } else if (n4 == 401 && this.currentFilterEditField < this.filterEditPos.length) {
            int n6 = this.currentFilterEditField;
            String string = this.filterDisplayed[n6];
            switch (n3) {
                case 36: {
                    this.filterEditPos[n6] = 0;
                    break;
                }
                case 35: {
                    this.filterEditPos[n6] = string.length();
                    break;
                }
                case 37: {
                    this.filterEditPos[n6] = Math.max(0, this.filterEditPos[n6] - 1);
                    break;
                }
                case 39: {
                    this.filterEditPos[n6] = Math.min(string.length(), this.filterEditPos[n6] + 1);
                    break;
                }
                case 127: {
                    if (this.filterEditPos[n6] >= string.length()) break;
                    String string2 = string.substring(0, this.filterEditPos[n6]);
                    String string3 = string.substring(this.filterEditPos[n6]);
                    this.filterDisplayed[this.currentFilterEditField] = string3.length() > 1 ? string2 + string3.substring(1) : string2;
                    bl2 = true;
                    break;
                }
                case 8: {
                    if (this.filterEditPos[n6] <= 0) break;
                    String string4 = string.substring(0, this.filterEditPos[n6]);
                    String string5 = string.substring(this.filterEditPos[n6]);
                    this.filterDisplayed[this.currentFilterEditField] = string4.length() > 1 ? string4.substring(0, string4.length() - 1) + string5 : string5;
                    int n7 = n6;
                    this.filterEditPos[n7] = this.filterEditPos[n7] + -1;
                    bl2 = true;
                    break;
                }
                case 10: {
                    this.filterOn[this.currentFilterEditField] = true;
                    bl = true;
                    break;
                }
                case 27: {
                    this.setFilterFocus(this.currentFilterEditField, false);
                    break;
                }
                case 9: {
                    int n8;
                    int n9 = this.getColumnCount();
                    if (keyEvent.isShiftDown()) {
                        n8 = this.currentFilterEditField;
                        n2 = n8 - 1;
                        if (n2 < 0) {
                            n2 = n9 - 1;
                        }
                        n = 0;
                        while (n < 500 && (!this.columnOn[n2] || this.columnWidth[n2] < 7.0)) {
                            if (--n2 < 0) {
                                n2 = n9 - 1;
                            }
                            ++n;
                        }
                        this.currentFilterEditField = n8 = n2;
                        break;
                    }
                    n8 = this.currentFilterEditField;
                    n2 = (n8 + 1) % n9;
                    n = 0;
                    while (n < 500 && (!this.columnOn[n2] || this.columnWidth[n2] < 7.0)) {
                        n2 = (n2 + 1) % n9;
                        ++n;
                    }
                    this.currentFilterEditField = n8 = n2;
                    break;
                }
            }
        }
        if (bl) {
            this.setFilter(this.currentFilterEditField, this.filterDisplayed[this.currentFilterEditField]);
            this.notifyListeners(6, this.currentFilterEditField);
        }
        if (bl2 && this.selectionMode == 1) {
            charSequence = null;
            if (this.filterDisplayed[this.currentFilterEditField] != null) {
                charSequence = this.filterDisplayed[this.currentFilterEditField].toLowerCase();
            }
            double d = this.filterNumbers[this.currentFilterEditField];
            int n10 = 0;
            if (this.currentFilterEditField >= 0 && this.currentFilterEditField < this.columnType.length) {
                n10 = this.columnType[this.currentFilterEditField];
            }
            n2 = -1;
            n = -1;
            int n11 = 0;
            while (n11 < this.displayListCount) {
                if (n10 == 1 || n10 == 2 && !Double.isNaN(d)) {
                    if (d == this.numericalData[this.displayList[n11]][this.currentFilterEditField]) {
                        n = n11;
                        n2 = this.displayList[n];
                        break;
                    }
                } else {
                    String string = this.getCellLabel(this.displayList[n11], this.currentFilterEditField).toLowerCase();
                    if (string != null && string.indexOf((String)charSequence) >= 0) {
                        n = n11;
                        n2 = this.displayList[n];
                        break;
                    }
                }
                ++n11;
            }
            if (n2 > -1) {
                if (this.lastSelectedRow > -1) {
                    this.selectRow(this.lastSelectedRow, false);
                }
                n11 = this.gotoRow(n2) ? 1 : 0;
                this.selectRow(n2, true);
                this.notifyListeners(this.getRow(n2, true, true), 8, this.currentFilterEditField, n, n2, null);
                if (n11 != 0) {
                    this.notifyListeners(null, 7, -1, n2, n2, null);
                }
            }
        }
        this.cursorOn = true;
        this.repaint();
    }

    private void paintGrid(Graphics graphics) {
        int n;
        if (graphics == null || this.displayListCount < 1) {
            return;
        }
        Dimension dimension = this.getSize();
        graphics.setClip(0, 0, dimension.width, dimension.height);
        int n2 = this.getHeaderHeight();
        int n3 = dimension.height - 2;
        if (this.hScrollbarOn) {
            n3 -= 15;
        }
        if (this.isFilterBarOn() && this.getFilterBarPosition() == 0) {
            n3 -= this.getFilterHeight();
        }
        if (this.isTotalRowOn(-1)) {
            n3 -= this.getTotalRowHeight();
        }
        graphics.setColor(this.getGridColor());
        int n4 = n2 + 3;
        int n5 = this.firstRow;
        while (n5 < this.displayListCount && n4 < n3) {
            n = this.rowHeight[this.displayList[n5]];
            graphics.drawLine(0, n4 + n, this.columnXpos[this.columnXpos.length - 1] - 1, n4 + n);
            n4 += n;
            ++n5;
        }
        n5 = 0;
        while (n5 < this.columnXpos.length) {
            n = this.columnXpos[n5] - this.offset - 1;
            graphics.drawLine(n, 0, n, this.rowBottom);
            ++n5;
        }
    }

    public boolean isHeaderOn() {
        return this.headerOn;
    }

    public void setFilterOn(int n, boolean bl) {
        if (n < -1 || n >= this.filterOn.length) {
            throw new IllegalArgumentException("invalid column index: " + n);
        }
        if (n == -1) {
            int n2 = 0;
            while (n2 < this.filterOn.length) {
                this.filterOn[n2] = bl;
                ++n2;
            }
        } else {
            this.filterOn[n] = bl;
        }
        this.refilterTable();
        this.checkScrollBars();
        this.adjustXpos();
        this.autoRepaint();
    }

    public boolean isFilterBarOn() {
        return this.filterBarOn;
    }

    public void setImage(int n, int n2, Image image) {
        if (n < 0 || n >= this.getColumnCount()) {
            return;
        }
        Integer n3 = null;
        n3 = n2 == -1 ? new Integer(n) : new Integer(1000000 + n * 1000000 + n2);
        if (image != null) {
            this.cellImages.put(n3, image);
        } else {
            this.cellImages.remove(n3);
        }
        if (n2 >= 0 && n2 <= this.tableData.getLastIndex()) {
            int n4 = 0;
            if (n2 < this.rowHeight.length) {
                n4 = this.rowHeight[n2];
            }
            this.calculateRowHeight(n2);
            if (this.matchesFilter(this.getRow(n2, false, false), n2)) {
                this.totalRowHeight = this.totalRowHeight - n4 + this.rowHeight[n2];
            }
        } else if (n2 < 0) {
            this.calculateRowHeight(-1);
        }
        this.checkScrollBars();
        this.autoRepaint();
    }

    public Image getImage(int n, int n2) {
        if (n < 0 || n >= this.getColumnCount()) {
            return null;
        }
        Integer n3 = null;
        n3 = n2 == -1 ? new Integer(n) : new Integer(1000000 + n * 1000000 + n2);
        Image image = (Image)this.cellImages.get(n3);
        if (image == null) {
            n3 = new Integer(n);
            image = (Image)this.cellImages.get(n3);
        }
        return image;
    }

    public boolean isSortingOn(int n) {
        if (n >= 0 && n < this.sortingOn.length) {
            return this.sortingOn[n];
        }
        return false;
    }

    private Font createFont(String string, String string2, int n, int n2) {
        if (string == null) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string3 = string2;
        int n3 = Math.max(0, n2);
        int n4 = n;
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().toLowerCase().trim();
            n4 = string4.equals("bold") ? 1 : (string4.equals("italic") ? 2 : (string4.equals("bolditalic") || string4.equals("italicbold") ? 3 : 0));
        }
        if (stringTokenizer.hasMoreTokens()) {
            try {
                n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 12;
            }
        }
        return new Font(string3, n4, n3);
    }

    public int getLastSelectedCell() {
        return this.lastSelectedCell;
    }

    public void setFilterFocus(int n, boolean bl) {
        if (n >= 0 && bl) {
            this.currentFilterEditField = n;
            this.requestFocus();
            this.cursorOn = true;
        } else {
            this.currentFilterEditField = -1;
            this.cursorOn = false;
        }
        this.autoRepaint();
    }

    public void removeRow(int n) {
        if (n < 0 || n > this.tableData.getLastIndex()) {
            return;
        }
        int n2 = this.tableData.getRowCount();
        this.tableData.removeRow(n);
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            if (this.sortedList[n4] == n) {
                n3 = n4;
            }
            if (this.sortedList[n4] >= n) {
                int n5 = n4;
                this.sortedList[n5] = this.sortedList[n5] + -1;
            }
            ++n4;
        }
        n4 = n3;
        while (n4 < this.sortedList.length - 1) {
            this.sortedList[n4] = this.sortedList[n4 + 1];
            ++n4;
        }
        n4 = this.tableData.getLastIndex();
        int n6 = n;
        while (n6 < n4) {
            if (n6 < this.selectedRows.length - 1) {
                this.selectedRows[n6] = this.selectedRows[n6 + 1];
            }
            if (n6 < this.rowForeground.length - 1) {
                this.rowForeground[n6] = this.rowForeground[n6 + 1];
            }
            if (n6 < this.rowBackground.length - 1) {
                this.rowBackground[n6] = this.rowBackground[n6 + 1];
            }
            if (n6 < this.rowHeight.length - 1) {
                this.rowHeight[n6] = this.rowHeight[n6 + 1];
            }
            ++n6;
        }
        this.removeRowImage(n);
        this.rowHeightCalculation = true;
        this.refilterTable();
        this.checkScrollBars();
        this.adjustXpos();
        this.autoRepaint();
    }

    private String getURLTarget(int n, int n2) {
        String string = n + "_" + n2;
        if (this.urlTargetList.get(string) != null) {
            return (String)this.urlTargetList.get(string);
        }
        string = n + "";
        if (this.urlTargetList.get(string) != null) {
            return (String)this.urlTargetList.get(string);
        }
        return (String)this.urlTargetList.get("default");
    }

    public void setHeaderBackground(int n, Color color) {
        if (this.headerBackground != null && n >= 0 && n < this.headerBackground.length) {
            this.headerBackground[n] = color;
            this.autoRepaint();
        }
    }

    public Color getHeaderBackground(int n) {
        if (this.headerBackground != null && n >= 0 && n < this.headerBackground.length) {
            return this.headerBackground[n];
        }
        return null;
    }

    public void setRowForeground(int n, Color color) {
        if (n == -1) {
            this.defaultRowForeground = color != null ? color : Color.black;
        } else if (n >= 0) {
            if (n >= this.rowForeground.length) {
                this.rowForeground = Table.createArrayCopy(this.rowForeground, n + 50);
            }
            this.rowForeground[n] = color;
        }
        this.autoRepaint();
    }

    public Color getRowForeground(int n) {
        if (n > -1 && n < this.rowForeground.length && this.rowForeground[n] != null) {
            return this.rowForeground[n];
        }
        return this.defaultRowForeground;
    }

    public Table() {
        this(1);
    }

    public Table(int n) {
        this(new TableData(n));
    }

    public Table(TableData tableData) {
        if (tableData == null) {
            throw new IllegalArgumentException("TableData is NULL");
        }
        this.tableData = tableData;
        Object object = this.threadLock = new Object();
        synchronized (object) {
            try {
                this.threadLock.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
            this.threadType = 10;
            this.tooltipThread = new Thread(this);
            this.tooltipThread.start();
            Object var8_3 = null;
        }
        this.row_col_index = new int[3];
        this.listeners = new Vector();
        this.urlList = new Hashtable();
        this.urlTargetList = new Hashtable();
        this.urlTargetList.put("default", "_self");
        this.cellImages = new Hashtable();
        this.tooltipLabels = new Hashtable();
        this.tooltipDelays = new Hashtable();
        this.tooltipDelays.put("tooltipdelay", new Integer(1500));
        this.lastMousePosition = new Point(0, 0);
        int n = tableData.getLastIndex();
        this.rowForeground = new Color[n + 1];
        this.rowBackground = new Color[n + 1];
        this.selectedRows = new boolean[n + 1];
        this.rowHeight = new int[n + 1];
        int n2 = tableData.getRowCount();
        this.displayList = new int[n2];
        this.sortedList = new int[n2];
        int n3 = this.getColumnCount();
        this.numericalData = new double[100][n3];
        this.headerLabels = new String[n3];
        this.headerPushed = new boolean[n3];
        this.filterOn = new boolean[n3];
        this.columnOn = new boolean[n3];
        this.columnWidth = new double[n3];
        this.columnAlignment = new int[n3];
        this.columnType = new int[n3];
        this.filterDisplayed = new String[n3];
        this.filterValues = new String[n3];
        this.filterNumbers = new double[n3];
        this.filterCheck = new int[n3];
        this.filterEditPos = new int[n3];
        this.sortingOn = new boolean[n3];
        this.columnXpos = new int[n3];
        this.columnPrefix = new String[n3];
        this.columnPostfix = new String[n3];
        this.columnTotal = new double[n3];
        this.totalRowOn = new boolean[n3];
        this.decimalCount = new int[n3];
        this.defaultSortOrder = new int[n3];
        this.sortOrder = new int[n3];
        this.headerBackground = new Color[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.columnType[n4] = 0;
            this.columnWidth[n4] = 100.0;
            this.columnAlignment[n4] = 0;
            this.filterDisplayed[n4] = new String();
            this.filterValues[n4] = new String();
            this.columnOn[n4] = true;
            this.sortingOn[n4] = true;
            this.defaultSortOrder[n4] = 0;
            this.sortOrder[n4] = 2;
            ++n4;
        }
        try {
            this.defaultRowBackground = SystemColor.window;
            this.defaultRowForeground = SystemColor.windowText;
            this.setBackground(SystemColor.control);
            this.systemColorPresent = true;
        }
        catch (Throwable throwable) {
            this.defaultRowBackground = Color.white;
            this.defaultRowForeground = Color.black;
            this.setBackground(new Color(13947080));
        }
        this.selectionMode = 0;
        this.firstRow = 0;
        this.lastSelectedRow = -1;
        this.firstSelectedRow = -1;
        this.currentFilterEditField = -1;
        this.lastSortedColumn = -1;
        this.currentSeperator = -1;
        this.visibleColumnCount = tableData.getColumnCount();
        this.hScrollbarOn = false;
        this.vScrollbarOn = false;
        this.upButtonPushed = false;
        this.downButtonPushed = false;
        this.aboveSliderPushed = false;
        this.belowSliderPushed = false;
        this.leftButtonPushed = false;
        this.rightButtonPushed = false;
        this.leftToSliderPushed = false;
        this.rightToSliderPushed = false;
        this.filterWildCard = "*";
        this.preferredSize = new Dimension(100 * n3 + 20, 200);
        this.headerOn = true;
        this.fonts = new Hashtable();
        this.fontColors = new Hashtable();
        this.dateFormatter = new Vector();
        this.dateFormatter.setSize(n3);
        this.dateParser = new SimpleDateFormat();
        this.dateParser.setLenient(false);
        this.dateParserPattern = new Vector();
        this.defaultDatePattern = this.dateParser.toPattern();
        n4 = 0;
        while (n4 < n3) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
            this.dateFormatter.setElementAt(dateFormat, n4);
            ++n4;
        }
        this.alternateRowBackgroundCount = 1;
        this.alternateRowBackgroundStart = 1;
        this.rowHeightCalculation = true;
        this.setFont(DEFAULT_FONT);
        this.filterBarPosition = 0;
        this.initiallySortedColumn = -1;
        this.calculateRowHeight(-1);
        this.checkScrollBars();
        this.adjustXpos();
        this.enableEvents(57L);
        this.automaticRepaintOn = true;
    }

    public synchronized void setColumnCount(int n) {
        n = Math.max(1, n);
        this.tableData.setColumnCount(n);
        this.setColumnDataCount(n);
        this.autoRepaint();
    }

    private synchronized void setRowDataCount(int n, int n2) {
        if (n2 >= this.sortedList.length) {
            this.sortedList = Table.createArrayCopy(this.sortedList, n2 + 50, -1);
        }
        if (n2 >= this.displayList.length) {
            this.displayList = Table.createArrayCopy(this.displayList, n2 + 50, -1);
        }
        if (n >= this.rowBackground.length) {
            this.rowBackground = Table.createArrayCopy(this.rowBackground, n + 50);
        }
        if (n >= this.rowForeground.length) {
            this.rowForeground = Table.createArrayCopy(this.rowForeground, n + 50);
        }
        if (n >= this.selectedRows.length) {
            this.selectedRows = Table.createArrayCopy(this.selectedRows, n + 50);
        }
        if (n >= this.rowHeight.length) {
            this.rowHeight = Table.createArrayCopy(this.rowHeight, n + 50, 0);
        }
    }

    public int getColumnCount() {
        return this.tableData.getColumnCount();
    }

    public void setColumnAlignment(int n, int n2) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column: " + n);
        }
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Invalid column alignment");
        }
        this.columnAlignment[n] = n2;
        this.autoRepaint();
    }

    public int getColumnAlignment(int n) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column: " + n);
        }
        return this.columnAlignment[n];
    }

    public final void paint(Graphics graphics) {
        if (this.numberFormatter == null) {
            this.numberFormatter = NumberFormat.getInstance(this.getLocale());
        }
        if (this.currencyFormatter == null) {
            this.currencyFormatter = NumberFormat.getCurrencyInstance(this.getLocale());
        }
        Dimension dimension = this.getSize();
        if (this.offscreen == null || this.offscreen.getWidth(this) < dimension.width || this.offscreen.getHeight(this) < dimension.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
        }
        Graphics graphics2 = graphics;
        if (this.offscreen != null) {
            graphics2 = this.offscreen.getGraphics();
        }
        this.render(graphics2);
        if (graphics2 != graphics) {
            graphics.drawImage(this.offscreen, 0, 0, this);
            graphics2.dispose();
        }
        if (TableEvent.evaluation) {
            TableEvent.showEvaluation(this);
        }
        super.paint(graphics);
    }

    private void startScrollerThread(int n) {
        if (this.scrollerThread != null) {
            this.scrollerThread.stop();
            this.scrollerThread = null;
        }
        this.threadType = n;
        this.scrollerThread = new Thread(this);
        this.scrollerThread.start();
    }

    public void loadURLParameters(String string) {
        this.loadURLParameters(string, null);
    }

    public void loadURLParameters(String string, Hashtable hashtable) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        URL uRL = this.createURL(string);
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                int n = 0;
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n2 = string2.indexOf("=");
                    if (n2 <= 0) continue;
                    String string3 = string2.substring(0, n2).trim();
                    String string4 = string2.substring(n2 + 1).trim();
                    if (hashtable != null) {
                        hashtable.put(string3.toLowerCase(), string4);
                        if (this.loadingMessageOn && n % 100 == 0) {
                            ++this.loadingDataDots;
                            this.repaint();
                        }
                        ++n;
                        continue;
                    }
                    this.setParameter(string3, string4);
                    this.repaint();
                }
                bufferedReader.close();
                inputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("Error reading from the URL resource: " + uRL.toExternalForm());
                iOException.printStackTrace();
            }
            catch (SecurityException securityException) {
                System.out.println("Error reading from the URL resource: " + uRL.toExternalForm());
                securityException.printStackTrace();
            }
        }
    }

    private String getDateString(Date date, int n) {
        String string = "";
        DateFormat dateFormat = (DateFormat)this.dateFormatter.elementAt(n);
        if (date != null) {
            try {
                string = dateFormat.format(date);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = date.toString();
            }
        }
        return string;
    }

    public int getRowIndex(Object object) {
        return this.tableData.getRowIndex(object);
    }

    public int getRowIndex(int n) {
        if (n >= 0 && n < this.displayList.length) {
            return this.displayList[n];
        }
        return -1;
    }

    private URL getURL(int n, int n2) {
        if (n < 0 || n > this.tableData.getLastIndex() || n2 < -1 || n2 >= this.getColumnCount()) {
            return null;
        }
        Integer n3 = null;
        n3 = n2 == -1 ? new Integer(n) : new Integer(1000000 + n * 1000 + n2);
        URL uRL = (URL)this.urlList.get(n3);
        if (uRL == null) {
            uRL = (URL)this.urlList.get(new Integer(n));
        }
        return uRL;
    }

    protected static String[] getStringArray(String string, String string2) {
        String[] stringArray = new String[]{};
        if (string != null) {
            if (string2 == null) {
                string2 = ",";
            }
            int n = 1;
            int n2 = 0;
            while (n2 >= 0) {
                if ((n2 = string.indexOf(string2, n2)) != -1 && n2 != string.length() - 1) {
                    ++n2;
                    ++n;
                    continue;
                }
                if (n2 != string.length() - 1) continue;
                n2 = -1;
            }
            stringArray = new String[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (n3 < string.length() && string.charAt(n3) == string2.charAt(0)) {
                    stringArray[n4] = "";
                    ++n3;
                } else {
                    int n5 = string.indexOf(string2, n3 + 1);
                    stringArray[n4] = n5 > 0 ? string.substring(n3, n5).trim() : string.substring(n3).trim();
                    n3 = n5 + 1;
                }
                ++n4;
            }
        }
        return stringArray;
    }

    public void setTotalRowOn(int n, boolean bl) {
        if (n >= 0 && n < this.totalRowOn.length) {
            this.totalRowOn[n] = bl;
        } else if (n == -1) {
            int n2 = 0;
            while (n2 < this.totalRowOn.length) {
                this.totalRowOn[n2] = bl;
                ++n2;
            }
        }
        this.checkScrollBars();
        this.autoRepaint();
    }

    private void processMouseMoved(MouseEvent mouseEvent) {
        Dimension dimension = this.getSize();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.getRowColumnIndex(n, n2, this.row_col_index);
        int n3 = this.getHeaderHeight() + 2;
        int n4 = 0;
        if (this.isFilterBarOn()) {
            n4 = this.getFilterHeight();
        }
        int n5 = 0;
        if (this.getFilterBarPosition() == 1) {
            n5 = this.getHeaderHeight() + 2 + 1;
        } else {
            n5 = dimension.height - 2 - n4;
            if (this.hScrollbarOn) {
                n5 -= 15;
            }
        }
        int n6 = dimension.width;
        if (this.visibleColumnCount > 1) {
            n6 = this.columnXpos[this.columnXpos.length - 1];
        }
        if (this.vScrollbarOn) {
            n6 = dimension.width - 15;
        }
        this.currentSeperator = this.get_field_separator(n);
        Cursor cursor = DEFAULT_CURSOR;
        String string = null;
        String string2 = null;
        int n7 = this.columnXpos[this.columnXpos.length - 1];
        if (this.visibleColumnCount == 1) {
            n7 = dimension.width;
        }
        if (this.visibleColumnCount > 1 && n2 < n3 && this.currentSeperator >= 0) {
            if (this.headerOn) {
                cursor = RESIZE_CURSOR;
                string = "tooltipHeader_" + this.row_col_index[1];
                string2 = "tooltipDelayHeader";
            }
        } else if (n2 < n3 && n < n7) {
            if (this.headerOn) {
                cursor = HAND_CURSOR;
                string = "tooltipHeader_" + this.row_col_index[1];
                string2 = "tooltipDelayHeader";
            }
        } else if (n2 > n5 && n2 < n5 + n4 && n < n6) {
            cursor = TEXT_CURSOR;
            string = "tooltipFilter_" + this.row_col_index[1];
            string2 = "tooltipDelayFilter";
            if (this.getTooltip(string) == null) {
                string = "tooltipFilter";
            }
        } else {
            URL uRL;
            String string3 = "";
            if (this.row_col_index[0] >= 0 && (uRL = this.getURL(this.row_col_index[0], this.row_col_index[1])) != null) {
                cursor = HAND_CURSOR;
                string3 = uRL.toString();
            }
            this.currentSeperator = -1;
            if (this.appletContext != null && string3 != null) {
                this.showStatus(string3);
            }
        }
        if (this.getCursor() == null || this.getCursor() != cursor) {
            this.setCursor(cursor);
        }
        if (string != null && this.getTooltip(string) != null) {
            if (!string.equals(this.currentTooltip)) {
                this.currentTooltip = string;
                this.tooltipCountDown = string2 != null ? (this.tooltipDelays.get(string2 = string2.toLowerCase().trim()) != null ? ((Integer)this.tooltipDelays.get(string2)).intValue() : ((Integer)this.tooltipDelays.get("tooltipdelay")).intValue()) : 1500;
            }
            this.repaint();
        } else {
            this.tooltipCountDown = Integer.MAX_VALUE;
            this.tooltipOn = false;
            this.currentTooltip = null;
            this.repaint();
        }
    }

    private static Color[] createArrayCopy(Color[] colorArray, int n) {
        n = Math.max(0, n);
        if (colorArray != null) {
            Color[] colorArray2 = new Color[n];
            System.arraycopy(colorArray, 0, colorArray2, 0, Math.min(colorArray.length, n));
            return colorArray2;
        }
        return new Color[n];
    }

    private static int[] createArrayCopy(int[] nArray, int n, int n2) {
        n = Math.max(0, n);
        if (nArray != null) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
            int n3 = nArray.length;
            while (n3 < nArray2.length) {
                nArray2[n3] = n2;
                ++n3;
            }
            return nArray2;
        }
        nArray = new int[n];
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = n2;
            ++n4;
        }
        return nArray;
    }

    private static boolean[] createArrayCopy(boolean[] blArray, int n) {
        n = Math.max(0, n);
        if (blArray != null) {
            boolean[] blArray2 = new boolean[n];
            System.arraycopy(blArray, 0, blArray2, 0, Math.min(blArray.length, n));
            return blArray2;
        }
        return new boolean[n];
    }

    private void processKeys(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && (this.selectionMode == 1 || this.selectionMode == 2)) {
            this.handleRowKeySelection(keyEvent);
        }
        if (this.currentFilterEditField > -1) {
            this.handleFilterEdit(keyEvent);
        }
    }

    private void paintHeader(Graphics graphics, boolean bl) {
        Dimension dimension = this.getSize();
        int n = this.getHeaderHeight();
        graphics.setClip(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.getBackground());
        graphics.fillRect(3, 3, dimension.width - 4 - 1, n);
        if (bl) {
            Font font = this.getFont("headerFont");
            if (font != null) {
                graphics.setFont(font);
            } else {
                graphics.setFont(this.getFont());
            }
            int n2 = this.getColumnCount();
            int n3 = 0;
            while (n3 < n2) {
                if (this.columnOn[n3]) {
                    int n4;
                    int n5 = 2 - this.offset + 1;
                    if (n3 > 0 && n3 <= this.columnXpos.length) {
                        n5 = this.columnXpos[n3 - 1] - this.offset;
                    }
                    int n6 = 0;
                    if (n3 > 0 && n3 < this.columnXpos.length) {
                        n6 = this.columnXpos[n3] - this.columnXpos[n3 - 1];
                    } else if (n3 < this.columnXpos.length) {
                        n6 = this.columnXpos[n3] - 2 - 1;
                    }
                    boolean bl2 = this.headerPushed[n3];
                    graphics.setClip(0, 0, dimension.width, dimension.height);
                    Color color = this.getBackground();
                    if (this.headerBackground != null && n3 < this.headerBackground.length && this.headerBackground[n3] != null) {
                        color = this.headerBackground[n3];
                        graphics.setColor(color);
                        graphics.fillRect(n5, 3, n6 - 1, n - 1);
                    } else {
                        graphics.setColor(color);
                    }
                    graphics.draw3DRect(n5, 3, n6 - 1, n - 1, !bl2);
                    if (n3 == this.lastSortedColumn) {
                        if (this.getSortOrder(n3) == 0) {
                            int n7 = n5 + n6 - 8;
                            if (n3 < this.columnAlignment.length && this.columnAlignment[n3] == 2) {
                                n7 = n5 + 6;
                            }
                            n4 = 10;
                            graphics.setColor(color.darker());
                            graphics.drawLine(n7, n4, n7 - 3, n4 + 5);
                            graphics.setColor(color.brighter());
                            graphics.drawLine(n7 + 1, n4, n7 + 4, n4 + 5);
                            graphics.drawLine(n7 + 4, n4 + 5, n7 - 2, n4 + 5);
                        } else if (this.getSortOrder(n3) == 1) {
                            int n8 = n5 + n6 - 8;
                            if (n3 < this.columnAlignment.length && this.columnAlignment[n3] == 2) {
                                n8 = n5 + 6;
                            }
                            n4 = 10;
                            graphics.setColor(color.darker());
                            graphics.drawLine(n8 - 3, n4, n8, n4 + 5);
                            graphics.drawLine(n8 - 3, n4, n8 + 4, n4);
                            graphics.setColor(color.brighter());
                            graphics.drawLine(n8 + 4, n4, n8 + 1, n4 + 5);
                        }
                    }
                    if (n3 >= 0 && this.headerLabels != null && n3 < this.headerLabels.length) {
                        Color color2;
                        String string = this.headerLabels[n3];
                        n4 = 4;
                        if (bl2) {
                            ++n4;
                        }
                        if ((color2 = this.getFontColor("headerFontColor")) != null) {
                            graphics.setColor(color2);
                        } else {
                            graphics.setColor(this.getForeground());
                        }
                        this.paintFieldLabel(graphics, string, n4, n3, bl2);
                    }
                }
                ++n3;
            }
        }
        int n9 = this.columnXpos[this.columnXpos.length - 1] - this.offset;
        graphics.setClip(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.getBackground());
        graphics.fill3DRect(n9, 3, dimension.width, n, true);
    }

    private void handleHorizontalScrollbar(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = 17 + this.hSliderSpace;
        int n3 = this.columnXpos[this.columnXpos.length - 1];
        if (n > 2 && n < 17) {
            this.leftButtonPushed = true;
            if (this.offset > 0) {
                this.offset -= 10;
                this.offset = Math.max(0, this.offset);
                int n4 = this.hSliderSpace + 30;
                this.hSliderPos = 18 + (int)Math.round((double)this.offset / (double)(n3 - n4) * (double)(this.hSliderSpace - this.hSliderSize));
                this.startScrollerThread(1);
            }
        } else if (n > n2 && n < n2 + 15) {
            this.rightButtonPushed = true;
            if (n3 - this.offset > n2 + 15) {
                int n5 = n3 - this.offset - n2 - 15 - 1;
                this.offset += Math.min(10, n5);
                int n6 = this.hSliderSpace + 30;
                this.hSliderPos = 18 + (int)Math.round((double)(this.offset + 3) / (double)(n3 - n6) * (double)(this.hSliderSpace - this.hSliderSize));
                this.startScrollerThread(2);
            }
        } else if (n < this.hSliderPos && n >= 17) {
            this.leftToSliderPushed = true;
            this.offset -= 15 + this.hSliderSpace;
            this.offset = Math.max(this.offset, 0);
            int n7 = this.hSliderSpace + 30;
            this.hSliderPos = 18 + (int)Math.round((double)this.offset / (double)(n3 - n7) * (double)(this.hSliderSpace - this.hSliderSize));
            this.scrollByPageToX = n;
            this.startScrollerThread(5);
        } else if (n >= this.hSliderPos + this.hSliderSize && n <= n2) {
            this.rightToSliderPushed = true;
            int n8 = n3 - this.offset - n2 - 15 - 1;
            this.offset += Math.min(15 + this.hSliderSpace, n8);
            int n9 = this.hSliderSpace + 30;
            this.hSliderPos = 18 + (int)Math.round((double)(this.offset + 3) / (double)(n3 - n9) * (double)(this.hSliderSpace - this.hSliderSize));
            this.scrollByPageToX = n;
            this.startScrollerThread(6);
        } else if (n > this.hSliderPos && n < this.hSliderPos + this.hSliderSize) {
            this.hSliderAdjusting = true;
            this.hSliderAdjustPos = n;
        }
    }

    private void removeRowImage(int n) {
        Integer n2;
        if (n < 0) {
            return;
        }
        int n3 = this.getColumnCount();
        int n4 = 0;
        while (n4 < n3) {
            n2 = new Integer(1000000 + n4 * 1000000 + n);
            this.cellImages.remove(n2);
            ++n4;
        }
        Enumeration enumeration = ((Hashtable)this.cellImages.clone()).keys();
        while (enumeration.hasMoreElements()) {
            n2 = (Integer)enumeration.nextElement();
            int n5 = n2;
            if (n5 % 1000000 <= n || !this.cellImages.containsKey(n2)) continue;
            Image image = (Image)this.cellImages.remove(n2);
            this.cellImages.put(new Integer(n5 - 1), image);
        }
    }

    private void handleRowKeySelection(KeyEvent keyEvent) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.displayListCount) {
            if (this.displayList[n2] == this.lastSelectedRow) {
                n = n2;
            }
            ++n2;
        }
        n2 = 0;
        switch (keyEvent.getKeyCode()) {
            case 16: {
                if (this.firstSelectedRow != -1) break;
                this.firstSelectedRow = Math.max(n, 0);
                break;
            }
            case 33: 
            case 36: 
            case 38: {
                int n3;
                if (keyEvent.getKeyCode() == 38) {
                    n2 = Math.max(n - 1, n2);
                } else if (keyEvent.getKeyCode() == 33) {
                    n2 = Math.max(n - this.maxDisplayRowCount, n2);
                }
                if (this.currentFilterEditField >= 0 || n <= 0 || n == n2) break;
                if (this.selectionMode == 1) {
                    this.selectRow(this.displayList[n], false);
                    this.notifyListeners(this.getRow(this.displayList[n], true, true), 1, -1, n, this.displayList[n], null);
                } else {
                    if (this.selectionMode != 2 || !keyEvent.isShiftDown()) break;
                    if (n > this.firstSelectedRow) {
                        n3 = n;
                        while (n3 > Math.max(n2, this.firstSelectedRow)) {
                            this.selectRow(this.displayList[n3], false);
                            this.notifyListeners(this.getRow(this.displayList[n3]), 1, -1, n3, this.displayList[n3], null);
                            --n3;
                        }
                    } else if (n == this.firstSelectedRow) {
                        n3 = 0;
                        while (n3 < this.displayList.length) {
                            if (this.selectedRows[n3]) {
                                this.selectRow(this.displayList[n3], false);
                                this.notifyListeners(this.getRow(this.displayList[n3]), 1, -1, n3, this.displayList[n3], null);
                            }
                            ++n3;
                        }
                    }
                    n3 = Math.min(n, this.firstSelectedRow);
                    while (n3 > n2) {
                        this.selectRow(this.displayList[n3], true);
                        this.notifyListeners(this.getRow(this.displayList[n3]), 0, -1, n3, this.displayList[n3], null);
                        --n3;
                    }
                }
                n3 = this.gotoRow(this.displayList[n2]) ? 1 : 0;
                this.selectRow(this.displayList[n2], true);
                Object[] objectArray = this.getRow(this.displayList[n2], true, true);
                this.setFilterFields(objectArray);
                this.notifyListeners(objectArray, 0, -1, n2, this.displayList[n2], null);
                if (n3 == 0) break;
                this.notifyListeners(null, 7, -1, n2, this.displayList[n2], null);
                break;
            }
            case 34: 
            case 35: 
            case 40: {
                int n4;
                n2 = this.displayListCount - 1;
                if (keyEvent.getKeyCode() == 40) {
                    n2 = Math.min(n + 1, n2);
                } else if (keyEvent.getKeyCode() == 34) {
                    n2 = Math.min(n + this.maxDisplayRowCount, n2);
                }
                if (this.currentFilterEditField >= 0 || n >= this.displayListCount - 1 || n == n2) break;
                if (this.selectionMode == 1) {
                    if (n >= 0) {
                        this.selectRow(this.displayList[n], false);
                        this.notifyListeners(this.getRow(this.displayList[n]), 1, -1, n, this.displayList[n], null);
                    }
                } else {
                    if (this.selectionMode != 2 || !keyEvent.isShiftDown()) break;
                    if (n != -1 && n < this.firstSelectedRow) {
                        n4 = Math.max(0, n);
                        while (n4 < Math.min(n2, this.firstSelectedRow)) {
                            this.selectRow(this.displayList[n4], false);
                            this.notifyListeners(this.getRow(this.displayList[n4]), 1, -1, n4, this.displayList[n4], null);
                            ++n4;
                        }
                    } else if (n == this.firstSelectedRow) {
                        n4 = 0;
                        while (n4 < this.displayList.length) {
                            if (this.selectedRows[n4]) {
                                this.selectRow(this.displayList[n4], false);
                                this.notifyListeners(this.getRow(this.displayList[n4]), 1, -1, n4, this.displayList[n4], null);
                            }
                            ++n4;
                        }
                    }
                    n4 = Math.max(n, this.firstSelectedRow);
                    while (n4 < n2) {
                        if (n4 != -1) {
                            this.selectRow(this.displayList[n4], true);
                            this.notifyListeners(this.getRow(this.displayList[n4]), 0, -1, n4, this.displayList[n4], null);
                        }
                        ++n4;
                    }
                }
                n4 = this.gotoRow(this.displayList[n2]);
                this.selectRow(this.displayList[n2], true);
                Object[] objectArray = this.getRow(this.displayList[n2], true, true);
                this.setFilterFields(objectArray);
                this.notifyListeners(objectArray, 0, -1, n2, this.displayList[n2], null);
                if (n4 == 0) break;
                this.notifyListeners(null, 7, -1, n2, this.displayList[n2], null);
                break;
            }
            case 39: {
                if (this.currentFilterEditField >= 0 || n < 0 || this.lastSelectedCell >= this.getColumnCount() - 1) break;
                ++this.lastSelectedCell;
                this.repaint();
                this.notifyListeners(this.getRow(this.displayList[n], true, true), 0, this.lastSelectedCell, n, this.displayList[n], null);
                break;
            }
            case 37: {
                if (this.currentFilterEditField >= 0 || n < 0 || this.lastSelectedCell <= 0) break;
                this.lastSelectedCell += -1;
                this.repaint();
                this.notifyListeners(this.getRow(this.displayList[n], true, true), 0, this.lastSelectedCell, n, this.displayList[n], null);
                break;
            }
            case 10: {
                if (this.lastSelectedRow < 0) break;
                this.notifyListeners(this.getRow(this.lastSelectedRow, true, true), 2, -1, n, this.lastSelectedRow, null);
                break;
            }
            case 116: {
                if (this.loadingData) break;
                this.updateData(false);
                break;
            }
        }
        this.checkScrollBars();
        this.repaint();
    }

    private synchronized void setColumnDataCount(int n) {
        String[] stringArray = new String[n];
        Color[] colorArray = new Color[n];
        System.arraycopy(this.headerLabels, 0, stringArray, 0, Math.min(this.headerLabels.length, n));
        System.arraycopy(this.headerBackground, 0, colorArray, 0, Math.min(this.headerBackground.length, n));
        this.headerLabels = stringArray;
        this.headerBackground = colorArray;
        double[][] dArray = new double[this.numericalData.length][n];
        int n2 = 0;
        while (n2 < this.numericalData.length) {
            System.arraycopy(this.numericalData[n2], 0, dArray[n2], 0, Math.min(this.numericalData[n2].length, dArray[n2].length));
            ++n2;
        }
        this.numericalData = dArray;
        int[] nArray = new int[n];
        System.arraycopy(this.columnType, 0, nArray, 0, Math.min(this.columnType.length, n));
        this.columnType = nArray;
        int[] nArray2 = new int[n];
        System.arraycopy(this.columnAlignment, 0, nArray2, 0, Math.min(this.columnAlignment.length, n));
        this.columnAlignment = nArray2;
        boolean[] blArray = new boolean[n];
        System.arraycopy(this.columnOn, 0, blArray, 0, Math.min(this.columnOn.length, n));
        int n3 = this.columnOn.length;
        while (n3 < n) {
            blArray[n3] = true;
            ++n3;
        }
        this.columnOn = blArray;
        this.visibleColumnCount = 0;
        n3 = 0;
        while (n3 < n) {
            if (this.columnOn[n3]) {
                ++this.visibleColumnCount;
            }
            ++n3;
        }
        double[] dArray2 = new double[n];
        System.arraycopy(this.columnWidth, 0, dArray2, 0, Math.min(this.columnWidth.length, n));
        int n4 = this.columnWidth.length;
        while (n4 < n) {
            dArray2[n4] = 100.0;
            ++n4;
        }
        this.columnWidth = dArray2;
        this.columnXpos = new int[n];
        this.adjustXpos();
        String[] stringArray2 = new String[n];
        System.arraycopy(this.columnPrefix, 0, stringArray2, 0, Math.min(this.columnPrefix.length, n));
        this.columnPrefix = stringArray2;
        String[] stringArray3 = new String[n];
        System.arraycopy(this.columnPostfix, 0, stringArray3, 0, Math.min(this.columnPostfix.length, n));
        this.columnPostfix = stringArray3;
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(this.headerPushed, 0, blArray2, 0, Math.min(this.headerPushed.length, n));
        this.headerPushed = blArray2;
        String[] stringArray4 = new String[n];
        String[] stringArray5 = new String[n];
        int[] nArray3 = new int[n];
        double[] dArray3 = new double[n];
        boolean[] blArray3 = new boolean[n];
        int[] nArray4 = new int[n];
        System.arraycopy(this.filterDisplayed, 0, stringArray4, 0, Math.min(this.filterDisplayed.length, n));
        System.arraycopy(this.filterValues, 0, stringArray5, 0, Math.min(this.filterValues.length, n));
        System.arraycopy(this.filterCheck, 0, nArray3, 0, Math.min(this.filterCheck.length, n));
        System.arraycopy(this.filterNumbers, 0, dArray3, 0, Math.min(this.filterNumbers.length, n));
        System.arraycopy(this.filterOn, 0, blArray3, 0, Math.min(this.filterOn.length, n));
        System.arraycopy(this.filterEditPos, 0, nArray4, 0, Math.min(this.filterEditPos.length, n));
        this.filterDisplayed = stringArray4;
        this.filterValues = stringArray5;
        this.filterCheck = nArray3;
        this.filterNumbers = dArray3;
        this.filterOn = blArray3;
        this.filterEditPos = nArray4;
        double[] dArray4 = new double[n];
        System.arraycopy(this.columnTotal, 0, dArray4, 0, Math.min(this.columnTotal.length, n));
        this.columnTotal = dArray4;
        boolean[] blArray4 = new boolean[n];
        System.arraycopy(this.totalRowOn, 0, blArray4, 0, Math.min(this.totalRowOn.length, n));
        this.totalRowOn = blArray4;
        int[] nArray5 = new int[n];
        System.arraycopy(this.decimalCount, 0, nArray5, 0, Math.min(this.decimalCount.length, n));
        this.decimalCount = nArray5;
        boolean[] blArray5 = new boolean[n];
        int n5 = 0;
        while (n5 < blArray5.length) {
            blArray5[n5] = true;
            ++n5;
        }
        System.arraycopy(this.sortingOn, 0, blArray5, 0, Math.min(this.sortingOn.length, n));
        this.sortingOn = blArray5;
        int[] nArray6 = new int[n];
        int[] nArray7 = new int[n];
        int n6 = 0;
        while (n6 < nArray6.length) {
            nArray6[n6] = 0;
            nArray7[n6] = 2;
            ++n6;
        }
        System.arraycopy(this.defaultSortOrder, 0, nArray6, 0, Math.min(this.defaultSortOrder.length, n));
        System.arraycopy(this.sortOrder, 0, nArray7, 0, Math.min(this.sortOrder.length, n));
        this.defaultSortOrder = nArray6;
        this.sortOrder = nArray7;
        this.dateFormatter.setSize(n);
        this.dateParserPattern.setSize(n);
        n6 = 0;
        while (n6 < n) {
            if (this.dateFormatter.elementAt(n6) == null) {
                this.dateFormatter.setElementAt(DateFormat.getDateTimeInstance(2, 2), n6);
            }
            ++n6;
        }
    }

    public void setFontColor(String string, Color color) {
        if (string != null) {
            string = string.toLowerCase().trim();
            this.fontColors.remove(string);
            if (color != null) {
                this.fontColors.put(string, color);
            }
            this.autoRepaint();
        }
    }

    public Color getFontColor(String string) {
        if (string != null) {
            return (Color)this.fontColors.get(string.toLowerCase().trim());
        }
        return null;
    }

    private int compare(int n, int n2, int n3, int n4) {
        if (n3 < -1 || n3 >= this.getColumnCount()) {
            return 1;
        }
        if (n == -1 && n2 == -1) {
            return 0;
        }
        if (n == -1) {
            return 1;
        }
        if (n2 == -1) {
            return -1;
        }
        if (n3 == -1) {
            if (n > n2) {
                return 1;
            }
            if (n < n2) {
                return -1;
            }
            return 0;
        }
        Object object = null;
        Object object2 = null;
        if (n4 != 1 && n4 != 2 && n4 != 4) {
            object = this.getCell(n, n3);
            object2 = this.getCell(n2, n3);
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return 1;
            }
            if (object2 == null) {
                return -1;
            }
        }
        switch (n4) {
            case 0: {
                if (object instanceof String && object2 instanceof String) {
                    String string;
                    String string2 = ((String)object).toLowerCase();
                    if (string2.compareTo(string = ((String)object2).toLowerCase()) < 0) {
                        return -1;
                    }
                    if (string2.compareTo(string) > 0) {
                        return 1;
                    }
                }
                return 0;
            }
            case 1: 
            case 2: 
            case 4: {
                if (n < this.numericalData.length && n2 < this.numericalData.length && n3 < this.numericalData[n].length) {
                    double d = this.numericalData[n][n3];
                    double d2 = this.numericalData[n2][n3];
                    if (d < d2) {
                        return -1;
                    }
                    if (d > d2) {
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
            case 3: {
                if (!(object instanceof Date) || !(object2 instanceof Date)) break;
                if (((Date)object).before((Date)object2)) {
                    return -1;
                }
                if (((Date)object).after((Date)object2)) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    public void setDataParameterField(String string, String string2) {
        if (this.dataURL != null && this.dataURL.trim().length() >= 0) {
            if (string != null && string.trim().length() > 0) {
                String string3 = "&";
                int n = this.dataURL.indexOf("&" + string);
                if (n == -1) {
                    n = this.dataURL.indexOf("?" + string);
                    string3 = "?";
                }
                if (n >= 0) {
                    String string4 = null;
                    string4 = this.dataURL.indexOf("&", n + 1) >= 0 ? this.dataURL.substring(n, this.dataURL.indexOf("&", n + 1)) : this.dataURL.substring(n);
                    this.dataURL = string2 != null && string2.length() > 0 ? this.replaceSubstring(this.dataURL, string4, string3 + string + "=" + string2) : this.replaceSubstring(this.dataURL, string4, string3 + string + "=");
                }
            }
        } else if (string != null && string2 != null) {
            this.dataURL = string + "=" + string2;
        }
    }

    private int get_field(int n) {
        int n2 = this.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.columnOn[n3] && n <= this.columnXpos[n3] - 1 - this.offset) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void setColumnOn(int n, boolean bl) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column: " + n);
        }
        this.columnOn[n] = bl;
        this.visibleColumnCount = 0;
        int n2 = 0;
        while (n2 < this.columnOn.length) {
            if (this.columnOn[n2]) {
                ++this.visibleColumnCount;
            }
            ++n2;
        }
        this.adjustXpos();
        this.autoRepaint();
    }

    private int getTotalRowHeight() {
        int n = 20;
        Font font = this.getFont("totalRowFont");
        n = font != null ? this.getFontMetrics(font).getHeight() + 3 : this.getFontMetrics(this.getFont()).getHeight() + 3;
        return n;
    }

    public void setTooltip(String string, String string2) {
        if (string != null && string2 != null && string2.trim().length() > 0) {
            this.tooltipLabels.put(string.toLowerCase(), string2);
        } else if (string != null) {
            this.tooltipLabels.remove(string.toLowerCase());
        }
    }

    public String getTooltip(String string) {
        if (string != null) {
            return (String)this.tooltipLabels.get(string.toLowerCase());
        }
        return null;
    }

    public String getCellLabel(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        if (!this.tableData.containsRow(n)) {
            return null;
        }
        int n3 = 0;
        if (n2 < this.columnType.length) {
            n3 = this.columnType[n2];
        }
        Object object = this.tableData.getCell(n, n2);
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Date) {
            if (object instanceof Date && n2 < this.dateFormatter.size() && this.dateFormatter.elementAt(n2) != null) {
                string = this.getDateString((Date)object, n2);
            }
        } else if (n3 == 1 || n3 == 2) {
            int n4 = this.getDecimalCount(n2);
            this.numberFormatter.setMaximumFractionDigits(n4);
            this.numberFormatter.setMinimumFractionDigits(n4);
            string = this.numberFormatter.format(this.numericalData[n][n2]);
        }
        return string;
    }

    private void checkScrollBars() {
        int n;
        Dimension dimension = this.getSize();
        this.hScrollbarOn = false;
        int n2 = this.columnXpos[this.columnXpos.length - 1];
        if (!this.columnStretchOn && this.visibleColumnCount > 1) {
            n = dimension.width - 2;
            if (this.vScrollbarOn) {
                n -= 15;
            }
            if (n2 > n || this.offset < 0) {
                this.hScrollbarOn = true;
            }
        }
        n = this.getHeaderHeight();
        int n3 = dimension.height - n - 4;
        if (this.hScrollbarOn) {
            n3 -= 15;
        }
        if (this.filterBarOn) {
            n3 -= this.getFilterHeight();
        }
        if (this.isTotalRowOn(-1)) {
            n3 -= this.getTotalRowHeight();
        }
        int n4 = 15;
        if (this.displayListCount > 0) {
            n4 = (int)Math.round((double)this.totalRowHeight / (double)this.displayListCount);
            n4 = Math.max(5, n4);
        }
        this.maxDisplayRowCount = (int)Math.round((double)n3 / (double)n4);
        this.maxDisplayRowCount = Math.max(1, this.maxDisplayRowCount - 1);
        int n5 = Math.max(0, this.maxDisplayRowCount);
        this.vScrollerTop = n + 2;
        int n6 = this.displayListCount - this.firstRow;
        if (n6 < n5 && this.firstRow > 0) {
            this.firstRow = Math.max(this.displayListCount - this.maxDisplayRowCount, 0);
        }
        this.vScrollbarOn = false;
        if (n6 > n5 || this.firstRow > 0) {
            this.vScrollbarOn = true;
        }
        this.vSliderSpace = dimension.height - n - 30 - 2;
        if (this.hScrollbarOn) {
            this.vSliderSpace -= 15;
        }
        this.hSliderSpace = dimension.width - 30 - 4 - 1;
        if (this.vScrollbarOn) {
            this.hSliderSpace -= 15;
        }
        n5 = Math.min(n5, this.displayListCount);
        this.vSliderSize = (int)Math.round((double)n5 / (double)this.displayListCount * (double)this.vSliderSpace) - 2;
        this.vSliderSize = Math.max(this.vSliderSize, 6);
        this.vSliderPos = this.vScrollerTop + 1 + 15 + (int)Math.round((double)this.firstRow / (double)(this.displayListCount - this.maxDisplayRowCount) * (double)(this.vSliderSpace - this.vSliderSize - 2));
        int n7 = this.hSliderSpace + 30;
        int n8 = n7 + 2;
        if (n2 - this.offset < n8) {
            this.offset -= n8 - (n2 - this.offset);
            this.offset = Math.max(0, this.offset);
        }
        this.hSliderSize = (int)Math.round((double)n7 / (double)n2 * (double)this.hSliderSpace);
        this.hSliderSize = Math.max(this.hSliderSize, 6);
        this.hSliderPos = 18 + (int)Math.round((double)this.offset / (double)(n2 - n7) * (double)(this.hSliderSpace - this.hSliderSize));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateData(boolean bl) {
        if (!bl) {
            Object object = this.threadLock;
            synchronized (object) {
                try {
                    this.threadLock.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                this.threadType = 0;
                Thread thread = new Thread((Runnable)this, "THREAD_UPDATE_DATA");
                thread.start();
                return;
            }
        }
        this.update_data();
    }

    private void initLoadData() {
        try {
            this.appletContext = this.getAppletContext();
        }
        catch (Exception exception) {
            this.appletContext = null;
        }
        this.loadAndSetURLData = this.getParameter("loadAndSetURLData") != null && this.getParameter("loadAndSetURLData").trim().equalsIgnoreCase("true");
        Hashtable hashtable = new Hashtable();
        if (this.getParameter("data") != null && !this.loadAndSetURLData) {
            this.dataURL = this.getParameter("data");
            this.loadURLParameters(this.dataURL, hashtable);
        }
        this.loadAppletParameters(hashtable);
        this.setParameters(hashtable);
        if (this.getParameter("data") != null && this.loadAndSetURLData) {
            this.loadingData = false;
            this.dataURL = this.getParameter("data");
            this.automaticRepaintOn = true;
            this.loadURLParameters(this.dataURL);
            this.automaticRepaintOn = false;
        }
        if (this.initiallySortedColumn >= 0 && this.initiallySortedColumn < this.getColumnCount()) {
            this.sortColumn(this.initiallySortedColumn, this.defaultSortOrder[this.initiallySortedColumn]);
        } else {
            this.sortColumn(-1, 0);
        }
        this.loadingData = false;
        this.automaticRepaintOn = true;
        this.repaint();
        this.notifyListeners(4, -1);
    }

    public void setTableData(TableData tableData) {
        if (tableData == null) {
            throw new IllegalArgumentException("Table data is NULL");
        }
        this.tableData = tableData;
        this.setColumnDataCount(tableData.getColumnCount());
        this.setRowDataCount(tableData.getLastIndex(), tableData.getRowCount());
        int n = 0;
        while (n < this.sortedList.length) {
            this.sortedList[n] = n;
            ++n;
        }
        this.rowHeightCalculation = true;
        this.refilterTable();
        this.adjustXpos();
        this.checkScrollBars();
        this.autoRepaint();
    }

    public TableData getTableData() {
        return this.tableData;
    }

    public void setHeaderOn(boolean bl) {
        this.headerOn = bl;
        this.autoRepaint();
    }

    public void setFilterBarOn(boolean bl) {
        this.filterBarOn = bl;
        this.checkScrollBars();
        this.autoRepaint();
    }

    private static String getIPString(byte[] byArray) {
        if (byArray != null) {
            StringBuffer stringBuffer = new StringBuffer(15);
            int n = 0;
            while (n < byArray.length) {
                int n2 = byArray[n] & 0xFF;
                stringBuffer.append(n2);
                if (n < byArray.length - 1) {
                    stringBuffer.append(".");
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.currencyFormatter = null;
        int n = 0;
        while (n < this.dateFormatter.size()) {
            if (this.dateFormatter.elementAt(n) != null) {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.dateFormatter.elementAt(n);
                String string = simpleDateFormat.toPattern();
                this.dateFormatter.setElementAt(new SimpleDateFormat(string, locale), n);
            }
            this.dateParser = this.dateFormatInputLocale != null ? new SimpleDateFormat(this.dateParser.toPattern(), this.dateFormatInputLocale) : new SimpleDateFormat(this.dateParser.toPattern(), locale);
            this.dateParser.setLenient(false);
            this.defaultDatePattern = this.dateParser.toPattern();
            ++n;
        }
        this.autoRepaint();
    }

    public void setDateFormatter(int n, DateFormat dateFormat) {
        if (n >= 0 && n < this.getColumnCount()) {
            if (n >= this.dateFormatter.size()) {
                this.dateFormatter.setSize(n + 1);
            }
            this.dateFormatter.setElementAt(dateFormat, n);
        }
        this.autoRepaint();
    }

    public DateFormat getDateFormatter(int n) {
        if (n < this.dateFormatter.size()) {
            return (DateFormat)this.dateFormatter.elementAt(n);
        }
        return null;
    }

    public void removeTableListener(TableListener tableListener) {
        this.listeners.removeElement(tableListener);
    }

    public void setFont(Font font) {
        if (font != null) {
            super.setFont(font);
        } else {
            super.setFont(DEFAULT_FONT);
        }
        this.calculateRowHeight(-1);
        this.checkScrollBars();
        this.autoRepaint();
    }

    public void setFont(String string, Font font) {
        if (string != null) {
            string = string.toLowerCase().trim();
            this.fonts.remove(string);
            if (font != null) {
                this.fonts.put(string, font);
            }
            if (string.equalsIgnoreCase("rowFont")) {
                this.calculateRowHeight(-1);
            }
            this.checkScrollBars();
            this.autoRepaint();
        }
    }

    public Font getFont(String string) {
        if (string != null && this.fonts != null) {
            return (Font)this.fonts.get(string.toLowerCase().trim());
        }
        return null;
    }

    public void setColumnWidth(int n, int n2) {
        this.setColumnWidth(n, n2, true);
    }

    private void setColumnWidth(int n, int n2, boolean bl) {
        if (n >= 0 && n < this.columnWidth.length) {
            n2 = Math.max(0, n2);
            this.columnWidth[n] = n2;
            if (bl) {
                this.adjustXpos();
            }
            this.checkScrollBars();
            this.autoRepaint();
        }
    }

    public int getColumnWidth(int n) {
        if (n >= 0 && n < this.columnWidth.length) {
            return (int)Math.round(this.columnWidth[n]);
        }
        return 0;
    }

    public void render(Graphics graphics) {
        if (this.loadingData && this.loadingMessageOn) {
            Dimension dimension = this.getSize();
            graphics.setColor(Color.white);
            graphics.fillRect(2, 2, dimension.width - 4, dimension.height - 4);
            this.paintBorder(graphics);
            graphics.setFont(DEFAULT_FONT);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = "loading data...";
            if (this.loadingDataMessage != null && this.loadingDataMessage.trim().length() > 0) {
                string = this.loadingDataMessage;
            }
            int n = 7;
            int n2 = fontMetrics.getHeight() + 2 + 2;
            graphics.drawString(string, n, n2);
            n += fontMetrics.stringWidth(string) + 2;
            int n3 = 0;
            while (n3 < this.loadingDataDots) {
                graphics.drawLine(n, n2 - 1, n, n2 - 1);
                if ((n += 3) > dimension.width - 4) {
                    n = 2;
                    n2 += fontMetrics.getHeight();
                }
                ++n3;
            }
        } else {
            Dimension dimension = this.getSize();
            graphics.setClip(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.defaultRowBackground);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (this.tableData.hasChangedSince(this.lastPaintTime)) {
                this.calculateTotals();
                this.rowHeightCalculation = true;
            }
            this.paintRows(graphics);
            if (this.gridOn) {
                this.paintGrid(graphics);
            }
            if (this.headerOn) {
                this.paintHeader(graphics, true);
            }
            if (this.filterBarOn) {
                this.paintFilter(graphics);
            }
            if (this.isTotalRowOn(-1)) {
                this.paintTotalRow(graphics);
            }
            this.paintScrollBars(graphics);
            this.paintBorder(graphics);
            if (this.tooltipOn) {
                this.paintTooltip(graphics, this.currentTooltip, this.lastMousePosition);
            }
            this.lastPaintTime = System.currentTimeMillis();
        }
    }

    public void setCell(int n, int n2, Object object) {
        if (this.tableData.containsRow(n)) {
            this.tableData.setCell(n, n2, object);
            if (n2 >= 0 && n2 < this.getColumnCount() && n >= 0 && n <= this.tableData.getLastIndex()) {
                switch (this.getColumnType(n2)) {
                    case 2: {
                        try {
                            this.numericalData[n][n2] = new Double((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    case 4: {
                        this.numericalData[n][n2] = Table.getIPNumber(object);
                        break;
                    }
                }
            }
            this.isSorted = false;
            this.autoRepaint();
        }
    }

    public Object getCell(int n, int n2) {
        try {
            if (this.columnType[n2] == 1 || this.columnType[n2] == 2) {
                return this.numericalData[n][n2] + "";
            }
            return this.tableData.getCell(n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return this.tableData.getCell(n, n2);
        }
    }

    public boolean gotoRowPosition(int n) {
        n = Math.max(n, 0);
        if ((n = Math.min(n, this.displayListCount)) != -1) {
            if (n < this.firstRow) {
                this.firstRow = n;
            } else if (n >= this.firstRow + this.maxDisplayRowCount) {
                this.firstRow = n - (this.maxDisplayRowCount - 1);
            } else {
                return false;
            }
        }
        this.firstRow = Math.max(this.firstRow, 0);
        this.vSliderPos = this.vScrollerTop + 1 + 15 + (int)Math.round((double)this.firstRow / (double)(this.displayListCount - this.maxDisplayRowCount) * (double)(this.vSliderSpace - this.vSliderSize - 2));
        this.autoRepaint();
        return true;
    }

    public void setSortingOn(int n, boolean bl) {
        if (n >= 0 && n < this.sortingOn.length) {
            this.sortingOn[n] = bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long getIPNumber(Object object) {
        if (object == null) {
            return Long.MAX_VALUE;
        }
        long l = Long.MAX_VALUE;
        if (object instanceof String) {
            String string = (String)object;
            try {
                int n = 0;
                int n2 = string.indexOf(46);
                if (n2 <= 0) return Long.MAX_VALUE;
                long l2 = Long.parseLong(string.substring(n, n2));
                if (l2 < 0L) return Long.MAX_VALUE;
                if (l2 > 255L) return Long.MAX_VALUE;
                l = l2 * 0x1000000L;
                n = n2 + 1;
                n2 = string.indexOf(46, n);
                if (n2 <= 0) return Long.MAX_VALUE;
                l2 = Long.parseLong(string.substring(n, n2));
                if (l2 < 0L) return Long.MAX_VALUE;
                if (l2 > 255L) return Long.MAX_VALUE;
                l += l2 * 65536L;
                n = n2 + 1;
                n2 = string.indexOf(46, n);
                if (n2 <= 0) return Long.MAX_VALUE;
                l2 = Long.parseLong(string.substring(n, n2));
                if (l2 < 0L) return Long.MAX_VALUE;
                if (l2 > 255L) return Long.MAX_VALUE;
                l += l2 * 256L;
                n = n2 + 1;
                int n3 = Integer.parseInt(string.substring(n));
                if (n3 < 0) return Long.MAX_VALUE;
                if (n3 > 255) return Long.MAX_VALUE;
                l += (long)n3;
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                return Long.MAX_VALUE;
            }
        } else {
            if (!(object instanceof byte[])) return l;
            byte[] byArray = (byte[])object;
            if (byArray.length != 4) return l;
            l = (long)(byArray[0] & 0xFF) * 0x1000000L;
            l += (long)(byArray[1] & 0xFF) * 65536L;
            l += (long)(byArray[2] & 0xFF) * 256L;
            l += (long)(byArray[3] & 0xFF);
        }
        return l;
    }

    public void setFilterBarPosition(int n) {
        if (n == 1 || n == 0) {
            this.filterBarPosition = n;
            this.checkScrollBars();
            this.autoRepaint();
        }
    }

    public int setRow(int n, Object[] objectArray) {
        return this.setRow(n, null, objectArray);
    }

    public int setRow(int n, Object object, Object[] objectArray) {
        int n2 = this.getColumnCount();
        boolean bl = false;
        bl = n >= 0 ? !this.tableData.containsRow(n) : true;
        if (this.labelCacheOn) {
            this.checkLabelCache(objectArray);
        }
        int n3 = this.tableData.setRow(n, object, objectArray);
        int n4 = this.tableData.getRowCount();
        if (n4 >= this.sortedList.length) {
            this.sortedList = Table.createArrayCopy(this.sortedList, n4 + 50, -1);
        }
        if (bl) {
            this.sortedList[n4 - 1] = n3;
        }
        if (n3 >= this.numericalData.length) {
            double[][] dArray = new double[n3 + 500][n2];
            int n5 = 0;
            while (n5 < this.numericalData.length) {
                System.arraycopy(this.numericalData[n5], 0, dArray[n5], 0, Math.min(n2, this.numericalData[n5].length));
                ++n5;
            }
            this.numericalData = dArray;
        }
        int n6 = 0;
        while (n6 < Math.min(objectArray.length, n2)) {
            switch (this.getColumnType(n6)) {
                case 1: 
                case 2: {
                    try {
                        this.numericalData[n3][n6] = Double.valueOf((String)objectArray[n6]);
                        objectArray[n6] = null;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case 4: {
                    this.numericalData[n3][n6] = Table.getIPNumber(objectArray[n6]);
                    break;
                }
            }
            ++n6;
        }
        if (bl && this.matchesFilter(objectArray, -1)) {
            if (this.displayListCount >= this.displayList.length) {
                this.displayList = Table.createArrayCopy(this.displayList, this.displayListCount + 50, -1);
            }
            this.displayList[this.displayListCount++] = n3;
        }
        if ((n6 = this.tableData.getLastIndex()) >= this.selectedRows.length) {
            this.selectedRows = Table.createArrayCopy(this.selectedRows, n6 + 250);
        }
        if (n6 >= this.rowForeground.length) {
            this.rowForeground = Table.createArrayCopy(this.rowForeground, n6 + 250);
        }
        if (n6 >= this.rowBackground.length) {
            this.rowBackground = Table.createArrayCopy(this.rowBackground, n6 + 250);
        }
        if (bl) {
            this.calculateRowHeight(n3);
            if (this.matchesFilter(objectArray, -1)) {
                this.totalRowHeight += this.rowHeight[n3];
            }
        }
        this.isSorted = false;
        if (this.automaticRepaintOn) {
            this.checkScrollBars();
            this.repaint();
        }
        return n3;
    }

    public Object[] getRow(int n) {
        return this.getRow(n, true, false);
    }

    private Object[] getRow(int n, boolean bl, boolean bl2) {
        Object[] objectArray;
        block9: {
            if (n < 0 || n > this.tableData.getLastIndex()) {
                throw new IllegalArgumentException("Invalid row: " + n);
            }
            objectArray = this.tableData.getRow(n);
            if (objectArray == null || !bl) break block9;
            NumberFormat numberFormat = null;
            try {
                numberFormat = NumberFormat.getInstance(this.getLocale());
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                numberFormat = NumberFormat.getInstance();
            }
            if (numberFormat != null) {
                numberFormat.setGroupingUsed(false);
                int n2 = 0;
                while (n2 < objectArray.length) {
                    numberFormat.setMaximumFractionDigits(this.getDecimalCount(n2));
                    numberFormat.setMinimumFractionDigits(this.getDecimalCount(n2));
                    if (n2 < this.columnType.length && (this.columnType[n2] == 1 || this.columnType[n2] == 2)) {
                        objectArray[n2] = numberFormat.format(this.numericalData[n][n2]);
                    }
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (n3 < this.columnType.length && (this.columnType[n3] == 1 || this.columnType[n3] == 2)) {
                        objectArray[n3] = this.numericalData[n][n3] + "";
                    }
                    ++n3;
                }
            }
        }
        return objectArray;
    }

    public void selectRow(int n, boolean bl) {
        if (n >= 0 && n < this.selectedRows.length) {
            this.selectedRows[n] = bl;
            this.lastSelectedRow = n;
        } else if (n == -1) {
            int n2 = 0;
            while (n2 < this.selectedRows.length) {
                this.selectedRows[n2] = bl;
                ++n2;
            }
        }
        this.autoRepaint();
    }

    public int getFilterBarPosition() {
        return this.filterBarPosition;
    }

    public void setAlternateRowBackground(Color color, int n, int n2) {
        this.alternateRowBackgroundColor = color;
        if (n >= 0) {
            this.alternateRowBackgroundCount = n;
        }
        if (n2 >= 0) {
            this.alternateRowBackgroundStart = n2;
        }
        this.autoRepaint();
    }

    public Color getAlternateRowBackground() {
        return this.alternateRowBackgroundColor;
    }

    private void paintArrowButton(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        graphics.setClip(n, n2, n3, n4);
        this.paint3DBox(graphics, n, n2, n3, n4, bl);
        int n6 = 0;
        if (bl) {
            n6 = 1;
        }
        int n7 = n + n3 / 2 + n6;
        int n8 = n2 + n4 / 2 + n6;
        graphics.setColor(Color.black);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        switch (n5) {
            case 0: {
                nArray[0] = n7 - n4 / 5 - 1;
                nArray[1] = n7 + n4 / 5 + 1;
                nArray[2] = n7;
                nArray2[0] = n8 + n4 / 16 + 1;
                nArray2[1] = n8 + n4 / 16 + 1;
                nArray2[2] = n8 - n4 / 5 - 1;
                graphics.fillPolygon(nArray, nArray2, 3);
                break;
            }
            case 1: {
                nArray[0] = n7 - n4 / 5;
                nArray[1] = n7 + n4 / 5 + 1;
                nArray[2] = n7;
                nArray2[0] = n8 - n4 / 16 - 1;
                nArray2[1] = n8 - n4 / 16 - 1;
                nArray2[2] = n8 + n4 / 5;
                graphics.fillPolygon(nArray, nArray2, 3);
                break;
            }
            case 2: {
                graphics.drawLine(n7 - 2, n8, n7 - 2, n8);
                graphics.drawLine(n7 - 1, n8 - 1, n7 - 1, n8 + 1);
                graphics.drawLine(n7, n8 - 2, n7, n8 + 2);
                graphics.drawLine(n7 + 1, n8 - 3, n7 + 1, n8 + 3);
                break;
            }
            case 3: {
                graphics.drawLine(n7 + 2, n8, n7 + 2, n8);
                graphics.drawLine(n7 + 1, n8 - 1, n7 + 1, n8 + 1);
                graphics.drawLine(n7, n8 - 2, n7, n8 + 2);
                graphics.drawLine(n7 - 1, n8 - 3, n7 - 1, n8 + 3);
                break;
            }
        }
        Dimension dimension = this.getSize();
        graphics.setClip(0, 0, dimension.width, dimension.height);
    }

    public Object[] getColumn(int n, int n2, int n3) {
        String[] stringArray = null;
        if (n >= 0 && n < this.getColumnCount()) {
            if (n3 < 0) {
                n3 = this.displayListCount - n2;
            }
            stringArray = new String[n3];
            int n4 = Math.min(this.displayListCount, n2 + n3);
            int n5 = n2;
            int n6 = 0;
            while (n5 < n4) {
                stringArray[n6] = this.getCell(this.displayList[n5], n);
                ++n5;
                ++n6;
            }
        }
        return stringArray;
    }

    public int getLastSortedColumn() {
        return this.lastSortedColumn;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (!this.isEnabled() || this.loadingData) {
            return;
        }
        if (aWTEvent instanceof MouseEvent) {
            this.lastMousePosition.x = ((MouseEvent)aWTEvent).getX();
            this.lastMousePosition.y = ((MouseEvent)aWTEvent).getY();
            switch (aWTEvent.getID()) {
                case 503: {
                    this.processMouseMoved((MouseEvent)aWTEvent);
                    break;
                }
                case 501: {
                    this.processMousePressed((MouseEvent)aWTEvent);
                    break;
                }
                case 506: {
                    this.processMouseDragged((MouseEvent)aWTEvent);
                    break;
                }
                case 502: {
                    this.processMouseReleased((MouseEvent)aWTEvent);
                    break;
                }
                case 505: {
                    this.tooltipCountDown = Integer.MAX_VALUE;
                    this.currentTooltip = null;
                    this.tooltipOn = false;
                    this.repaint();
                    break;
                }
            }
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeys((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof ComponentEvent) {
            if (aWTEvent.getID() == 101) {
                this.adjustXpos();
                this.checkScrollBars();
                this.repaint();
            } else if (aWTEvent.getID() == 100 && TableEvent.evaluation) {
                TableEvent.showEvaluation(this);
            }
        }
        super.processEvent(aWTEvent);
    }

    private void getRowColumnIndex(int n, int n2, int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            Font font;
            Dimension dimension = this.getSize();
            nArray[0] = -1;
            if (nArray.length > 2) {
                nArray[2] = -1;
            }
            int n3 = this.getHeaderHeight() + 2;
            int n4 = dimension.height - 2;
            if (this.isFilterBarOn() && this.getFilterBarPosition() == 1) {
                n3 += this.getFilterHeight();
            } else if (this.isFilterBarOn()) {
                n4 -= this.getFilterHeight();
            }
            if (this.isTotalRowOn(-1)) {
                n4 -= this.getTotalRowHeight();
            }
            if ((font = this.getFont("rowFont")) == null) {
                font = this.getFont();
            }
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n5 = fontMetrics.getHeight() + 2;
            if (n2 < n4) {
                int n6 = n3 + 1;
                int n7 = this.firstRow;
                while (n6 < n4 && n7 < this.displayListCount) {
                    int n8 = n5;
                    if (this.displayList[n7] < this.rowHeight.length) {
                        n8 = this.rowHeight[this.displayList[n7]];
                    }
                    if (n2 >= n6 && n2 < n6 + n8) {
                        nArray[0] = this.displayList[n7];
                        if (nArray.length <= 2) break;
                        nArray[2] = n7;
                        break;
                    }
                    ++n7;
                    n6 += n8;
                }
            }
            if (nArray.length > 1) {
                nArray[1] = this.get_field(n);
            }
        }
    }

    private String replaceSubstring(String string, String string2, String string3) {
        int n;
        String string4 = string;
        if (string != null && string2 != null && string2.length() > 0 && (n = string.indexOf(string2)) >= 0) {
            String string5 = string.substring(0, n);
            String string6 = string.substring(n + string2.length());
            string4 = string3 != null ? string5 + string3 + string6 : string5 + string6;
        }
        return string4;
    }

    public void setParentApplet(Applet applet) {
        if (applet == this) {
            applet = null;
        }
        this.parentApplet = applet;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private int get_field_separator(int n) {
        int n2 = this.getColumnCount();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (n3 < this.columnOn.length && this.columnOn[n3] && n3 < this.columnXpos.length && n > this.columnXpos[n3] - this.offset - 3 && n < this.columnXpos[n3] - this.offset + 2) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public void setFilterWildCard(String string) {
        this.filterWildCard = string != null && string.length() > 0 ? string : null;
    }

    public String getFilterWildCard() {
        return this.filterWildCard;
    }

    public void setPrefix(int n, String string) {
        if (n >= 0 && n < this.columnPrefix.length) {
            this.columnPrefix[n] = string;
            this.autoRepaint();
        }
    }

    public String getPrefix(int n) {
        if (n >= 0 && n < this.columnPrefix.length) {
            return this.columnPrefix[n];
        }
        return null;
    }

    public boolean isColumnStretchOn() {
        return this.columnStretchOn;
    }

    public String getParameter(String string) {
        String string2 = null;
        if (string != null) {
            if (this.parameterPrefix != null) {
                string = this.parameterPrefix + string;
            }
            if (this.parentApplet != null) {
                try {
                    string2 = this.parentApplet.getParameter(string);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            } else {
                string2 = super.getParameter(string);
            }
        }
        return string2;
    }

    public void setParameter(String string, String string2) {
        block264: {
            if (string == null) {
                return;
            }
            string = string.toLowerCase().trim();
            if (string2 != null) {
                string2 = string2.trim();
            }
            if (string.equals("columncount")) {
                if (string2 != null && string2.length() > 0) {
                    try {
                        this.setColumnCount(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid columnCount: " + string2);
                    }
                }
            } else if (string.startsWith("row_")) {
                try {
                    int n = Integer.parseInt(string.substring(4));
                    String[] stringArray = Table.getStringArray(string2, this.fieldSeparator);
                    Object[] objectArray = new Object[stringArray.length];
                    int n2 = this.getColumnCount();
                    int n3 = 0;
                    while (n3 < Math.min(stringArray.length, n2)) {
                        Date date;
                        objectArray[n3] = stringArray[n3];
                        if (this.getColumnType(n3) == 3 && (date = this.parseDate(n3, stringArray[n3])) != null) {
                            objectArray[n3] = date;
                        }
                        ++n3;
                    }
                    this.setRow(n, objectArray);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid row index: " + string);
                }
                catch (NullPointerException nullPointerException) {}
            } else if (string.equals("labelcacheon")) {
                this.labelCacheOn = string2 != null && string2.trim().equalsIgnoreCase("true");
            } else if (string.equals("header")) {
                if (string2 != null) {
                    String[] stringArray = Table.getStringArray(Table.convertLineBreaks(string2), this.fieldSeparator);
                    if (stringArray != null) {
                        int n = Math.min(stringArray.length, this.getColumnCount());
                        int n4 = 0;
                        while (n4 < n) {
                            this.setHeader(n4, stringArray[n4]);
                            ++n4;
                        }
                    }
                } else {
                    this.setHeader(null);
                }
            } else if (string.equals("headerbackground")) {
                String[] stringArray;
                int n = 0;
                while (n < this.headerBackground.length) {
                    this.headerBackground[n] = null;
                    ++n;
                }
                if (string2 != null && (stringArray = Table.getStringArray(string2, ",")) != null) {
                    int n5 = Math.min(stringArray.length, this.getColumnCount());
                    int n6 = 0;
                    while (n6 < n5) {
                        Color color;
                        if (stringArray[n6] != null && stringArray[n6].trim().length() > 0 && (color = Table.createColor(stringArray[n6])) != null) {
                            this.setHeaderBackground(n6, color);
                        }
                        ++n6;
                    }
                }
            } else if (string.startsWith("tooltipdelay")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        Integer n = new Integer(string2);
                        this.tooltipDelays.put(string, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid " + string + " " + string2);
                    }
                } else {
                    this.tooltipDelays.remove(string);
                }
            } else if (string.startsWith("tooltipbackground")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = Table.createColor(string2);
                    if (color != null) {
                        this.tooltipBackground = color;
                    }
                } else {
                    this.tooltipBackground = null;
                }
            } else if (string.startsWith("tooltip")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.tooltipLabels.put(string, Table.convertLineBreaks(string2));
                } else {
                    this.tooltipLabels.remove(string);
                }
            } else if (string.equals("headeroff")) {
                this.setHeaderOn(string2 == null || !string2.toLowerCase().equals("true"));
            } else if (string.equals("columnwidth")) {
                Long[] longArray;
                if (string2 != null && string2.length() > 0 && (longArray = this.getLongValues(string2)) != null) {
                    int n = this.getColumnCount();
                    int n7 = 0;
                    while (n7 < n) {
                        if (n7 < longArray.length && longArray[n7] != null) {
                            this.setColumnWidth(n7, longArray[n7].intValue(), false);
                        } else {
                            this.setColumnWidth(n7, 100, false);
                        }
                        ++n7;
                    }
                    this.adjustXpos();
                }
            } else if (string.equals("columnstretchon")) {
                this.setColumnStretchOn(string2 != null && string2.toLowerCase().equals("true"));
            } else if (string.equals("filterbaron")) {
                this.setFilterBarOn(string2 != null && string2.toLowerCase().equals("true"));
            } else if (string.equals("filter")) {
                String[] stringArray;
                if (string2 != null && string2.length() > 0 && (stringArray = Table.getStringArray(string2, this.fieldSeparator)) != null) {
                    int n = 0;
                    while (n < stringArray.length && n < this.getColumnCount()) {
                        if (stringArray[n] != null) {
                            this.setFilter(n, stringArray[n].trim());
                        } else {
                            this.setFilter(n, null);
                        }
                        ++n;
                    }
                }
            } else if (string.equals("filteron")) {
                Long[] longArray;
                int n = 0;
                while (n < this.filterOn.length) {
                    this.filterOn[n] = false;
                    ++n;
                }
                if (string2 != null && string2.trim().length() > 0 && (longArray = this.getLongValues(string2)) != null) {
                    int n8 = 0;
                    while (n8 < longArray.length) {
                        int n9;
                        if (longArray[n8] != null && (n9 = (int)longArray[n8].longValue()) >= 0 && n9 < this.filterOn.length) {
                            this.setFilterOn(n9, true);
                        }
                        ++n8;
                    }
                }
            } else if (string.equals("filterbarposition")) {
                if (string2 != null && string2.toLowerCase().equals("top")) {
                    this.setFilterBarPosition(1);
                } else {
                    this.setFilterBarPosition(0);
                }
            } else if (string.equals("progressivefilteron")) {
                this.setProgressiveFilterOn(string2 != null && string2.toLowerCase().equals("true"));
            } else if (string.equals("filterwildcard")) {
                this.setFilterWildCard(string2);
            } else if (string.equals("totalrowon")) {
                if ((string2 = string2 != null ? string2.toLowerCase() : "").equals("true")) {
                    this.setTotalRowOn(-1, true);
                } else {
                    int n = 0;
                    while (n < this.totalRowOn.length) {
                        this.totalRowOn[n] = false;
                        ++n;
                    }
                    Long[] longArray = this.getLongValues(string2);
                    if (longArray != null) {
                        int n10 = 0;
                        while (n10 < longArray.length) {
                            int n11;
                            if (longArray[n10] != null && (n11 = (int)longArray[n10].longValue()) >= 0 && n11 < this.totalRowOn.length) {
                                this.totalRowOn[n11] = true;
                            }
                            ++n10;
                        }
                    }
                }
            } else if (string.equals("selectionmode")) {
                this.setSelectionMode(0);
                if (string2 != null && string2.length() > 0) {
                    if (string2.toLowerCase().equals("single")) {
                        this.setSelectionMode(1);
                    } else if (string2.toLowerCase().equals("multiple")) {
                        this.setSelectionMode(2);
                    }
                }
            } else if (string.equals("columnalignment")) {
                int n = this.getColumnCount();
                if (string2 != null && string2.length() > 0) {
                    String[] stringArray = Table.getStringArray(string2, ",");
                    int n12 = 0;
                    while (n12 < n) {
                        this.setColumnAlignment(n12, 0);
                        if (n12 < stringArray.length && stringArray[n12] != null) {
                            if (stringArray[n12].trim().equalsIgnoreCase("center")) {
                                this.setColumnAlignment(n12, 1);
                            } else if (stringArray[n12].trim().equalsIgnoreCase("right")) {
                                this.setColumnAlignment(n12, 2);
                            }
                        }
                        ++n12;
                    }
                } else {
                    int n13 = 0;
                    while (n13 < n) {
                        this.setColumnAlignment(n13, 0);
                        ++n13;
                    }
                }
            } else if (string.equals("columntype")) {
                int n = this.getColumnCount();
                int n14 = 0;
                while (n14 < n) {
                    this.setColumnType(n14, 0);
                    ++n14;
                }
                if (string2 != null && string2.length() > 0) {
                    String[] stringArray = Table.getStringArray(string2, ",");
                    int n15 = 0;
                    while (n15 < n) {
                        if (n15 < stringArray.length && stringArray[n15] != null) {
                            if (stringArray[n15].trim().equalsIgnoreCase("number")) {
                                this.setColumnType(n15, 1);
                            } else if (stringArray[n15].trim().equalsIgnoreCase("currency")) {
                                this.setColumnType(n15, 2);
                            } else if (stringArray[n15].trim().equalsIgnoreCase("date")) {
                                this.setColumnType(n15, 3);
                            } else if (stringArray[n15].trim().equalsIgnoreCase("ip")) {
                                this.setColumnType(n15, 4);
                            }
                        }
                        ++n15;
                    }
                }
            } else if (string.equals("rowforeground")) {
                Color color;
                this.setRowForeground(-1, this.getForeground());
                if (string2 != null && string2.length() > 0 && (color = Table.createColor(string2)) != null) {
                    this.setRowForeground(-1, color);
                }
            } else if (string.startsWith("rowforeground_")) {
                try {
                    int n = Integer.parseInt(string.substring(14));
                    this.setRowForeground(n, Table.createColor(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid row index: " + string);
                }
            } else if (string.equals("rowbackground")) {
                Color color;
                this.setRowBackground(-1, Color.white);
                if (string2 != null && string2.length() > 0 && (color = Table.createColor(string2)) != null) {
                    this.setRowBackground(-1, color);
                }
            } else if (string.startsWith("rowbackground_")) {
                try {
                    int n = Integer.parseInt(string.substring(14));
                    this.setRowBackground(n, Table.createColor(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid row index: " + string);
                }
            } else if (string.equals("foreground")) {
                Color color;
                this.setForeground(Color.black);
                if (string2 != null && string2.length() > 0 && (color = Table.createColor(string2)) != null) {
                    this.setForeground(color);
                }
            } else if (string.equals("background")) {
                Color color;
                if (this.systemColorPresent) {
                    this.setBackground(SystemColor.control);
                } else {
                    this.setBackground(new Color(13947080));
                }
                if (string2 != null && string2.length() > 0 && (color = Table.createColor(string2)) != null) {
                    this.setBackground(color);
                }
            } else if (string.startsWith("prefix_")) {
                try {
                    int n = Integer.parseInt(string.substring(7));
                    this.setPrefix(n, string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid prefix column index: " + string);
                }
            } else if (string.startsWith("postfix_")) {
                try {
                    int n = Integer.parseInt(string.substring(8));
                    this.setPostfix(n, string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid prefix column index: " + string);
                }
            } else if (string.startsWith("decimalcount_")) {
                try {
                    int n = Integer.parseInt(string.substring(13));
                    int n16 = Integer.parseInt(string2);
                    this.setDecimalCount(n, n16);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.out.println("Invalid parameter name: " + string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid decimal count: " + string + " " + string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println("Invalid column index: " + string + " " + string2);
                }
            } else if (string.equals("sortingoff")) {
                if ((string2 = string2 != null ? string2.toLowerCase() : "").equals("true")) {
                    int n = 0;
                    while (n < this.sortingOn.length) {
                        this.sortingOn[n] = false;
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < this.sortingOn.length) {
                        this.sortingOn[n] = true;
                        ++n;
                    }
                    Long[] longArray = this.getLongValues(string2);
                    if (longArray != null) {
                        int n17 = 0;
                        while (n17 < longArray.length) {
                            int n18;
                            if (longArray[n17] != null && (n18 = (int)longArray[n17].longValue()) >= 0 && n18 < this.sortingOn.length) {
                                this.sortingOn[n18] = false;
                            }
                            ++n17;
                        }
                    }
                }
            } else if (string.equals("defaultsortorder")) {
                String[] stringArray;
                if (string2 != null && string2.trim().length() > 0 && (stringArray = Table.getStringArray(string2, ",")) != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n] != null && stringArray[n].trim().toLowerCase().startsWith("asc")) {
                            this.setDefaultSortOrder(n, 0);
                        } else if (stringArray[n] != null && stringArray[n].trim().toLowerCase().startsWith("desc")) {
                            this.setDefaultSortOrder(n, 1);
                        }
                        ++n;
                    }
                }
            } else if (string.equals("sortedcolumn")) {
                this.initiallySortedColumn = -1;
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.initiallySortedColumn = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid " + string + " " + string2);
                    }
                }
            } else if (string.equals("gridon")) {
                this.setGridOn(string2 != null && string2.toLowerCase().equals("true"));
            } else if (string.equals("gridcolor")) {
                this.setGridColor(Table.createColor(string2));
            } else if (string.startsWith("url_")) {
                URL uRL;
                if (string2 != null && (uRL = this.createURL(string2)) != null) {
                    try {
                        string = string.substring(4);
                        int n = 0;
                        int n19 = -1;
                        int n20 = string.indexOf("_");
                        if (n20 > 0) {
                            n = Integer.parseInt(string.substring(0, n20));
                            n19 = Integer.parseInt(string.substring(n20 + 1));
                        } else {
                            n = Integer.parseInt(string);
                        }
                        this.addURL(n, n19, uRL);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid URL index: " + string + " " + string2);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        System.out.println("Invalid parameter name: " + string + " " + string2);
                    }
                }
            } else if (string.equals("urlcolor")) {
                this.urlColor = Table.createColor(string2);
            } else if (string.equals("urlstyle")) {
                this.urlStyle = 0;
                if (string2 != null && string2.length() > 0) {
                    if ((string2 = string2.toLowerCase()).equals("line")) {
                        this.urlStyle = 0;
                    } else if (string2.equals("noline")) {
                        this.urlStyle = 1;
                    }
                }
            } else if (string.equals("urltarget")) {
                if (string2 != null) {
                    this.urlTargetList.put("default", string2);
                } else {
                    this.urlTargetList.put("default", "_self");
                }
            } else if (string.startsWith("urltarget_")) {
                string = string.substring(10);
                this.urlTargetList.remove(string);
                if (string2 != null) {
                    this.urlTargetList.put(string, string2);
                }
            } else if (string.equals("fieldseparator")) {
                this.fieldSeparator = ",";
                if (string2 != null && string2.length() == 1) {
                    this.fieldSeparator = string2;
                }
            } else if (string.equals("locale")) {
                if (string2 != null && string2.length() > 0) {
                    String string3;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                    String string4 = string3 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreElements()) {
                        string4 = stringTokenizer.nextToken();
                    }
                    this.setLocale(new Locale(string3.toUpperCase(), string4.toUpperCase()));
                } else {
                    this.setLocale(null);
                }
            } else if (string.startsWith("dateformat_")) {
                try {
                    int n = Integer.parseInt(string.substring(11));
                    if (n < 0 || n >= this.getColumnCount()) break block264;
                    if (string2 != null && string2.length() > 0) {
                        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.dateFormatter.elementAt(n);
                        if (simpleDateFormat != null) {
                            simpleDateFormat.applyPattern(string2);
                        } else {
                            simpleDateFormat = new SimpleDateFormat(string2);
                        }
                        try {
                            simpleDateFormat.format(new Date());
                            this.setDateFormatter(n, simpleDateFormat);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            System.out.println("Invalid " + string + " " + string2);
                            this.setDateFormatter(n, DateFormat.getDateTimeInstance(2, 2));
                        }
                        break block264;
                    }
                    this.setDateFormatter(n, DateFormat.getDateTimeInstance(2, 2));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid column index: " + string + " " + string2);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.out.println("No column index: " + string + " " + string2);
                }
            } else if (string.startsWith("dateformatinput_")) {
                try {
                    int n = Integer.parseInt(string.substring(16));
                    if (n < 0 || n >= this.getColumnCount()) break block264;
                    if (string2 != null && string2.length() > 0) {
                        if (n >= this.dateParserPattern.size()) {
                            this.dateParserPattern.setSize(n + 1);
                        }
                        this.dateParserPattern.setElementAt(string2, n);
                        break block264;
                    }
                    this.dateParserPattern.setElementAt(this.defaultDatePattern, n);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid column index: " + string + " " + string2);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.out.println("No column index: " + string + " " + string2);
                }
            } else if (string.equals("dateformatinputlocale")) {
                if (string2 != null && string2.length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                    if (stringTokenizer.hasMoreTokens()) {
                        String string5;
                        String string6 = string5 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreElements()) {
                            string6 = stringTokenizer.nextToken();
                        }
                        this.dateFormatInputLocale = new Locale(string5.toUpperCase(), string6.toUpperCase());
                    }
                } else {
                    this.dateFormatInputLocale = null;
                }
                this.dateParser = this.dateFormatInputLocale != null ? new SimpleDateFormat(this.dateParser.toPattern(), this.dateFormatInputLocale) : new SimpleDateFormat(this.dateParser.toPattern(), this.getLocale());
                this.dateParser.setLenient(false);
                this.defaultDatePattern = this.dateParser.toPattern();
            } else if (string.equals("font")) {
                this.setFont(this.createFont(string2, DEFAULT_FONT.getName(), DEFAULT_FONT.getStyle(), DEFAULT_FONT.getSize()));
            } else if (string.endsWith("font")) {
                this.setFont(string, this.createFont(string2, DEFAULT_FONT.getName(), DEFAULT_FONT.getStyle(), DEFAULT_FONT.getSize()));
            } else if (string.endsWith("fontcolor")) {
                this.setFontColor(string, Table.createColor(string2));
            } else if (string.equals("alternaterowbackground")) {
                this.setAlternateRowBackground(null, -1, -1);
                if (string2 != null && string2.length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                    String string7 = null;
                    int n = -1;
                    int n21 = -1;
                    if (stringTokenizer.hasMoreTokens()) {
                        string7 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            n = n21 = Integer.parseInt(stringTokenizer.nextToken().trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid count: " + string + " " + string2);
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            n21 = Integer.parseInt(stringTokenizer.nextToken().trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid start: " + string + " " + string2);
                        }
                    }
                    this.setAlternateRowBackground(Table.createColor(string7), n, n21);
                }
            } else if (string.startsWith("image_")) {
                try {
                    int n = Integer.parseInt(string.substring(6));
                    if (n < 0 || n >= this.getColumnCount()) break block264;
                    if (string2 != null && string2.length() > 0) {
                        Image image = this.getImage(this.getDocumentBase(), string2);
                        MediaTracker mediaTracker = new MediaTracker(this);
                        mediaTracker.addImage(image, 0);
                        mediaTracker.waitForAll();
                        if (image != null) {
                            this.setImage(n, -1, image);
                        }
                        break block264;
                    }
                    this.setImage(n, -1, null);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid column index: " + string + " " + string2);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.out.println("No column index: " + string + " " + string2);
                }
                catch (SecurityException securityException) {
                    System.out.println("Security exception, could not load image: " + string2);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("MediaTracker failure, could not load image: " + string2);
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("Error loading image: " + string2);
                }
            } else if (string.startsWith("cellimage_")) {
                try {
                    string = string.substring(10);
                    int n = -1;
                    int n22 = -1;
                    int n23 = string.indexOf("_");
                    if (n23 > 0) {
                        n = Integer.parseInt(string.substring(0, n23));
                        n22 = Integer.parseInt(string.substring(n23 + 1));
                    }
                    if (n < 0 || n22 < 0) break block264;
                    if (string2 != null && string2.length() > 0) {
                        Image image = this.getImage(this.getDocumentBase(), string2);
                        MediaTracker mediaTracker = new MediaTracker(this);
                        mediaTracker.addImage(image, 0);
                        mediaTracker.waitForAll();
                        if (image != null) {
                            this.setImage(n22, n, image);
                        }
                        break block264;
                    }
                    this.setImage(n22, n, null);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid row and column index: " + string + " " + string2);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.out.println("Invalid row and column index: " + string + " " + string2);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Error with media tracker, could not read image: " + string + " " + string2);
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("Error loading image: " + string2);
                }
            } else if (string.equals("data")) {
                this.dataURL = string2;
            }
        }
        this.autoRepaint();
    }

    private Long[] getLongValues(String string) {
        Long[] longArray = null;
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            longArray = new Long[stringTokenizer.countTokens()];
            int n = 0;
            while (n < longArray.length) {
                try {
                    longArray[n] = new Long(stringTokenizer.nextToken().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    longArray[n] = null;
                }
                ++n;
            }
        }
        return longArray;
    }

    private boolean[] getBooleanValues(String string) {
        boolean[] blArray = new boolean[]{};
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            blArray = new boolean[stringTokenizer.countTokens()];
            int n = 0;
            while (n < blArray.length) {
                blArray[n] = stringTokenizer.nextToken().trim().equalsIgnoreCase("true");
                ++n;
            }
        }
        return blArray;
    }

    public double[] getColumnValues(int n, int n2, int n3) {
        if (n < 0 || n >= this.columnType.length || n2 < 0) {
            return null;
        }
        double[] dArray = null;
        if (this.columnType[n] == 1 || this.columnType[n] == 2) {
            if (n3 < 0) {
                n3 = this.displayListCount - n2;
            }
            dArray = new double[n3];
            int n4 = n2;
            int n5 = 0;
            while (n4 < n2 + n3) {
                dArray[n5] = n4 < this.displayListCount && this.displayList[n4] < this.numericalData.length ? this.numericalData[this.displayList[n4]][n] : Double.NaN;
                ++n4;
                ++n5;
            }
        }
        return dArray;
    }

    private boolean matchesFilter(Object[] objectArray, int n) {
        if (objectArray == null || this.filterOn == null) {
            return true;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (n2 < this.filterOn.length && this.filterOn[n2] && n2 < this.filterCheck.length && n2 < this.filterValues.length && this.filterValues[n2] != null && this.filterValues[n2].length() != 0) {
                int n3 = 1;
                if (n2 < this.columnType.length) {
                    n3 = this.columnType[n2];
                }
                String string = null;
                if (n3 == 0 || n3 == 3 || n3 == 4 || Double.isNaN(this.filterNumbers[n2]) || n == -1) {
                    if (objectArray[n2] instanceof String) {
                        string = ((String)objectArray[n2]).toLowerCase();
                    } else if (objectArray[n2] instanceof Date) {
                        string = this.getDateString((Date)objectArray[n2], n2).toLowerCase();
                    }
                }
                String string2 = this.filterValues[n2];
                switch (this.filterCheck[n2]) {
                    case 1: {
                        if (string == null || string.indexOf(string2) != -1) break;
                        return false;
                    }
                    case 2: {
                        if (string == null || string.startsWith(string2)) break;
                        return false;
                    }
                    case 3: {
                        if (string == null || string.endsWith(string2)) break;
                        return false;
                    }
                    case 0: {
                        if (!(!Double.isNaN(this.filterNumbers[n2]) && n >= 0 && (n3 == 1 || n3 == 2) ? this.numericalData[n][n2] != this.filterNumbers[n2] : string != null && !string.equals(string2))) break;
                        return false;
                    }
                    case 4: {
                        if (!(!Double.isNaN(this.filterNumbers[n2]) && n >= 0 && (n3 == 1 || n3 == 2) ? this.numericalData[n][n2] == this.filterNumbers[n2] : string != null && string.equals(string2))) break;
                        return false;
                    }
                    case 5: {
                        double d;
                        if (n3 == 0) {
                            if (string == null || string.compareTo(string2) > 0) break;
                            return false;
                        }
                        if (n3 == 3) break;
                        if (n3 == 4) {
                            if (!Double.isNaN(this.filterNumbers[n2]) && n >= 0) {
                                if (!(this.numericalData[n][n2] <= this.filterNumbers[n2])) break;
                                return false;
                            }
                            if (string != null) {
                                if (string.compareTo(string2) > 0) break;
                                return false;
                            }
                            return false;
                        }
                        if (!Double.isNaN(this.filterNumbers[n2])) {
                            if (n >= 0) {
                                d = this.numericalData[n][n2];
                            } else {
                                try {
                                    d = string != null ? new Double(string) : Double.NaN;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    return false;
                                }
                            }
                            if (!(d <= this.filterNumbers[n2])) break;
                            return false;
                        }
                        return false;
                    }
                    case 6: {
                        double d;
                        if (n3 == 0) {
                            if (string == null || string.compareTo(string2) >= 0) break;
                            return false;
                        }
                        if (n3 == 3) break;
                        if (n3 == 4) {
                            if (!Double.isNaN(this.filterNumbers[n2]) && n >= 0) {
                                if (!(this.numericalData[n][n2] < this.filterNumbers[n2])) break;
                                return false;
                            }
                            if (string != null) {
                                if (string.compareTo(string2) >= 0) break;
                                return false;
                            }
                            return false;
                        }
                        if (!Double.isNaN(this.filterNumbers[n2])) {
                            if (n >= 0) {
                                d = this.numericalData[n][n2];
                            } else {
                                try {
                                    d = string != null ? new Double(string) : Double.NaN;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    return false;
                                }
                            }
                            if (!(d < this.filterNumbers[n2])) break;
                            return false;
                        }
                        return false;
                    }
                    case 7: {
                        double d;
                        if (n3 == 0) {
                            if (string == null || string.compareTo(string2) < 0) break;
                            return false;
                        }
                        if (n3 == 3) break;
                        if (n3 == 4) {
                            if (!Double.isNaN(this.filterNumbers[n2]) && n >= 0) {
                                if (!(this.numericalData[n][n2] >= this.filterNumbers[n2])) break;
                                return false;
                            }
                            if (string != null) {
                                if (string.compareTo(string2) < 0) break;
                                return false;
                            }
                            return false;
                        }
                        if (!Double.isNaN(this.filterNumbers[n2])) {
                            if (n >= 0) {
                                d = this.numericalData[n][n2];
                            } else {
                                try {
                                    d = string != null ? new Double(string) : Double.NaN;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    return false;
                                }
                            }
                            if (!(d >= this.filterNumbers[n2])) break;
                            return false;
                        }
                        return false;
                    }
                    case 8: {
                        double d;
                        if (n3 == 0) {
                            if (string == null || string.compareTo(string2) <= 0) break;
                            return false;
                        }
                        if (n3 == 3) break;
                        if (n3 == 4) {
                            if (!Double.isNaN(this.filterNumbers[n2]) && n >= 0) {
                                if (!(this.numericalData[n][n2] > this.filterNumbers[n2])) break;
                                return false;
                            }
                            if (string != null) {
                                if (string.compareTo(string2) <= 0) break;
                                return false;
                            }
                            return false;
                        }
                        if (!Double.isNaN(this.filterNumbers[n2])) {
                            if (n >= 0) {
                                d = this.numericalData[n][n2];
                            } else {
                                try {
                                    d = string != null ? new Double(string) : Double.NaN;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    return false;
                                }
                            }
                            if (!(d > this.filterNumbers[n2])) break;
                            return false;
                        }
                        return false;
                    }
                }
            }
            ++n2;
        }
        return true;
    }

    private void processMouseReleased(MouseEvent mouseEvent) {
        URL uRL;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.get_field(n);
        if (this.selectedHeader >= 0 && this.selectedHeader < this.headerPushed.length && this.sortingOn[this.selectedHeader] && this.headerPushed[this.selectedHeader]) {
            this.headerPushed[this.selectedHeader] = false;
            int n4 = this.getHeaderHeight();
            if (!this.adjusting && n2 < n4 + 2 && n3 == this.selectedHeader && this.headerOn) {
                if (this.selectedHeader != this.lastSortedColumn || !this.isSorted) {
                    this.sortColumn(this.selectedHeader, this.defaultSortOrder[this.selectedHeader]);
                } else if (this.selectedHeader == this.lastSortedColumn && this.isSorted) {
                    if (this.sortOrder[this.selectedHeader] == 1) {
                        this.sortColumn(this.selectedHeader, 0);
                    } else {
                        this.sortColumn(this.selectedHeader, 1);
                    }
                }
                this.notifyListeners(5, this.selectedHeader);
            }
        }
        this.getRowColumnIndex(n, n2, this.row_col_index);
        this.clickedRow = this.row_col_index[0];
        if (this.row_col_index[0] >= 0 && this.row_col_index[0] == this.clickedRow && this.row_col_index[1] == this.clickedCell && (uRL = this.getURL(this.row_col_index[0], this.row_col_index[1])) != null && this.appletContext != null) {
            String string = this.getURLTarget(this.row_col_index[0], this.row_col_index[1]);
            this.appletContext.showDocument(uRL, string);
        }
        if (this.scrollerThread != null) {
            this.scrollerThread.stop();
            this.scrollerThread = null;
        }
        this.adjusting = false;
        this.upButtonPushed = false;
        this.downButtonPushed = false;
        this.leftButtonPushed = false;
        this.aboveSliderPushed = false;
        this.belowSliderPushed = false;
        this.rightButtonPushed = false;
        this.leftToSliderPushed = false;
        this.rightToSliderPushed = false;
        this.vSliderAdjusting = false;
        this.hSliderAdjusting = false;
        this.repaint();
    }

    private void adjustHorizontalScrollbar(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = n - this.hSliderAdjustPos;
        if (n < this.hSliderPos && n2 > 0 || n > this.hSliderPos + this.hSliderSize && n2 < 0) {
            this.hSliderAdjustPos = n;
            return;
        }
        this.hSliderPos += n2;
        this.hSliderPos = Math.max(this.hSliderPos, 18);
        this.hSliderPos = Math.min(this.hSliderPos, 17 + this.hSliderSpace - this.hSliderSize + 1);
        int n3 = 30 + this.hSliderSpace;
        int n4 = this.hSliderPos - 2 - 15 - 1;
        this.offset = (int)Math.round((double)(n4 * (this.columnXpos[this.columnXpos.length - 1] - n3 - 3)) / (double)(this.hSliderSpace - this.hSliderSize));
        this.hSliderAdjustPos = n;
        this.repaint();
    }

    private void refilterTable() {
        this.displayListCount = 0;
        int n = this.getRowCount();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n && n2 < this.sortedList.length) {
            Object[] objectArray;
            int n3 = this.sortedList[n2];
            if (n3 >= 0 && this.matchesFilter(objectArray = this.getRow(n3, false, false), n3) && this.displayListCount < nArray.length) {
                nArray[this.displayListCount++] = this.sortedList[n2];
            }
            ++n2;
        }
        this.displayList = new int[this.displayListCount];
        System.arraycopy(nArray, 0, this.displayList, 0, this.displayList.length);
        this.totalRowHeight = 0;
        n2 = 0;
        while (n2 < this.displayList.length) {
            this.totalRowHeight = this.displayList[n2] < this.rowHeight.length ? (this.totalRowHeight += this.rowHeight[this.displayList[n2]]) : (this.rowHeight[0] > 0 ? (this.totalRowHeight += this.rowHeight[0]) : (this.totalRowHeight += 15));
            ++n2;
        }
        this.calculateTotals();
    }

    public void removeAll() {
        this.tableData.removeAll();
        this.lastSelectedRow = -1;
        this.lastSelectedCell = -1;
        this.sortedList = new int[10];
        this.selectedRows = new boolean[10];
        this.rowForeground = new Color[10];
        this.rowBackground = new Color[10];
        this.totalRowHeight = 0;
        this.rowHeightCalculation = true;
        this.refilterTable();
        this.checkScrollBars();
        this.adjustXpos();
        this.autoRepaint();
    }

    public void setHeader(String[] stringArray) {
        int n = 0;
        while (n < this.headerLabels.length) {
            this.headerLabels[n] = stringArray != null && n < stringArray.length ? stringArray[n] : null;
            ++n;
        }
        this.autoRepaint();
    }

    public String[] getHeader() {
        return this.headerLabels;
    }

    public void setHeader(int n, String string) {
        if (n >= 0 && n < this.headerLabels.length) {
            this.headerLabels[n] = string;
        }
    }

    public String getHeader(int n) {
        if (n >= 0 && n < this.headerLabels.length) {
            return this.headerLabels[n];
        }
        return null;
    }

    public int getFirstRowPosition() {
        return this.firstRow;
    }

    public int getLastSelectedRow() {
        return this.lastSelectedRow;
    }

    public boolean isAutomaticRepaintOn() {
        return this.automaticRepaintOn;
    }

    public int getRowCount() {
        return this.tableData.getRowCount();
    }

    public int getFilteredRowCount() {
        return this.displayListCount;
    }

    public int getMaxVisibleRowCount() {
        Font font;
        int n;
        Dimension dimension = this.getSize();
        int n2 = this.getHeaderHeight();
        int n3 = dimension.height - 2;
        if (this.hScrollbarOn) {
            n3 -= 15;
        }
        if (this.isFilterBarOn() && this.getFilterBarPosition() == 0) {
            n3 -= this.getFilterHeight();
        }
        if (this.isTotalRowOn(-1)) {
            n3 -= this.getTotalRowHeight();
        }
        int n4 = n = n2 + 2 + 1;
        if (this.isFilterBarOn() && this.getFilterBarPosition() == 1) {
            n4 += this.getFilterHeight();
        }
        if ((font = this.getFont("rowFont")) == null) {
            font = this.getFont();
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n5 = fontMetrics.getHeight() + 2;
        int n6 = 0;
        int n7 = this.firstRow;
        while (n4 < n3) {
            ++n6;
            int n8 = n5;
            if (n7 < this.displayList.length) {
                n8 = this.rowHeight[this.displayList[n7]];
            }
            n4 += n8;
        }
        return n6;
    }

    private int getFilterHeight() {
        int n = 0;
        if (this.filterBarOn) {
            Font font = this.getFont("filterBarFont");
            n = font != null ? this.getFontMetrics(font).getHeight() + 4 : this.getFontMetrics(this.getFont()).getHeight() + 4;
        }
        return n;
    }

    private void handleVerticalScrollbar(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        int n2 = this.getHeaderHeight();
        int n3 = n2 + 15 + this.vSliderSpace + 15;
        if (n > this.vScrollerTop && n < this.vScrollerTop + this.upButtonHeight) {
            this.upButtonPushed = true;
            if (this.firstRow > 0) {
                this.firstRow += -1;
                this.vSliderPos = this.vScrollerTop + 1 + 15 + (int)Math.round((double)this.firstRow / (double)(this.displayListCount - this.maxDisplayRowCount) * (double)(this.vSliderSpace - this.vSliderSize - 2));
                this.startScrollerThread(3);
            }
        } else if (n > n3 - this.downButtonHeight && n < n3) {
            this.downButtonPushed = true;
            if (this.displayListCount - this.firstRow > this.maxDisplayRowCount) {
                ++this.firstRow;
                this.vSliderPos = this.vScrollerTop + 1 + 15 + (int)Math.round((double)this.firstRow / (double)(this.displayListCount - this.maxDisplayRowCount) * (double)(this.vSliderSpace - this.vSliderSize - 2));
                this.startScrollerThread(4);
            }
        } else if (n < this.vSliderPos && n >= this.vScrollerTop + this.upButtonHeight) {
            this.aboveSliderPushed = true;
            this.firstRow -= this.maxDisplayRowCount;
            this.firstRow = Math.max(this.firstRow, 0);
            this.vSliderPos = this.vScrollerTop + 1 + 15 + (int)Math.round((double)this.firstRow / (double)(this.displayListCount - this.maxDisplayRowCount) * (double)(this.vSliderSpace - this.vSliderSize - 2));
            this.scrollByPageToY = n;
            this.startScrollerThread(7);
        } else if (n >= this.vSliderPos + this.vSliderSize && n < this.vScrollerTop + this.upButtonHeight + this.vSliderSpace + 1) {
            this.belowSliderPushed = true;
            this.firstRow += this.maxDisplayRowCount;
            this.firstRow = Math.min(this.firstRow, this.displayListCount - this.maxDisplayRowCount);
            this.vSliderPos = this.vScrollerTop + 1 + 15 + (int)Math.round((double)this.firstRow / (double)(this.displayListCount - this.maxDisplayRowCount) * (double)(this.vSliderSpace - this.vSliderSize - 2));
            this.scrollByPageToY = n;
            this.startScrollerThread(8);
        } else if (n > this.vSliderPos && n < this.vSliderPos + this.vSliderSize) {
            this.vSliderAdjusting = true;
            this.vSliderAdjustPos = n;
        }
        this.notifyListeners(null, 7, -1, this.firstRow, this.getRowIndex(this.firstRow), null);
    }

    public void setTooltipBackground(Color color) {
        this.tooltipBackground = color;
    }

    public Color getTooltipBackground() {
        return this.tooltipBackground;
    }

    public void setRowBackground(int n, Color color) {
        if (n == -1) {
            this.defaultRowBackground = color != null ? color : Color.white;
        } else if (n >= 0) {
            if (n >= this.rowBackground.length) {
                this.rowBackground = Table.createArrayCopy(this.rowBackground, n + 50);
            }
            this.rowBackground[n] = color;
        }
        this.autoRepaint();
    }

    public Color getRowBackground(int n) {
        if (n > -1 && n < this.rowBackground.length && this.rowBackground[n] != null) {
            return this.rowBackground[n];
        }
        return this.defaultRowBackground;
    }

    public void setGridOn(boolean bl) {
        this.gridOn = bl;
        this.autoRepaint();
    }

    public URL getDocumentBase() {
        if (this.parentApplet != null) {
            return this.parentApplet.getDocumentBase();
        }
        return super.getDocumentBase();
    }

    private int paintFieldLabel(Graphics graphics, String string, int n, int n2, boolean bl) {
        int n3;
        if (graphics == null) {
            if (n2 > 0 && n2 < this.columnXpos.length) {
                return this.columnXpos[n2 - 1] - this.offset;
            }
            return 2 - this.offset;
        }
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.getHeight();
        if (string == null) {
            string = "";
        }
        String[] stringArray = new String[]{string};
        if (string.indexOf(10) >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            stringArray = new String[stringTokenizer.countTokens()];
            n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n3++] = stringTokenizer.nextToken();
            }
        }
        int n5 = Integer.MAX_VALUE;
        n3 = 0;
        while (n3 < stringArray.length) {
            int n6 = 0;
            if (stringArray[n3] != null) {
                n6 = fontMetrics.stringWidth(stringArray[n3]);
            }
            int n7 = 0;
            n7 = n2 > 0 && n2 <= this.columnXpos.length ? this.columnXpos[n2 - 1] - this.offset : 3 - this.offset;
            int n8 = this.columnXpos[0] - 2 - 1;
            if (n2 > 0 && n2 < this.columnXpos.length) {
                n8 = this.columnXpos[n2] - this.columnXpos[n2 - 1];
            }
            switch (this.columnAlignment[n2]) {
                case 0: {
                    n7 += 3;
                    break;
                }
                case 2: {
                    if (this.visibleColumnCount > 1) {
                        n7 = Math.max(this.columnXpos[n2] - this.offset - n6 - 3, n7 + 3);
                        break;
                    }
                    int n9 = n7 + 3;
                    n7 = this.columnXpos[n2] - n6 - 3;
                    n7 = Math.max(n9, n7);
                    break;
                }
                case 1: {
                    int n10 = n7 + n8 / 2;
                    n7 = Math.max(n10 - n6 / 2, n7 + 3);
                    break;
                }
            }
            n5 = Math.min(n5, n7);
            if (bl) {
                ++n7;
            }
            graphics.setClip(n7, 0, n8 - 6, dimension.height);
            if (this.isEnabled()) {
                if (bl) {
                    graphics.drawString(stringArray[n3], n7, n + n4);
                } else {
                    graphics.drawString(stringArray[n3], n7, n + n4);
                }
            } else {
                graphics.setColor(this.getBackground().brighter());
                if (bl) {
                    graphics.drawString(stringArray[n3], n7 + 1, n + n4 + 1);
                } else {
                    graphics.drawString(stringArray[n3], n7 + 1, n + n4);
                }
                graphics.setColor(Color.black);
                if (bl) {
                    graphics.drawString(stringArray[n3], n7, n + n4);
                } else {
                    graphics.drawString(stringArray[n3], n7, n + n4 - 1);
                }
            }
            n += fontMetrics.getMaxAscent() + 1;
            ++n3;
        }
        return n5;
    }

    static {
        DEFAULT_CURSOR = new Cursor(0);
        HAND_CURSOR = new Cursor(12);
        RESIZE_CURSOR = new Cursor(11);
        TEXT_CURSOR = new Cursor(2);
        TableEvent.version = Table.getVersion();
        DEFAULT_FONT = new Font("Dialog", 0, 11);
        labelCache = new Hashtable();
    }

    public void setSelectionMode(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid selection mode");
        }
        this.selectionMode = n;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public int[] getDisplayedRows() {
        int[] nArray = new int[this.displayListCount];
        System.arraycopy(this.displayList, 0, nArray, 0, this.displayListCount);
        return nArray;
    }

    private void qsort(int[] nArray, int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || nArray == null || nArray.length <= 1) {
            return;
        }
        int n4 = n;
        int n5 = n2;
        if (n2 > n) {
            int n6 = nArray[(n + n2) / 2];
            while (n4 <= n5) {
                int n7 = 1;
                if (n3 >= 0 && n3 < this.columnType.length) {
                    n7 = this.columnType[n3];
                }
                while (n4 < n2 && this.compare(nArray[n4], n6, n3, n7) == -1) {
                    ++n4;
                }
                while (n5 > n && this.compare(nArray[n5], n6, n3, n7) == 1) {
                    --n5;
                }
                if (n4 > n5) continue;
                int n8 = nArray[n4];
                nArray[n4] = nArray[n5];
                nArray[n5] = n8;
                ++n4;
                --n5;
            }
            if (n < n5) {
                this.qsort(nArray, n, n5, n3);
            }
            if (n4 < n2) {
                this.qsort(nArray, n4, n2, n3);
            }
        }
    }

    private void setFilterValueAndCheck(int n, String string) {
        if (n >= 0 && n < this.filterValues.length && n < this.filterCheck.length) {
            this.filterValues[n] = null;
            if (string != null && string.trim().length() > 0) {
                if ((string = string.trim().toLowerCase()).startsWith("<=")) {
                    this.filterValues[n] = string.substring(2);
                    this.filterCheck[n] = 8;
                } else if (string.endsWith("<=")) {
                    this.filterValues[n] = string.substring(0, string.length() - 2);
                    this.filterCheck[n] = 8;
                } else if (string.startsWith(">=")) {
                    this.filterValues[n] = string.substring(2);
                    this.filterCheck[n] = 6;
                } else if (string.endsWith(">=")) {
                    this.filterValues[n] = string.substring(0, string.length() - 2);
                    this.filterCheck[n] = 6;
                } else if (string.startsWith("<>")) {
                    this.filterValues[n] = string.substring(2);
                    this.filterCheck[n] = 4;
                } else if (string.endsWith("<>")) {
                    this.filterValues[n] = string.substring(0, string.length() - 2);
                    this.filterCheck[n] = 4;
                } else if (string.startsWith("<")) {
                    this.filterValues[n] = string.substring(1);
                    this.filterCheck[n] = 7;
                } else if (string.endsWith("<")) {
                    this.filterValues[n] = string.substring(0, string.length() - 1);
                    this.filterCheck[n] = 7;
                } else if (string.startsWith(">")) {
                    this.filterValues[n] = string.substring(1);
                    this.filterCheck[n] = 5;
                } else if (string.endsWith(">")) {
                    this.filterValues[n] = string.substring(0, string.length() - 1);
                    this.filterCheck[n] = 5;
                } else if (this.filterWildCard != null && this.filterWildCard.trim().length() > 0) {
                    if (string.startsWith(this.filterWildCard) && string.endsWith(this.filterWildCard)) {
                        this.filterValues[n] = (string = string.substring(1)).length() > 1 ? string.substring(0, string.length() - this.filterWildCard.length()) : string;
                        this.filterCheck[n] = 1;
                    } else if (string.endsWith(this.filterWildCard)) {
                        this.filterValues[n] = string.substring(0, string.length() - this.filterWildCard.length());
                        this.filterCheck[n] = 2;
                    } else if (string.startsWith(this.filterWildCard)) {
                        this.filterValues[n] = string.substring(this.filterWildCard.length());
                        this.filterCheck[n] = 3;
                    } else {
                        this.filterValues[n] = string;
                        this.filterCheck[n] = 0;
                    }
                } else {
                    this.filterValues[n] = string;
                    this.filterCheck[n] = n < this.columnType.length && (this.columnType[n] == 1 || this.columnType[n] == 2) ? 0 : 1;
                }
            }
            if (this.filterValues[n] != null && this.filterValues[n].length() > 0 && n < this.filterNumbers.length && n < this.columnType.length) {
                if (this.columnType[n] == 1 || this.columnType[n] == 2) {
                    try {
                        this.filterNumbers[n] = new Double(this.filterValues[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.filterNumbers[n] = Double.NaN;
                    }
                } else if (this.columnType[n] == 4) {
                    this.filterNumbers[n] = Table.getIPNumber(this.filterValues[n]);
                    if (this.filterNumbers[n] == 9.223372036854776E18) {
                        this.filterNumbers[n] = Double.NaN;
                    }
                }
            }
        }
    }

    public void setProgressiveFilterOn(boolean bl) {
        this.progressiveFilterOn = bl;
    }

    public void setPreferredSize(int n, int n2) {
        this.preferredSize = new Dimension(n, n2);
        this.autoRepaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    public void loadAppletParameters(Hashtable hashtable) {
        Object object;
        String string;
        if (this.getParameter("columnCount") != null) {
            this.setParameter("columncount", this.getParameter("columnCount"));
        }
        int n = 0;
        while (n < parameters_all.length) {
            String string2 = this.getParameter(parameters_all[n]);
            if (string2 != null && string2.trim().length() > 0) {
                hashtable.put(parameters_all[n], string2);
            }
            if (parameters_all[n].equalsIgnoreCase("filterWildCard")) {
                if (string2 != null) {
                    hashtable.put(parameters_all[n], string2);
                } else {
                    hashtable.put(parameters_all[n], "*");
                }
            }
            ++n;
        }
        n = this.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < parameters_col.length) {
                string = parameters_col[n3] + n2;
                object = this.getParameter(string);
                if (object != null && ((String)object).trim().length() > 0) {
                    hashtable.put(string, object);
                }
                ++n3;
            }
            ++n2;
        }
        n2 = 0;
        String string3 = null;
        while ((string3 = this.getParameter("row_" + n2)) != null) {
            hashtable.put("row_" + n2, string3);
            if (!this.loadingMessageOn || ++n2 % 100 != 0) continue;
            ++this.loadingDataDots;
            this.repaint();
        }
        string = this.getParameter("rowCellParameters");
        if (string != null && string.trim().length() > 0) {
            object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken().toLowerCase().trim();
                String string5 = this.getParameter(string4);
                if (string5 == null || string5.trim().length() <= 0) continue;
                hashtable.put(string4, string5);
            }
        } else {
            String string6;
            int n4;
            object = new String[hashtable.size()];
            Enumeration enumeration = hashtable.keys();
            int n5 = 0;
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                if (!string7.startsWith("row_")) continue;
                object[n5++] = string7;
            }
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                n2 = Integer.parseInt(((String)object[n7]).substring(4));
                n4 = 0;
                while (n4 < parameters_row.length) {
                    String string8 = parameters_row[n4] + n2;
                    string6 = this.getParameter(string8);
                    if (string6 != null && string6.trim().length() > 0) {
                        hashtable.put(string8, string6);
                    }
                    ++n4;
                }
                if (this.loadingMessageOn && n6 % 100 == 0) {
                    ++this.loadingDataDots;
                    this.repaint();
                }
                ++n6;
                ++n7;
            }
            n7 = 0;
            while (n7 < n5) {
                n2 = Integer.parseInt(((String)object[n7]).substring(4));
                n4 = 0;
                while (n4 < n) {
                    int n8 = 0;
                    while (n8 < parameters_row_col.length) {
                        string6 = parameters_row_col[n8] + n2 + "_" + n4;
                        String string9 = this.getParameter(string6);
                        if (string9 != null && string9.trim().length() > 0) {
                            hashtable.put(string6, string9);
                        }
                        ++n8;
                    }
                    ++n4;
                }
                if (this.loadingMessageOn && n6 % 100 == 0) {
                    ++this.loadingDataDots;
                    this.repaint();
                }
                ++n6;
                ++n7;
            }
        }
    }

    public void setParameters(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        boolean bl = this.automaticRepaintOn;
        this.automaticRepaintOn = false;
        this.setParameter("columncount", (String)hashtable.get("columncount"));
        hashtable.remove("columncount");
        if (hashtable.containsKey("fieldseparator")) {
            this.setParameter("fieldseparator", (String)hashtable.get("fieldseparator"));
            hashtable.remove("fieldseparator");
        }
        if (hashtable.containsKey("columntype")) {
            this.setParameter("columntype", (String)hashtable.get("columntype"));
            hashtable.remove("columntype");
        }
        if (hashtable.containsKey("labelcacheon")) {
            this.setParameter("labelcacheon", (String)hashtable.get("labelcacheon"));
            hashtable.remove("labelcacheon");
        }
        if (hashtable.containsKey("locale")) {
            this.setParameter("locale", (String)hashtable.get("locale"));
            hashtable.remove("locale");
        }
        if (hashtable.containsKey("dateformatinputlocale")) {
            this.setParameter("dateformatinputlocale", (String)hashtable.get("dateformatinputlocale"));
            hashtable.remove("dateformatinputlocale");
        }
        int n = this.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            String string = "dateformatinput_" + n2;
            if (hashtable.containsKey(string)) {
                this.setParameter(string, (String)hashtable.get(string));
                hashtable.remove(string);
            }
            ++n2;
        }
        Enumeration enumeration = hashtable.keys();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            this.setParameter(string, string2);
            if (!this.loadingMessageOn || n3++ % 100 != 0) continue;
            ++this.loadingDataDots;
            this.repaint();
        }
        hashtable.clear();
        this.calculateRowHeight(-1);
        this.checkScrollBars();
        this.adjustXpos();
        this.automaticRepaintOn = bl;
        this.autoRepaint();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    private void paintScrollBars(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Dimension dimension = this.getSize();
        int n5 = this.getHeaderHeight();
        graphics.setClip(0, 0, dimension.width, dimension.height);
        if (this.vScrollbarOn) {
            n4 = 15;
            n3 = dimension.height - n5 - 4 - 1;
            if (this.hScrollbarOn) {
                n3 -= n4;
            }
            n2 = dimension.width - 2 - n4;
            n = 2 + n5 + 1;
            graphics.setColor(this.getBackground().darker());
            graphics.fillRect(n2, n, n4, dimension.height);
            if (this.vSliderSpace > 3) {
                this.upButtonHeight = 15;
                this.downButtonHeight = 15;
            } else {
                this.upButtonHeight = (n3 - 1) / 2;
                this.downButtonHeight = n3 - this.upButtonHeight - 1;
            }
            this.paintArrowButton(graphics, n2, n, n4, this.upButtonHeight, 0, this.upButtonPushed);
            this.paintArrowButton(graphics, n2, n + n3 - this.downButtonHeight, n4, this.downButtonHeight, 1, this.downButtonPushed);
            if (this.vSliderSpace - 2 > this.vSliderSize) {
                this.paint3DBox(graphics, n2, this.vSliderPos, n4, this.vSliderSize, false);
            }
        }
        if (this.hScrollbarOn) {
            n4 = 15;
            n3 = dimension.width - 4 - 1;
            if (this.vScrollbarOn) {
                n3 -= n4;
            }
            n2 = 3;
            n = dimension.height - n4 - 2;
            graphics.setColor(this.getBackground().darker());
            graphics.fillRect(n2 + 15, n, this.hSliderSpace, n4);
            this.paintArrowButton(graphics, n2, n, n4, n4, 2, this.leftButtonPushed);
            this.paintArrowButton(graphics, n2 + n3 - n4, n, n4, n4, 3, this.rightButtonPushed);
            if (this.hSliderSpace - 2 > this.hSliderSize) {
                this.paint3DBox(graphics, this.hSliderPos, n, this.hSliderSize, 15, false);
            }
        }
    }

    private void notifyListeners(int n, int n2) {
        TableEvent tableEvent = new TableEvent(this, n, n2);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((TableListener)enumeration.nextElement()).tableSelection(tableEvent);
        }
    }

    private void notifyListeners(Object[] objectArray, int n, int n2, int n3, int n4, Point point) {
        TableEvent tableEvent = new TableEvent(this, objectArray, n, n2, n3, n4, point);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((TableListener)enumeration.nextElement()).tableSelection(tableEvent);
        }
    }
}

