/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.LineChart;
import com.objectplanet.chart.PieChart;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;

public class BarChart
extends Chart {
    public static final int SIDE_BY_SIDE_BARS = 0;
    public static final int STACKED_BARS = 1;
    public static final int VALUE_LABELS_OUTSIDE = 1;
    public static final int VALUE_LABELS_INSIDE = 0;
    public static final int VALUE_LABELS_FLOATING = 3;
    public static final int BAR_LABELS_BELOW = 2;
    public static final int BAR_LABELS_FLOATING = 3;
    public static final int BAR_LABELS_BELOW_AND_FLOATING = 4;
    private boolean multiColorOn;
    private int valueLabelStyle;
    private boolean barOutlineOn;
    private Color barOutlineColor;
    private boolean autoLabelSpacingOn;
    private double barWidthFraction;
    private int barType;
    private Rectangle[][] barBounds;

    private void paintBar(Graphics graphics, int n, int n2) {
        ChartSample chartSample = this.getSample(n, n2);
        int n3 = this.getSeriesCount();
        if (chartSample == null || chartSample.value == null || chartSample.value.isNaN() || chartSample.getFloatValue() == 0.0 && this.barType == 1 && n3 > 1) {
            return;
        }
        int n4 = this.getSeriesRange(n);
        double d = chartSample.getFloatValue();
        if (this.barType != 1 && (d < this.currentLowerRange[n4] && this.currentLowerRange[n4] > 0.0 || d > this.currentUpperRange[n4] && this.currentUpperRange[n4] < 0.0)) {
            return;
        }
        if (this.multiColorOn) {
            if (this.getSeriesCount() > 1 || this.barType == 1 || this.multiSeriesOn) {
                graphics.setColor(this.getSampleColor(n));
            } else {
                graphics.setColor(this.getSampleColor(n2));
            }
        } else {
            graphics.setColor(this.getSampleColor(0));
        }
        Rectangle rectangle = null;
        if (this.barBounds != null && n < this.barBounds.length && this.barBounds[n] != null && n2 < this.barBounds[n].length) {
            rectangle = this.barBounds[n][n2];
        }
        if (rectangle != null) {
            boolean bl = chartSample != null && chartSample.isSelected();
            Color color = this.getChartForeground();
            if (this.barOutlineOn) {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height);
                Color color2 = graphics.getColor();
                if (this.barOutlineColor != null) {
                    graphics.setColor(this.barOutlineColor);
                } else {
                    graphics.setColor(color);
                }
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (bl) {
                    graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height == 2 ? 1 : rectangle.height - 2);
                }
                graphics.setColor(color2);
            } else {
                if (this.gridAlignment == 1) {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (bl) {
                    Color color3 = graphics.getColor();
                    if (this.barOutlineColor != null) {
                        graphics.setColor(this.barOutlineColor);
                    } else {
                        graphics.setColor(color);
                    }
                    if (this.gridAlignment == 1) {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    } else {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                    }
                    graphics.setColor(color3);
                }
            }
            if (this.is3DModeOn()) {
                this.paint3DBar(graphics, rectangle, bl, d);
            }
        }
    }

    public void setBarLabelsOn(boolean bl) {
        if (this.sampleLabelsOn != bl) {
            this.sampleLabelsOn = bl;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public void setAutoLabelSpacingOn(boolean bl) {
        if (bl != this.autoLabelSpacingOn) {
            this.autoLabelSpacingOn = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    boolean isAnyFloatingLabelsOn() {
        return this.isValueLabelsOn() && this.valueLabelStyle == 3 || this.sampleLabelsOn && (this.barLabelStyle == 3 || this.barLabelStyle == 4);
    }

    public void setBarLabels(String[] stringArray) {
        this.barLabels = stringArray;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public String[] getBarLabels() {
        if (this.barLabels != null) {
            return this.barLabels;
        }
        return this.getSampleLabels();
    }

    public String[] getLegendLabels() {
        if (this.legendLabels != null) {
            return this.legendLabels;
        }
        if (this.getSeriesCount() > 1 || this.barType == 1 || this.multiSeriesOn) {
            return this.getSeriesLabels();
        }
        return this.getSampleLabels();
    }

    public void setBarType(int n) {
        if (n != this.barType) {
            if (n == 0 || n == 1) {
                this.barType = n;
                this.needRender = true;
                this.needChartCalculation = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Invalid bar type: " + n);
            }
        }
    }

    public int getBarType() {
        return this.barType;
    }

    double getHighestValue(int n) {
        if (this.barType == 0 || this.getSeriesRange(0) != n) {
            return super.getHighestValue(n);
        }
        double d = super.getHighestValue(n);
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        int n4 = 0;
        while (n4 < n2) {
            double d2 = 0.0;
            int n5 = 0;
            while (n5 < n3) {
                ChartSample chartSample = this.getSample(n5, n4);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN() && chartSample.value > 0.0) {
                    d2 += chartSample.value.doubleValue();
                }
                ++n5;
            }
            d = Math.max(d, d2);
            ++n4;
        }
        return d;
    }

    double getLowestValue(int n) {
        if (this.barType == 0) {
            return super.getLowestValue(n);
        }
        double d = super.getLowestValue(n);
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        int n4 = 0;
        while (n4 < n2) {
            double d2 = 0.0;
            int n5 = 0;
            while (n5 < n3) {
                ChartSample chartSample = this.getSample(n5, n4);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN() && chartSample.value < 0.0) {
                    d2 += chartSample.value.doubleValue();
                }
                ++n5;
            }
            d = Math.min(d, d2);
            ++n4;
        }
        return d;
    }

    public void setBarAlignment(int n) {
        if (n != this.gridAlignment) {
            if (n == 0 || n == 1) {
                this.gridAlignment = n;
                this.needRender = true;
                this.needGraphBounds = true;
                this.needChartCalculation = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Alignment must be HORIZONTAL or VERTICAL");
            }
        }
    }

    public int getgridAlignment() {
        return this.gridAlignment;
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
        int n;
        if (!this.needChartCalculation) {
            return;
        }
        this.calculateZeroLines(rectangle);
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        if (this.is3DModeOn() && n2 > 0 && n3 > 0) {
            double d;
            double d2;
            if (this.depth3d >= 0) {
                this.depth3dPoint.x = this.depth3d;
                this.depth3dPoint.y = -this.depth3d;
            } else if (this.gridAlignment == 1) {
                d2 = (double)rectangle.width / (double)n2;
                d = d2 * this.barWidthFraction;
                if (this.barType == 0) {
                    d /= (double)n3;
                }
                this.depth3dPoint.x = (int)Math.round(d * 1.25);
                this.depth3dPoint.y = (int)Math.round(-d / 1.25);
            } else {
                d2 = (double)rectangle.height / (double)n2;
                d = d2 * this.barWidthFraction;
                if (this.barType == 0) {
                    d /= (double)n3;
                }
                this.depth3dPoint.x = (int)Math.round(d * 1.25 * 0.75);
                this.depth3dPoint.y = (int)Math.round(-(d / 1.25 * 0.75));
            }
        }
        if (this.barBounds == null || this.barBounds.length != n3 || this.barBounds[0].length != n2) {
            Rectangle[][] rectangleArray = new Rectangle[n3][n2];
            n = 0;
            while (n < n3) {
                int n4 = 0;
                while (n4 < n2) {
                    if (this.barBounds != null && n < this.barBounds.length && n4 < this.barBounds[0].length && this.barBounds[n][n4] != null) {
                        rectangleArray[n][n4] = this.barBounds[n][n4];
                    }
                    ++n4;
                }
                ++n;
            }
            this.barBounds = rectangleArray;
        }
        int n5 = 0;
        while (n5 < n2) {
            n = 0;
            while (n < n3) {
                if (this.barBounds[n][n5] == null) {
                    this.barBounds[n][n5] = new Rectangle();
                }
                ++n;
            }
            ++n5;
        }
        double d = 0.0;
        double d3 = rectangle2.width;
        if (n2 > 0 && n3 > 0) {
            d = this.gridAlignment == 1 ? (double)rectangle2.width / (double)n2 : (double)rectangle2.height / (double)n2;
            d3 = d * this.barWidthFraction;
            if (this.barType == 0) {
                d3 /= (double)n3;
            }
        }
        double d4 = d * (1.0 - this.barWidthFraction);
        double d5 = 0.0;
        boolean bl = this.is3DModeOn();
        if (this.gridAlignment == 1) {
            d5 = (double)rectangle2.x + d4 / 2.0;
            if (bl) {
                d5 -= (double)this.depth3dPoint.x;
            }
        } else {
            d5 = (double)rectangle2.y + d4 / 2.0;
            if (bl) {
                d5 -= (double)this.depth3dPoint.y;
            }
        }
        if (this.gridAlignment == 1) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < n3) {
                    double d6;
                    double d7;
                    double d8;
                    double d9;
                    Rectangle rectangle3 = this.barBounds[n7][n6];
                    if (d5 >= 0.0) {
                        rectangle3.x = (int)(d5 + 0.5);
                        rectangle3.width = (int)(d5 + d3 + 0.5) - rectangle3.x;
                    } else {
                        rectangle3.x = (int)(d5 - 0.5);
                        rectangle3.width = (int)(d5 + d3 - 0.5) - rectangle3.x;
                    }
                    boolean bl2 = this.barType == 1;
                    int n8 = bl2 ? 0 : this.getSeriesRange(n7);
                    double d10 = this.getSampleValue(n7, n6);
                    if (d10 >= 0.0) {
                        int n9;
                        int n10;
                        d9 = 0.0;
                        if (this.currentUpperRange[n8] != 0.0) {
                            d9 = d10 / this.currentUpperRange[n8] * (double)(this.zeroLine[n8] - rectangle2.y);
                        }
                        rectangle3.height = (int)(d9 + 0.5);
                        rectangle3.y = this.zeroLine[n8] - rectangle3.height;
                        rectangle3.height = Math.max(0, rectangle3.height);
                        if (bl2 && n7 > 0) {
                            double d11 = 0.0;
                            int n11 = 0;
                            while (n11 < n7) {
                                double d12 = this.getSampleValue(n11, n6);
                                if (d12 >= 0.0) {
                                    d11 += d12;
                                }
                                ++n11;
                            }
                            d8 = 0.0;
                            if (this.currentUpperRange[n8] != 0.0) {
                                d8 = d11 / this.currentUpperRange[n8] * (double)(this.zeroLine[n8] - rectangle2.y);
                            }
                            rectangle3.y = (d7 = (double)this.zeroLine[n8] - d8 - d9) >= 0.0 ? (int)(d7 + 0.5) : (int)(d7 - 0.5);
                            d6 = d9 + d7 - (double)rectangle3.y;
                            rectangle3.height = d6 >= 0.0 ? (int)(d6 + 0.5) : (int)(d6 - 0.5);
                        }
                        if ((n10 = rectangle3.y + rectangle3.height) > (n9 = rectangle2.y + rectangle2.height)) {
                            rectangle3.height -= n10 - n9;
                        }
                    } else {
                        d9 = 0.0;
                        if (this.currentLowerRange[n8] != 0.0) {
                            d9 = d10 / this.currentLowerRange[n8] * (double)(rectangle2.y + rectangle2.height - this.zeroLine[n8]);
                        }
                        rectangle3.height = (int)(d9 + 0.5);
                        rectangle3.y = this.zeroLine[n8];
                        if (bl2 && n7 > 0) {
                            double d13 = 0.0;
                            int n12 = 0;
                            while (n12 < n7) {
                                if (this.getSampleValue(n12, n6) < 0.0) {
                                    d13 += this.getSampleValue(n12, n6);
                                }
                                ++n12;
                            }
                            d8 = 0.0;
                            if (this.currentLowerRange[n8] != 0.0) {
                                d8 = d13 / this.currentLowerRange[n8] * (double)(rectangle2.y + rectangle2.height - this.zeroLine[n8]);
                            }
                            rectangle3.y = (d7 = (double)this.zeroLine[n8] + d8) >= 0.0 ? (int)(d7 + 0.5) : (int)(d7 - 0.5);
                            d6 = d9 + d7 - (double)rectangle3.y;
                            rectangle3.height = d6 >= 0.0 ? (int)(d6 + 0.5) : (int)(d6 - 0.5);
                        }
                        if (rectangle3.y < rectangle2.y) {
                            rectangle3.height -= rectangle2.y - rectangle3.y;
                            rectangle3.y = rectangle2.y;
                        }
                    }
                    if (bl) {
                        rectangle3.y -= this.depth3dPoint.y;
                    }
                    if (this.barType == 0 || n7 == n3 - 1) {
                        d5 += d3;
                    }
                    ++n7;
                }
                d5 += d4;
                ++n6;
            }
        } else {
            int n13 = 0;
            while (n13 < n2) {
                int n14 = 0;
                while (n14 < n3) {
                    double d14;
                    double d15;
                    double d16;
                    double d17;
                    Rectangle rectangle4 = this.barBounds[n14][n13];
                    if (d5 >= 0.0) {
                        rectangle4.y = (int)(d5 + 0.5);
                        rectangle4.height = (int)(d5 + d3 + 0.5) - rectangle4.y;
                    } else {
                        rectangle4.y = (int)(d5 - 0.5);
                        rectangle4.height = (int)(d5 + d3 - 0.5) - rectangle4.y;
                    }
                    boolean bl3 = this.barType == 1;
                    int n15 = bl3 ? 0 : this.getSeriesRange(n14);
                    double d18 = this.getSampleValue(n14, n13);
                    if (d18 >= 0.0) {
                        d17 = 0.0;
                        if (this.currentUpperRange[n15] != 0.0) {
                            d17 = d18 / this.currentUpperRange[n15] * (double)(rectangle2.x + rectangle2.width - this.zeroLine[n15]);
                        }
                        rectangle4.width = (int)(d17 + 0.5);
                        rectangle4.x = this.zeroLine[n15];
                        if (this.barType == 1 && n14 > 0) {
                            double d19 = 0.0;
                            int n16 = 0;
                            while (n16 < n14) {
                                double d20 = this.getSampleValue(n16, n13);
                                if (d20 >= 0.0) {
                                    d19 += d20;
                                }
                                ++n16;
                            }
                            d16 = 0.0;
                            if (this.currentUpperRange[n15] != 0.0) {
                                d16 = d19 / this.currentUpperRange[n15] * (double)(rectangle2.x + rectangle2.width - this.zeroLine[n15]);
                            }
                            rectangle4.x = (d15 = (double)this.zeroLine[n15] + d16) >= 0.0 ? (int)(d15 + 0.5) : (int)(d15 - 0.5);
                            d14 = d17 + d15 - (double)rectangle4.x;
                            rectangle4.width = d14 >= 0.0 ? (int)(d14 + 0.5) : (int)(d14 - 0.5);
                        }
                        if (rectangle4.x < rectangle2.x) {
                            rectangle4.width -= rectangle2.x - rectangle4.x;
                            rectangle4.x = rectangle2.x;
                        }
                    } else {
                        int n17;
                        int n18;
                        d17 = 0.0;
                        if (this.currentLowerRange[n15] != 0.0) {
                            d17 = d18 / this.currentLowerRange[n15] * (double)(this.zeroLine[n15] - rectangle2.x);
                        }
                        rectangle4.width = (int)(d17 + 0.5);
                        rectangle4.x = this.zeroLine[n15] - rectangle4.width;
                        if (this.barType == 1 && n14 > 0) {
                            double d21 = 0.0;
                            int n19 = 0;
                            while (n19 < n14) {
                                if (this.getSampleValue(n19, n13) < 0.0) {
                                    d21 += this.getSampleValue(n19, n13);
                                }
                                ++n19;
                            }
                            d16 = 0.0;
                            if (this.currentLowerRange[n15] != 0.0) {
                                d16 = d21 / this.currentLowerRange[n15] * (double)(this.zeroLine[n15] - rectangle2.x);
                            }
                            rectangle4.x = (d15 = (double)this.zeroLine[n15] - d16 - d17) >= 0.0 ? (int)(d15 + 0.5) : (int)(d15 - 0.5);
                            d14 = d17 + d15 - (double)rectangle4.x;
                            rectangle4.width = d14 >= 0.0 ? (int)(d14 + 0.5) : (int)(d14 - 0.5);
                        }
                        if ((n18 = rectangle4.x + rectangle4.width) > (n17 = rectangle2.x + rectangle2.width)) {
                            rectangle4.width -= n18 - n17;
                        }
                    }
                    if (bl) {
                        rectangle4.x -= this.depth3dPoint.x;
                    }
                    if (this.barType == 0 || n14 == n3 - 1) {
                        d5 += d3;
                    }
                    ++n14;
                }
                d5 += d4;
                ++n13;
            }
        }
        this.needChartCalculation = false;
    }

    private void paintBarLabels(Graphics graphics, Rectangle rectangle) {
        if (!this.sampleLabelsOn || this.barLabelStyle == 3) {
            return;
        }
        String[] stringArray = this.getBarLabels();
        if (stringArray == null) {
            return;
        }
        Font font = this.getFont("barLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.gridAlignment == 1) {
            int n = this.getLabelAngle("barLabelAngle");
            int n2 = 0;
            Math.min(stringArray.length, this.getSampleCount());
            int n3 = Math.max(this.visibleSamples[0] - 1, 0);
            int n4 = Math.min(n3 + this.visibleSamples[1] + 1, stringArray.length);
            int n5 = n3;
            while (n5 < n4) {
                if (stringArray[n5] != null) {
                    boolean bl = false;
                    int n6 = this.getSeriesCount();
                    int n7 = 0;
                    while (n7 < n6) {
                        if (this.isSelected(n7, n5)) {
                            bl = true;
                            break;
                        }
                        ++n7;
                    }
                    Color color = this.getSampleLabelColor(n5);
                    if (bl && this.getSampleLabelSelectionColor() != null) {
                        graphics.setColor(this.getSampleLabelSelectionColor());
                    } else if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(this.getForeground());
                    }
                    Dimension dimension = this.getLabelSize(stringArray[n5], fontMetrics);
                    Dimension dimension2 = this.getAngledLabelSize(dimension, n);
                    int n8 = Integer.MIN_VALUE;
                    int n9 = 0;
                    if (this.barBounds != null && this.barBounds.length > 0 && n5 < this.barBounds[0].length) {
                        n8 = this.barBounds[0][n5].x;
                        n9 = this.barBounds[this.barBounds.length - 1][n5].x + this.barBounds[this.barBounds.length - 1][n5].width - n8;
                    }
                    int n10 = n8 + n9 / 2;
                    n8 = n % 90 == 0 ? n10 - dimension2.width / 2 : (n % 180 > 90 ? n10 + n9 / 2 - dimension2.width : n10 - n9 / 2);
                    int n11 = rectangle.x - 2 - (this.is3DModeOn() ? this.depth3dPoint.x : 0);
                    if (n10 >= n11 && n10 <= rectangle.x + rectangle.width + 2) {
                        int n12 = rectangle.y + rectangle.height + 6;
                        if (n % 180 == 0) {
                            n12 += fontMetrics.getMaxAscent() - 4;
                        }
                        if (this.is3DModeOn()) {
                            n12 -= this.depth3dPoint.y;
                        }
                        if (this.sampleScrollerOn) {
                            n12 += 10;
                        }
                        if (this.isValueLabelsOn() && this.valueLabelStyle == 1 && this.lowerRange[0] < 0.0) {
                            int n13 = rectangle.y;
                            int n14 = this.zeroLine[0] - (this.is3DModeOn() ? this.depth3dPoint.y : 0);
                            int n15 = 0;
                            while (n15 < this.barBounds.length) {
                                int n16 = this.barBounds[n15][n5].y + this.barBounds[n15][n5].height;
                                if (n16 > n13 && n16 > n14) {
                                    n13 = n16;
                                }
                                ++n15;
                            }
                            n12 = Math.max(n12, n13 + fontMetrics.getMaxAscent() + 10);
                            n13 = rectangle.y + rectangle.height - (this.is3DModeOn() ? this.depth3dPoint.y : 0);
                            n12 = Math.min(n12, n13 + fontMetrics.getMaxAscent() + 10);
                        }
                        if (this.autoLabelSpacingOn) {
                            if (stringArray[n5] != null && stringArray[n5].trim().length() > 0 && (n8 > n2 || n5 == 0)) {
                                this.paintLabel(graphics, stringArray[n5], n8, n12, dimension, 0, n);
                                n2 = n8 + dimension2.width;
                            }
                        } else {
                            this.paintLabel(graphics, stringArray[n5], n8, n12, dimension, 0, n);
                        }
                    }
                }
                ++n5;
            }
        } else {
            int n = this.getLabelAngle("barLabelAngle");
            int n17 = Math.min(stringArray.length, this.getSampleCount());
            int n18 = Math.max(this.visibleSamples[0] - 1, 0);
            int n19 = Math.min(n18 + this.visibleSamples[1] + 1, n17);
            int n20 = n18;
            while (n20 < n19) {
                if (stringArray[n20] != null) {
                    boolean bl = false;
                    int n21 = this.getSeriesCount();
                    int n22 = 0;
                    while (n22 < n21) {
                        if (this.isSelected(n22, n20)) {
                            bl = true;
                            break;
                        }
                        ++n22;
                    }
                    Color color = this.getSampleLabelColor(n20);
                    if (bl && this.getSampleLabelSelectionColor() != null) {
                        graphics.setColor(this.getSampleLabelSelectionColor());
                    } else if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(this.getForeground());
                    }
                    Dimension dimension = this.getLabelSize(stringArray[n20], fontMetrics);
                    Dimension dimension3 = this.getAngledLabelSize(dimension, n);
                    int n23 = dimension3.height;
                    if (this.barBounds.length > 0 && n20 < this.barBounds[this.barBounds.length - 1].length && n20 < this.barBounds[0].length) {
                        n23 = this.barBounds[this.barBounds.length - 1][n20].y + this.barBounds[this.barBounds.length - 1][n20].height - this.barBounds[0][n20].y;
                    }
                    int n24 = 0;
                    if (n20 < this.barBounds[0].length) {
                        n24 = this.barBounds[0][n20].y + n23 / 2;
                    }
                    int n25 = n24 - dimension3.height / 2;
                    if (n % 180 == 0) {
                        n25 += fontMetrics.getAscent() - 1;
                    } else if (n % 180 > 90) {
                        n25 = n24 - n23 / 2;
                    } else if (n % 180 != 90) {
                        n25 = n24 + n23 / 2 - dimension3.height;
                    }
                    if (n24 >= rectangle.y && n24 <= rectangle.y + rectangle.height - (this.is3DModeOn() ? this.depth3dPoint.y : 0)) {
                        int n26 = rectangle.x - dimension3.width - 3;
                        if (this.is3DModeOn()) {
                            n26 -= this.depth3dPoint.x;
                        }
                        if (this.sampleScrollerOn) {
                            n26 -= 10;
                        }
                        if (this.isValueLabelsOn() && this.valueLabelStyle == 1 && this.lowerRange[0] < 0.0) {
                            int n27 = rectangle.x + rectangle.width;
                            int n28 = 0;
                            double d = 0.0;
                            int n29 = 0;
                            while (n29 < this.barBounds.length) {
                                if (!(this.getSampleValue(n29, n20) >= 0.0)) {
                                    d = this.barType == 1 ? (d += this.getSampleValue(n29, n20)) : this.getSampleValue(n29, n20);
                                    if (this.barBounds[n29][n20].x < n27) {
                                        String string = this.getLabel("valueLabelPrefix");
                                        String string2 = this.getLabel("valueLabelPostfix");
                                        n27 = this.barBounds[n29][n20].x;
                                        String string3 = this.formatNumber(d, this.getSampleDecimalCount(0));
                                        string3 = string != null ? string + string3 : string3;
                                        string3 = string2 != null ? string3 + string2 : string3;
                                        n28 = fontMetrics.stringWidth(string3);
                                    }
                                }
                                ++n29;
                            }
                            n26 = Math.min(n26, n27 - n28 - dimension3.width - 3);
                            n27 = rectangle.x - (this.is3DModeOn() ? this.depth3dPoint.x : 0);
                            n26 = Math.max(n26, n27 - n28 - dimension3.width - 3);
                            n26 = Math.min(n26, (n27 -= this.sampleScrollerOn ? 10 : 0) - dimension3.width - 3);
                        }
                        this.paintLabel(graphics, stringArray[n20], n26, n25, dimension, 1, n);
                    }
                }
                ++n20;
            }
        }
    }

    void paintFloatingLabels(Graphics graphics, Rectangle rectangle) {
        boolean bl;
        super.paintFloatingLabels(graphics, rectangle);
        boolean bl2 = bl = this.valueLabelStyle == 3 || this.barLabelStyle == 3 || this.barLabelStyle == 4;
        if (bl && this.mouseOverSeriesIndex >= 0 && this.mouseOverSampleIndex >= -1) {
            Font font = this.getFont("floatingLabelFont");
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.mouseOverSampleIndex >= 0) {
                String string = this.constructFloatingLabel(this.mouseOverSeriesIndex, this.mouseOverSampleIndex, true);
                this.paintFloatingLabel(graphics, rectangle, this.mouseOverSeriesIndex, this.mouseOverSampleIndex, string, font, fontMetrics);
            } else if (this.isFloatingOnLegendOn()) {
                int n = this.getSampleCount();
                int n2 = 0;
                while (n2 < n) {
                    String string = this.constructFloatingLabel(this.mouseOverSeriesIndex, n2, false);
                    this.paintFloatingLabel(graphics, rectangle, this.mouseOverSeriesIndex, n2, string, font, fontMetrics);
                    ++n2;
                }
            }
        }
    }

    public void setMultiColorOn(boolean bl) {
        if (bl != this.multiColorOn) {
            this.multiColorOn = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    private void paintBars(Graphics graphics, Rectangle rectangle) {
        int n;
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        if (rectangle.width < 0 || rectangle.height < 0) {
            return;
        }
        boolean bl = this.is3DModeOn();
        if (bl) {
            graphics.setClip(rectangle.x - this.depth3dPoint.x + 1, rectangle.y + 1, rectangle.width + this.depth3dPoint.x - 1, rectangle.height - this.depth3dPoint.y - 1);
        } else if (this.parentChart != null && this.parentChart.is3DModeOn()) {
            graphics.setClip(rectangle.x + 1 - this.parentChart.depth3dPoint.x, rectangle.y + 1 - this.parentChart.depth3dPoint.y, rectangle.width - 1, rectangle.height - 1);
        } else {
            graphics.setClip(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1);
        }
        int n4 = Math.max(this.visibleSamples[0] - 1, 0);
        int n5 = Math.min(n4 + this.visibleSamples[1] + 1, n3);
        if (this.gridAlignment == 1) {
            if (this.barType == 0) {
                n = n4;
                while (n < n5) {
                    int n6 = 0;
                    while (n6 < n2) {
                        this.paintBar(graphics, n6, n);
                        ++n6;
                    }
                    ++n;
                }
            } else {
                int n7;
                n = n4;
                while (n < n5) {
                    n7 = n2 - 1;
                    while (n7 >= 0) {
                        if (this.getSampleValue(n7, n) < 0.0) {
                            this.paintBar(graphics, n7, n);
                        }
                        --n7;
                    }
                    ++n;
                }
                n = n4;
                while (n < n5) {
                    n7 = 0;
                    while (n7 < n2) {
                        if (this.getSampleValue(n7, n) >= 0.0) {
                            this.paintBar(graphics, n7, n);
                        }
                        ++n7;
                    }
                    ++n;
                }
            }
        } else if (this.barType == 0) {
            n = n5 - 1;
            while (n >= n4) {
                int n8 = n2 - 1;
                while (n8 >= 0) {
                    this.paintBar(graphics, n8, n);
                    --n8;
                }
                --n;
            }
        } else {
            int n9;
            n = n5 - 1;
            while (n >= n4) {
                n9 = n2 - 1;
                while (n9 >= 0) {
                    if (this.getSampleValue(n9, n) < 0.0) {
                        this.paintBar(graphics, n9, n);
                    }
                    --n9;
                }
                --n;
            }
            n = n5 - 1;
            while (n >= n4) {
                n9 = 0;
                while (n9 < n2) {
                    if (this.getSampleValue(n9, n) >= 0.0) {
                        this.paintBar(graphics, n9, n);
                    }
                    ++n9;
                }
                --n;
            }
        }
        if (bl) {
            graphics.setColor(this.getBackground());
            Polygon polygon = new Polygon();
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height - this.depth3dPoint.y + 1);
            polygon.addPoint(rectangle.x + rectangle.width - this.depth3dPoint.x - 1, rectangle.y + rectangle.height - this.depth3dPoint.y + 1);
            graphics.fillPolygon(polygon);
            graphics.setColor(this.getChartForeground());
            graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x + rectangle.width - this.depth3dPoint.x, rectangle.y + rectangle.height - this.depth3dPoint.y);
            polygon.xpoints[0] = rectangle.x;
            polygon.ypoints[0] = rectangle.y;
            polygon.xpoints[1] = rectangle.x - this.depth3dPoint.x;
            polygon.ypoints[1] = rectangle.y;
            polygon.xpoints[2] = rectangle.x - this.depth3dPoint.x;
            polygon.ypoints[2] = rectangle.y - this.depth3dPoint.y;
            graphics.setColor(this.getBackground());
            graphics.fillPolygon(polygon);
            graphics.setColor(this.getChartForeground());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x - this.depth3dPoint.x, rectangle.y - this.depth3dPoint.y);
        }
    }

    public void setValueLabelStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                if (n == this.valueLabelStyle) break;
                this.valueLabelStyle = n;
                this.needRender = true;
                this.needGraphBounds = true;
                this.needChartCalculation = true;
                this.autoRepaint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid valueLabelStyle: " + n);
            }
        }
    }

    public int getValueLabelStyle() {
        return this.valueLabelStyle;
    }

    public boolean isMultiColorOn() {
        return this.multiColorOn;
    }

    public boolean isBarOutlineOn() {
        return this.barOutlineOn;
    }

    public ChartSample checkSelection(Point point) {
        int n;
        ChartSample chartSample = null;
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        if (this.isLegendOn() && this.legendBounds != null) {
            n = 0;
            while (n < this.legendBounds.length) {
                if (this.legendBounds[n] != null && this.legendBounds[n].contains(point)) {
                    if (n2 > 1 || this.barType == 1 || this.multiSeriesOn) {
                        chartSample = new ChartSample(-1);
                        chartSample.setSeries(n);
                        break;
                    }
                    if (n >= n3) break;
                    chartSample = this.getSample(0, n);
                    break;
                }
                ++n;
            }
        }
        if (chartSample == null && this.barBounds != null) {
            n = this.getSampleCount();
            while (n != 0) {
                int n4 = this.gridAlignment == 0 ? this.getSampleCount() - n : n - 1;
                --n;
                int n5 = this.getSeriesCount();
                while (n5 != 0) {
                    Polygon polygon;
                    int n6 = this.gridAlignment == 0 ? this.getSeriesCount() - n5 : n5 - 1;
                    n6 = this.barType == 1 ? n5 - 1 : n6;
                    --n5;
                    Rectangle rectangle = this.barBounds[n6][n4];
                    if (rectangle == null || rectangle == null) continue;
                    Rectangle rectangle2 = rectangle;
                    if (this.barType != 1 || this.getSeriesCount() <= 1) {
                        if (this.gridAlignment == 1 && rectangle2.height < 3) {
                            rectangle2.y -= 3 - rectangle2.height;
                            rectangle2.height = 6;
                        } else if (this.gridAlignment == 0 && rectangle2.width < 3) {
                            rectangle2.x -= 3 - rectangle2.width;
                            rectangle2.width = 6;
                        }
                    }
                    if (rectangle2.contains(point)) {
                        return this.getSample(n6, n4);
                    }
                    if (!this.is3DModeOn()) continue;
                    if (this.gridAlignment != 1 || this.barType != 1 || this.getSampleValues(n6)[n4] > 0.0 || n6 == 0) {
                        polygon = new Polygon();
                        polygon.addPoint(rectangle.x, rectangle.y);
                        polygon.addPoint(polygon.xpoints[0] + this.depth3dPoint.x, polygon.ypoints[0] + this.depth3dPoint.y);
                        polygon.addPoint(polygon.xpoints[1] + rectangle.width, polygon.ypoints[1]);
                        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
                        if (polygon.contains(point)) {
                            return this.getSample(n6, n4);
                        }
                    }
                    if (this.gridAlignment == 0 && this.barType == 1 && !(this.getSampleValues(n6)[n4] > 0.0) && n6 != 0) continue;
                    polygon = new Polygon();
                    polygon.addPoint(rectangle.x + rectangle.width - 1, rectangle.y);
                    polygon.addPoint(rectangle.x + this.depth3dPoint.x + rectangle.width, rectangle.y + this.depth3dPoint.y);
                    polygon.addPoint(rectangle.x + this.depth3dPoint.x + rectangle.width, rectangle.y + this.depth3dPoint.y + rectangle.height);
                    polygon.addPoint(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
                    if (!polygon.contains(point)) continue;
                    return this.getSample(n6, n4);
                }
            }
        }
        return chartSample;
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.paintBars(graphics, rectangle);
        if (this.is3DModeOn()) {
            int n = this.rangeOn.length - 1;
            while (n >= 0) {
                this.paint3DZeroDivider(graphics, rectangle, n);
                --n;
            }
        }
        this.paintValueLabels(graphics, rectangle);
    }

    public void reset() {
        super.reset();
        this.multiColorOn = false;
        this.barLabelStyle = 2;
        this.valueLabelStyle = 1;
        this.barOutlineOn = true;
        this.autoLabelSpacingOn = false;
        this.barWidthFraction = 0.4;
        this.barType = 0;
        this.multiSeriesOn = false;
        this.barWidthFraction = 0.4;
        this.barOutlineColor = null;
    }

    public BarChart() {
        this(1);
    }

    public BarChart(int n) {
        this(n, 100.0);
    }

    public BarChart(int n, double d) {
        this(n, d, 0.0);
    }

    public BarChart(int n, double d, double d2) {
        this(1, n, d, d2);
    }

    public BarChart(int n, int n2, double d, double d2) {
        super(n2);
        this.chartType = "bar";
        this.setAutomaticRepaintOn(false);
        this.setSeriesCount(n);
        this.upperRange[0] = this.currentUpperRange[0] = d;
        this.lowerRange[0] = this.currentLowerRange[0] = d2;
        this.setAutomaticRepaintOn(true);
    }

    public boolean isBarLabelsOn() {
        return this.sampleLabelsOn;
    }

    public boolean isAutoLabelSpacingOn() {
        return this.autoLabelSpacingOn;
    }

    public void setMultiSeriesOn(boolean bl) {
        if (bl != this.multiSeriesOn) {
            this.multiSeriesOn = bl;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    private String constructFloatingLabel(int n, int n2, boolean bl) {
        String string;
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount()) {
            return "";
        }
        String string2 = "";
        if (this.sampleLabelsOn && (this.barLabelStyle == 3 || this.barLabelStyle == 4)) {
            if (this.getSeriesCount() == 1) {
                if (this.getSampleLabel(n2) != null) {
                    string2 = string2 + this.getSampleLabel(n2);
                }
            } else {
                string = this.getSeriesLabel(n);
                if (bl && string != null) {
                    string2 = string.endsWith("\n") ? string2 + string : string2 + string + " : ";
                }
                if (this.getSampleLabel(n2) != null) {
                    string2 = string2 + this.getSampleLabel(n2);
                }
            }
        }
        if (this.isValueLabelsOn() && this.valueLabelStyle == 3) {
            String string3;
            string = this.getLabel("valueLabelPrefix_" + n);
            if (string == null) {
                string = this.getLabel("valueLabelPrefix");
            }
            if ((string3 = this.getLabel("valueLabelPostfix_" + n)) == null) {
                string3 = this.getLabel("valueLabelPostfix");
            }
            if (string2.length() > 0) {
                String string4 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string4 = string != null ? string + string4 : string4;
                String string5 = string4 = string3 != null ? string4 + string3 : string4;
                string2 = string2.endsWith("\n") ? string2 + string4 : string2 + " : " + string4;
            } else {
                string2 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string2 = string != null ? string + string2 : string2;
                string2 = string3 != null ? string2 + string3 : string2;
            }
        }
        return string2;
    }

    private void paintValueLabels(Graphics graphics, Rectangle rectangle) {
        block84: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            boolean bl;
            FontMetrics fontMetrics;
            int n9;
            int n10;
            block83: {
                graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
                n10 = this.getSampleCount();
                n9 = this.getSeriesCount();
                if (n10 == 0 || n9 == 0 || this.valueLabelStyle == 3) {
                    return;
                }
                Font font = this.getFont("valueLabelFont");
                this.getSize();
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics();
                bl = this.is3DModeOn();
                n8 = rectangle.y;
                n7 = n8 + rectangle.height - (bl ? this.depth3dPoint.y : 0);
                n6 = rectangle.x - (bl ? this.depth3dPoint.x : 0);
                n5 = rectangle.x + rectangle.width;
                this.getChartBackground();
                n4 = this.getLabelAngle("valueLabelAngle");
                n3 = fontMetrics.getHeight();
                n2 = fontMetrics.getDescent();
                n = fontMetrics.getAscent();
                if (this.valueLabelStyle != 1 || n9 <= 1 || this.barType != 1) break block83;
                if (!this.isValueLabelsOn(0)) {
                    return;
                }
                int n11 = this.getSampleDecimalCount(0);
                String string = this.getLabel("valueLabelPrefix");
                String string2 = this.getLabel("valueLabelPostfix");
                int n12 = Math.max(this.visibleSamples[0] - 1, 0);
                int n13 = Math.min(n12 + this.visibleSamples[1] + 1, n10);
                int n14 = n12;
                while (n14 < n13) {
                    Serializable serializable;
                    double d = 0.0;
                    double d2 = 0.0;
                    boolean bl2 = false;
                    int n15 = 0;
                    while (n15 < n9) {
                        serializable = this.getSample(n15, n14);
                        if (serializable != null && serializable.value != null) {
                            bl2 = true;
                            double d3 = serializable.getFloatValue();
                            if (d3 >= 0.0) {
                                d += d3;
                            } else {
                                d2 += d3;
                            }
                        }
                        ++n15;
                    }
                    if (bl2) {
                        boolean bl3;
                        boolean bl4;
                        int n16;
                        String string3 = this.formatNumber(d, n11);
                        string3 = string != null ? string + string3 : string3;
                        string3 = string2 != null ? string3 + string2 : string3;
                        serializable = this.getLabelSize(string3, fontMetrics);
                        Dimension dimension = this.getAngledLabelSize((Dimension)serializable, n4);
                        String string4 = this.formatNumber(d2, n11);
                        string4 = string != null ? string + string4 : string4;
                        string4 = string2 != null ? string4 + string2 : string4;
                        Dimension dimension2 = this.getLabelSize(string4, fontMetrics);
                        Dimension dimension3 = this.getAngledLabelSize(dimension2, n4);
                        Rectangle rectangle2 = this.barBounds[0][n14];
                        Rectangle rectangle3 = this.barBounds[0][n14];
                        int n17 = 0;
                        while (n17 < this.barBounds.length) {
                            Rectangle rectangle4 = this.barBounds[n17][n14];
                            if (rectangle4 != null) {
                                if (this.gridAlignment == 1) {
                                    if (rectangle4.y < rectangle2.y) {
                                        rectangle2 = rectangle4;
                                    }
                                    if (rectangle4.y + rectangle4.height > rectangle3.y + rectangle3.height) {
                                        rectangle3 = rectangle4;
                                    }
                                } else {
                                    if (rectangle4.x + rectangle4.width > rectangle2.x + rectangle2.width) {
                                        rectangle2 = rectangle4;
                                    }
                                    if (rectangle4.x < rectangle3.x) {
                                        rectangle3 = rectangle4;
                                    }
                                }
                            }
                            ++n17;
                        }
                        n17 = 0;
                        int n18 = 0;
                        int n19 = 0;
                        int n20 = 0;
                        if (this.gridAlignment == 1) {
                            n17 = rectangle2.x + rectangle2.width / 2 - dimension.width / 2;
                            n18 = rectangle2.y - 2;
                            if (n4 % 180 != 0) {
                                n18 -= dimension.height;
                            }
                            n19 = rectangle3.x + rectangle3.width / 2 - dimension3.width / 2;
                            n20 = rectangle3.y + rectangle3.height + n3 - n2;
                            if (n4 % 180 != 0) {
                                n20 = rectangle3.y + rectangle3.height + 2;
                            }
                        } else {
                            n17 = rectangle2.x + rectangle2.width + 2;
                            n18 = rectangle2.y + rectangle2.height / 2 + n3 / 2 - n2 + 1;
                            if (n4 % 180 != 0) {
                                n18 = rectangle2.y + rectangle2.height / 2 - dimension.height / 2;
                            }
                            n19 = rectangle3.x - dimension3.width - 1;
                            n20 = n18;
                            if (n4 % 180 != 0) {
                                n20 = rectangle3.y + rectangle3.height / 2 - dimension3.height / 2;
                            }
                        }
                        if (bl) {
                            if (this.gridAlignment == 1) {
                                n17 += this.depth3dPoint.x;
                                n18 += this.depth3dPoint.y;
                            } else {
                                n17 += this.depth3dPoint.x;
                                n18 += this.depth3dPoint.y;
                            }
                        }
                        if (this.gridAlignment == 1) {
                            if (n4 % 180 == 0) {
                                n18 = Math.max(n18, rectangle.y - 2);
                                n18 = Math.min(rectangle.y + rectangle.height - 2, n18);
                                n20 = Math.max(rectangle.y + n - (bl ? this.depth3dPoint.y : 0), n20);
                                n20 = Math.min(rectangle.y + rectangle.height + n - (bl ? this.depth3dPoint.y : 0), n20);
                            } else {
                                n18 = Math.max(n18, rectangle.y - dimension.height - 2);
                                n18 = Math.min(n18, rectangle.y + rectangle.height - dimension.height - 2);
                                n20 = Math.min(n20, rectangle.y + rectangle.height + 2 - (bl ? this.depth3dPoint.y : 0));
                                n20 = Math.max(n20, rectangle.y + 2 - (bl ? this.depth3dPoint.y : 0));
                            }
                        } else {
                            n17 = Math.min(rectangle.x + rectangle.width + 2, n17);
                            n17 = Math.max(rectangle.x + 2, n17);
                            n19 = Math.max(rectangle.x - dimension3.width - 1 - (bl ? this.depth3dPoint.x : 0), n19);
                            n19 = Math.min(rectangle.x + rectangle.width - dimension3.width - 1 - (bl ? this.depth3dPoint.x : 0), n19);
                        }
                        if (this.gridAlignment == 1) {
                            n16 = rectangle2.x + rectangle2.width / 2;
                            bl4 = n16 >= n6 && n16 <= n5;
                            n16 = rectangle3.x + rectangle3.width / 2;
                            bl3 = n16 >= n6 && n16 <= n5;
                        } else {
                            n16 = rectangle2.y + rectangle2.height / 2;
                            bl4 = n16 >= n8 && n16 <= n7;
                            n16 = rectangle3.y + rectangle3.height / 2;
                            bl3 = n16 >= n8 && n16 <= n7;
                        }
                        graphics.setColor(this.getForeground());
                        if (d >= 0.0 && this.upperRange[0] > 0.0 && bl4 && (d != 0.0 || !(d2 < 0.0))) {
                            this.paintLabel(graphics, string3, n17, n18, (Dimension)serializable, 0, n4);
                        }
                        if (d2 < 0.0 && this.lowerRange[0] < 0.0 && bl3) {
                            this.paintLabel(graphics, string4, n19, n20, dimension2, 0, n4);
                        }
                    }
                    ++n14;
                }
                break block84;
            }
            if (this.valueLabelStyle != 1 && this.valueLabelStyle != 0) break block84;
            int n21 = Math.max(this.visibleSamples[0] - 1, 0);
            int n22 = Math.min(n21 + this.visibleSamples[1] + 1, n10);
            int n23 = n21;
            while (n23 < n22) {
                int n24 = 0;
                while (n24 < n9) {
                    ChartSample chartSample = this.getSample(n24, n23);
                    if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN() && this.isValueLabelsOn(n24)) {
                        String string;
                        String string5 = this.getLabel("valueLabelPrefix_" + n24);
                        if (string5 == null) {
                            string5 = this.getLabel("valueLabelPrefix");
                        }
                        if ((string = this.getLabel("valueLabelPostfix_" + n24)) == null) {
                            string = this.getLabel("valueLabelPostfix");
                        }
                        double d = chartSample.getFloatValue();
                        int n25 = this.getSampleDecimalCount(n24);
                        String string6 = this.formatNumber(d, n25);
                        string6 = string5 != null ? string5 + string6 : string6;
                        string6 = string != null ? string6 + string : string6;
                        Dimension dimension = this.getLabelSize(string6, fontMetrics);
                        Dimension dimension4 = this.getAngledLabelSize(dimension, n4);
                        Rectangle rectangle5 = null;
                        if (this.barBounds != null && n24 < this.barBounds.length && this.barBounds[n24] != null && n23 < this.barBounds[n24].length) {
                            rectangle5 = this.barBounds[n24][n23];
                        }
                        int n26 = 0;
                        int n27 = 0;
                        boolean bl5 = true;
                        if (rectangle5 != null && this.valueLabelStyle == 1) {
                            if (this.gridAlignment == 1) {
                                n26 = rectangle5.x + rectangle5.width / 2 - dimension4.width / 2;
                                if (d >= 0.0) {
                                    if (n4 % 180 == 0) {
                                        n27 = rectangle5.y - 2;
                                        n27 = Math.max(n8 - 2, n27);
                                        n27 = Math.min(n7 - 1, n27);
                                    } else {
                                        n27 = rectangle5.y - 2 - dimension4.height;
                                        n27 = Math.max(n27, n8 - dimension4.height - 2);
                                        n27 = Math.min(n27, n7 - dimension4.height - 2);
                                    }
                                    if (n4 % 180 > 0 && n4 % 180 < 90) {
                                        n26 = rectangle5.x + rectangle5.width - dimension4.width + 1;
                                    } else if (n4 % 180 > 90) {
                                        n26 = rectangle5.x - 1;
                                    }
                                    if (bl && n9 == 1) {
                                        n27 += this.depth3dPoint.y;
                                        n26 += this.depth3dPoint.x;
                                        n27 = n4 % 180 == 0 ? Math.max(n8 - 2, n27) : Math.max(n8 - dimension4.height - 2, n27);
                                    }
                                } else {
                                    if (n4 % 180 == 0) {
                                        n27 = rectangle5.y + rectangle5.height + n;
                                        n27 = Math.min(n7 + n, n27);
                                        n27 = bl ? Math.max(n8 - this.depth3dPoint.y + n, n27) : Math.max(n8 + n, n27);
                                    } else {
                                        n27 = rectangle5.y + rectangle5.height + 3;
                                        n27 = Math.min(n7 + 3, n27);
                                        n27 = bl ? Math.max(n8 - this.depth3dPoint.y + 2, n27) : Math.max(n8 + 2, n27);
                                    }
                                    if (n4 % 180 > 0 && n4 % 180 < 90) {
                                        n26 = rectangle5.x - 1;
                                    } else if (n4 % 180 > 90) {
                                        n26 = rectangle5.x + rectangle5.width - dimension4.width + 1;
                                    }
                                }
                            } else {
                                if (d >= 0.0) {
                                    n26 = rectangle5.x + rectangle5.width + 3;
                                    n26 = Math.min(rectangle.x + rectangle.width + 3, n26);
                                    n26 = Math.max(n6 + 3, n26);
                                } else {
                                    n26 = rectangle5.x - dimension4.width - 3;
                                    n26 = Math.max(n6 - dimension4.width - 3, n26);
                                    n26 = Math.min(n6 + rectangle.width - dimension4.width - 3, n26);
                                }
                                n27 = rectangle5.y + rectangle5.height / 2 + n3 / 2 - n2 + 1;
                                if (n4 % 180 != 0) {
                                    n27 = rectangle5.y + rectangle5.height / 2 - dimension4.height / 2;
                                }
                                if (bl && n9 == 1 && d >= 0.0) {
                                    n27 += this.depth3dPoint.y;
                                    n26 += this.depth3dPoint.x;
                                    n26 = Math.min(rectangle.x + rectangle.width + 3, n26);
                                }
                            }
                        } else if (rectangle5 != null) {
                            if (this.gridAlignment == 1) {
                                n26 = rectangle5.x + rectangle5.width / 2 - dimension4.width / 2 + 1;
                                if (d >= 0.0) {
                                    if (n4 % 180 == 0) {
                                        n27 = rectangle5.y + fontMetrics.getAscent();
                                        n27 = Math.max(n27, rectangle.y + dimension4.height - 1);
                                        n27 = Math.min(n27, rectangle.y + rectangle.height - 2);
                                    } else {
                                        n27 = rectangle5.y + 3;
                                        n27 = Math.min(n27, rectangle5.y + rectangle5.height - dimension4.height - 2);
                                        n27 = Math.max(n27, rectangle.y + 3);
                                    }
                                } else if (n4 % 180 == 0) {
                                    n27 = rectangle5.y + rectangle5.height - 2;
                                    n27 = Math.min(n27, rectangle.y + rectangle.height - 2 - (bl ? this.depth3dPoint.y : 0));
                                    n27 = Math.max(n27, rectangle.y + dimension4.height - 1);
                                } else {
                                    n27 = rectangle5.y + rectangle5.height - dimension4.height - 2;
                                    n27 = Math.min(n27, rectangle.y + rectangle.height - dimension4.height - 2 - (bl ? this.depth3dPoint.y : 0));
                                    n27 = Math.max(n27, rectangle.y + 3 - (bl ? this.depth3dPoint.y : 0));
                                }
                                if (this.barType == 1 && n9 > 1) {
                                    bl5 = dimension4.height < rectangle5.height;
                                }
                            } else {
                                if (d >= 0.0) {
                                    n26 = rectangle5.x + rectangle5.width - dimension4.width - 1;
                                    n26 = Math.max(n26, rectangle5.x + 2);
                                    n26 = Math.min(n26, rectangle.x + rectangle.width - dimension4.width - 1);
                                } else {
                                    n26 = rectangle5.x + 2;
                                    n26 = Math.max(n26, rectangle.x + 2 - (bl ? this.depth3dPoint.x : 0));
                                    n26 = Math.min(n26, rectangle.x + rectangle.width - dimension4.width - 1 - (bl ? this.depth3dPoint.x : 0));
                                }
                                n27 = rectangle5.y + rectangle5.height / 2 + n3 / 2 - n2 + 1;
                                if (n4 % 180 != 0) {
                                    n27 = rectangle5.y + rectangle5.height / 2 - dimension4.height / 2;
                                }
                                if (this.barType == 1 && n9 > 1) {
                                    bl5 = dimension4.width < rectangle5.width;
                                }
                            }
                        }
                        Color color = null;
                        if (this.valueLabelStyle == 1) {
                            graphics.setColor(this.getForeground());
                            color = this.getChartBackground();
                        } else {
                            Color color2 = this.getSampleColor(0);
                            if (this.multiColorOn) {
                                color2 = n9 > 1 || this.barType == 1 || this.multiSeriesOn ? this.getSampleColor(n24) : this.getSampleColor(n23);
                            }
                            if ((color2.getRed() + color2.getGreen() + color2.getBlue()) / 3 > 110) {
                                graphics.setColor(Color.black);
                            } else {
                                graphics.setColor(Color.white);
                            }
                            color = color2;
                        }
                        if (this.gridAlignment == 1 && rectangle5 != null) {
                            int n28 = rectangle5.x + rectangle5.width / 2;
                            bl5 &= n28 >= n6 && n28 <= n5;
                        } else if (rectangle5 != null) {
                            int n29 = rectangle5.y + rectangle5.height / 2;
                            bl5 &= n29 >= n8 && n29 <= n7;
                        }
                        if (bl5) {
                            this.paintLabel(graphics, string6, n26, n27, dimension, 0, n4);
                        }
                    }
                    ++n24;
                }
                ++n23;
            }
        }
    }

    public void setBarWidth(double d) {
        if (d != this.barWidthFraction) {
            d = Math.max(0.0, d);
            this.barWidthFraction = d = Math.min(1.0, d);
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public double getBarWidth() {
        return this.barWidthFraction;
    }

    public void setBarLabelStyle(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                if (n == this.barLabelStyle) break;
                this.barLabelStyle = n;
                this.needRender = true;
                this.needGraphBounds = true;
                this.needChartCalculation = true;
                this.autoRepaint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid barLabelStyle: " + n);
            }
        }
    }

    public int getBarLabelStyle() {
        return this.barLabelStyle;
    }

    public void render(Graphics graphics) {
        this.render(graphics, !this.isServletModeOn());
    }

    void render(Graphics graphics, boolean bl) {
        Rectangle rectangle;
        Serializable serializable;
        Rectangle rectangle2 = this.getGraphBounds();
        Rectangle rectangle3 = this.getDataBounds(rectangle2);
        this.calculateChartData(rectangle2, rectangle3);
        int n = 0;
        while (n < this.overlayCharts.size()) {
            Chart chart = (Chart)this.overlayCharts.elementAt(n);
            if (chart != null && this.isOverlayChartOn(n)) {
                serializable = new Rectangle(rectangle2);
                rectangle = new Rectangle(rectangle3);
                if (this.is3DModeOn()) {
                    ((Rectangle)serializable).x -= this.depth3dPoint.x;
                    ((Rectangle)serializable).y -= this.depth3dPoint.y;
                    rectangle.x -= this.depth3dPoint.x;
                    rectangle.y -= this.depth3dPoint.y;
                }
                if (chart instanceof LineChart) {
                    chart.calculateChartData((Rectangle)serializable, this.getLineChartBounds(rectangle));
                } else {
                    chart.calculateChartData((Rectangle)serializable, rectangle);
                }
            }
            ++n;
        }
        Dimension dimension = this.getSize();
        if (bl && this.offscreen == null) {
            this.offscreen = this.createImage(Math.max(1, dimension.width), Math.max(1, dimension.height));
            this.needRender = true;
        }
        if (!bl || this.needRender || this.offscreen == null) {
            if (!this.externalGraphicsOn && !bl) {
                this.og = graphics;
            } else if (bl || this.externalGraphicsOn) {
                if (!this.externalGraphicsOn && this.offscreen != null) {
                    this.og = this.offscreen.getGraphics();
                }
                this.og.setColor(this.getBackground());
                this.og.fillRect(0, 0, dimension.width, dimension.height);
            }
            this.paintTitle(this.og, dimension);
            if (this.isLegendOn()) {
                this.paintLegend(this.og, rectangle2, this.getLegendLabels());
            }
            this.paintGrid(this.og, rectangle2);
            this.paintBarLabels(this.og, rectangle2);
            if (this.upperRange != this.lowerRange) {
                this.renderData(this.og, rectangle2, rectangle3);
                int n2 = 0;
                while (n2 < this.overlayCharts.size()) {
                    serializable = (Chart)this.overlayCharts.elementAt(n2);
                    if (serializable != null && this.isOverlayChartOn(n2)) {
                        rectangle = new Rectangle(rectangle2);
                        Rectangle rectangle4 = new Rectangle(rectangle3);
                        rectangle.x -= this.depth3dPoint.x;
                        rectangle.y -= this.depth3dPoint.y;
                        rectangle4.x -= this.depth3dPoint.x;
                        rectangle4.y -= this.depth3dPoint.y;
                        if (serializable instanceof LineChart) {
                            ((Chart)serializable).renderData(this.og, rectangle, this.getLineChartBounds(rectangle4));
                        } else if (serializable instanceof PieChart) {
                            ((Chart)serializable).renderData(this.og, rectangle, rectangle4);
                        } else {
                            ((Chart)serializable).renderData(this.og, rectangle2, rectangle3);
                        }
                    }
                    ++n2;
                }
            }
            if (!this.externalGraphicsOn && this.og != graphics) {
                this.og.dispose();
            }
            this.needRender = false;
        }
        if ((bl || this.externalGraphicsOn) && this.offscreen != null) {
            graphics.drawImage(this.offscreen, 0, 0, this);
        }
        this.paintFloatingLabels(graphics, rectangle2);
    }

    private void paint3DBar(Graphics graphics, Rectangle rectangle, boolean bl, double d) {
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x, rectangle.y);
        polygon.addPoint(polygon.xpoints[0] + this.depth3dPoint.x, polygon.ypoints[0] + this.depth3dPoint.y);
        polygon.addPoint(polygon.xpoints[1] + rectangle.width, polygon.ypoints[1]);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(rectangle.x + rectangle.width, rectangle.y);
        polygon2.addPoint(polygon.xpoints[2], polygon.ypoints[2]);
        polygon2.addPoint(polygon.xpoints[2], polygon.ypoints[2] + rectangle.height);
        polygon2.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.setColor(graphics.getColor().darker());
        graphics.fillPolygon(polygon);
        graphics.setColor(graphics.getColor().darker());
        graphics.fillPolygon(polygon2);
        if (this.barOutlineOn) {
            if (this.barOutlineColor != null) {
                graphics.setColor(this.barOutlineColor);
            } else {
                graphics.setColor(this.getChartForeground());
            }
            graphics.drawPolygon(polygon);
            graphics.drawPolygon(polygon2);
            if (bl) {
                graphics.drawLine(polygon2.xpoints[1] - 1, polygon2.ypoints[1] + 1, polygon2.xpoints[2] - 1, polygon2.ypoints[2]);
                graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1] + 1, polygon.xpoints[2] - 1, polygon.ypoints[2] + 1);
                if (this.gridAlignment == 1) {
                    graphics.drawLine(polygon2.xpoints[2] - 1, polygon2.ypoints[2], polygon2.xpoints[3] - 1, polygon2.ypoints[3]);
                    graphics.drawLine(polygon.xpoints[0] + 1, polygon.ypoints[0], polygon.xpoints[1] + 1, polygon.ypoints[1]);
                    if (rectangle.height != 0) {
                        graphics.drawLine(polygon2.xpoints[0], polygon2.ypoints[0] + 1, polygon2.xpoints[1], polygon2.ypoints[1] + 1);
                    } else {
                        graphics.drawLine(polygon.xpoints[3] - 1, polygon.ypoints[3] - 1, polygon.xpoints[0] + 1, polygon.ypoints[0] - 1);
                    }
                } else {
                    graphics.drawLine(polygon2.xpoints[2], polygon2.ypoints[2] - 1, polygon2.xpoints[3], polygon2.ypoints[3] - 1);
                    graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0] + 1, polygon.xpoints[1], polygon.ypoints[1] + 1);
                    if (rectangle.width != 0) {
                        graphics.drawLine(polygon.xpoints[2] - 1, polygon.ypoints[2], polygon.xpoints[3] - 1, polygon.ypoints[3]);
                    } else {
                        graphics.drawLine(polygon2.xpoints[3] + 1, polygon2.ypoints[3] - 1, polygon2.xpoints[0] + 1, polygon2.ypoints[0] + 1);
                    }
                }
            }
        } else if (bl) {
            if (this.barOutlineColor != null) {
                graphics.setColor(this.barOutlineColor);
            } else {
                graphics.setColor(this.getChartForeground());
            }
            graphics.drawPolygon(polygon);
            graphics.drawLine(polygon2.xpoints[1], polygon2.ypoints[1], polygon2.xpoints[2], polygon2.ypoints[2]);
            if (this.gridAlignment == 1) {
                graphics.drawLine(polygon2.xpoints[2], polygon2.ypoints[2], polygon2.xpoints[3], polygon2.ypoints[3]);
            } else {
                graphics.drawLine(polygon2.xpoints[2], polygon2.ypoints[2] - 1, polygon2.xpoints[3], polygon2.ypoints[3] - 1);
                graphics.drawLine(polygon2.xpoints[3] - 1, polygon2.ypoints[3] - 1, polygon2.xpoints[0] - 1, polygon2.ypoints[0]);
            }
        }
    }

    public int getValuePosition(double d) {
        return this.getValuePosition(0, d, this.getGraphBounds());
    }

    public void setBarOutlineOn(boolean bl) {
        if (this.barOutlineOn != bl) {
            this.barOutlineOn = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isMultiSeriesOn() {
        return this.multiSeriesOn;
    }

    private void paint3DZeroDivider(Graphics graphics, Rectangle rectangle, int n) {
        if (!this.rangeOn[n = Math.min(this.rangeOn.length - 1, Math.max(0, n))]) {
            return;
        }
        graphics.setColor(n == 0 ? this.getChartForeground() : this.getRangeColor(n));
        if (this.gridAlignment == 1) {
            int n2 = Math.max(this.zeroLine[n], rectangle.y);
            n2 = Math.min(n2, rectangle.y + rectangle.height);
            int n3 = rectangle.x - this.depth3dPoint.x;
            int n4 = n2 - this.depth3dPoint.y;
            graphics.drawLine(n3, n4, n3 + rectangle.width, n4);
            graphics.drawLine(n3 + rectangle.width, n4, rectangle.x + rectangle.width, n2);
        } else {
            int n5 = Math.max(this.zeroLine[n], rectangle.x);
            n5 = Math.min(n5, rectangle.x + rectangle.width);
            int n6 = rectangle.y - this.depth3dPoint.y;
            int n7 = n5 - this.depth3dPoint.x;
            graphics.drawLine(n7, n6, n7, n6 + rectangle.height);
            graphics.drawLine(n7, n6, n5, rectangle.y);
        }
    }

    private Rectangle getLineChartBounds(Rectangle rectangle) {
        int n;
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n2 = n = this.barType == 1 ? 1 : this.getSeriesCount();
        if (this.barBounds != null && this.barBounds.length > 0 && this.barBounds[0] != null && this.barBounds[0].length > 0) {
            int n3 = this.barBounds[0][0].x + this.barBounds[0][0].width * n / 2 - rectangle.x;
            rectangle2.x += n3;
            rectangle2.width -= n3 * 2;
        }
        return rectangle2;
    }

    public Rectangle getGraphBounds() {
        Insets insets;
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        int n2;
        if (!this.needGraphBounds && this.currentBounds != null) {
            return this.currentBounds;
        }
        Rectangle rectangle = super.getGraphBounds(this.getLegendLabels());
        Dimension dimension = this.getSize();
        int n3 = rectangle.x;
        int n4 = dimension.width - rectangle.width - rectangle.x;
        int n5 = rectangle.y;
        int n6 = dimension.height - rectangle.height - rectangle.y;
        int n7 = 0;
        while (n7 < this.rangeAdjusterOn.length) {
            if (this.rangeAdjusterOn[n7]) {
                if (this.gridAlignment == 1) {
                    if (this.rangeAdjusterPosition[n7] == 0) {
                        n3 += 6;
                    } else {
                        n4 += 6;
                    }
                } else if (this.rangeAdjusterPosition[n7] == 0) {
                    n6 += 6;
                } else {
                    n5 += 6;
                }
            }
            ++n7;
        }
        if (this.sampleLabelsOn && (this.barLabelStyle == 2 || this.barLabelStyle == 4)) {
            int n8;
            Font font = this.getFont("barLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            n2 = this.getLabelAngle("barLabelAngle");
            if (this.gridAlignment == 1) {
                n = 0;
                object4 = this.getBarLabels();
                n8 = 0;
                while (n8 < ((String[])object4).length) {
                    object3 = this.getLabelSize((String)object4[n8], fontMetrics);
                    object2 = this.getAngledLabelSize((Dimension)object3, n2);
                    n = Math.max(((Dimension)object2).height, n);
                    ++n8;
                }
                n6 += n;
                if (n2 % 180 == 0) {
                    n6 -= fontMetrics.getMaxDescent();
                }
            } else {
                n = 0;
                object4 = this.getBarLabels();
                n8 = 0;
                while (n8 < ((String[])object4).length) {
                    object3 = this.getLabelSize((String)object4[n8], fontMetrics);
                    object2 = this.getAngledLabelSize((Dimension)object3, n2);
                    n = Math.max(n, ((Dimension)object2).width);
                    ++n8;
                }
                n3 += n;
            }
        }
        boolean bl = false;
        int n9 = 0;
        while (n9 < this.rangeOn.length) {
            bl = this.rangeOn[n9] ? true : bl;
            ++n9;
        }
        if (bl || this.targetsLabel.size() > 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont("rangeLabelFont"));
            if (this.gridAlignment == 1) {
                n2 = 0;
                n = 0;
                object4 = this.targetsLabel.keys();
                while (object4.hasMoreElements()) {
                    String string2 = (String)object4.nextElement();
                    object3 = this.getTargetLabel(string2);
                    if (object3 == null || ((String)object3).length() <= 0) continue;
                    if (this.rangePosition[0] == 0) {
                        n2 = Math.max(n2, fontMetrics.stringWidth((String)object3));
                        continue;
                    }
                    n = Math.max(n, fontMetrics.stringWidth((String)object3));
                }
                if (this.rangeLabelsOn[0] && this.rangeOn[0]) {
                    int n10 = this.getRangeDecimalCount(0);
                    String string3 = this.formatNumber(this.upperRange[0], n10);
                    object3 = this.formatNumber(this.lowerRange[0], n10);
                    object2 = this.getLabel("rangeLabelPrefix");
                    object = this.getLabel("rangeLabelPostfix");
                    string3 = object2 != null ? (String)object2 + string3 : string3;
                    object3 = object2 != null ? (String)object2 + (String)object3 : object3;
                    string3 = object != null ? string3 + (String)object : string3;
                    Object object5 = object3 = object != null ? (String)object3 + (String)object : object3;
                    if (this.rangePosition[0] == 0) {
                        n2 = Math.max(n2, fontMetrics.stringWidth(string3));
                        n2 = Math.max(n2, fontMetrics.stringWidth((String)object3));
                    } else {
                        n = Math.max(n, fontMetrics.stringWidth(string3));
                        n = Math.max(n, fontMetrics.stringWidth((String)object3));
                    }
                }
                if (this.rangeLabelsOn[1] && this.rangeOn[1]) {
                    int n11 = this.getRangeDecimalCount(1);
                    String string4 = this.formatNumber(this.upperRange[1], n11);
                    object3 = this.formatNumber(this.lowerRange[1], n11);
                    object2 = this.getLabel("rangeLabelPrefix_2");
                    object = this.getLabel("rangeLabelPostfix_2");
                    string4 = object2 != null ? (String)object2 + string4 : string4;
                    object3 = object2 != null ? (String)object2 + (String)object3 : object3;
                    string4 = object != null ? string4 + (String)object : string4;
                    Object object6 = object3 = object != null ? (String)object3 + (String)object : object3;
                    if (this.rangePosition[1] == 0) {
                        n2 = Math.max(n2, fontMetrics.stringWidth(string4));
                        n2 = Math.max(n2, fontMetrics.stringWidth((String)object3));
                    } else {
                        n = Math.max(n, fontMetrics.stringWidth(string4));
                        n = Math.max(n, fontMetrics.stringWidth((String)object3));
                    }
                }
                n3 += n2 + 2;
                n4 += n > 0 ? n + 2 : 0;
            } else {
                if (this.targetsValue.size() > 0) {
                    n5 += fontMetrics.getMaxAscent();
                }
                if (this.rangeLabelsOn[0] && this.rangeOn[0]) {
                    if (this.rangePosition[0] == 0) {
                        n6 += fontMetrics.getMaxAscent();
                        if (this.targetsLabel.size() > 0) {
                            n6 += fontMetrics.getHeight();
                        }
                    } else {
                        n5 += fontMetrics.getMaxAscent();
                        if (this.targetsLabel.size() > 0) {
                            n5 += fontMetrics.getHeight();
                        }
                    }
                    n2 = this.getRangeDecimalCount(0);
                    String string5 = this.formatNumber(this.upperRange[0], n2);
                    object4 = this.getLabel("rangeLabelPrefix");
                    String string6 = this.getLabel("rangeLabelPostfix");
                    string5 = object4 != null ? (String)object4 + string5 : string5;
                    string5 = string6 != null ? string5 + string6 : string5;
                    n4 = Math.max(n4, fontMetrics.stringWidth(string5) / 2 + 5);
                    object3 = this.formatNumber(this.lowerRange[0], n2);
                    object3 = object4 != null ? (String)object4 + (String)object3 : object3;
                    object3 = string6 != null ? (String)object3 + string6 : object3;
                    n3 = Math.max(n3, fontMetrics.stringWidth((String)object3) / 2 + 5);
                }
                if (this.rangeLabelsOn[1] && this.rangeOn[1]) {
                    if (this.rangePosition[1] == 0) {
                        n6 += fontMetrics.getMaxAscent();
                    } else {
                        n5 += fontMetrics.getMaxAscent();
                    }
                    n2 = this.getRangeDecimalCount(1);
                    String string7 = this.formatNumber(this.upperRange[1], n2);
                    object4 = this.getLabel("rangeLabelPrefix_2");
                    String string8 = this.getLabel("rangeLabelPostfix_2");
                    string7 = object4 != null ? (String)object4 + string7 : string7;
                    string7 = string8 != null ? string7 + string8 : string7;
                    n4 = Math.max(n4, fontMetrics.stringWidth(string7) / 2 + 5);
                    object3 = this.formatNumber(this.lowerRange[1], n2);
                    object3 = object4 != null ? (String)object4 + (String)object3 : object3;
                    object3 = string8 != null ? (String)object3 + string8 : object3;
                    n3 = Math.max(n3, fontMetrics.stringWidth((String)object3) / 2 + 5);
                }
            }
        }
        if (this.isValueLabelsOn(0) && this.valueLabelStyle == 1) {
            double d;
            Font font = this.getFont("valueLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n12 = this.getSampleDecimalCount(0);
            if (this.gridAlignment == 1) {
                double d2 = this.getHighestValue(0);
                int n13 = this.getLabelAngle("valueLabelAngle");
                object2 = this.formatNumber(d2, n12);
                object = this.getLabelSize((String)object2, fontMetrics);
                Dimension dimension2 = this.getAngledLabelSize((Dimension)object, n13);
                n5 += dimension2.height - 4;
                d = this.getLowestValue(0);
                if (d < 0.0) {
                    object2 = this.formatNumber(d, n12);
                    object = this.getLabelSize((String)object2, fontMetrics);
                    dimension2 = this.getAngledLabelSize((Dimension)object, n13);
                    n6 += dimension2.height - 2;
                    if (n13 % 180 == 0) {
                        n6 -= fontMetrics.getDescent();
                    }
                }
            } else {
                double d3 = this.getHighestValue(0);
                double d4 = 0.0;
                if (this.upperRange[0] - this.lowerRange[0] != 0.0) {
                    d4 = (d3 - this.lowerRange[0]) / (this.upperRange[0] - this.lowerRange[0]);
                }
                rectangle.x = n3;
                rectangle.width = dimension.width - n3 - n4;
                int n14 = (int)Math.round((double)rectangle.x + d4 * (double)rectangle.width);
                int n15 = fontMetrics.stringWidth(this.formatNumber(d3, n12));
                if ((n14 += n15) > rectangle.x + rectangle.width) {
                    n4 += Math.min(n14 - rectangle.width - rectangle.x, n15);
                }
                if ((d = this.getLowestValue(0)) < 0.0) {
                    d4 = 0.0;
                    if (this.upperRange[0] - this.lowerRange[0] != 0.0) {
                        d4 = (d - this.lowerRange[0]) / (this.upperRange[0] - this.lowerRange[0]);
                    }
                    n14 = (int)Math.round((double)rectangle.x + d4 * (double)rectangle.width);
                    n15 = fontMetrics.stringWidth(this.formatNumber(d, n12));
                    if ((n14 -= n15) < rectangle.x) {
                        n3 += Math.min(rectangle.x - n14, n15 - 6);
                    }
                }
            }
        }
        if ((string = this.getLabel("sampleAxisLabel")) != null) {
            int n16 = this.getLabelAngle("sampleAxisLabelAngle");
            n16 = this.gridAlignment == 0 ? n16 : 0;
            Font font = this.getFont("sampleAxisLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            Dimension dimension3 = this.getLabelSize(string, fontMetrics);
            Dimension dimension4 = this.getAngledLabelSize(dimension3, n16);
            if (this.gridAlignment == 1) {
                n6 += dimension4.height + 3;
            } else {
                n3 += dimension4.width + 5;
            }
        }
        int n17 = 0;
        do {
            String string9;
            String string10 = string9 = n17 == 0 ? this.getLabel("rangeAxisLabel") : this.getLabel("rangeAxisLabel_2");
            if (string9 == null || !this.rangeOn[n17]) continue;
            int n18 = n17 == 0 ? this.getLabelAngle("rangeAxisLabelAngle") : this.getLabelAngle("rangeAxisLabelAngle_2");
            n18 = this.gridAlignment == 1 ? n18 : 0;
            Font font = this.getFont("rangeAxisLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            object2 = this.getLabelSize(string9, fontMetrics);
            Dimension dimension5 = this.getAngledLabelSize((Dimension)object2, n18);
            if (this.gridAlignment == 1) {
                if (this.rangePosition[n17] == 0) {
                    n3 += dimension5.width + 20;
                    continue;
                }
                n4 += dimension5.width + 20;
                continue;
            }
            if (this.rangePosition[n17] == 0) {
                n6 += dimension5.height + 5 - (n18 % 360 == 0 ? fontMetrics.getDescent() : 0);
                continue;
            }
            n5 += dimension5.height + 5;
        } while (++n17 < 2);
        if (this.is3DModeOn()) {
            if (this.depth3d >= 0) {
                n6 += this.depth3d;
                n3 += this.depth3d;
            } else {
                n17 = Math.max(1, this.getSampleCount());
                if (this.barType == 0) {
                    n17 *= Math.max(1, this.getSeriesCount());
                }
                if (this.gridAlignment == 1) {
                    int n19 = 0;
                    if ((double)n17 + this.barWidthFraction * 1.25 > 0.0) {
                        n19 = (int)((double)rectangle.width * this.barWidthFraction * 1.25 / ((double)n17 + this.barWidthFraction * 1.25));
                    }
                    rectangle.width = dimension.width - (n3 += n19) - n4;
                    double d = 0.0;
                    if (n17 > 0) {
                        d = (double)(rectangle.width / n17) * this.barWidthFraction;
                    }
                    n6 += (int)Math.round(d / 1.25);
                } else {
                    int n20 = 0;
                    if ((double)(1.25f * (float)n17) + this.barWidthFraction * 0.75 > 0.0) {
                        n20 = (int)((double)rectangle.height * this.barWidthFraction * 0.75 / ((double)(1.25f * (float)n17) + this.barWidthFraction * 0.75));
                    }
                    rectangle.height = dimension.height - n5 - (n6 += n20);
                    double d = (double)(rectangle.height / n17) * this.barWidthFraction;
                    n3 += (int)Math.round(d * 1.25 * 0.75);
                }
            }
        }
        if ((insets = this.getGraphInsets()) != null) {
            n5 = insets.top == -1 ? n5 : insets.top;
            n3 = insets.left == -1 ? n3 : insets.left;
            n6 = insets.bottom == -1 ? n6 : insets.bottom;
            n4 = insets.right == -1 ? n4 : insets.right;
        }
        rectangle.x = n3;
        rectangle.width = dimension.width - n3 - n4 - 1;
        rectangle.y = n5;
        rectangle.height = dimension.height - n5 - n6 - 1;
        this.needGraphBounds = false;
        this.currentBounds = rectangle;
        return rectangle;
    }

    public void setBarOutlineColor(Color color) {
        if (color != this.barOutlineColor) {
            this.barOutlineColor = color;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    private void paintFloatingLabel(Graphics graphics, Rectangle rectangle, int n, int n2, String string, Font font, FontMetrics fontMetrics) {
        int n3;
        Cloneable cloneable;
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount() || fontMetrics == null) {
            return;
        }
        Rectangle rectangle2 = this.barBounds[n][n2];
        if (rectangle2 == null) {
            return;
        }
        if (this.gridAlignment == 1) {
            if (rectangle2.x + rectangle2.width < rectangle.x - this.depth3dPoint.x || rectangle2.x > rectangle.x + rectangle.width) {
                return;
            }
            if (rectangle2.y + rectangle2.height < rectangle.y || rectangle2.y > rectangle.y + rectangle.height - this.depth3dPoint.y) {
                return;
            }
        } else {
            if (rectangle2.y + rectangle2.height < rectangle.y || rectangle2.y > rectangle.y + rectangle.height - this.depth3dPoint.y) {
                return;
            }
            if (rectangle2.x + rectangle2.width < rectangle.x - this.depth3dPoint.x || rectangle2.x > rectangle.x + rectangle.width) {
                return;
            }
        }
        Dimension dimension = this.getLabelSize(string, fontMetrics);
        int n4 = this.mousePosition.x + 3;
        if (this.gridAlignment == 1) {
            n4 = rectangle2.x + rectangle2.width / 2 - dimension.width / 2 + 1;
        } else if (this.mousePosition.x < 0) {
            n4 = rectangle2.x + rectangle2.width / 2 - dimension.width / 2;
        }
        int n5 = this.mousePosition.y - dimension.height + fontMetrics.getAscent();
        if (this.gridAlignment == 0 || this.mousePosition.y < 0) {
            n5 = rectangle2.y + rectangle2.height / 2 - dimension.height / 2 + fontMetrics.getAscent();
        }
        if (this.barType == 1 && n5 - dimension.height / 2 < rectangle2.y) {
            n5 = rectangle2.y + dimension.height / 2 + 1;
        } else if (this.is3DModeOn() && this.depth3dPoint.y != 0 && this.gridAlignment == 1 && this.mousePosition.y < rectangle2.y && this.mousePosition.y >= 0) {
            n4 += -this.depth3dPoint.x * (rectangle2.y - this.mousePosition.y) / this.depth3dPoint.y;
            cloneable = null;
            if (n < this.getSeriesCount() - 1) {
                cloneable = this.barBounds[n + 1][n2];
            } else if (n2 < this.getSampleCount() - 1) {
                cloneable = this.barBounds[0][n2 + 1];
            }
            if (cloneable != null) {
                n3 = -this.depth3dPoint.x * (((Rectangle)cloneable).y - this.mousePosition.y) / this.depth3dPoint.y;
                if (n5 >= ((Rectangle)cloneable).y && n4 > ((Rectangle)cloneable).x - 10) {
                    n4 = ((Rectangle)cloneable).x - 10;
                } else if (n5 < ((Rectangle)cloneable).y && n4 > ((Rectangle)cloneable).x + n3 - 10) {
                    n4 = ((Rectangle)cloneable).x + n3 - 10;
                }
            }
        }
        cloneable = this.getSize();
        n4 = Math.max(n4, 3);
        n4 = Math.min(n4, cloneable.width - dimension.width - 3);
        n5 = Math.max(n5, fontMetrics.getAscent() + 1);
        n5 = Math.min(n5, cloneable.height - dimension.height + fontMetrics.getAscent() - 1);
        n3 = fontMetrics.getHeight();
        int n6 = fontMetrics.getDescent();
        graphics.setColor(new Color(255, 255, 231));
        graphics.fillRect(n4 - 2, n5 - n3 + n6 * 2 - 2, dimension.width + 5, dimension.height);
        graphics.setColor(this.getChartForeground());
        if (this.getSeriesCount() == 1 && this.multiColorOn) {
            graphics.setColor(this.getSampleColor(n2).darker());
        } else if (this.multiColorOn) {
            graphics.setColor(this.getSampleColor(n).darker());
        }
        graphics.drawRect(n4 - 3, n5 - n3 + n6 * 2 - 3, dimension.width + 5, dimension.height + 1);
        graphics.setColor(Color.black);
        this.paintLabel(graphics, string, n4, n5, dimension, 0, 0);
    }
}

