/*
 * Copyright (c) 1998-2004 Servertec. All Rights Reserved.
 *
 * This software is the proprietary and confidential property of Servertec.
 * Use only in accordance with the terms of the license agreement.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Enumeration;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.ServletConfig;
import javax.servlet.http.Cookie;

import stec.lang.DString;

import stec.iws.ServletConfigImpl;
import stec.iws.Utils;
import stec.iws.Request;
import stec.iws.Response;

public class DumpFormServlet extends BaseServlet
{
	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		PrintWriter writer = _response.getWriter();

		writer.println("<html>");
		writer.println("<head><title>Dump Form  Servlet</title></head>");
		writer.println("<body>");

		ArgsServlet.args(writer, _request, _response);

		dumpInitParams(writer, _request);
		HeadersServlet.server_variables(writer, _request);
		HeadersServlet.headers(writer, _request);
		dumpFormData(writer, _request);
		dumpCookies(writer, _request, _response);

		writer.println("</body>");
		writer.println("</html>");
	}

	protected void dumpInitParams(PrintWriter writer, Request _request) throws IOException
	{
		writer.println("<h1>Init Parameters:</h1>");

		String key;
		String values[];

		ServletConfigImpl config = (ServletConfigImpl)getServletConfig();

		Enumeration e = config.getInitParameterNames();

		while(e.hasMoreElements())
		{
			key = (String)e.nextElement();
			values = config.getInitParameterValues(key);
			for(int i = 0; i < values.length; i++)
			{
				writer.println(key + "(" + i + ") = " + values[i] + "<br>");
			}
		}
	}

	protected static void dumpFormData(PrintWriter writer, Request _request) throws IOException
	{
		writer.println("<h1>Form Data:</h1>");

		writer.println("method = " + _request.getMethod() + "<br>");
		writer.println("content length = " + _request.getContentLength() + "<br>");

		String key;
		String values[];

		Enumeration e = _request.getParameterNames();

		while(e.hasMoreElements())
		{
			key = (String)e.nextElement();
			values = _request.getParameterValues(key);
			for(int i = 0; i < values.length; i++)
			{
				writer.println(key + "(" + i + ") = " + values[i] + "<br>");
			}
		}
	}

	protected static void dumpCookies(PrintWriter writer, Request _request, Response _response) throws IOException
	{
		writer.println("<h1>Cookies:</h1>");

		String charset = _response.getCharacterEncoding();

		Cookie cookies[] = _request.getCookies();

		for(int i = 0; i < cookies.length; i++)
		{
			writer.println(Utils.decodeURL(cookies[i].getName(), charset) + " = " + Utils.decodeURL(cookies[i].getValue(), charset) + "<br>");
		}
	}
}
