/*
 * Copyright (c) 1999-2005 Servertec. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Servertec ("Confidential Information").  You shall not disclose
 * such Confidential Information and shall use it only in accordance
 * with the terms of the license agreement you entered into with
 * Servertec.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

#define CLASS "iwsCommand"
#define SSL_CLASS "iwsSSLCommand"

#include "parse_params.h"

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <process.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#define KB 1024
#define BUF_SIZE (((8 * KB) + 1) * sizeof(char))

#define JAVA "java"
#define SPACE " "
#define MSVM "jview"

void error(char *msg)
{
    	fprintf(stderr, "%s\n", msg);
    	exit(-1);
}

int main(int argc, char *argv[], char *envp[])
{
	char *java_exe;
	char *classpath;
	int rc;
	int count;

	int length;
	char *p;
	char *class;

#ifdef _WIN32
    char **args, **ap;
	char *param;

	int usingMSVM;
	int lMSVM;
	int i;
#else
	char buf[BUF_SIZE];
	char command[BUF_SIZE];
#endif

	if(argc != 4)
	{
		error("Syntax: " COMMAND "_iws {[http|https]://}<hostname>:<port> <id> <password>");
	}

	// setup java
	java_exe = (char *)getenv("JAVA_EXE");
    if(java_exe == NULL)
	{
		error("JAVA_EXE is not defined.");
	}

	count = count_args(java_exe);
	if(count == 0)
	{
		error("JAVA_EXE is empty.");
	}
	
#ifdef _WIN32
	param = extract_arg(java_exe, 0);

	strip_quotes(param);

	// which java vm, microsoft/javasoft
	usingMSVM = FALSE;
	p = param;
	lMSVM = strlen(MSVM);
	length = strlen(param) - lMSVM + 1;
	for(i = 0; i < length; i++)
	{
		if(strnicmp(p, MSVM, lMSVM) == 0)
		{
			usingMSVM = TRUE;
			break;
		}

		p++;
	}

	// add 4 for parameters: -classpath <classpath> <class> 0x00
    ap = args = (char **)malloc((argc + count + 4) * sizeof(char *));
    
	*ap++ = param;

	for(i = 1; i < count; i++)
	{
		param = extract_arg(java_exe, i);
		strip_quotes(param);
		
		*ap++ = param;
	}

	// setup args

	// setup classpath
	classpath = (char *)getenv("CLASSPATH");
    if (classpath == NULL)
		error("CLASSPATH is not defined.");

	if(!usingMSVM)
	{
	    *ap++ = strdup("-classpath");
	    *ap++ = strdup(classpath);
	}
#else
	// setup java executable
	strcpy(command, java_exe);

	// setup args
    strcat(command, SPACE);

	// setup classpath
	classpath = (char *)getenv("CLASSPATH");
    if (classpath == NULL)
		error("CLASSPATH is not defined.");

    sprintf(buf, "-classpath %s", classpath);
	strcat(command, buf);
#endif

	// process first argument
	p = strstr(*++argv, "://");
	if(p == NULL)
	{
		class = CLASS;
		p = *argv;
	}
	else
	{
#ifdef _WIN32
		if(strnicmp((const char *)*argv, "HTTP:", 5) == 0)
#else
		if(strncasecmp((const char *)*argv, "HTTP:", 5) == 0)
#endif /* _WIN32 */
		{
			class = CLASS;
		}
		else
		{
			class = SSL_CLASS;
		}

		p+=3;
	}

	--argc;
	
#ifdef _WIN32
	// setup CLASS executable
    *ap++ = strdup(class);

	// setup CLASS command
    *ap++ = strdup(COMMAND);

	*ap++ = strdup(p);

	// setup user arguments
    while(--argc > 0)
	{
		*ap++ = strdup(*++argv);
	}

    *ap = NULL;
#else
	// setup CLASS executable
    strcat(command, SPACE);
	strcat(command, class);

	// setup CLASS command
    strcat(command, SPACE);
	strcat(command, COMMAND);

	strcat(command, SPACE);
	strcat(command, p);

	// setup user arguments
    while (--argc > 0)
	{
	   	strcat(command, SPACE);
		strcat(command, *++argv);
	}
#endif

#ifdef _WIN32
	rc = spawnv(P_WAIT, args[0], args);
#else
	rc = system(command);
#endif

#ifdef __NEVER__ // we do not need to free
#ifdef _WIN32

	ap = args;

	while(*ap != NULL)
	{
		free(*ap);
		ap++;
	}

	free(args);
#endif
#endif

	return rc;
}
