/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.tomcat.util.compat.Action;
import org.apache.tomcat.util.compat.SimpleClassLoader;
import org.apache.tomcat.util.depend.DependClassLoader;

public class Jdk11Compat {
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    static String javaVersion;
    static boolean java2;
    static Jdk11Compat compat;
    static final String JAVA2_SUPPORT = "org.apache.tomcat.util.compat.Jdk12Support";
    private static final String URL_COMPAT_HANDLERS = "org.apache.tomcat.util.compat";
    private static final int dL = 10;

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static boolean isJava2() {
        return java2;
    }

    public ClassLoader newClassLoaderInstance(URL[] urls, ClassLoader parent) {
        return new SimpleClassLoader(urls, parent);
    }

    public Object getAccessControlContext() throws Exception {
        return null;
    }

    public Object doPrivileged(Action action, Object acc) throws Exception {
        return action.run();
    }

    public void setContextClassLoader(ClassLoader cl) {
    }

    public void refreshPolicy() {
    }

    public ClassLoader getContextClassLoader() {
        return null;
    }

    public ClassLoader getParentLoader(ClassLoader cl) {
        if (cl instanceof DependClassLoader) {
            return ((DependClassLoader)cl).getParentLoader();
        }
        if (cl instanceof SimpleClassLoader) {
            return ((SimpleClassLoader)cl).getParentLoader();
        }
        return null;
    }

    public URL[] getURLs(ClassLoader cl, int depth) {
        int c = 0;
        while (true) {
            if (cl instanceof DependClassLoader && cl != null) {
                cl = ((DependClassLoader)cl).getParentLoader();
                continue;
            }
            if (depth == c) {
                return ((SimpleClassLoader)cl).getURLs();
            }
            if ((cl = ((SimpleClassLoader)cl).getParentLoader()) == null || depth < ++c) break;
        }
        return null;
    }

    public ResourceBundle getBundle(String name, Locale loc, ClassLoader cl) {
        return ResourceBundle.getBundle(name, loc);
    }

    public Object getX509Certificates(byte[] x509) throws Exception {
        return null;
    }

    public static Jdk11Compat getJdkCompat() {
        return compat;
    }

    private static void init() {
        try {
            javaVersion = JAVA_1_0;
            Class.forName("java.lang.Void");
            javaVersion = JAVA_1_1;
            Class.forName("java.lang.ThreadLocal");
            java2 = true;
            javaVersion = JAVA_1_2;
            Class.forName("java.lang.StrictMath");
            javaVersion = JAVA_1_3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (java2) {
            try {
                Class<?> c = Class.forName(JAVA2_SUPPORT);
                compat = (Jdk11Compat)c.newInstance();
            }
            catch (Exception ex) {
                compat = new Jdk11Compat();
            }
        } else {
            compat = new Jdk11Compat();
            try {
                URL ex = new URL("jar:file:/test.jar!/foo");
            }
            catch (MalformedURLException ex) {
                Jdk11Compat.d("Installing jar protocol handler ");
                String handlers = System.getProperty("java.protocol.handler.pkgs");
                if (handlers == null) {
                    handlers = URL_COMPAT_HANDLERS;
                } else if (handlers.indexOf(URL_COMPAT_HANDLERS) < 0) {
                    handlers = String.valueOf(String.valueOf(handlers)).concat(":org.apache.tomcat.util.compat");
                }
                ((Hashtable)System.getProperties()).put("java.protocol.handler.pkgs", handlers);
                try {
                    URL uRL = new URL("jar:file:/test.jar!/foo");
                }
                catch (MalformedURLException ex1) {
                    Jdk11Compat.d("Jar protocol failing ");
                    ex1.printStackTrace();
                }
            }
        }
    }

    private static void d(String s) {
        System.err.println("Jdk11Compat: ".concat(String.valueOf(String.valueOf(s))));
    }

    static {
        JAVA_1_0 = JAVA_1_0;
        JAVA_1_1 = JAVA_1_1;
        JAVA_1_2 = JAVA_1_2;
        JAVA_1_3 = JAVA_1_3;
        java2 = false;
        Jdk11Compat.init();
        JAVA2_SUPPORT = JAVA2_SUPPORT;
        URL_COMPAT_HANDLERS = URL_COMPAT_HANDLERS;
        dL = 10;
    }
}

