/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.DirectoryStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.ImagePanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.Panel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class DirectoryPanel
extends Panel
implements DirectoryStep {
    JTextField tfDir_;
    JButton btBrowse_;

    public DirectoryPanel() {
        this.setLayout(new BoxLayout(this, 0));
        JPanel pnMain = new JPanel();
        pnMain.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 5, 5, 5))));
        pnMain.setLayout(new BoxLayout(pnMain, 1));
        JPanel pnHaut = new JPanel();
        pnHaut.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea(Globals.i18n("UI_DirectoryMessage"));
        textArea.setEditable(false);
        textArea.setHighlighter(null);
        textArea.setBackground(pnMain.getBackground());
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setBorder(new EmptyBorder(new Insets(5, 0, 5, 0)));
        JLabel lbTitle = new JLabel(Globals.i18n("UI_Directory"));
        lbTitle.setFont(lbTitle.getFont().deriveFont(1, 20.0f));
        lbTitle.setOpaque(true);
        lbTitle.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 0, 5, 0))));
        lbTitle.setBackground(pnMain.getBackground().darker());
        lbTitle.setForeground(Color.white);
        pnHaut.add("North", lbTitle);
        pnHaut.add("South", textArea);
        JPanel pnBas = new JPanel();
        pnBas.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JPanel eastPanel = new JPanel();
        eastPanel.setLayout(new BorderLayout());
        eastPanel.setBorder(new EmptyBorder(new Insets(5, 0, 5, 0)));
        centerPanel.setLayout(new BorderLayout());
        this.tfDir_ = new JTextField();
        centerPanel.add("North", this.tfDir_);
        this.btBrowse_ = new JButton(Globals.i18n("UI_Browse"));
        this.btBrowse_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryPanel.this.browse();
            }
        });
        eastPanel.add("East", this.btBrowse_);
        centerPanel.add("South", eastPanel);
        pnBas.add("North", centerPanel);
        pnMain.add(pnHaut);
        pnMain.add(pnBas);
        ImagePanel pnImage = ImagePanel.IMAGE_PANEL;
        this.add(pnImage);
        this.add(pnMain);
    }

    public void setDirectory(File f) {
        if (f != null) {
            this.tfDir_.setText(f.getAbsolutePath());
        }
    }

    public File getDirectory() {
        String dirstr = this.tfDir_.getText().trim();
        if (dirstr == null || "".equals(dirstr)) {
            JOptionPane.showMessageDialog(this, Globals.i18n("UI_MustChoose"), Globals.i18n("UI_Error"), 0);
            return null;
        }
        File dir = new File(dirstr);
        return dir;
    }

    public void roDirectory(File d) {
        JOptionPane.showMessageDialog(this, Globals.i18n("Setup_NoWritableDirectory") + d.getAbsolutePath() + "\n" + Globals.i18n("Setup_NoWritableDirectoryInfos"), Globals.i18n("UI_Error"), 0);
    }

    public void rejectDirectory() {
        JOptionPane.showMessageDialog(this, Globals.i18n("UI_NotChooseDirectory"), Globals.i18n("UI_Error"), 0);
    }

    public boolean acceptDirectory(File dest_path) {
        int res = JOptionPane.showConfirmDialog(this, Globals.i18n("UI_InstallationDirectory") + "\n" + dest_path.getAbsolutePath() + "\n" + Globals.i18n("UI_IsThatRight"), Globals.i18n("UI_Confirm"), 0, 3);
        return res == 0;
    }

    public boolean IsCreateDirectory(File dest_path) {
        int res = JOptionPane.showConfirmDialog(this, Globals.i18n("UI_InstallationDirectory") + "\n" + dest_path.getAbsolutePath() + "\n" + Globals.i18n("UI_IsCreateDirectory"), Globals.i18n("UI_Confirm"), 0, 3);
        if (res == 0) {
            if (!dest_path.mkdirs()) {
                this.chosseAnotherDirectory(dest_path);
            } else {
                return true;
            }
        }
        return false;
    }

    public void chosseAnotherDirectory(File dest_path) {
        JOptionPane.showMessageDialog(this, Globals.i18n("UI_InstallationDirectory") + "\n" + dest_path.getAbsolutePath() + "\n" + Globals.i18n("UI_UnableToCreate"), Globals.i18n("UI_Error"), 0);
    }

    private void browse() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int res = fc.showSaveDialog(this);
        File dir = null;
        if (res == 0 && (dir = fc.getSelectedFile()) != null) {
            if (dir.exists() && dir.isDirectory() && dir.canWrite()) {
                this.tfDir_.setText(dir.getAbsolutePath());
            } else {
                JOptionPane.showMessageDialog(this, dir.getName() + Globals.i18n("UI_NotValidDirectory"), Globals.i18n("UI_Error"), 0);
            }
        }
    }
}

