/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.AbstractInstall;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.EndStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.InstallStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.RegistryUtility;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.ShortcutsUtility;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.StepFactory;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.Vector;

public class Uninstall
extends AbstractInstall {
    private File uninstlog_;

    public Uninstall(String destPath) {
        Globals.OPERATION = 2;
        Globals.DEST_PATH = destPath;
        Globals.setLanguage("default");
        this.ui_ = StepFactory.createUI(this);
        Globals.printDebug("UI created");
        this.uninstlog_ = new File(destPath + File.separator + "uninstall.daf");
        if (!this.uninstlog_.exists() || !this.uninstlog_.canRead()) {
            this.exitOnError(new IOException(this.uninstlog_.getName() + " " + Globals.i18n("Uninstall_NotBeRead")));
        }
        this.nextStep();
        this.ui_.activateUI();
    }

    public void nextStep() {
        switch (this.state_) {
            case 1: {
                this.state_ = 2;
                this.setActionEnabled(5);
                this.step_ = this.ui_.createWelcomeStep();
                break;
            }
            case 2: {
                this.state_ = 10;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createInstallStep();
                break;
            }
            case 10: {
                this.setActionEnabled(0);
                this.startUninstall();
                this.setActionEnabled(4);
                this.state_ = 12;
                this.setActionEnabled(8);
                this.step_ = this.ui_.createEndStep();
                ((EndStep)this.step_).setStats(this.stats_);
                break;
            }
            case 12: {
                this.ui_.quitUI();
                this.quit();
            }
        }
    }

    public void previousStep() {
        switch (this.state_) {
            case 10: {
                Globals.printDebug("WELCOME");
                this.state_ = 2;
                this.setActionEnabled(5);
                this.step_ = this.ui_.createWelcomeStep();
                break;
            }
            default: {
                Globals.printDebug("can't go back...");
            }
        }
    }

    private void startUninstall() {
        InstallStep step = (InstallStep)this.step_;
        try {
            step.setProgression(0);
            step.status(Globals.i18n("Uninstall_DeletingFiles"));
            Vector directories = this.deleteFiles(this.uninstlog_);
            step.setProgression(50);
            step.status(Globals.i18n("Uninstall_DeletingUninstallDirectory"));
            this.deleteDirRecursive(new File(Globals.DEST_PATH));
            step.setProgression(60);
            step.status(Globals.i18n("Uninstall_DeletingDirectories"));
            this.deleteDirectories(directories);
            step.setProgression(100);
            ShortcutsUtility.deleteShortcuts(Globals.IS_UNIX, Globals.IS_WIN, this.ui_);
            if (Globals.IS_WIN) {
                RegistryUtility.deleteDaffodilEntry();
                step.status(Globals.i18n("Uninstall_UpdatingWindowsRegistry"));
                this.updateWindowsRegistry();
                this.ui_.uiSleep(2000L);
                step.status(Globals.i18n("Uninstall_WindowsRegistryUpdated"));
                this.ui_.uiSleep(1000L);
                new File("ICE_JNIRegistry.dll").delete();
            }
            step.status(Globals.i18n("Uninstall_UninstallationComplete"));
        }
        catch (IOException e) {
            this.exitOnError(e);
        }
    }

    public void redoStep() {
        System.err.println("REDO Step Not handled");
        Thread.dumpStack();
    }

    private Vector deleteFiles(File log) throws IOException {
        Vector<File> dirs = new Vector<File>();
        LineNumberReader logReader = new LineNumberReader(new FileReader(log));
        String line = logReader.readLine();
        while (line != null) {
            File del = new File(line);
            if (del.isDirectory()) {
                dirs.add(del);
            } else if (del.delete()) {
                this.stats_.addFile(del, true);
            } else {
                this.stats_.addFile(del, false);
                Globals.printDebug("F " + del + " not deleted");
            }
            line = logReader.readLine();
        }
        logReader.close();
        return dirs;
    }

    private void deleteDirectories(Vector directories) throws IOException {
        Object[] dirs = directories.toArray();
        Arrays.sort(dirs);
        int i = dirs.length - 1;
        while (i >= 0) {
            File del = (File)dirs[i];
            if (del.delete()) {
                this.stats_.addDirectory(del, true);
            } else {
                this.stats_.addDirectory(del, false);
                Globals.printDebug("D " + del + " not deleted");
            }
            --i;
        }
    }

    protected void updateWindowsRegistry() throws IOException {
        try {
            RegistryKey uninstallKey = Registry.HKEY_LOCAL_MACHINE.openSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", 2);
            uninstallKey.deleteSubKey(Globals.APP_NAME + " " + Globals.APP_VERSION);
            uninstallKey.closeKey();
        }
        catch (Exception e) {
            throw new IOException("" + e);
        }
    }
}

