/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import java.io.File;
import java.util.Vector;

public class Stats {
    public static final boolean SUCCESS = true;
    public static final boolean FAILURE = false;
    Vector dirs_ = new Vector();
    Vector files_ = new Vector();
    Vector exes_ = new Vector();
    int nbDirSucc_ = 0;
    int nbFileSucc_ = 0;

    public void addFile(File f, boolean success) {
        if (success) {
            if (f.isDirectory()) {
                ++this.nbDirSucc_;
            } else {
                ++this.nbFileSucc_;
            }
        } else if (f.isDirectory()) {
            this.dirs_.add(f);
        } else {
            this.files_.add(f);
        }
    }

    public void addDirectory(File f, boolean success) {
        if (success) {
            ++this.nbDirSucc_;
        } else {
            this.dirs_.add(f);
        }
    }

    public void addExecutable(File exe) {
        this.exes_.add(exe);
    }

    public File[] getSuccessfulDirs() {
        return new File[this.nbDirSucc_];
    }

    public File[] getSuccessfulFiles() {
        return new File[this.nbFileSucc_];
    }

    public File[] getExecutables() {
        File[] res = new File[this.exes_.size()];
        int i = 0;
        while (i < this.exes_.size()) {
            res[i] = (File)this.exes_.get(i);
            ++i;
        }
        return res;
    }

    public File[] getFailedDirs() {
        File[] res = new File[this.dirs_.size()];
        int i = 0;
        while (i < this.dirs_.size()) {
            res[i] = (File)this.dirs_.get(i);
            ++i;
        }
        return res;
    }

    public File[] getFailedFiles() {
        File[] res = new File[this.files_.size()];
        int i = 0;
        while (i < this.files_.size()) {
            res[i] = (File)this.files_.get(i);
            ++i;
        }
        return res;
    }

    public String getSuccessReport() {
        String res = "";
        switch (Globals.OPERATION) {
            case 1: 
            case 3: {
                res = res + Globals.i18n("Stats_CreatedDirectories") + " " + this.nbDirSucc_ + "\n";
                res = res + Globals.i18n("Stats_CreatedFiles") + " " + this.nbFileSucc_ + "\n";
                break;
            }
            case 2: {
                res = res + Globals.i18n("Stats_DeletedDirectories") + " " + this.nbDirSucc_ + "\n";
                res = res + Globals.i18n("Stats_DeletedFiles") + " " + this.nbFileSucc_ + "\n";
            }
        }
        return res;
    }

    public String getFailureReport() {
        int i;
        String res = "";
        if (this.dirs_.size() > 0) {
            switch (Globals.OPERATION) {
                case 1: 
                case 3: {
                    res = res + Globals.i18n("Stats_NotCreateDirectories") + "\n";
                    break;
                }
                case 2: {
                    res = res + Globals.i18n("Stats_NotRemoveDirectories") + "\n";
                }
            }
            i = 0;
            while (i < this.dirs_.size()) {
                res = res + "  " + ((File)this.dirs_.get(i)).getAbsolutePath() + "\n";
                ++i;
            }
        }
        if (this.files_.size() > 0) {
            switch (Globals.OPERATION) {
                case 1: 
                case 3: {
                    res = res + Globals.i18n("Stats_NotCreateFiles") + "\n";
                    break;
                }
                case 2: {
                    res = res + Globals.i18n("Stats_NotRemoveFiles") + "\n";
                }
            }
            i = 0;
            while (i < this.files_.size()) {
                res = res + "  " + ((File)this.files_.get(i)).getAbsolutePath() + "\n";
                ++i;
            }
        }
        return res;
    }

    public String getExecutablesReport() {
        String res = "";
        if (this.exes_.size() > 0 && (Globals.OPERATION == 1 || Globals.OPERATION == 3)) {
            res = res + Globals.i18n("Stats_Executables") + "\n";
            int i = 0;
            while (i < this.exes_.size()) {
                res = res + "  " + ((File)this.exes_.get(i)).getAbsolutePath() + "\n";
                ++i;
            }
        }
        return res;
    }
}

