/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.LinkDebian;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.LinkGnome;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.LinkKDE;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.StepFactory;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.WindowsShortcut;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryException;
import com.ice.jni.registry.RegistryKey;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ShortcutsUtility {
    public static void createShortcuts(Object[] launchparms, StepFactory ui_) {
        block4: {
            try {
                if (Globals.IS_UNIX) {
                    Globals.printDebug("KDE LINKS IN:");
                    Globals.printDebug("  " + System.getProperty("user.home") + File.separator + ".kde" + File.separator + "share" + File.separator + "applnk" + File.separator + "Daffodil");
                    Globals.printDebug("  " + System.getProperty("user.home") + File.separator + "Desktop");
                    LinkKDE.create();
                    Globals.printDebug("GNOME LINKS IN:");
                    Globals.printDebug("  " + System.getProperty("user.home") + File.separator + ".gnome" + File.separator + "apps" + File.separator + "Daffodil");
                    Globals.printDebug("  " + System.getProperty("user.home") + File.separator + ".gnome-desktop");
                    LinkGnome.createAll(launchparms);
                    Globals.printDebug("DEBIAN LINKS IN:");
                    Globals.printDebug("  " + System.getProperty("user.home") + File.separator + ".menu");
                    LinkDebian.create();
                    break block4;
                }
                if (Globals.IS_WIN) {
                    ShortcutsUtility.createWindowsShortcuts(launchparms);
                    break block4;
                }
                ui_.showError(new Exception(Globals.i18n("Setup_SorryFeatureNotImplemented")));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static final void createWindowsShortcuts(Object[] launchparms) throws IOException {
        if (launchparms == null) {
            return;
        }
        String desktopPath = Globals.DEST_PATH;
        String startMenuPath = Globals.DEST_PATH;
        try {
            RegistryKey dirKey = Registry.HKEY_CURRENT_USER.openSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
            desktopPath = dirKey.getStringValue("Desktop");
            startMenuPath = dirKey.getStringValue("Programs");
            byte[] b = dirKey.getValue("Programs").getByteData();
            startMenuPath = new String(b, "Cp1252");
            Globals.printDebug("\nStartMenu path in registry: '" + startMenuPath + "'");
            if (startMenuPath != null && startMenuPath.indexOf("D?marrer") > -1) {
                int deb = startMenuPath.indexOf("D?marrer");
                int last = deb + 8;
                startMenuPath = startMenuPath.substring(0, deb) + "D\u00e9marrer" + startMenuPath.substring(last);
            }
        }
        catch (Exception e) {
            Globals.printDebug("\nDesktop or Programs Folder not found :\n" + e.getMessage());
        }
        if (desktopPath == null || !new File(desktopPath).exists()) {
            desktopPath = Globals.DEST_PATH;
        }
        if (startMenuPath == null || !new File(startMenuPath).exists()) {
            startMenuPath = Globals.DEST_PATH;
        }
        Globals.printDebug("\nDesktop path : '" + desktopPath + "'");
        Globals.printDebug("\nStart menu path : '" + startMenuPath + "'");
        String linkpath = "";
        if (!"applications".equals("Daffodil".toLowerCase()) && !"utilities".equals("Daffodil".toLowerCase())) {
            linkpath = linkpath + "\\Daffodil";
        }
        if (launchparms.length > 1) {
            linkpath = linkpath + "\\" + Globals.APP_NAME + " " + Globals.APP_VERSION;
        }
        Globals.printDebug(" Link path ::: " + linkpath);
        int i = 0;
        while (i < launchparms.length) {
            String[] parmset = (String[])launchparms[i];
            String args = parmset[2] + parmset[3] + parmset[4] + parmset[5];
            String linkname = linkpath + "\\" + parmset[0] + ".lnk";
            String iconfile = ShortcutsUtility.getWindowsIconFile(parmset[0]);
            Globals.printDebug("full link path :: " + desktopPath + linkname);
            Globals.printDebug("full target path :: " + parmset[1]);
            if (!(!Globals.isServerSelected && (linkname.endsWith("StartServer") || linkname.endsWith("StopServer")) || !Globals.isEmbeddedSelected && (linkname.endsWith("BrowserEmbedded") || linkname.endsWith("ShellEmbedded")) || !Globals.isClientSelected && (linkname.endsWith("BrowserServer") || linkname.endsWith("ShellServer")))) {
                System.out.println("Scriptstr :: " + parmset[1]);
                System.out.println("Scriptstr :: " + args);
                new WindowsShortcut(startMenuPath + linkname, parmset[1], args.length() > 0 ? args : null, Globals.DEST_PATH, iconfile);
            }
            ++i;
        }
    }

    public static final String getWindowsIconFile(String name) {
        File defaultIcon = null;
        if ("icons/ShellPrompt" != null && "icons/ShellPrompt".length() > 0) {
            defaultIcon = new File(Globals.DEST_PATH, "icons/ShellPrompt".replace('/', File.separatorChar) + ".ico");
            Globals.printDebug("default icon= " + defaultIcon);
        }
        File tryIcon = defaultIcon != null ? new File(defaultIcon.getParentFile(), name + ".ico") : new File(Globals.DEST_PATH, name + ".ico");
        Globals.printDebug("try icon= " + tryIcon);
        if (tryIcon.exists()) {
            return tryIcon.getAbsolutePath();
        }
        if (defaultIcon.exists()) {
            return defaultIcon.getAbsolutePath();
        }
        return null;
    }

    public static void deleteShortcuts(boolean IS_UNIX, boolean IS_WIN, StepFactory ui_) {
        if (IS_WIN) {
            ShortcutsUtility.deleteWindowsShortCut();
        }
    }

    private static void deleteWindowsShortCut() {
        try {
            RegistryKey dirKey = Registry.HKEY_CURRENT_USER.openSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
            String desktopPath = dirKey.getStringValue("Desktop");
            String startMenuPath = dirKey.getStringValue("Programs");
            byte[] b = dirKey.getValue("Programs").getByteData();
            startMenuPath = new String(b, "Cp1252");
            if (desktopPath == null || !new File(desktopPath).exists()) {
                desktopPath = Globals.DEST_PATH;
            }
            if (startMenuPath == null || !new File(startMenuPath).exists()) {
                startMenuPath = Globals.DEST_PATH;
            }
            String linkpath = "";
            if (!"applications".equals("Daffodil".toLowerCase()) && !"utilities".equals("Daffodil".toLowerCase())) {
                linkpath = linkpath + "\\Daffodil";
            }
            linkpath = linkpath + "\\" + Globals.APP_NAME + " " + Globals.APP_VERSION;
            Globals.printDebug(" Link path " + linkpath);
            Globals.printDebug(" startMenuPath " + startMenuPath);
            Globals.printDebug(" desktopPath " + desktopPath);
            File startMenuFile = new File(startMenuPath + linkpath);
            ShortcutsUtility.deleteDirRecursive(startMenuFile);
            ShortcutsUtility.deleteDaffodil(desktopPath, startMenuPath);
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (RegistryException ex) {}
    }

    private static void deleteDaffodil(String deskTopPath, String startMenuPath) {
        String linkpath = "";
        if (!"applications".equals("Daffodil".toLowerCase()) && !"utilities".equals("Daffodil".toLowerCase())) {
            File deskTopFile = new File(deskTopPath + "\\" + "Daffodil");
            File startMenuFile = new File(startMenuPath + "\\" + "Daffodil");
            Globals.printDebug(deskTopPath + "\\" + "Daffodil");
            Globals.printDebug(startMenuPath + "\\" + "Daffodil");
            if (startMenuFile.list() == null || startMenuFile.list().length == 0) {
                if (!startMenuFile.delete()) {
                    Globals.printDebug("D " + startMenuPath + " not deleted");
                }
            } else {
                Globals.printDebug("D " + startMenuPath + " not empty");
            }
        }
    }

    private static void deleteDirRecursive(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] filelist = dir.listFiles();
        int i = 0;
        while (i < filelist.length) {
            boolean isdir = filelist[i].isDirectory();
            if (isdir) {
                ShortcutsUtility.deleteDirRecursive(filelist[i]);
            } else if (!filelist[i].delete()) {
                Globals.printDebug("F " + filelist[i] + " not deleted");
            }
            ++i;
        }
        if (!dir.delete()) {
            Globals.printDebug("D " + dir + " not deleted");
        }
    }
}

