/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import kgd.card.player.gui.Stat;
import kgd.card.player.gui.Tools;

public final class StatCodec {
    private Map ivStats = new HashMap();
    private File ivFile = null;

    public void decode() throws Exception {
        this.decode("Stats.dat");
    }

    public void decode(File file) throws Exception {
        if (file == null) {
            throw new Exception("Unable to decode Stat file");
        }
        this.ivFile = file;
        this.ivStats = new HashMap();
        if (!file.exists()) {
            return;
        }
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(bufferedInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader(inflaterInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                this.decodeGame(string);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inflaterInputStream.close();
            bufferedInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            throw new Exception("Unable to decode Stat file");
        }
    }

    public void decode(String string) throws Exception {
        this.decode(new File(String.valueOf(Tools.DIR_USER) + string));
    }

    private void decodeGame(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        Stat stat = new Stat();
        while (stringTokenizer.hasMoreTokens()) {
            Parm parm = new Parm(stringTokenizer.nextToken(), "=");
            if (parm.ivKey.equals("Game")) {
                stat.setGame(parm.ivValue);
            }
            if (parm.ivKey.equals("Played")) {
                stat.setPlayed(new Long(parm.ivValue));
            }
            if (parm.ivKey.equals("Won")) {
                stat.setWon(new Long(parm.ivValue));
            }
            if (parm.ivKey.equals("WonScore")) {
                stat.setWonScore(new Long(parm.ivValue));
            }
            if (parm.ivKey.equals("Lost")) {
                stat.setLost(new Long(parm.ivValue));
            }
            if (!parm.ivKey.equals("LostScore")) continue;
            stat.setLostScore(new Long(parm.ivValue));
        }
        this.ivStats.put(stat.getGame(), stat);
    }

    public void encode() throws Exception {
        if (this.ivFile == null) {
            this.encode("Stats.dat");
        } else {
            this.encode(this.ivFile);
        }
    }

    public void encode(File file) throws Exception {
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(bufferedOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(deflaterOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        Iterator iterator = this.ivStats.values().iterator();
        while (iterator.hasNext()) {
            String string = this.encodeGame((Stat)iterator.next());
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        outputStreamWriter.close();
        deflaterOutputStream.close();
        bufferedOutputStream.close();
        fileOutputStream.close();
    }

    public void encode(String string) throws Exception {
        this.encode(new File(String.valueOf(Tools.DIR_USER) + string));
    }

    private String encodeGame(Stat stat) {
        return new String("Game=" + stat.getGame() + ";" + "Played=" + stat.getPlayed() + ";" + "Won=" + stat.getWon() + ";" + "WonScore=" + stat.getWonScore() + ";" + "Lost=" + stat.getLost() + ";" + "LostScore=" + stat.getLostScore());
    }

    public File getFile() {
        return this.ivFile;
    }

    public Map getStats() {
        return this.ivStats;
    }

    public void setFile(File file) {
        this.ivFile = file;
    }

    public void setStats(Map map) {
        this.ivStats = map;
    }

    public void updateStats(Stat stat) throws Exception {
        this.ivStats.remove(stat.getGame());
        this.ivStats.put(stat.getGame(), stat);
        this.encode();
    }

    private final class Parm {
        private String ivKey;
        private String ivValue;

        public Parm(String string, String string2) {
            int n = string.indexOf(string2);
            if (n > 0) {
                this.ivKey = string.substring(0, n);
                this.ivValue = string.substring(n + 1);
            }
        }
    }
}

