/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import kgd.card.player.data.Score;
import kgd.card.player.gui.GameScore;
import kgd.card.player.gui.Tools;

public final class ScoreCodec {
    private Map ivGameScores = new HashMap();
    private File ivFile = null;

    public void decode() throws Exception {
        this.decode("Hiscores.dat");
    }

    public void decode(File file) throws Exception {
        if (file == null) {
            throw new Exception("Unable to decode Score file");
        }
        this.ivFile = file;
        this.ivGameScores = new HashMap();
        if (!file.exists()) {
            return;
        }
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(bufferedInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader(inflaterInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                this.decodeGame(string);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inflaterInputStream.close();
            bufferedInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            throw new Exception("Unable to decode Score file");
        }
    }

    public void decode(String string) throws Exception {
        this.decode(new File(String.valueOf(Tools.DIR_USER) + string));
    }

    private void decodeGame(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = null;
        List list = null;
        while (stringTokenizer.hasMoreTokens()) {
            Parm parm = new Parm(stringTokenizer.nextToken(), "=");
            if (parm.ivKey.equals("Game")) {
                string2 = parm.ivValue;
            }
            if (!parm.ivKey.equals("Scores")) continue;
            list = this.decodeScores(parm.ivValue);
        }
        GameScore gameScore = new GameScore(string2, list);
        this.ivGameScores.put(string2, gameScore);
    }

    private List decodeScores(String string) {
        ArrayList<Score> arrayList = new ArrayList<Score>(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "+");
            Score score = new Score();
            score.setPlayer(stringTokenizer2.nextToken());
            score.setDecks(new Integer(stringTokenizer2.nextToken()));
            score.setFoundation(new Integer(stringTokenizer2.nextToken()));
            score.setTableau(new Integer(stringTokenizer2.nextToken()));
            score.setUndo(new Integer(stringTokenizer2.nextToken()));
            score.setAutoMove(new Integer(stringTokenizer2.nextToken()));
            score.setRedeal(new Integer(stringTokenizer2.nextToken()));
            score.setTime(new Integer(stringTokenizer2.nextToken()));
            arrayList.add(score);
        }
        return arrayList;
    }

    public void encode() throws Exception {
        if (this.ivFile == null) {
            this.encode("Hiscores.dat");
        } else {
            this.encode(this.ivFile);
        }
    }

    public void encode(File file) throws Exception {
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(bufferedOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(deflaterOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        Iterator iterator = this.ivGameScores.values().iterator();
        while (iterator.hasNext()) {
            String string = this.encodeGame((GameScore)iterator.next());
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        outputStreamWriter.close();
        deflaterOutputStream.close();
        bufferedOutputStream.close();
        fileOutputStream.close();
    }

    public void encode(String string) throws Exception {
        this.encode(new File(String.valueOf(Tools.DIR_USER) + string));
    }

    private String encodeGame(GameScore gameScore) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < gameScore.getScores().size()) {
            Score score = (Score)gameScore.getScores().get(n);
            stringBuffer.append(String.valueOf(score.getPlayer()) + "+" + score.getDecks() + "+" + score.getFoundation() + "+" + score.getTableau() + "+" + score.getUndo() + "+" + score.getAutoMove() + "+" + score.getRedeal() + "+" + score.getTime());
            if (n < gameScore.getScores().size() - 1) {
                stringBuffer.append("|");
            }
            ++n;
        }
        return new String("Game=" + gameScore.getGame() + ";" + "Scores=" + stringBuffer + ";");
    }

    public File getFile() {
        return this.ivFile;
    }

    public Map getGameScores() {
        return this.ivGameScores;
    }

    public void setFile(File file) {
        this.ivFile = file;
    }

    public void setGameScores(Map map) {
        this.ivGameScores = map;
    }

    public void updateGameScores(GameScore gameScore) throws Exception {
        this.ivGameScores.remove(gameScore.getGame());
        this.ivGameScores.put(gameScore.getGame(), gameScore);
        this.encode();
    }

    private final class Parm {
        private String ivKey;
        private String ivValue;

        public Parm(String string, String string2) {
            int n = string.indexOf(string2);
            if (n > 0) {
                this.ivKey = string.substring(0, n);
                this.ivValue = string.substring(n + 1);
            }
        }
    }
}

