/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.Dimension;
import java.awt.Rectangle;
import kgd.card.player.data.Card;
import kgd.card.player.data.Drag;
import kgd.card.player.data.Widget;
import kgd.card.player.gui.CardUI;
import kgd.card.player.gui.WidgetUI;

public final class DragUI {
    private Drag ivDrag;
    private CardUI[] ivSourceCardUIs;
    private WidgetUI[] ivTargetWidgetUIs;
    private Dimension ivSourceDimension;

    public DragUI(Drag drag) {
        this.ivDrag = drag;
        int n = this.ivDrag.getSourceCards().size();
        this.ivSourceCardUIs = new CardUI[n];
        int n2 = 0;
        while (n2 < n) {
            this.ivSourceCardUIs[n2] = (CardUI)((Card)this.ivDrag.getSourceCards().get(n2)).getListener();
            ++n2;
        }
        Rectangle rectangle = this.ivSourceCardUIs[0].getBounds().union(this.ivSourceCardUIs[n - 1].getBounds());
        this.ivSourceDimension = rectangle.getSize();
        int n3 = this.ivDrag.getTargetWidgets().size();
        if (n3 == 0) {
            this.ivTargetWidgetUIs = null;
            return;
        }
        this.ivTargetWidgetUIs = new WidgetUI[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.ivTargetWidgetUIs[n4] = (WidgetUI)((Widget)this.ivDrag.getTargetWidgets().get(n4)).getListener();
            ++n4;
        }
    }

    protected void end() {
        int n = this.ivDrag.getTargetIndex();
        if (n > -1) {
            this.ivTargetWidgetUIs[n].setDraggedOver(false);
        }
    }

    public Drag getDrag() {
        return this.ivDrag;
    }

    public CardUI[] getSourceCardUIs() {
        return this.ivSourceCardUIs;
    }

    public WidgetUI[] getTargetWidgetUIs() {
        return this.ivTargetWidgetUIs;
    }

    protected void searchTarget() {
        if (this.ivTargetWidgetUIs == null) {
            return;
        }
        Rectangle rectangle = new Rectangle(this.ivSourceCardUIs[0].getLocation(), this.ivSourceDimension);
        int n = this.ivDrag.getTargetIndex();
        int n2 = this.ivDrag.getTargetIndex();
        if (n2 > -1 && !this.ivTargetWidgetUIs[n2].getBounds().intersects(rectangle)) {
            n2 = -1;
        }
        if (n2 == -1) {
            int n3 = 0;
            while (n3 < this.ivTargetWidgetUIs.length) {
                if (this.ivTargetWidgetUIs[n3].getBounds().intersects(rectangle)) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        if (n2 != n) {
            if (n > -1) {
                this.ivTargetWidgetUIs[n].setDraggedOver(false);
            }
            if (n2 > -1) {
                this.ivTargetWidgetUIs[n2].setDraggedOver(true);
            }
        }
        this.ivDrag.setTargetIndex(n2);
    }
}

