/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import kgd.card.player.data.Score;
import kgd.card.player.gui.FrmMain;
import kgd.card.player.gui.Tools;

public final class DlgName
extends JDialog {
    private JLabel ivLblTitle;
    private JLabel ivLblTime;
    private JLabel ivLblTimeValue;
    private JLabel ivLblBonus;
    private JLabel ivLblBonusValue;
    private JLabel ivLblBuilding;
    private JLabel ivLblBuildingValue;
    private JLabel ivLblUndo;
    private JLabel ivLblUndoValue;
    private JLabel ivLblAutoMove;
    private JLabel ivLblAutoMoveValue;
    private JLabel ivLblRedeal;
    private JLabel ivLblRedealValue;
    private JLabel ivLblTotal;
    private JLabel ivLblTotalValue;
    private JLabel ivLblRank;
    private JLabel ivLblRankValue;
    private JLabel ivLblPlayer;
    private JTextField ivTxtPlayer;
    private JButton ivBttContinue;
    private Score ivScore;
    private int ivRank;
    private String ivPlayer;

    public DlgName() {
        this.initialize();
    }

    public DlgName(Frame frame, Score score, int n) {
        super(frame, true);
        this.ivScore = score;
        this.ivRank = n;
        this.ivPlayer = this.ivScore.getPlayer();
        this.initialize();
    }

    private void checkPlayer() {
        String string = this.ivTxtPlayer.getText().equals("") ? "Quid" : this.ivTxtPlayer.getText();
        this.ivPlayer = string;
    }

    private void eventButtonClicked(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ivBttContinue) {
            this.checkPlayer();
            this.dispose();
        }
    }

    public String getPlayer() {
        return this.ivPlayer;
    }

    private void initialize() {
        this.setTitle(Tools.translate("Name-Title"));
        this.setName("DlgName");
        this.getContentPane().setLayout(new FlowLayout(1, 4, 4));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DlgName.this.dispose();
            }
        });
        this.initializeComponents();
        this.initializeValues();
        int n = 218 + FrmMain.getFrameInsetsDimension().width;
        int n2 = 302 + FrmMain.getFrameInsetsDimension().height;
        int n3 = (Toolkit.getDefaultToolkit().getScreenSize().width - n) / 2;
        int n4 = (Toolkit.getDefaultToolkit().getScreenSize().height - n2) / 2;
        if (this.getParent() != null) {
            n3 = this.getParent().getX() + (this.getParent().getWidth() - n) / 2;
            n4 = this.getParent().getY() + (this.getParent().getHeight() - n2) / 2;
        }
        ((Component)this).setBounds(n3, n4, n, n2);
        ((Component)this).setVisible(true);
    }

    private void initializeComponents() {
        this.ivLblTitle = new JLabel();
        this.ivLblTitle.setPreferredSize(new Dimension(210, 70));
        this.ivLblTitle.setFont(new Font("dialog.bold", 1, 20));
        this.ivLblTitle.setForeground(Color.black);
        this.ivLblTitle.setHorizontalAlignment(0);
        this.ivLblTitle.setHorizontalTextPosition(0);
        this.ivLblTitle.setVerticalAlignment(0);
        this.ivLblTitle.setVerticalTextPosition(0);
        this.ivLblTitle.setIcon(Tools.getIcon("DlgNameIcon.gif"));
        this.getContentPane().add(this.ivLblTitle);
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0), false);
        jPanel.setPreferredSize(new Dimension(210, 148));
        jPanel.setBorder(new EtchedBorder());
        this.getContentPane().add(jPanel);
        this.ivLblTime = new JLabel();
        this.ivLblTime.setPreferredSize(new Dimension(142, 20));
        this.ivLblTime.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblTime.setHorizontalAlignment(2);
        this.ivLblTime.setText(Tools.translate("Name-Time"));
        jPanel.add(this.ivLblTime);
        this.ivLblTimeValue = new JLabel();
        this.ivLblTimeValue.setPreferredSize(new Dimension(52, 20));
        this.ivLblTimeValue.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblTimeValue.setHorizontalAlignment(4);
        jPanel.add(this.ivLblTimeValue);
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setPreferredSize(new Dimension(194, 2));
        jPanel.add(jSeparator);
        this.ivLblBuilding = new JLabel();
        this.ivLblBuilding.setPreferredSize(new Dimension(142, 20));
        this.ivLblBuilding.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblBuilding.setHorizontalAlignment(2);
        this.ivLblBuilding.setText(Tools.translate("Name-Building"));
        jPanel.add(this.ivLblBuilding);
        this.ivLblBuildingValue = new JLabel();
        this.ivLblBuildingValue.setPreferredSize(new Dimension(52, 20));
        this.ivLblBuildingValue.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblBuildingValue.setHorizontalAlignment(4);
        jPanel.add(this.ivLblBuildingValue);
        this.ivLblUndo = new JLabel();
        this.ivLblUndo.setPreferredSize(new Dimension(142, 20));
        this.ivLblUndo.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblUndo.setHorizontalAlignment(2);
        this.ivLblUndo.setText(Tools.translate("Name-Undo"));
        jPanel.add(this.ivLblUndo);
        this.ivLblUndoValue = new JLabel();
        this.ivLblUndoValue.setPreferredSize(new Dimension(52, 20));
        this.ivLblUndoValue.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblUndoValue.setHorizontalAlignment(4);
        jPanel.add(this.ivLblUndoValue);
        this.ivLblAutoMove = new JLabel();
        this.ivLblAutoMove.setPreferredSize(new Dimension(142, 20));
        this.ivLblAutoMove.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblAutoMove.setHorizontalAlignment(2);
        this.ivLblAutoMove.setText(Tools.translate("Name-WrongMove"));
        jPanel.add(this.ivLblAutoMove);
        this.ivLblAutoMoveValue = new JLabel();
        this.ivLblAutoMoveValue.setPreferredSize(new Dimension(52, 20));
        this.ivLblAutoMoveValue.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblAutoMoveValue.setHorizontalAlignment(4);
        jPanel.add(this.ivLblAutoMoveValue);
        this.ivLblRedeal = new JLabel();
        this.ivLblRedeal.setPreferredSize(new Dimension(142, 20));
        this.ivLblRedeal.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblRedeal.setHorizontalAlignment(2);
        this.ivLblRedeal.setText(Tools.translate("Name-Redeals"));
        jPanel.add(this.ivLblRedeal);
        this.ivLblRedealValue = new JLabel();
        this.ivLblRedealValue.setPreferredSize(new Dimension(52, 20));
        this.ivLblRedealValue.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblRedealValue.setHorizontalAlignment(4);
        jPanel.add(this.ivLblRedealValue);
        this.ivLblBonus = new JLabel();
        this.ivLblBonus.setPreferredSize(new Dimension(142, 20));
        this.ivLblBonus.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblBonus.setHorizontalAlignment(2);
        this.ivLblBonus.setText(Tools.translate("Name-Bonus"));
        jPanel.add(this.ivLblBonus);
        this.ivLblBonusValue = new JLabel();
        this.ivLblBonusValue.setPreferredSize(new Dimension(52, 20));
        this.ivLblBonusValue.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblBonusValue.setHorizontalAlignment(4);
        jPanel.add(this.ivLblBonusValue);
        JSeparator jSeparator2 = new JSeparator(0);
        jSeparator2.setPreferredSize(new Dimension(194, 2));
        jPanel.add(jSeparator2);
        this.ivLblTotal = new JLabel();
        this.ivLblTotal.setPreferredSize(new Dimension(142, 20));
        this.ivLblTotal.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblTotal.setHorizontalAlignment(2);
        this.ivLblTotal.setText(Tools.translate("Name-Total"));
        jPanel.add(this.ivLblTotal);
        this.ivLblTotalValue = new JLabel();
        this.ivLblTotalValue.setPreferredSize(new Dimension(52, 20));
        this.ivLblTotalValue.setFont(new Font("dialog.bold", 1, 14));
        this.ivLblTotalValue.setForeground(Color.red);
        this.ivLblTotalValue.setHorizontalAlignment(4);
        jPanel.add(this.ivLblTotalValue);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 4), false);
        jPanel2.setPreferredSize(new Dimension(210, 32));
        jPanel2.setBorder(new EtchedBorder());
        this.getContentPane().add(jPanel2);
        this.ivLblPlayer = new JLabel();
        this.ivLblPlayer.setPreferredSize(new Dimension(92, 20));
        this.ivLblPlayer.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblPlayer.setHorizontalAlignment(2);
        this.ivLblPlayer.setText(Tools.translate("Name-Player"));
        jPanel2.add(this.ivLblPlayer);
        this.ivTxtPlayer = new JTextField();
        this.ivTxtPlayer.setPreferredSize(new Dimension(102, 20));
        this.ivTxtPlayer.setFont(new Font("dialog.bold", 1, 12));
        jPanel2.add(this.ivTxtPlayer);
        if (this.ivRank < 1) {
            this.ivLblPlayer.setVisible(false);
            this.ivTxtPlayer.setVisible(false);
        }
        this.ivBttContinue = new JButton();
        this.ivBttContinue.setPreferredSize(new Dimension(210, 32));
        this.ivBttContinue.setIcon(Tools.getIcon("OK.gif"));
        this.ivBttContinue.setRolloverIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttContinue.setPressedIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttContinue.setToolTipText(Tools.translate("Name-OK"));
        this.ivBttContinue.setFocusPainted(false);
        this.ivBttContinue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgName.this.eventButtonClicked(actionEvent);
            }
        });
        this.getContentPane().add(this.ivBttContinue);
    }

    private void initializeValues() {
        String string = "- ";
        if (this.ivRank > 0) {
            this.ivLblTitle.setText(String.valueOf(this.ivRank));
        } else {
            this.ivLblTitle.setText("X");
        }
        this.ivLblTimeValue.setText(String.valueOf(this.ivScore.getTime()));
        this.ivLblBuildingValue.setText(String.valueOf(this.ivScore.getBuilding()));
        if (this.ivScore.getUndo() < 0) {
            this.ivLblUndoValue.setText(String.valueOf(string) + Math.abs(this.ivScore.getUndo()));
        } else {
            this.ivLblUndoValue.setText(String.valueOf(this.ivScore.getUndo()));
        }
        if (this.ivScore.getAutoMove() < 0) {
            this.ivLblAutoMoveValue.setText(String.valueOf(string) + Math.abs(this.ivScore.getAutoMove()));
        } else {
            this.ivLblAutoMoveValue.setText(String.valueOf(this.ivScore.getAutoMove()));
        }
        if (this.ivScore.getRedeal() < 0) {
            this.ivLblRedealValue.setText(String.valueOf(string) + Math.abs(this.ivScore.getRedeal()));
        } else {
            this.ivLblRedealValue.setText(String.valueOf(this.ivScore.getRedeal()));
        }
        if (this.ivScore.isComplete()) {
            this.ivLblBonusValue.setText(String.valueOf(this.ivScore.getBonus()));
        } else {
            this.ivLblBonusValue.setText("0");
        }
        this.ivLblTotalValue.setText(String.valueOf(this.ivScore.getTotal()));
        this.ivTxtPlayer.setText(this.ivScore.getPlayer());
    }

    public static void main(String[] stringArray) {
        try {
            DlgName dlgName = new DlgName();
            dlgName.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            ((Component)dlgName).setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }
}

