/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.data;

import kgd.card.player.data.Pile;
import kgd.card.player.data.Widget;

public final class Card
extends Widget {
    public static final int CARD_FAMILY_SPIDE = 0;
    public static final int CARD_FAMILY_CLUB = 1;
    public static final int CARD_FAMILY_HEART = 2;
    public static final int CARD_FAMILY_DIAMOND = 3;
    public static final int CARD_COLOR_BLACK = 0;
    public static final int CARD_COLOR_RED = 1;
    public static final int CARD_RANK_ACE = 0;
    public static final int CARD_RANK_TWO = 1;
    public static final int CARD_RANK_THREE = 2;
    public static final int CARD_RANK_FOUR = 3;
    public static final int CARD_RANK_FIVE = 4;
    public static final int CARD_RANK_SIX = 5;
    public static final int CARD_RANK_SEVEN = 6;
    public static final int CARD_RANK_EIGHT = 7;
    public static final int CARD_RANK_NINE = 8;
    public static final int CARD_RANK_TEN = 9;
    public static final int CARD_RANK_JACK = 10;
    public static final int CARD_RANK_QUEEN = 11;
    public static final int CARD_RANK_KING = 12;
    private final int ivFamily;
    private final int ivRank;
    private final String ivId;
    private Pile ivPile = null;
    private boolean ivFlipped = false;

    public Card(int n, int n2) {
        this.ivFamily = n;
        this.ivRank = n2;
        this.ivId = String.valueOf(n) + "-" + n2;
    }

    public Card(Card card, Pile pile) {
        this.ivFamily = card.getFamily();
        this.ivRank = card.getRank();
        this.ivId = card.getId();
        this.ivFlipped = card.isFlipped();
        this.ivPile = pile == null ? card.getPile() : pile;
    }

    public final int getColor() {
        return this.ivFamily / 2;
    }

    public final int getFamily() {
        return this.ivFamily;
    }

    public final String getId() {
        return this.ivId;
    }

    public Pile getPile() {
        return this.ivPile;
    }

    public final int getRank() {
        return this.ivRank;
    }

    public boolean isFlipped() {
        return this.ivFlipped;
    }

    protected void move(Pile pile) {
        if (pile == this.ivPile) {
            return;
        }
        if (this.ivPile != null) {
            this.ivPile.getCards().remove(this);
        }
        this.ivPile = pile;
        if (this.ivPile != null) {
            this.ivPile.getCards().add(this);
        }
    }

    protected void setFlipped(boolean bl) {
        if (bl == this.ivFlipped) {
            return;
        }
        boolean bl2 = this.ivFlipped;
        this.ivFlipped = bl;
        this.fireStateChanged("Flipped");
    }
}

