/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.bean;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class KBorder2
extends AbstractBorder {
    public static final int FLAT = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int DOUBLE_RAISED = 3;
    public static final int DOUBLE_LOWERED = 4;
    private int ivBorderType;
    private int ivBorderThickness;
    private static Color cvColor = null;

    public KBorder2() {
        this(1, 1);
    }

    public KBorder2(int n, int n2) {
        this.setBorderType(n);
        this.setBorderThickness(n2);
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(this.ivBorderThickness, this.ivBorderThickness, this.ivBorderThickness, this.ivBorderThickness);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.left = insets.right = this.ivBorderThickness;
        insets.top = insets.bottom = this.ivBorderThickness;
        return insets;
    }

    public int getBorderThickness() {
        return this.ivBorderThickness;
    }

    public int getBorderType() {
        return this.ivBorderType;
    }

    protected Color getHighlightColor(Component component) {
        return component.getBackground().brighter();
    }

    protected Color getShadowColor(Component component) {
        return component.getBackground().darker().darker();
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.ivBorderType) {
            case 1: {
                this.paintRaisedBorder(component, graphics, n, n2, n3, n4);
                break;
            }
            case 2: {
                this.paintLoweredBorder(component, graphics, n, n2, n3, n4);
                break;
            }
        }
    }

    protected void paintLoweredBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.translate(n, n2);
        int n5 = 0;
        while (n5 < this.ivBorderThickness) {
            graphics.setColor(this.getShadowColor(component));
            graphics.drawLine(n5, n5, n5, n4 - (1 + n5));
            graphics.drawLine(1 + n5, n5, n3 - (1 + n5), n5);
            graphics.setColor(this.getHighlightColor(component));
            graphics.drawLine(1 + n5, n4 - (1 + n5), n3 - (1 + n5), n4 - (1 + n5));
            graphics.drawLine(n3 - (1 + n5), 1 + n5, n3 - (1 + n5), n4 - (2 + n5));
            ++n5;
        }
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    protected void paintRaisedBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.translate(n, n2);
        int n5 = 0;
        while (n5 < this.ivBorderThickness) {
            graphics.setColor(this.getShadowColor(component));
            graphics.drawLine(1 + n5, n4 - (1 + n5), n3 - (1 + n5), n4 - (1 + n5));
            graphics.drawLine(n3 - (1 + n5), 1 + n5, n3 - (1 + n5), n4 - (2 + n5));
            graphics.setColor(this.getHighlightColor(component));
            graphics.drawLine(n5, n5, n5, n4 - (1 + n5));
            graphics.drawLine(1 + n5, n5, n3 - (1 + n5), n5);
            ++n5;
        }
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    public void setBorderThickness(int n) {
        if (this.ivBorderThickness == n) {
            return;
        }
        if (n < 1) {
            n = 1;
        }
        this.ivBorderThickness = n;
    }

    public void setBorderType(int n) {
        if (this.ivBorderType == n) {
            return;
        }
        this.ivBorderType = n;
    }
}

