/*
 * program: psfilt
 * file: version.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * Version number and patch level
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: version.c,v $
 * Revision 1.3  1994/07/13  18:14:32  rj
 * beta status removed
 *
 * Revision 1.2  1994/03/18  12:07:41  rj
 * support for duplex mode added
 * lots of missing `#ifdef COLORED' inserted
 *
 * Revision 1.1.1.1  1993/12/31  20:56:47  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: version.c,v 1.3 1994/07/13 18:14:32 rj Exp $";

#include <stdio.h>

#include "psfilt.h"
#include "defaults.h"
#include "ps.h"
#include "version.h"
#include "patchlevel.h"

static void printstr (cstring name, cstring value)
{
  if (value)
    fprintf (stderr, "		%s=%s\n", name, value);
  else
    fprintf (stderr, "		no %s\n", name);
}

void printversion()
{
  fprintf (stderr, "psfilt version %d.%d.%d\n", RELEASE, REVISION, PATCHLEVEL);
  fprintf (stderr, "	as of %s %s\n", __TIME__, __DATE__);
#ifdef COLORED
  fprintf (stderr, "		may produce colored output\n");
#else
  fprintf (stderr, "		can't produce colored output\n");
#endif
  fprintf (stderr, "	defaults:\n");
#define PS(name)	printstr (#name, DEFAULT_##name);
  PS(PAPERTYPE)
  printstr ("DSC_Data", dscdata_name (DEFAULT_DSC));

  PS(PPDPATH)
  PS(AFMPATH)
  PS(FONTPATH)

  fprintf (stderr, "		the cache is %s, file name=`%s'\n", DEFAULT_CACHEGLOBAL?"global":"local", DEFAULT_CACHEFILE);
#ifdef __GNUC__
  fprintf (stderr, "	compiled with gcc version %s\n", __VERSION__);
#endif
}
