/*
 * program: psfilt
 * file: verbmode.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: verbmode.c,v $
 * Revision 1.1.1.1  1993/12/31  20:56:44  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: verbmode.c,v 1.1.1.1 1993/12/31 20:56:44 rj Exp $";

#include "psfilt.h"
#include "verbmode.h"

static struct
{
  cstring	ctrl[32];
  cstring	del;
} const verbtable[] =
{
  "NUL", "^A",  "^B",  "^C",  "^D", "^E", "^F", "^G",
  "BS",  "TAB", "NL",  "^K",  "FF", "CR", "^N", "^O",
  "^P",  "^Q",  "^R",  "^S",  "^T", "^U", "^V", "^W",
  "^X",  "^Y",  "^Z", "ESC", "^\\", "^]", "^^", "^_",
  "DEL",
  "NUL", "SOH", "STX", "ETX",  "EOT", "ENQ", "ACK", "BEL",
  "BS",  "HT",  "LF",  "VT",   "FF",  "CR",  "SO",  "SI",
  "DLE", "DC1", "DC2", "DC3",  "DC4", "NAK", "SYN", "ETB",
  "CAN", "EM",  "SUB", "ESC",  "FS",  "GS",  "RS",  "US",
  "DEL",
  "^@", "^A", "^B", "^C",  "^D", "^E", "^F", "^G",
  "^H", "^I", "^J", "^K",  "^L", "^M", "^N", "^O",
  "^P", "^Q", "^R", "^S",  "^T", "^U", "^V", "^W",
  "^X", "^Y", "^Z", "^[", "^\\", "^]", "^^", "^_",
  "^?",
    "$0",  "$1",  "$2",  "$3",   "$4",  "$5",  "$6",  "$7",
    "$8",  "$9", "$10", "$11",  "$12", "$13", "$14", "$15",
   "$16", "$17", "$18", "$19",  "$20", "$21", "$22", "$23",
   "$24", "$25", "$26", "$27",  "$28", "$29", "$30", "$31",
  "$127"
};

/* map non printable ISO 646 characters and non ISO 646 characters into sequences of ISO 646 characters:	*/
cstring verbcontrol (t_verbmode verbmode, uchar c)
{
  static char buf[8];

  if (c & 0x80 || verbmode < 0 || verbmode >= ARRAYDIM (verbtable))
  {
    sprintf (buf, "\\%03o", c);
    return buf;
  }
  elif (c < ' ')
    return verbtable[verbmode].ctrl[c];
  else
    return verbtable[verbmode].del;
}
