/*
 * library: uti
 * file: uti.h
 *
 * Copyright  1990, 1991, 1992, 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: uti.h,v 1.1.2.1 1994/07/09 16:29:21 rj Exp $
 * $Log: uti.h,v $
 * Revision 1.1.2.1  1994/07/09  16:29:21  rj
 * light version fr psfilt
 *
 * Revision 1.2  1994/07/09  15:21:28  rj
 * `uti.h lite' fr psfilt
 *
 * Revision 1.1.1.1  1993/12/31  20:56:46  rj
 * erster cvs import.
 *
 */

#ifndef UTI_H
#define UTI_H

#include "gdefs.h"

#define fprint(fp, s)		fputs ((s), (fp))
#define streq(s0, s1)		(!strcmp ((s0), (s1)))
#define strneq(s0, s1, len)	(!strncmp ((s0), (s1), (len)))

#include <stdarg.h>

extern int		intcmp (int, int),
			longcmp (long, long),
			ushortcmp (ushort, ushort),
			strpcmp (const cstring *, const cstring *);

extern void		*malloc0 (size_t);

extern size_t		strnlen (cstring, size_t);

extern size_t		chrind (cstring, char);

extern int		strind (const cstring *, cstring);

extern bool		strabbr (cstring pattern, cstring test),
			strnabbr (cstring pattern, cstring test, size_t min);

extern cstring		basename (cstring);
extern bool		strmatch (cstring pattern, cstring fn);

extern string		strlower (string),
			strstrip (string),
			strcmpr (string);

extern FILE		*fsopen (string buf, size_t buflen, cstring rw);
extern void		fsclose (FILE *fp);

#endif UTI_H
