/*
 * library: uti
 * file: strnabbr.c
 *
 * Copyright  1991 Robert Joop
 *
 * $Log: strnabbr.c,v $
 * Revision 1.1.1.1  1993/12/31  20:16:16  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: strnabbr.c,v 1.1.1.1 1993/12/31 20:16:16 rj Exp $";

#include <stdio.h>

#include "gdefs.h"
#include "uti.h"

#ifdef __STDC__
bool strnabbr (cstring pattern, cstring test, size_t min)
#else
bool strnabbr (pattern, test, min)
  string	pattern, test;
  int		min;
#endif
{
  register	len;

  if (strlen (pattern)<min)
    fprintf (stderr, "strnabbr(): strlen (pattern) < min\n");
  if ((len = strlen (test))<min)
    return false;
  return !strncmp (pattern, test, len);
}
