/*
 * library: uti
 * file: strmatch.c
 *
 * Copyright  1991 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: strmatch.c,v $
 * Revision 1.1.1.1  1993/12/31  20:16:16  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: strmatch.c,v 1.1.1.1 1993/12/31 20:16:16 rj Exp $";

#include "gdefs.h"
#include "uti.h"

#ifdef __STDC__
static bool match (cstring pattern, cstring fn)
#else
static bool match (pattern, fn)
  string	pattern, fn;
#endif
{
  int		a, o;

  switch (*pattern)
  {
    case '\0':	return !*fn;
    case '?':	return match (pattern+1, fn+1);
    case '*':	for (; *fn; fn++)
		  if (match (pattern+1, fn))
		    return true;
		return match (pattern+1, fn);
    case '[':	for (a=0, o=chrind (++pattern, ']')-1; a<=o; a++)
		  if (pattern[a] == '-' && a && a<o)
		    if (pattern[a-1] <= *fn && *fn <= pattern[a+1])
		      return match (pattern+o+2, fn+1);
		    else
		      continue;
		  elif (pattern[a] == *fn)
		    return match (pattern+o+2, fn+1);
		  else
		    continue;
		return false;
    case '\\':	pattern++;
    default:	return *pattern == *fn ? match (pattern+1, fn+1) : false;
  }
}

#ifdef __STDC__
bool strmatch (cstring pattern, cstring fn)
#else
bool strmatch (pattern, fn)
  string	pattern, fn;
#endif
{
  if (*fn == '.')
    if (*pattern == '.')
      return match (pattern+1, fn+1);
    else
      return false;
  else
    return match (pattern, fn);
}
