/*
 * fsopen() adaped for linux.
 *
 * This Version is working for libc-linux-4.5.8.
 * As it uses internal libc-functions, it may not
 * work for newer libraries.
 * But perhaps it is included in newer versions.
 *
 * Carsten Paeth <calle@calle.in-berlin.de>
 *
 * $Header: /home/rainbow/rj/cvs/uti/fsopen-linux.c,v 1.2 1994/07/13 18:03:30 rj Exp $
 * $Log: fsopen-linux.c,v $
 * Revision 1.2  1994/07/13  18:03:30  rj
 * checked to be working with libc 4.5.26
 *
 */

/* #define TEST */

#ifdef TEST
#define MEM_C
#endif

#include <errno.h>
#include "gdefs.h"
#include "uti.h"

#include <libio.h>
/* define for 4.5.8 */
#define TODO

extern struct _IO_jump_t _IO_str_jumps;
extern void _IO_init __P((_IO_FILE*, int));
extern void _IO_str_init_static __P((_IO_FILE *, char*, int, char*));

#ifdef TODO
typedef void *(*_IO_alloc_type) __P((_IO_size_t));
typedef void (*_IO_free_type) __P((void*));

struct _IO_str_fields
{
  /* The current length is max(_len, _IO_write_ptr-_IO_write_base). */
  _IO_size_t _len;
  _IO_alloc_type _allocate_buffer;
  _IO_free_type _free_buffer;
};

typedef struct _IO_strfile_
{
  struct _IO_FILE_plus _f;
  struct _IO_str_fields _s;
} _IO_strfile;
#endif

FILE *fsopen (string buf, size_t buflen, cstring rw)
{
  _IO_strfile	*fp = (_IO_strfile *)malloc(sizeof(_IO_strfile));

  if (!fp) {
     errno = EMFILE;
     return NULL;
  }

  if (!strcmp (rw, "r")) {
	  _IO_init((_IO_FILE*)fp, _IO_NO_WRITES+_IO_USER_BUF);
	  ((_IO_FILE*)fp)->_jumps = &_IO_str_jumps;
    _IO_str_init_static ((_IO_FILE*)fp, buf, buflen, buf);
  } elif (!strcmp (rw, "w")) {
	  _IO_init((_IO_FILE*)fp, _IO_NO_READS+_IO_USER_BUF);
	  ((_IO_FILE*)fp)->_jumps = &_IO_str_jumps;
    _IO_str_init_static ((_IO_FILE*)fp, buf, buflen, NULL);
  } else
    return NULL;
  return (FILE*)fp;
}

void fsclose (FILE *fp)
{
   fclose(fp);
/*
   if (fp->_flags & _IO_IS_FILEBUF) {
      fprintf (stderr, "fsclose(): warning: close non string stream\n");
      fclose(fp);
      return;
   }
   fp->_flags = _IO_IS_FILEBUF+_IO_NO_READS+_IO_NO_WRITES+_IO_TIED_PUT_GET;
   free(fp);
*/
}

#ifdef TEST

error_(string s)
{
  perror (s);
  exit (1);
}

main (int argc, char **argv)
{
  char	buf0[] = "hello, world!\n",
	buf1[100];
  FILE	*fp;

  if (!(fp = fsopen (buf0, sizeof buf0, "r")))
    error_("fsopen");

  if (!fgets (buf1, sizeof buf1, fp))
    error_("1. fgets");
  printf ("1: got %s", buf1);

  rewind (fp);
  if (!fgets (buf1, sizeof buf1, fp))
    error_("2. fgets");
  printf ("2: got %s", buf1);

  return 0;
}

#endif
