/*
 * library: uti
 * file: fsopen.c
 *
 * Copyright  1992, 1993 Robert Joop
 *
 * how do you think sprintf(3) and sscanf(3) are implemented?
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: fsopen-generic.c,v $
 * Revision 1.2  1994/08/18  11:58:54  rj
 * fix for hp-ux
 *
 * Revision 1.1  1994/01/05  02:18:51  rj
 * fsopen.c in fsopen-generic.c umbenannt.
 * neues fsopen-linux.c von calle.
 *
 * Revision 1.1.1.1  1993/12/31  20:16:15  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: fsopen-generic.c,v 1.2 1994/08/18 11:58:54 rj Exp $";

#ifdef TEST
#define MEM_C
#endif

#include <errno.h>
#include "gdefs.h"
#include "uti.h"

#ifndef _NFILE
# define _NFILE	255
#endif

static FILE	*files;
static int	nfile;

FILE *fsopen (string buf, size_t buflen, cstring rw)
{
  int	fd;
  FILE	*fp;

  for (fp=files, fd=0; fd<nfile; fp++, fd++)
    if (!(fp->_flag & (_IOREAD|_IOWRT|_IORW)))
      break;
  if (fd == nfile)
  {
    if (nfile)
    {
      fprintf (stderr, "fsopen(): warning: more than %d open strings\n", nfile);
      files = realloc (files, (nfile+=_NFILE)*sizeof (FILE));
    }
    else
      files = malloc ((nfile+=_NFILE)*sizeof (FILE));
    if (!files)
    {
      errno = EMFILE;
      return NULL;
    }
    memset (files+(nfile-_NFILE), 0, _NFILE*sizeof (FILE));
    fp = files + fd;
  }

  fp->_base = fp->_ptr = (unsigned char *)buf;
  fp->_cnt = buflen;
#ifdef _HPUX_SOURCE
  /* by Joe Hildebrand <hildjj@fuentez.com> */
  fp->__fileL = _NFILE & 0xff;
  fp->__fileH = 0;
#else
  fp->_file = _NFILE;
#endif

  if (!strcmp (rw, "r"))
    fp->_flag = _IOREAD|_IOEOF;
  elif (!strcmp (rw, "w"))
    fp->_flag = _IOWRT|_IOEOF;
  else
    return NULL;
  return fp;
}

void fsclose (FILE *fp)
{
  if (fp->_flag & _IOWRT)
    *fp->_ptr = '\0';
  fp->_flag = 0;
}

#ifdef TEST

error_(string s)
{
  perror (s);
  exit (1);
}

main (int argc, char **argv)
{
  char	buf0[] = "hello, world!\n",
	buf1[100];
  FILE	*fp;

  if (!(fp = fsopen (buf0, sizeof buf0, "r")))
    error_("fsopen");

  if (!fgets (buf1, sizeof buf1, fp))
    error_("1. fgets");
  printf ("1: got %s", buf1);

  rewind (fp);
  memset (buf1, 0, sizeof buf1);
  if (!fgets (buf1, sizeof buf1, fp))
    error_("2. fgets");
  printf ("2: got %s", buf1);

  return 0;
}

#endif
