/*
 * program: psfilt
 * file: binstr.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: str.c,v $
 * Revision 1.1.1.1  1993/12/31  20:56:46  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: str.c,v 1.1.1.1 1993/12/31 20:56:46 rj Exp $";

#include "gdefs.h"
#include "binstr.h"

#define STEP	256

void binstrcat (t_binstr *binstr, const char *more, size_t morelen)
{
  if (binstr->buf)
  {
    if (binstr->used+morelen >= binstr->alloc)
      binstr->buf = regetmem (binstr->buf, binstr->alloc += morelen+STEP);
  }
  else
    binstr->buf = getmem (binstr->alloc = morelen+STEP);
  (void)memcpy (binstr->buf+binstr->used, more, morelen);
  binstr->used += morelen;
}

t_binstr binstrsave (const t_binstr *binstr)
{
  t_binstr rc = { binstr->used, binstr->used, memcpy (getmem (binstr->used), binstr->buf, binstr->used) };
  return rc;
}
