/*
 * program: psfilt
 * file: ucs2.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: ucs2.c,v $
 * Revision 1.1.1.1  1993/12/31  20:56:45  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: ucs2.c,v 1.1.1.1 1993/12/31 20:56:45 rj Exp $";

#include "psfilt.h"
#include "ucs2.h"
#include "ucs2list.h"

typedef struct
{
  t_ucs2	code;
  cstring	name;
} t_ucs2list;

const t_ucs2list ucs2list[] =
{
#include "ucs2list.c"
};

string strucs2 (string buf, t_ucs2 ucs2)
{
  if (ucs2 == UCS2_VOID)
    strcpy (buf, "<void>");
  else
  {
    int			len;
    const t_ucs2list	*l;

    for (l=ucs2list, len=ARRAYDIM (ucs2list); len--; l++)
      if (l->code == ucs2)
	break;
    if (len >= 0)
      sprintf (buf, "0x%04x/%s", ucs2, l->name);
    else
      sprintf (buf, "0x%04x", ucs2);
  }
  return buf;
}
