/*
 * program: psfilt
 * file: types.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: types.h,v 1.1.1.1 1993/12/31 20:56:45 rj Exp $
 * $Log: types.h,v $
 * Revision 1.1.1.1  1993/12/31  20:56:45  rj
 * erster cvs import.
 *
 */

#ifndef TYPES_H
#define TYPES_H

typedef long	t_version;

#define VERSION(maj, min)	((maj)*1000+(min))
#define VERSION_unspecified	(-1l)
#define VERSION_unknown		(-2l)

extern int	scanversion (t_version *version, cstring value);
extern int	versioncmp (t_version, t_version);
extern string	strversion (string buf, t_version);
extern t_version getversion (cstring buf);

#ifdef COLORED

typedef enum
{
  CM_void = -1,
  CM_rgb,
  CM_hsb,
} t_colormodel;

typedef struct
{
  t_colormodel	model;
  union
  {
    struct
    {
      float	red, green, blue;
    } rgb;
    struct
    {
      float	hue, saturation, brightness;
    } hsb;
  } u;
} t_color;

#endif

typedef float	t_point; /* has to be float or double! */

typedef struct
{
  t_point	x, y;
} t_vector;

extern t_vector		vector (t_point x, t_point y);
extern t_vector		vecadd (const t_vector *, const t_vector *);

typedef t_vector	t_width;	/* width in both directions of characters	*/

extern t_width		scalewidth (t_width width, t_point factor);

typedef struct
{
  t_point	width, height;
} t_dimension;

typedef struct
{
  t_point	llx, lly, urx, ury;	/* lower left and upper right	*/
} t_rectangle;

typedef enum
{
  LS_solid,
  LS_dashed,
  LS_dotted,
  LS_dash_dotted,
  LS_dash_dot_dotted,
} t_linestyle;

typedef struct
{
#ifdef COLORED
  t_color	color;
#endif
  t_point	width;
  t_linestyle	style;
} t_line;

typedef enum
{
  ADJleft, ADJtop = ADJleft,
  ADJcenter,
  ADJright, ADJbottom = ADJright,
} t_adjustment;

#endif TYPES_H
