/*
 * program: psfilt
 * file: types.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: types.c,v $
 * Revision 1.1.1.1  1993/12/31  20:56:46  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: types.c,v 1.1.1.1 1993/12/31 20:56:46 rj Exp $";

#include "psfilt.h"
#include "types.h"

int scanversion (t_version *version, cstring value)
{
  int	maj, min;

  if (sscanf (value, "%d.%d", &maj, &min) != 2)
    return fault;
  *version = VERSION (maj, min);
  return ok;
}

int versioncmp (t_version l, t_version r)
{
  if (l == VERSION_unspecified || r == VERSION_unspecified)
    return 0;
  if (l == VERSION_unknown)
    return -1;
  if (r == VERSION_unknown)
    return 1;
  return longcmp (l, r);
}

static cstring	version_unknown = "<unknown>",
		version_unspecified = "<unspecified>";

string strversion (string buf, t_version version)
{
  switch (version)
  {
    case VERSION_unknown:
	strcpy (buf, version_unknown);
	break;
    case VERSION_unspecified:
	strcpy (buf, version_unspecified);
	break;
    default:
	sprintf (buf, "%03ld.%03ld", version/1000, version%1000);
  }
  return buf;
}

t_version getversion (cstring buf)
{
  int	min, maj;

  if (sscanf (buf, "%d.%d", &min, &maj) == 2)
    return VERSION (maj, min);
  if (streq (buf, version_unknown))
    return VERSION_unknown;
  return VERSION_unspecified;
}

t_vector vector (t_point x, t_point y)
{
  t_vector v = { x, y };
  return v;
}

t_vector vecadd (const t_vector *l, const t_vector *r)
{
  return vector (l->x+r->x, l->y+r->y);
}

t_width scalewidth (t_width width, t_point factor)
{
  width.x *= factor;
  width.y *= factor;
  return width;
}
