/*
 * program: psfilt
 * file: token.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: token.h,v 1.2 1994/07/09 16:44:19 rj Exp $
 * $Log: token.h,v $
 * Revision 1.2  1994/07/09  16:44:19  rj
 * a lot of const's removed and added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:41  rj
 * erster cvs import.
 *
 */

#include "list.h"

#include "ucs2.h"
#include "printer.h"

typedef enum
{
  TOKEN_GLYPH,
  TOKEN_COMMAND,
} t_tokentype;

typedef enum
{
  COMMAND_START,
  COMMAND_SPACE,
  COMMAND_TAB,
  COMMAND_need_space2,
  COMMAND_need_space3,
  COMMAND_move_vertical,
  COMMAND_NEWLINE,
  COMMAND_NEWPAGE,
  COMMAND_END,
  COMMAND_MailMessage,
  COMMAND_NewsArticle,
  COMMAND_Separator,
  COMMAND_Banner,
  COMMAND_Banner3,
} t_commandtype;

typedef enum
{
  SPACE_SPACE,
  SPACE_DIGIT,
  SPACE_NARROW,
  SPACE_HALFNARROW,
  SPACE_ZERO,
} t_spacetype;

typedef struct
{
  t_line		line;
  t_point		separation;
} t_separator;

typedef struct
{
  t_commandtype		code;
  union
  {
    struct
    {
      cstring		fn;
      long		modtime;
    }			file;			/* COMMAND_START */
    t_point		spacewidth;	/* COMMAND_SPACE */
    struct
    {
      int		columns;	/* (input) */
      bool		relative;	/* vs. absolute */
      union
      {
	double		factor;		/* relative */
	t_point		size;		/* absolute */
      }			width;		/* (output) */
    }			simpletabs;	/* COMMAND_SimpleTabs */
    t_list		*tablist;	/* COMMAND_TabList */
    t_point		tabstop;	/* COMMAND_TAB */
    t_dimension		space2;		/* COMMAND_need_space2 */
    struct
    {
      t_point		width,
			ascender, descender;
    }			space3;			/* COMMAND_need_space3 */
    t_point		motion;		/* COMMAND_move_vertical */
    int			messageno;	/* COMMAND_MailMessage, COMMAND_NewsArticle */
    t_separator		separator;	/* COMMAND_Separator */
    struct
    {
      t_list		*token;
      t_adjustment	horadj;
    }			banner;		/* COMMAND_Banner */
    t_list		*banner3[3];	/* COMMAND_Banner3 */
  }			u;
} t_command;

typedef struct
{
  t_tokentype		type;
  union
  {
    t_glyph		glyph;
    t_command		command;
  }			u;
} t_token;

extern t_token		*commandtoken (t_commandtype code, ...);
#ifdef COLORED
#define GLYPHTOKEN( pfont, fontsize, color, charnames)	\
	glyphtoken (pfont, fontsize, color, charnames)
#else
#define GLYPHTOKEN( pfont, fontsize, color, charnames)	\
	glyphtoken (pfont, fontsize,        charnames)
#endif
extern t_token		*GLYPHTOKEN (t_pfont *pfont, t_point fontsize, const t_color *color, const t_cnames *charnames);
extern string		strtoken (string buf, const t_token *token);
extern int		printtoken (const t_token *, FILE *);
