/*
 * program: psfilt
 * file: token.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: token.c,v $
 * Revision 1.2  1994/07/09  16:44:17  rj
 * a lot of const's removed and added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:43  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: token.c,v 1.2 1994/07/09 16:44:17 rj Exp $";

#include <time.h>	/* ctime() */

#include "psfilt.h"
#include "error.h"
#include "token.h"

t_token *commandtoken (t_commandtype code, ...)
{
  static t_token	token;
  va_list		va;

  token.type = TOKEN_COMMAND;
  va_start (va, code);
  switch (token.u.command.code = code)
  {
    case COMMAND_START:
	if (token.u.command.u.file.fn = va_arg (va, cstring))
	  token.u.command.u.file.modtime = va_arg (va, long);
	break;

    case COMMAND_SPACE:
	{
	  t_spacetype	spacetype = va_arg (va, t_spacetype);
	  t_pfont	*pfont = va_arg (va, t_pfont *);
	  t_point	fontsize = va_arg (va, /*t_point:*/double);
#ifdef COLORED
	  t_color	color;
#endif
	  t_point	width;

#ifdef COLORED
	  clearcolor (&color); /* es wird ja nur die breite des glyphs gebraucht */
#endif
	  switch (spacetype)
	  {
	    case SPACE_SPACE:
	    case SPACE_DIGIT:
	      {
		t_cnames	reference;
		t_glyph		glyph;

		switch (spacetype)
		{
		  case SPACE_SPACE:	reference.names[0] = "space";	break;
		  case SPACE_DIGIT:	reference.names[0] = "zero";	break;
		}
		reference.count = 1;
		glyph = PSCHAR (pfont, fontsize, &color, &reference);
		width = glyph.metric->width.x * glyph.fontsize;
		break;
	      }
	    case SPACE_NARROW:
		width = fontsize / 6.;
		break;
	    case SPACE_HALFNARROW:
		width = fontsize / 12.;
		break;
	    case SPACE_ZERO:
		width = 0.;
		break;
	    default:
		ierror ("commandtoken, COMMAND_SPACE, illegal space type");
		abort();/* standard C doesn't recognize volatile for non-returning functions. but gcc knows that abort() and exit() don't return... */
	  }
	  token.u.command.u.spacewidth = width;
	}
	break;

    case COMMAND_TAB:
	token.u.command.u.tabstop = va_arg (va, /*t_point:*/double);
	break;

    case COMMAND_need_space2:
	token.u.command.u.space2 = va_arg (va, t_dimension);
	break;
    case COMMAND_need_space3:
	token.u.command.u.space3.width = va_arg (va, /*t_point:*/double);
	token.u.command.u.space3.ascender = va_arg (va, /*t_point:*/double);
	token.u.command.u.space3.descender = va_arg (va, /*t_point:*/double);
	break;

    case COMMAND_move_vertical:
	token.u.command.u.motion = va_arg (va, /*t_point:*/double);
	break;

    case COMMAND_MailMessage:
    case COMMAND_NewsArticle:
	token.u.command.u.messageno = va_arg (va, int);
	break;

    case COMMAND_Separator:
	token.u.command.u.separator.line = va_arg (va, t_line);
	token.u.command.u.separator.separation = va_arg (va, /*t_point:*/double);
	break;

    case COMMAND_Banner:
	if (token.u.command.u.banner.token = va_arg (va, t_list *))
	  token.u.command.u.banner.horadj = va_arg (va, t_adjustment);
	break;
    case COMMAND_Banner3:
      {
	int	field;
	
	for (field=0; field<3; field++)
	  token.u.command.u.banner3[field] = va_arg (va, t_list *);
	break;
      }
  }
  va_end (va);
  return &token;
}

t_token *glyphtoken (t_pfont *pfont, t_point fontsize,
#ifdef COLORED
						const t_color *color,
#endif
							const t_cnames *charnames)
{
  static t_token	token;

  token.type = TOKEN_GLYPH;
  token.u.glyph = PSCHAR (pfont, fontsize, color, charnames);
  return &token;
}

string strtoken (string buf, const t_token *token)
{
  if (!token)
    return strcpy (buf, "(null)");

  switch (token->type)
  {
    case TOKEN_GLYPH:
#ifdef COLORED
	if (!isdefaultcolor (&token->u.glyph.color))
	{
	  t_buf	color;
	  sprintf (buf, "glyph: /%s %gpt %s", token->u.glyph.metric->name, token->u.glyph.fontsize, strcolor (color, &token->u.glyph.color));
	}
	else
#endif
	sprintf (buf, "glyph: /%s %gpt", token->u.glyph.metric->name, token->u.glyph.fontsize);
	break;
    case TOKEN_COMMAND:
      {
	char *p;

	sprintf (buf, "command: code=%d: ", token->u.command.code);
	p = buf + strlen (buf);
	switch (token->u.command.code)
	{
	  case COMMAND_START:
	      if (token->u.command.u.file.fn)
		sprintf (p, "start of file: %s, mod %.24s", token->u.command.u.file.fn, ctime (&token->u.command.u.file.modtime));
	      else
		sprintf (p, "start of stdin or string");
	      break;
	  case COMMAND_TAB:
	      sprintf (p, "tab: %g", token->u.command.u.tabstop);
	      break;
	  case COMMAND_need_space2:
	      sprintf (p, "need space: w=%g, h=%g", token->u.command.u.space2.width, token->u.command.u.space2.height);
	      break;
	  case COMMAND_need_space3:
	      sprintf (p, "need space: w=%g, asc=%g, desc=%g", token->u.command.u.space3.width, token->u.command.u.space3.ascender, token->u.command.u.space3.descender);
	      break;
	  case COMMAND_move_vertical:
	      sprintf (p, "vertical motion: %g", token->u.command.u.motion);
	      break;
	  case COMMAND_NEWLINE:
	      sprintf (p, "new line");
	      break;
	  case COMMAND_NEWPAGE:
	      sprintf (p, "new page");
	      break;
	  case COMMAND_END:
	      sprintf (p, "end of file or string");
	      break;
	  case COMMAND_MailMessage:
	      sprintf (p, "Mail message #%d", token->u.command.u.messageno);
	      break;
	  case COMMAND_NewsArticle:
	      sprintf (p, "News article #%d", token->u.command.u.messageno);
	      break;
	  case COMMAND_Separator:
	      sprintf (p, "Separator w=%g sty=%d sep=%g", token->u.command.u.separator.line.width, token->u.command.u.separator.line.style, token->u.command.u.separator.separation);
	      break;
	  case COMMAND_Banner:
	      sprintf (p, "Banner ... adj=%d", token->u.command.u.banner.horadj);
	      break;
	  default:
	      strcpy (p, "?!");
	}
	break;
      }
    default:
	strcpy (buf, "?!");
  }
  return buf;
}

int printtoken (const t_token *token, FILE *fp)
{
  t_buf	buf;

  return fprintf (fp, "token: %s\n", strtoken (buf, token)) != EOF ? ok : fault;
}
