/*
 * program: psfilt
 * file: tex.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: tex.c,v $
 * Revision 1.1.1.1  1993/12/31  20:56:43  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: tex.c,v 1.1.1.1 1993/12/31 20:56:43 rj Exp $";

#include "psfilt.h"
#include "avl.h"
#include "ucs2list.h"
#include "tex.h"

typedef struct
{
  cstring	name;
  t_ucs2	ucs2;
} t_tex_stringmap;

static int strmapcmp (const t_tex_stringmap **lhs, const t_tex_stringmap **rhs)
{
  return strcmp ((*lhs)->name, (*rhs)->name);
}

static void init_strings (t_avl **strings, ...)
{
  va_list		va;
  t_tex_stringmap	*table;
  int			len;

  assert (*strings = avlcreate (sizeof (t_tex_stringmap *), strmapcmp, NULL));

  va_start (va, strings);
  while (table = va_arg (va, t_tex_stringmap *))
    for (len = va_arg (va, int); len--; table++)
      assert (avlinsert (*strings, &table));
  va_end (va);
}

static t_tex_stringmap tex_diacritic[] =	 /* INCOMPLETE!	*/
{
  "\"A", UCS2_latin_capital_letter_a_diaeresis,
  "\"O", UCS2_latin_capital_letter_o_diaeresis,
  "\"U", UCS2_latin_capital_letter_u_diaeresis,
  "\"a", UCS2_latin_small_letter_a_diaeresis,
  "\"o", UCS2_latin_small_letter_o_diaeresis,
  "\"u", UCS2_latin_small_letter_u_diaeresis,
  "\"s", UCS2_latin_small_letter_sharp_s,
};

static t_avl	*diacritics = NULL;

const t_xucs2 *texdiacritic2ucs2 (cstring name)
{
  t_tex_stringmap	search, *sp = &search, **found;

  if (!diacritics)
    init_strings (&diacritics, tex_diacritic, ARRAYDIM (tex_diacritic), NULL);

  search.name = name;
  if (found = (t_tex_stringmap **)avlsearch (diacritics, &sp))
  {
    static t_xucs2	xucs2;

    xucs2.count = 1;
    xucs2.codes[0] = (*found)->ucs2;
    return &xucs2;
  }
  else
    return NULL;
}
