/*
 * program: psfilt
 * file: strdeesc.c
 *
 * Copyright  1991 Jrn Schulze
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: strdeesc.c,v $
 * Revision 1.1.1.1  1993/12/31  20:56:45  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: strdeesc.c,v 1.1.1.1 1993/12/31 20:56:45 rj Exp $";

#include <ctype.h>
#ifdef BUG0
# undef tolower
# define tolower(c) (isupper (c) ? _tolower (c) : (c))
#endif

#include "gdefs.h"
#include "strdeesc.h"

string strdeesc (string s)
{
  string	in = s, out = s;

#define	OCTSUM	{								\
		  for (sum=i=0; i<3; i++)	/* at most 3 digits */		\
		    if (*in<'0' || *in>'7')					\
		      break;			/* no oct digit: sum ready */	\
		    else							\
		      sum = (sum<<3) | (*in++-'0');	/* oct sum */		\
		  *out++ = (char) sum;	/* write numeral escape */	\
		}

#define	DECSUM	{								\
		  for (sum=i=0; i<3; i++)	/* at most 3 digits */		\
		    if (*in<'0' || *in>'9')					\
		      break;			/* no digit: sum ready */	\
		    else							\
		      sum = (sum*10) + (*in++-'0');	/* dec sum */		\
		  *out++ = (char) sum;	/* write numeral escape */	\
		}

#define	HEXSUM	{								\
		  for (sum=i=0; i<2; i++)	/* at most 2 digits */		\
		    if (*in>='0' && *in<='9')				\
		      sum = (sum<<4) | (*in++-'0');	/* hex sum */		\
		    elif (e=tolower(*in), e>='a' && e<='f')			\
		      sum = (sum<<4) | (*in++-'a');	/* hex sum */		\
		    else							\
		      break;			/* no hex digit: sum ready */	\
		  *out++ = (char) sum;	/* write numeral escape */	\
		}

  int	i, sum, e;

  while (*in != '\0')
  {
    if (*in == '\\')
      switch (*++in)
      {
	case 'n':	*out++ = '\n';	in++; break;	/* realize escapes */
	case 't':	*out++ = '\t';	in++; break;	/* normally done by */
	case 'b':	*out++ = '\b';	in++; break;	/* the c compiler */
	case 'r':	*out++ = '\r';	in++; break;
	case 'f':	*out++ = '\f';	in++; break;
	case 'a':	*out++ = '\a';	in++; break;
	case 'd':			in++; DECSUM break;
	case 'x':			in++; HEXSUM break;
	default:	if (*in<'0' || *in>'7')
			  *out++ = *in++;		/* no special escape */
			else
			  OCTSUM
      }
    else
      *out++ = *in++;			/* copy */
  }
  *out = '\0';
  return s;
}
