/*
 * program: psfilt
 * file: str.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: str.c,v $
 * Revision 1.2  1994/07/09  16:44:15  rj
 * a lot of const's removed and added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:46  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: str.c,v 1.2 1994/07/09 16:44:15 rj Exp $";

#include "gdefs.h"
#include "avl.h"
#include "str.h"

#ifdef NEED_STRCASECMP

#include <ctype.h>

int strcasecmp (cstring s1, cstring s2)
{
  int	cp;

  while (*s1 && *s2)
    if (cp = (tolower (*s1++) - tolower (*s2++)))
      return cp;
  return *s1 ? 1 : *s2 ? -1 : 0;
}

#endif

string chop (string s)
{
  s[strlen (s)-1] = '\0';
  return s;
}

#ifdef _DEBUG_MALLOC_INC
/* dbmalloc defines strcmp as a macro with arguments, but we need a function for avlcreate... */
static int _strcmp (const char *l, const char *r)
{
  return strcmp (l, r);
}
#endif

string strunique (string s)
{
  static t_avl	*strings = NULL;
  bool		insert = true;

  if (!strings)
#ifdef _DEBUG_MALLOC_INC
    strings = avlcreate (0, _strcmp, NULL);
#else
    strings = avlcreate (0, strcmp, NULL);
#endif

  return avlinsrch (strings, &insert, s, strlen (s)+1);
}

int str0cmp (cstring l, cstring r)
{
  if (!l)
    return -1;
  if (!r)
    return 1;
  return strcmp (l, r);
}

int str00cmp (cstring l, cstring r)
{
  if (!l && !r)
    return 0;
  return str0cmp (l, r);
}

int getstring (const char *from, char **to)
{
  t_buf	lenbuf;
  int	lenlen, len;

  if (sscanf (from, "%[^:]", lenbuf) != 1)
    return fault;
  if (sscanf (lenbuf, "%d", &len) != 1)
    return fault;
  lenlen = strlen (lenbuf) + 1;
  if (len == -1)
  {
    *to = NULL;
    return lenlen;
  }
  if (strlen (from) < lenlen+len)
    return fault;
  memcpy (*to, from+lenlen, len);
  (*to)[len] = '\0';
  return lenlen+len;
}

int putstring (const char *from, FILE *into)
{
  int	len;

  len = from ? strlen (from) : -1;
  if (fprintf (into, "%d:", len) == EOF)
    return fault;
  return !from || fwrite (from, len, 1, into) == 1 ? ok : fault;
}
