/*
 * program: psfilt
 * file: ps.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: ps.h,v 1.5 1994/08/18 12:13:33 rj Exp $
 * $Log: ps.h,v $
 * Revision 1.5  1994/08/18  12:13:33  rj
 * fix for postscript parser font caches that ignore reencoding changes.
 *
 * Revision 1.4  1994/07/09  16:44:12  rj
 * a lot of const's removed and added
 *
 * Revision 1.3  1994/03/18  12:24:09  rj
 * new glyph `envelope' added.
 *
 * Revision 1.2  1994/01/09  23:46:12  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:40  rj
 * erster cvs import.
 *
 */

#include "avl.h"
#include "afm.h"
#include "fonts.h"
#include "color.h"

typedef struct
{
  cstring	fontname;
					/* corresponds to: */
  t_avl		*charstrings;		/* /CharStrings		char name -> code, if (code != -1) => encoding[code] == char name */
  cstring	encoding[256];		/* /Encoding		(current) encoding */
  int		emptyslots;		/* zahl der leeren slots in encoding[] */
} t_softfont;

typedef struct
{
  cstring	name;
  int		code;
} t_pschar;

extern int	pscharpcmp (const t_pschar *, const t_pschar *);

#if 0
/* die struktur wird nur fr soft-fonts benutzt.	*/
/* fr die built-in fonts wird t_afm benutzt.		*/
typedef struct
{
  cstring	name;
  t_version	fontversion;		/* iff known from PPD file */
  t_fontfamily	*fontfamily;
} t_psfont;
#endif

typedef enum
{
/* Prolog: */
  Header,
  Procedures,
/* Script: */
  Setup,
  Pages,
  Trailer,
} t_component;

typedef enum
{
  DSC_Clean7bit,
  DSC_Clean8bit,
  DSC_Binary,
} t_dscdata;

typedef struct
{
  int		printer, output;
} t_langlevels;

extern t_dscdata	dscdata;
extern bool		structured;	/* produce output according to Document Structuring Conventions (DSC) */
extern t_langlevels	languagelevels;

#define INTERNALFONT_NAME	"-psfilt-font-"		/* name of internal font */
#define INTERNALFONT_VERSION	VERSION (001,002)

extern cstring	dscdata_name (t_dscdata dscdata);

extern bool	psisfontinternal (cstring fontname, t_version *);
extern void	psinitafm (t_afmfile *),
		pscompleteafm (t_afmfile *);
extern int	psgetsymbol (string charname);

extern void	init_ps (FILE *ostream),
		finish_ps (void),

		psneededresource (cstring fmt, ...),
		pssupplyresource (FILE *istream, cstring fmt, ...),
		psfeature (cstring name, cstring value, cstring invocation),
		psstructure (t_component component, cstring fmt, ...),
		pscomment (cstring fmt, ...),

		psdupfont (cstring oldname, cstring newname),
		psfindfont (cstring fontname),				/* puts a fontdict on stack top */
		psaddmap (t_softfont *font, const cstring *newencoding, int count), /* assumes that a fontdict is on stack top */
		psscalesetfont (t_point factor),			/* assumes that a fontdict is on stack top, removes it */
		psfindscalesetfont (cstring fontname, t_point factor),

		psgsave (void),
		psgrestore (void),
		pstranslate (t_vector point),
		psrotate (double angle),

		psmoveto (t_vector point),
		psmovetoalign (t_vector point),
		pssetlinewidthandstyle (const t_line *line),
		psrlineto (t_vector point),
		psstroke (void),

		pssetgray (double shade),
#ifdef COLORED
		pssetcolor (const t_color *color),
#endif
		psclosepath (void),
		psfill (void),
		psgraybox (t_vector offset, t_dimension area, double shade),
		psbannerbox (t_vector offset, t_dimension area),

		psshow (const uchar *s, size_t len),
		pskxshow (const uchar *s, const t_point *wx, size_t len),
		pskshow (const uchar *s, const t_width *w, size_t len),
		psshowpage (void);
