/*
 * program: psfilt
 * file: printer.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: printer.h,v 1.4 1994/07/09 16:44:10 rj Exp $
 * $Log: printer.h,v $
 * Revision 1.4  1994/07/09  16:44:10  rj
 * a lot of const's removed and added
 *
 * Revision 1.3  1994/03/18  12:07:38  rj
 * support for duplex mode added
 * lots of missing `#ifdef COLORED' inserted
 *
 * Revision 1.2  1994/01/09  23:46:10  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:40  rj
 * erster cvs import.
 *
 */

#include "list.h"
#include "avl.h"

#include "ps.h"
#include "ppd.h"
#include "afm.h"
#include "fonts.h"
#include "cache.h"
#include "names.h"

typedef struct
{
  string	printertype;
  string	papertype;
  string	duplexmode;
} t_printerspec;

/*	eingebaute und externe fonts werden solange benutzt, wie ihr /Encoding ausreicht;
	erst wenn das nicht mehr der fall ist, mssen sie dupliziert werden. */
#define FONT_UNAVAILABLE	0x01	/* font ist nicht verfgbar */
#define FONT_BUILTIN		0x02	/* font ist in Drucker eingebaut */
#define FONT_INTERN		0x04	/* interner font von psfilt (INTERN_FONTNAME) */
#define FONT_EXTERN		0x08	/* font ist nicht in Drucker eingebaut, wird ggf. geladen */
#define FONT_INSTALLED		0x10	/* font befindet sich im Drucker */
#define FONT_DUPLICATED		0x20	/* font befindet sich doppelt im Drucker */

typedef struct		/* font as currently in the printer */
{
  t_font	*font;
  t_version	reqversion;
  int		flags;			/* see FONT_... above */
  t_avl		*misschars;		/* chars requested but unavailable */
  union
  {
    t_version	fontversion;		/* version of builtin/external font, may differ from afm->Version */
    t_fontfile	*external;		/* for external fonts */
  } u;
  t_afmfile	*afm;
  t_softfont	*dup;			/* copy where /Encoding may be changed */
} t_pfont;

typedef struct
{
  t_pfont		*pfont;
  t_point		fontsize;
#ifdef COLORED
  t_color		color;
#endif
  const t_charmetric	*metric;
} t_glyph;

typedef struct
{
  string	charname;
  t_point	ascender, descender;
  t_width	width;
} t_glyphinfo;

extern bool		abortoncharunavail;

extern void		init_printer (t_printerspec *printerspec, FILE *printer);
extern void		get_imageablearea (t_rectangle *imageablearea);

extern t_pfont		*getpfont (const t_cnames *fontnames, t_version);
extern void		resetpfonts (void);
#ifdef COLORED
#define PSCHAR( pfont, fontsize, color, charnames)	\
	pschar (pfont, fontsize, color, charnames)
#else
#define PSCHAR( pfont, fontsize, color, charnames)	\
	pschar (pfont, fontsize,        charnames)
#endif
extern t_glyph		PSCHAR (t_pfont *pfont, t_point fontsize, const t_color *color, const t_cnames *charnames);
extern void		getglyphinfo (const t_glyph *glyph, t_point scalefactor, t_glyphinfo *glyphinfo);

#ifdef COLORED
extern void		setcolor (const t_color *color);
#endif
extern void		setline (const t_line *line);
extern void		findfont (t_pfont *pfont, t_point fontsize);
extern int		encodefont (cstring charname);
extern void		setfont (void);
extern void		show (uchar *s, size_t len);
extern void		kxshow (uchar *s, const t_point *kx, size_t len);
extern void		kshow (uchar *s, const t_width *k, size_t len);
