/*
 * program: psfilt
 * file: ppd.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: ppd.h,v 1.4 1994/07/09 16:44:07 rj Exp $
 * $Log: ppd.h,v $
 * Revision 1.4  1994/07/09  16:44:07  rj
 * a lot of const's removed and added
 *
 * Revision 1.3  1994/03/18  12:07:36  rj
 * support for duplex mode added
 * lots of missing `#ifdef COLORED' inserted
 *
 * Revision 1.2  1994/01/09  23:46:06  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:40  rj
 * erster cvs import.
 *
 */

#ifndef PPD_H
#define PPD_H

#include "list.h"
#include "avl.h"
#include "afm.h"
#include "binstr.h"

typedef struct
{
  enum
  {
    PPD_StringOption,
    PPD_SymbolOption,
  }		type;
  string	value;
} t_ppdoption;

typedef struct
{
  enum
  {
    PPD_InvocationValue,
    PPD_QuotedValue,
    PPD_SymbolValue,
    PPD_StringValue,
  }		type;
#if BINARY_STRINGS
  union
  {
    string	str;
    t_binstr	bin;
  }		value;
#else
  string	value;
#endif
} t_ppdvalue;

typedef struct
{
  string	name;
  t_ppdvalue	value;
} t_ppdcap;

int ppdcappcmp (const t_ppdcap *l, const t_ppdcap *r);

typedef struct
{
  string	name;
  string	_default;
  t_avl		*list;		/* t_ppdcap sorted by name */
} t_ppdcaplist;

int ppdcaplistpcmp (const t_ppdcaplist *l, const t_ppdcaplist *r);

typedef struct
{
  string	fontname;
  t_version	version;
} t_ppdfont;

int ppdfontpcmp (const t_ppdfont *l, const t_ppdfont *r);

typedef struct
{
  string	_default;
  t_avl		*fonts;		/* t_ppdfont sorted by fontname */
} t_ppdfonts;

typedef struct
{
  string	name;
  string	value;
} t_ppdsymbol;

int ppdsymbolpcmp (const t_ppdsymbol *l, const t_ppdsymbol *r);

typedef struct
{
  t_avl		*caps;
  t_avl		*caplists;
  t_ppdfonts	fonts;
  t_avl		*symbols;
} t_ppd;

extern int	handle_key (t_ppd *ppd, string name),
		handle_cap (t_ppd *ppd, string name, t_list *values),
		handle_caplist (t_ppd *ppd, string name, const t_ppdoption *option, t_list *values),
		handle_default (t_ppd *ppd, string name, const t_ppdvalue *stringval),
		handle_query (t_ppd *ppd, string name, const t_ppdvalue *quotedval);

extern int	finish_ppd (string printername, t_ppd *ppd);



typedef struct
{
  string	name;
  string	invocation;
  t_dimension	size;
  t_rectangle	imageablearea;
} t_paperinfo;

typedef struct
{
  string	name;
  string	invocation;
} t_duplexinfo;

extern void	clear_ppd (t_ppd *ppd);
extern void	print_ppd (const t_ppd *ppd, FILE *fp);
extern void	free_ppd (t_ppd *ppd);

/* information functions:	*/
#if BINARY_STRINGS
extern const t_binstr	*getname (t_ppd *ppd);
extern const t_binstr	*getproduct (t_ppd *ppd);
#else
extern string	getname (t_ppd *ppd);
extern string	getproduct (t_ppd *ppd);
#endif
extern bool	iscolordevice (const t_ppd *);
extern bool	isfontbuiltin (const t_ppd *, string fontname, t_version *);
extern int	getlanguagelevel (const t_ppd *);
extern int	getpaperinvocation (const t_ppd *ppd, string papertype, string *invocation);
extern int	getpaperdimension (const t_ppd *ppd, string papertype, t_dimension *size);
extern int	getimageablearea (const t_ppd *ppd, string papertype, t_rectangle *area);
extern int	getpaperinfo (const t_ppd *ppd, string papertype, t_paperinfo *paperinfo);
extern int	getduplexinfo (const t_ppd *ppd, string duplexmode, t_duplexinfo *duplexinfo);
extern void	listduplexmodes (const t_ppd *ppd);

/* defined in parse-ppd.y:	*/
extern t_list	*ppddirs;
extern void	listppdfiles (void);
extern int	readppd (string printername, t_ppd *ppd);

#endif PPD_H
