/*
 * program: psfilt
 * file: parse-ppd.y
 *
 * Copyright  1992 1993 Robert Joop
 *
 * Parsing of .PPD files (PostScript Printer Description).
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: parse-ppd.y,v $
 * Revision 1.3  1994/07/09  16:44:04  rj
 * a lot of const's removed and added
 *
 * Revision 1.2  1994/01/09  23:46:00  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:38  rj
 * erster cvs import.
 *
 */

%{

static const char RCSId[] = "$Id: parse-ppd.y,v 1.3 1994/07/09 16:44:04 rj Exp $";

#if YYDEBUG_PPD
#  define YYDEBUG	1
#endif
#if YYDEBUG
#  define YYERROR_VERBOSE
#  define YYPRINT(file, type, value)   yyprintinput (file, type, value)
  static void yyprintinput();
#endif

#define yylex	lex_ppd
#define yyparse	parse_ppd
#define yyerror	ppderror

#include "psfilt.h"
#include "ppd.h"
#include "lex-ppd.h"
#include "mem.h"
#include "dirs.h"

static t_ppd		*PPD;	/* variable parse_ppd() writes into	*/

static void ppderror (cstring msg)
{
  ppdsay (IMP_error, "%s", msg);
}

%}

%pure_parser

%union
{
  t_buf		key;
  t_ppdoption	option;
  t_ppdvalue	value;
  t_list	*values;
}

%token <key>	Keyword
%token <key>	DefaultKeyword
%token <key>	QueryKeyword
%token <option>	Option
%token <value>	InvocationVal
%token <value>	QuotedVal
%token <value>	SymbolVal
%token <value>	StringVal

%type <values>	values
%type <value>	value

%start PPDinput

%%

PPDinput	:	lines
		;

lines		:	lines line
		|	empty
		;

empty		:
		;

line		:	Keyword
			{
			  if (handle_key (PPD, $1))
			    YYERROR;
			}
		|	Keyword values
			{
			  if (handle_cap (PPD, $1, $2))
			    YYERROR;
			}
		|	Keyword Option values
			{
			  if (handle_caplist (PPD, $1, &$2, $3))
			    YYERROR;
			}
		|	DefaultKeyword StringVal
			{
			  if (handle_default (PPD, $1, &$2))
			    YYERROR;
			}
		|	QueryKeyword QuotedVal
			{
			  if (handle_query (PPD, $1, &$2))
			    YYERROR;
			}
		;

values		:	value
			{
			  $$ = licreate (sizeof (t_ppdvalue), NULL, NULL);
			  liappend ($$, &$1);
			}
		|	values value
			{
			  $$ = $1;
			  liappend ($$, &$2);
			}
		;

value		:	InvocationVal
		|	QuotedVal
		|	SymbolVal
		|	StringVal
		;

%%

#if YYDEBUG
  static void yyprintinput (FILE *file, int type, YYSTYPE value)
  {
    switch (type)
    {
      case Keyword:
	fprintf (file, " %s", value.key);
	break;
      case DefaultKeyword:
	fprintf (file, " default %s", value.key);
	break;
      case QueryKeyword:
	fprintf (file, " query %s", value.key);
	break;
      case Option:
	switch (value.option.type)
	{
	  case PPD_StringOption:
	    fprintf (file, " %s", value.option.value);
	    break;
	  case PPD_SymbolOption:
	    fprintf (file, " ^%s", value.option.value);
	    break;
	}
	break;
    }
  }
#endif

int readppd (string printername, t_ppd *ppd)
{
  int		rc;

#if YYDEBUG
  yydebug = true;
#endif

  say (IMP_entertain, "loading description for printer \"%s\"\n", printername);
  clear_ppd (PPD = ppd);
  if (push_ppdlexer (JT_printer, printername))
  {
    say (IMP_warning, "can't open .PPD file for \"%s\"\n", printername);
    return fault;
  }
  rc = parse_ppd();

  return rc ? rc : finish_ppd (printername, ppd);
}
