/*
 * program: psfilt
 * file: output.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: output.h,v 1.3 1994/07/09 16:43:59 rj Exp $
 * $Log: output.h,v $
 * Revision 1.3  1994/07/09  16:43:59  rj
 * a lot of const's removed and added
 *
 * Revision 1.2  1994/01/09  23:45:56  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:40  rj
 * erster cvs import.
 *
 */

#ifndef OUTPUT_H
#define OUTPUT_H

#include "list.h"
#include "fonts.h"
#include "cache.h"

typedef struct	/* global output style */
{
  bool			landscape;
  struct
  {
    t_point		left, right, top, bottom;
  }			borderwidth;
  struct
  {
    t_point		sheet;
  }			headerheight;
  int			columns;
  t_point		columnsep;
}			t_goutput;

typedef struct
{
  bool			landscape;
  struct
  {
    bool		left, right, top, bottom;
  }			borderwidth;
  struct
  {
    bool		sheet;
  }			headerheight;
  bool			columns;
  bool			columnsep;
} t_goutputbools;

typedef enum
{
  LNSPautomatic,
  LNSPfixed,
  LNSPminimum,		/* semiautomatic, so that blank lines don't collapse */
} t_linespacing;

typedef struct
{
  string		family;
  t_fontrendition	rendition;
  t_point		size;
} t_fontspec;

typedef struct	/* file output style */
{
  struct
  {
    t_point		file, page, banner, userbanner;
  }			headerheight;
#ifdef COLORED
  t_color		color[N_IOM];
#endif
  t_fontspec		font[N_IOM];
  struct
  {
    t_linespacing	automatic;	/* vs. fixed */
    bool		relative;	/* vs. absolute */
    union
    {
      double		factor;		/* relative */
      t_point		size;		/* absolute; semantic depends on mode:
				    automatic:	inter-line spacing
				    fixed:	absolute height	*/
    }			height;
    t_point		minheight;
  }			linespacing;
  /* usage of the following two depend on t_inout.tabmode: */
  struct
  {
    bool		relative;	/* vs. absolute */
    union
    {
      double		factor;		/* relative to font size */
      t_point		size;		/* absolute (independent of font size) */
    } width;
  }			tabs;
  t_list		*tablist;
} t_foutput;

typedef struct
{
  struct
  {
    bool		file, page, banner, userbanner;
  }			headerheight;
  bool			color[N_IOM];
  struct
  {
    bool		family;
    struct
    {
      bool		weight, italic;
    }			rendition;
    bool		size;
  }			font[N_IOM];
  struct
  {
    bool		height;
    bool		minheight;
  }			linespacing;
  struct
  {
    bool		width;
  }			tabs;
  bool			tablist;
} t_foutputbools;

#define KERN_pairwise	0x01
#define KERN_track	0x02

extern int		kernflags;

extern void 		init_output (t_printerspec *printerspec, FILE *ostream, cstring username, t_inputtype inputtype, const t_goutput *goutput, t_list *jobs);
extern void		process (t_list *jobs);

#endif OUTPUT_H
