/*
 * program: psfilt
 * file: opt.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * option handling
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: opt.c,v $
 * Revision 1.4  1994/07/09  17:21:48  rj
 * stopping to read at NUL characters stopped
 *
 * Revision 1.3  1994/07/09  16:43:56  rj
 * a lot of const's removed and added
 *
 * Revision 1.2  1994/07/09  15:34:18  rj
 * stuff for configuration via GNU autoconf added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:46  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: opt.c,v 1.4 1994/07/09 17:21:48 rj Exp $";

/* AIX requires this to be the first thing in the file.  */
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not __GNUC__ */
#if HAVE_ALLOCA_H
#include <alloca.h>
#else /* not HAVE_ALLOCA_H */
#ifdef _AIX
 #pragma alloca
#else /* not _AIX */
char *alloca ();
#endif /* not _AIX */
#endif /* not HAVE_ALLOCA_H */
#endif /* not __GNUC__ */

#include "psfilt.h"
#include "lex-input.h"
#include "verbose.h"
#include "error.h"
#include "opt.h"

static int metaoptpcmp (t_metaoption *l, t_metaoption *r)
{
  return strcmp (l->name, r->name);
}

static t_avl	*metaoptions;

#define MAXARGS	256

void init_metaoptions()
{
  cstring	home = getenv ("HOME");
  t_fnbuf	fn;
  FILE		*fp;

  t_input	input;
  t_inout	inout;
  int		lineno = 1,
		colno = 0;
  t_inputtoken	lval;
  int		c;
  bool		insert;
  t_metaoption	*metaoption = alloca (sizeof (t_metaoption)+MAXARGS*sizeof (cstring));

  if (!metaoptions)
    metaoptions = avlcreate (0, metaoptpcmp, NULL);

  if (!home)
  {
    say (IMP_warning, "HOME is not set");
    return;
  }
  sprintf (fn, "%s/.psfilt", home);
  if (!(fp = fopen (fn, "r")))
  {
    say (IMP_warning2, "can't open %s\n", fn);
    return;
  }

  input.type = IT_options;
  input.translation = TRLT_none;

  inout.mode = IOM_lit;
  inout.tabmode = TMsimple;

  metaoption->name = NULL;
  pushlexjob (fn, fp, &input, &inout, &lineno, &colno);
  while ((c = lex_input (&lval)) != YY_NULL)
    switch (c)
    {
      case OPT_NAME:
	metaoption->name = lval.option;
	metaoption->locked = false;
	metaoption->args.count = 0;
	break;
      case OPT_ARG:
	metaoption->args.names[metaoption->args.count++] = lval.option;
	if (metaoption->args.count == MAXARGS)
	  ierror ("file %s, line %d: rhs of metaoption may only have %d args.", fn, lineno, MAXARGS);
	break;
      case END_OPT:
	if (metaoption->name)
	{
	  insert = true;
	  avlinsrch (metaoptions, &insert, metaoption, sizeof (t_metaoption)+(metaoption->args.count-1)*sizeof (cstring));
	  if (!insert)
	    error ("file %s, line %d: duplicate option %s", fn, lineno-1, metaoption->name);
	  metaoption->name = NULL;
	}
	break;
      default:
	ierror ("init_metaoptions(), illegal return from lexer");
    }
  poplexjob();
  fclose (fp);
}

t_names *getmetaopt_lock (cstring option)
{
  t_metaoption	search, *found;

  search.name = option;
  found = avlsearch (metaoptions, &search);
  if (found)
  {
    if (found->locked)
    {
      say (IMP_entertain, "recursive meta option \"%s\": translation aborted\n", option);
      return NULL;
    }
    else
    {
      if (VERBp (IMP_entertain))
      {
	int n;
	say (IMP_entertain, "translating meta option \"%s\":", option);
	for (n=0; n<found->args.count; n++)
	  say (IMP_entertain, " \"%s\"", found->args.names[n]);
	say (IMP_entertain, "\n");
      }
      found->locked = true;
      return &found->args;
    }
  }
  else
    return NULL;
}

void metaopt_unlock (cstring option)
{
  t_metaoption	search, *found;

  search.name = option;
  if (found = avlsearch (metaoptions, &search))
    found->locked = false;
  else
    ierror ("metaopt_unlock: can't find option %s", option);
}
