/*
 * program: psfilt
 * file: mnemo.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * Conversion of RFC 1345 mnemonics into UCS2.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: mnemo.c,v $
 * Revision 1.1.1.1  1993/12/31  20:56:48  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: mnemo.c,v 1.1.1.1 1993/12/31 20:56:48 rj Exp $";

#include "psfilt.h"
#include "avl.h"
#include "ucs2list.h"
#include "mnemo.h"
#include "verbose.h"
#include "error.h"

/* abbildung UCS2 / PostScript name (eine m:n beziehung) */
typedef struct
{
  cstring	mnemonic;
  t_ucs2	ucs2;
} t_map;

#if 0 /* unused: */
static int mapucs2cmp (l, r)	/* zur sortierung nach UCS2	*/
t_map	**l, **r;
{
  return ucs2cmp ((*l)->ucs2, (*r)->ucs2);
}
#endif

static int mapmnemocmp (l, r)	/* zur sortierung nach PostScript namen	*/
t_map	**l, **r;
{
  return strcmp ((*l)->mnemonic, (*r)->mnemonic);
}

static const t_map table[] =		/* abbildung mnemonic UCS2	*/
{
#include "mnemomap.c"
};

static t_avl	*mnemos = NULL;

static void init_mnemos()
{
  int		len;
  const t_map	*mnemo;

  mnemos = avlcreate (sizeof (t_map *), mapmnemocmp, NULL); assert (mnemos);
  for (mnemo=table, len=ARRAYDIM (table); len--; mnemo++)
    if (!avlinsert (mnemos, &mnemo))
      ierror ("init_mnemos(): duplicate at `%s'", mnemo->mnemonic);
}

const t_xucs2 *mnemo2glyph (cstring mnemo)
{
  t_map		search;
  const t_map	*sp = &search, **found;

  if (!mnemos)
    init_mnemos();

  search.mnemonic = mnemo;
  if (found = avlsearch (mnemos, &sp))
  {
    static t_xucs2	xucs2;

    xucs2.count = 1;
    xucs2.codes[0] = (*found)->ucs2;
    return &xucs2;
  }
  else
    return NULL;
}
