/*
 * program: psfilt
 * file: mem.h
 *
 * Copyright  1992 1993 Robert Joop
 *
 * memory allocation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mem.h,v 1.5 1994/07/09 17:06:43 rj Exp $
 * $Log: mem.h,v $
 * Revision 1.5  1994/07/09  17:06:43  rj
 * fix for systems where {re,m}alloc() is a macro, not a function
 *
 * Revision 1.4  1994/07/09  16:43:53  rj
 * a lot of const's removed and added
 *
 * Revision 1.3  1994/07/09  15:34:16  rj
 * stuff for configuration via GNU autoconf added
 *
 * Revision 1.2  1994/01/09  23:45:53  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:47  rj
 * erster cvs import.
 *
 */

#ifndef MEM_H
#define MEM_H

#ifndef MEM_C

#ifdef HAVE_MALLOC_H
#undef malloc
#undef realloc
#define malloc	hidden_malloc
#define realloc	hidden_realloc
#include <malloc.h>
#undef realloc
#undef malloc
#endif

#define malloc	getmem
#define realloc	regetmem

#endif /* MEM_C */

extern void	*getmem (size_t size);
extern void	*getmem0 (size_t size);
extern void	*regetmem (void *p, size_t size);

extern string	strsave (string s);
extern string	strnsave (string s, size_t max);
extern string	strfree (string s);

#endif /* MEM_H */
