/*
 * program: psfilt
 * file: mem.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: mem.c,v $
 * Revision 1.5  1994/07/09  17:15:08  rj
 * MEM_C has to be defined before mem.h is included!
 *
 * Revision 1.4  1994/07/09  17:06:42  rj
 * fix for systems where {re,m}alloc() is a macro, not a function
 *
 * Revision 1.3  1994/07/09  16:43:52  rj
 * a lot of const's removed and added
 *
 * Revision 1.2  1994/01/09  23:45:52  rj
 * PPD parser fr version 4 PPD files total umgeschrieben.
 * partieller support fr perl.
 *
 * Revision 1.1.1.1  1993/12/31  20:56:47  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: mem.c,v 1.5 1994/07/09 17:15:08 rj Exp $";

#define MEM_C
#include "psfilt.h"
#include "mem.h"
#include "error.h"

string strsave (string s)
{
  size_t	len;

  if (!s)
    return NULL;
  len = strlen (s)+1;
  return memcpy (getmem (len), s, len);
}

string strnsave (string s, size_t max)
{
  int		len;
  string	new;

  if (!s)
    return NULL;
  len = strnlen (s, max);
  new = getmem (len+1);
  new[len] = '\0';
  return memcpy (new, s, len);
}

string strfree (string s)
{
  if (s)
    free (s);
  return NULL;
}

void *getmem (size_t size)
{
  void	*p;

  if (!(p = malloc (size)))
    error ("getmem: can't get %d bytes of memory", size);
  return p;
}

void *getmem0 (size_t size)
{
  return memset (getmem (size), 0, size);
}

void *regetmem (void *p, size_t size)
{
  if (!(p = realloc (p, size)))
    error ("regetmem: can't get %d bytes of memory", size);
  return p;
}
