/*
 * program: psfilt
 * file: mail.c
 *
 * Copyright  1992 1993 Robert Joop
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: mail.c,v $
 * Revision 1.2  1994/07/09  15:34:13  rj
 * stuff for configuration via GNU autoconf added
 *
 * Revision 1.1.1.1  1993/12/31  20:56:44  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: mail.c,v 1.2 1994/07/09 15:34:13 rj Exp $";

#include "psfilt.h"
#include "avl.h"
#include "mail.h"

typedef struct
{
  string		fieldname;
  t_point		sizefactor;
  t_fontrendition	fontrendition;
} t_mailrendition;

static const t_mailrendition mailrendition_table[] =
{
  "Path", 0.3, FONTWEIGHT_normal, false,	/* (news) */
  "Return-path", .3, FONTWEIGHT_normal, false,	/* (mail) */
  "Received", .3, FONTWEIGHT_normal, false,	/* (mail) */
  "Distribution", .3, FONTWEIGHT_normal, false,	/* (news) */
  "Organisation", .3, FONTWEIGHT_normal, false,
  "Lines", .3, FONTWEIGHT_bold, false,		/* (news) */
  "Followup-To", .7, FONTWEIGHT_bold, false,	/* (news) */
  "Xref", .3, FONTWEIGHT_bold, false,		/* (news) */
  "Newsgroups", .3, FONTWEIGHT_bold, false,	/* (news) */
  "Newsgroup", .3, FONTWEIGHT_bold, false,	/* (news) */

  "From", 1.0, FONTWEIGHT_bold, false,		"Resent-From", 1.0, FONTWEIGHT_bold, false,
  "Sender", 1.0, FONTWEIGHT_bold, false,	"Resent-Sender", 1.0, FONTWEIGHT_bold, false,
  "Reply-To", 1.0, FONTWEIGHT_bold, false,	"Resent-Reply-To", 1.0, FONTWEIGHT_bold, false,
  "To", 1.0, FONTWEIGHT_bold, false,		"Resent-To", 1.0, FONTWEIGHT_bold, false,
  "Cc", 1.0, FONTWEIGHT_normal, false,		"Resent-Cc", 1.0, FONTWEIGHT_normal, false,
  "Bcc", 1.0, FONTWEIGHT_normal, false,		"Resent-Bcc", 1.0, FONTWEIGHT_normal, false,
  "Date", 1.0, FONTWEIGHT_bold, true,		"Resent-Date", 1.0, FONTWEIGHT_bold, true,

  "Message-ID", .3, FONTWEIGHT_normal, false,	"Resent-Message-ID", .3, FONTWEIGHT_normal, false,
  "In-Reply-To", .7, FONTWEIGHT_normal, false,
  "References", .5, FONTWEIGHT_normal, false,
  "Keywords", .5, FONTWEIGHT_normal, false,	/* (rfc822) */
  "Subject", 1.5, FONTWEIGHT_bold, false,
  "Summary", 1.5, FONTWEIGHT_bold, false,	/* (news) */
  "Comments", 1.0, FONTWEIGHT_bold, false,	/* (rfc822) */
  "Encrypted", 1.0, FONTWEIGHT_bold, true,	/* (rfc822) */
};

static int mailrenditionppcmp (t_mailrendition **l, t_mailrendition **r)
{
  return strcasecmp ((*l)->fieldname, (*r)->fieldname);
}

static t_avl	*mailrenditions = NULL;

static void init_mailrenditions()
{
  int			len;
  const t_mailrendition	*table;

  assert (mailrenditions = avlcreate (sizeof (t_mailrendition *), mailrenditionppcmp, NULL));
  for (table=mailrendition_table, len=ARRAYDIM (mailrendition_table); len--; table++)
    assert (avlinsert (mailrenditions, &table));
}

void mailrendition (cstring line, t_point *sizefactor, t_fontrendition *fontrendition)
{
  int	flen;

  if ((!memcmp (line, "From ", flen=5) || (flen = chrind (line, ':')) != fault) && flen < BUFLEN)
  {
    t_buf	fieldname;
    t_mailrendition	srch, *sp = &srch, **found;

    if (!mailrenditions)
      init_mailrenditions();

    while (strchr (" \t", line[flen-1]))
      --line;
    memcpy (srch.fieldname = fieldname, line, flen);
    fieldname[flen] = '\0';
    if (found = avlsearch (mailrenditions, &sp))
    {
      *sizefactor = (*found)->sizefactor;
      *fontrendition = (*found)->fontrendition;
      return;
    }
  }
  /* default: */
  *sizefactor = 1.0;
  fontrendition->weight = FONTWEIGHT_bold;
  fontrendition->italic = true;
}
