/*
 * library: list
 * file: livamap.c
 *
 * Copyright  1992, 1993 Robert Joop
 *
 * $Log: livamap.c,v $
 * Revision 1.1.1.1  1993/12/31  20:24:37  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: livamap.c,v 1.1.1.1 1993/12/31 20:24:37 rj Exp $";

#ifdef __STDC__
#  include <stdarg.h>
#else
#  include <varargs.h>
#endif

#define list_internal
#include "list.h"

#ifdef __STDC__
int livamap (t_list *list, int (*f)(), ...)
#else
int livamap (list, f, va_alist)
  t_list	*list;
  int		(*f)();
  va_dcl
#endif
{
  va_list	va;
  voidptr	elem;
  int		rc = ok;

  if (!list)
    return fault;
#ifdef __STDC__
  va_start (va, f);
#else !__STDC__
  va_start (va);
#endif __STDC__
  if (list->fixsize)
  {
    for (elem=lifirst (list); elem; elem=listep (list))
      if (rc = (*f)(elem, va))
	break;
  }
  else
  {
    for (elem=lifirst (list); elem; elem=listep (list))
      if (rc = (*f)(elem, va, lisize (list)))
	break;
  }
  va_end (va);
  return rc;
}
