/*
 * library: list
 * file: list.h
 *
 * Copyright  1990, 1991, 1992, 1993, 1994 Robert Joop
 *
 * $Id: list.h,v 1.1.1.1 1993/12/31 20:24:37 rj Exp $
 * $Log: list.h,v $
 * Revision 1.1.1.1  1993/12/31  20:24:37  rj
 * erster cvs import.
 *
 */

#ifndef LIST_H
#define LIST_H

#include "gdefs.h"
#include "uti.h"

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#ifdef list_internal

#  include <errno.h>

  typedef struct t_listnode
  {
    struct t_listnode	*pred,
			*succ;
    union
    {
      struct
      {
#ifdef __STDC__
	size_t	size;
#else
	long	size;
#endif
	double	dummy[0];	/* enforce double-alignment */
	char	buf[0];
      } var;
      double	dummy[0];	/* enforce double-alignment */
      char	fix[0];
    } elem;
  } t_listnode;

  typedef struct
  {
#ifdef __STDC__
    size_t	fixsize;
#else
    long	fixsize;
#endif
    int		(*cmpfunc)();
    void	(*freefunc)();
    int		length,
		position;
    t_listnode	*first,
		*last,
		*current;
  } t_list;

#else list_internal

  typedef struct t_list	t_list;		/* opaque type	*/

#endif list_internal

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

typedef enum
{
  LIINS_BEFORE,
  LIINS_AFTER,
} t_liinsside;	/* unsorted lists: list insertion side (relative to current element)	*/

#ifdef __STDC__

  extern t_list	*licreate (size_t fixsize, int (*cmpfunc)(), void (*freefunc)()),
		*liconcat (t_list *left, t_list *right),
		*lidestroy (t_list *list);

  extern void	*lifirst (t_list *list),
		*lilast (t_list *list),
		*listep (t_list *list),
		*libackstep (t_list *list),
		*ligoto (t_list *list, int pos),
		*liaddr (t_list *),

		*liinsert (t_list *list, void *newelem, ...),

		*liinsrch (t_list *list, bool *insert, void *elem, ...),
		*lisearch (t_list *list, void *elem),

		*lipush (t_list *list, void *elem, ...),
		*liappend (t_list *list, void *elem, ...);

  extern size_t	lisize (t_list *list);

  extern int	lilength (t_list *list),
		liposition (t_list *list),
		lidelete (t_list *list, int count);

  extern int	limap (t_list *list, int (*f)()),
		lirmap (t_list *list, int (*f)()),
		liamap (t_list *list, int (*f)(), void *a),
		liarmap (t_list *list, int (*f)(), void *a),
		livamap (t_list *list, int (*f)(), ...),
		livarmap (t_list *list, int (*f)(), ...);

  extern int	lisort (t_list *list, int (*cmpfunc)());

#else /* ! __STDC__ */

  extern t_list	*licreate(),
		*liconcat(),
		*lidestroy();

  extern char	*lifirst(),
		*listep(),
		*lilast(),
		*libackstep(),
		*liaddr(),
		*ligoto(),

		*liinsert(),

		*liinsrch(),
		*lisearch(),

		*lipush(),
		*liappend();

  extern long	lisize();

  extern int	lilength(),
		liposition(),
		lidelete();

  extern int	limap(),
		lirmap(),
		liamap(),
		liarmap(),
		livamap(),
		livarmap();

  extern int	lisort();

#endif /* __STDC__ */

#endif /* LIST_H */
