/*
 * library: list
 * file: limap.c
 *
 * Copyright  1990, 1991, 1992 Robert Joop
 *
 * $Log: limap.c,v $
 * Revision 1.1.1.1  1993/12/31  20:24:36  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: limap.c,v 1.1.1.1 1993/12/31 20:24:36 rj Exp $";

#define list_internal
#include "list.h"

#ifdef __STDC__
int limap (t_list *list, int (*f)())
#else
int limap (list, f)
  t_list	*list;
  int		(*f)();
#endif
{
  voidptr	elem;
  int		rc = ok;

  if (!list)
    return fault;
  if (list->fixsize)
  {
    for (elem=lifirst (list); elem; elem=listep (list))
      if (rc = (*f)(elem))
	break;
  }
  else
  {
    for (elem=lifirst (list); elem; elem=listep (list))
      if (rc = (*f)(elem, lisize (list)))
	break;
  }
  return rc;
}
