/*
 * library: list
 * file: liinsrch.c
 *
 * Copyright  1990, 1991, 1992, 1993, 1994 Robert Joop
 *
 * $Log: liinsrch.c,v $
 * Revision 1.1.1.1  1993/12/31  20:24:36  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: liinsrch.c,v 1.1.1.1 1993/12/31 20:24:36 rj Exp $";

#define list_internal
#include "list.h"
#ifdef __STDC__
#  include <stdarg.h>
#else
#  include <varargs.h>
#endif

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#ifdef __STDC__
static int makelistnode (t_list *list, t_liinsside side, void **elem, size_t varsize)
#else
static int makelistnode (list, side, elem, varsize)
  t_list	*list;
  t_liinsside	side;
  char		**elem;
  long		varsize;
#endif
{
#ifdef __STDC__
  size_t	size;
#else
  long		size;
#endif
  t_listnode	*new;

#ifdef __STDC__
  size = sizeof (t_listnode) + (list->fixsize ? list->fixsize-sizeof (size_t) : varsize);
#else
  size = sizeof (t_listnode) + (list->fixsize ? list->fixsize-sizeof (long) : varsize);
#endif
  if (!(new = (t_listnode *)malloc (size)))
    return fault;

  /* insert into list:	*/
  if (list->current)
  {
    if (side == LIINS_BEFORE) /* insert before current */
    {
      if (new->pred = list->current->pred)
	new->pred->succ = new;
      else
	list->first = new;
      new->succ = list->current;
      list->current->pred = new;
    }
    elif (side == LIINS_AFTER) /* insert after current */
    {
      if (new->succ = list->current->succ)
	new->succ->pred = new;
      else
	list->last = new;
      new->pred = list->current;
      list->current->succ = new;
      list->position++;
    }
    else
      return fault;
  }
  else /* empty list */
  {
    new->pred = new->succ = NULL;
    list->first = list->last = new;
    list->position = 0;
  }
  list->current = new;
  list->length++;

  if (list->fixsize)
  {
    if (*elem)
      (void)memcpy (new->elem.fix, *elem, list->fixsize);
    *elem = new->elem.fix;
  }
  else
  {
    if (*elem)
      (void)memcpy (new->elem.var.buf, *elem, new->elem.var.size = varsize);
    *elem = new->elem.var.buf;
  }

  return ok;
}

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#ifdef __STDC__
static int _liinsrch (t_list *list, bool *insert, void **elem, size_t varsize)
#else !__STDC__
static int _liinsrch (list, insert, elem, varsize)
  t_list	*list;
  bool		*insert;
  char		**elem;
  long		varsize;
#endif __STDC__
{
  if (!list->cmpfunc || !*elem)
    return fault;
  if (list->current)
  {
    int	side;

    if (side = (*list->cmpfunc)(*elem, list->fixsize ? list->current->elem.fix : list->current->elem.var.buf))
      if (side < 0)
      {
	t_listnode *pred;

	while ((pred=list->current->pred) && (list->current=pred, --list->position, (side = (*list->cmpfunc)(*elem, list->fixsize ? list->current->elem.fix : list->current->elem.var.buf)) < 0))
	  ;
      }
      else /* (side > 0) */
      {
	t_listnode *succ;

	while ((succ=list->current->succ) && (list->current=succ, list->position++, (side = (*list->cmpfunc)(*elem, list->fixsize ? list->current->elem.fix : list->current->elem.var.buf)) > 0))
	  ;
      }
    if (side)
      return *insert ? makelistnode (list, side < 0 ? LIINS_BEFORE : LIINS_AFTER, elem, varsize) : (errno = ESRCH, fault);
    else	/* element already exists	*/
    {
      *insert = false;
      *elem = list->fixsize ? list->current->elem.fix : list->current->elem.var.buf;
      return ok;
    }
  }
  else
    return *insert ? makelistnode (list, LIINS_AFTER, elem, varsize) : (errno=ESRCH, fault);
}

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#ifdef __STDC__
void *liinsrch (t_list *list, bool *insert, void *elem, ...)
#else !__STDC__
/* VARARGS 3 */
char *liinsrch (list, insert, elem, varsize)
  t_list	*list;
  bool		*insert;
  char		*elem;
  long		varsize;
#endif __STDC__
{
#ifdef __STDC__
  va_list	va;
  size_t	varsize;
#endif __STDC__

  if (!list || !list->cmpfunc)
  {
    errno = EFAULT;
    return NULL;
  }

#ifdef __STDC__
  va_start (va, elem);
  varsize = va_arg (va, size_t);
  va_end (va);
#endif __STDC__

  return _liinsrch (list, insert, &elem, varsize) ? NULL : elem;
}

#ifdef __STDC__
void *liinsert (t_list *list, void *elem, ...)
#else !__STDC__
/* VARARGS 2 */
char *liinsert (list, elem, varsize)
  t_list	*list;
  char		*elem;
  va_dcl
#endif __STDC__
{
  va_list	va;
  voidptr	rc;

#ifdef __STDC__
  va_start (va, elem);
#else !__STDC__
  va_start (va);
#endif __STDC__
  if (!list)
  {
    errno = EFAULT;
    return NULL;
  }
  if (list->cmpfunc)
  {
    bool	insert = true;
#ifdef __STDC__
    size_t	varsize;
#else
    long	varsize;
#endif

#ifdef __STDC__
    varsize = va_arg (va, size_t);
#else
    varsize = va_arg (va, long);
#endif
    if (_liinsrch (list, &insert, &elem, varsize))
      return NULL;
    rc = insert ? elem : (errno=EEXIST, (voidptr)NULL);
  }
  else
  {
    t_liinsside	side = va_arg (va, t_liinsside);
    size_t	varsize = va_arg (va, size_t);

    rc = makelistnode (list, side, &elem, varsize) ? NULL : elem;
  }
  va_end (va);
  return rc;
}

#ifdef __STDC__
void *lisearch (t_list *list, void *elem)
#else
char *lisearch (list, elem)
  t_list	*list;
  char		*elem;
#endif
{
  bool		insert = false;

  if (!list || !list->cmpfunc)
  {
    errno = EFAULT;
    return NULL;
  }
  return _liinsrch (list, &insert, &elem, 0) ? NULL : elem;
}

/* - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - = - */ 

#ifdef __STDC__
void *lipush (t_list *list, void *elem, ...)
#else !__STDC__
/* VARARGS 2 */
char *lipush (list, elem, varsize)
  t_list	*list;
  char		*elem;
  long		varsize;
#endif __STDC__
{
#ifdef __STDC__
  va_list	va;
  size_t	varsize;
#endif __STDC__

  if (!list || list->cmpfunc)
  {
    errno = EFAULT;
    return NULL;
  }

#ifdef __STDC__
  va_start (va, elem);
  varsize = va_arg (va, size_t);
  va_end (va);
#endif __STDC__
  if (list->length)
    (void)ligoto (list, 0);
  return makelistnode (list, LIINS_BEFORE, &elem, varsize) ? NULL : elem;
}

#ifdef __STDC__
void *liappend (t_list *list, void *elem, ...)
#else !__STDC__
/* VARARGS 2 */
char *liappend (list, elem, varsize)
  t_list	*list;
  char		*elem;
  long		varsize;
#endif __STDC__
{
#ifdef __STDC__
  va_list	va;
  size_t	varsize;
#endif __STDC__

  if (!list || list->cmpfunc)
  {
    errno = EFAULT;
    return NULL;
  }

#ifdef __STDC__
  va_start (va, elem);
  varsize = va_arg (va, size_t);
  va_end (va);
#endif __STDC__
  if (list->length)
    (void)ligoto (list, list->length - 1);
  return makelistnode (list, LIINS_AFTER, &elem, varsize) ? NULL : elem;
}
