/*
 * library: list
 * file: lidelete.c
 *
 * Copyright  1990, 1991, 1992, 1994 Robert Joop
 *
 * $Log: lidelete.c,v $
 * Revision 1.3  1994/07/09  17:13:06  rj
 * never use memory after free (in the old days, this was explicitly allowed!)
 *
 * Revision 1.2  1994/01/05  02:23:40  rj
 * fix fr malloc libraries bei denen man nach
 * free() nicht mehr auf den speicher zugreifen darf.
 *
 * Revision 1.1.1.1  1993/12/31  20:24:35  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: lidelete.c,v 1.3 1994/07/09 17:13:06 rj Exp $";

#define list_internal
#include "list.h"

#ifdef __STDC__
int lidelete (t_list *list, int count)
#else
int lidelete (list, count)
  t_list	*list;
  int		count;
#endif
{
  int	deleted;

  if (!list)
    return fault;
  if (!list->current)
    return count ? fault : ok;	/* correct to delete 0 elements from empty list	*/

  for (deleted=0; count--; deleted++)
  {
    voidptr	old;

    if (list->freefunc)
      (*list->freefunc)(list->fixsize ? list->current->elem.fix : list->current->elem.var.buf);

    --list->length;
    old = list->current;
    if (list->current->pred)
      list->current->pred->succ = list->current->succ;
    else
      list->first = list->current->succ;
    if (list->current->succ)
    {
      list->current->succ->pred = list->current->pred;
      list->current = list->current->succ;
      free (old);
    }
    else
    {
      --list->position;
      list->current = list->last = list->current->pred;
      free (old);
      return ++deleted;
    }
  }
  return deleted;
}
