/*
 * library: list
 * file: liconcat.c
 *
 * Copyright  1992, 1993 Robert Joop
 *
 * $Log: liconcat.c,v $
 * Revision 1.1.1.1  1993/12/31  20:24:35  rj
 * erster cvs import.
 *
 */

static const char RCSId[] = "$Id: liconcat.c,v 1.1.1.1 1993/12/31 20:24:35 rj Exp $";

#define list_internal
#include "list.h"

#ifdef __STDC__
t_list *liconcat (t_list *left, t_list *right)
#else
t_list *liconcat (left, right)
  t_list	*left, *right;
#endif
{
  if (left->fixsize != right->fixsize || left->cmpfunc || right->cmpfunc || left->freefunc != right->freefunc)
    return NULL;
  if (left->last)	/* left is nonempty */
    left->last->succ = right->first;
  else	/* left is empty */
  {
    left->first = right->first;
    left->current = right->current;
    left->position = right->position;
    left->last = right->last;
  }
  if (right->first)	/* right is nonempty */
    right->first->pred = left->last;
  left->length += right->length;
#ifndef NDEBUG
  right->first = right->last = right->current = NULL;
#endif
  free (right);
  return left;
}
